/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.flowevents.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.bpm.engine.model.BpmResponseResult;
import com.jxdinfo.hussar.bpm.engine.service.TaskEngineService;
import com.jxdinfo.hussar.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.bpm.extendproperties.service.ISysActExtendPropertiesService;
import com.jxdinfo.hussar.bpm.flowevents.dao.FlowEventsServiceMapper;
import com.jxdinfo.hussar.bpm.flowevents.model.FlowTask;
import com.jxdinfo.hussar.bpm.flowevents.model.Variables;
import com.jxdinfo.hussar.bpm.flowevents.service.FlowEventsService;
import com.jxdinfo.hussar.bpm.urgetask.model.SysActUrgeTask;
import com.jxdinfo.hussar.bpm.urgetask.service.ISysActUrgeTaskService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class FlowEventsServiceImpl
implements FlowEventsService {
    private final TaskService taskService;
    private final TaskEngineService taskEngineService;
    private final HistoryService historyService;
    private final RuntimeService runtimeService;
    private final IAssigneeChooseService iAssigneeChooseService;
    private final RepositoryService repositoryService;
    private final ISysActUrgeTaskService iSysActUrgeTaskService;
    private final ISysActExtendPropertiesService iSysActExtendPropertiesService;
    private final FlowEventsServiceMapper flowEventsServiceMapper;
    @Value(value="${spring.datasource.url}")
    private String url;
    private static final String CACAHENAME = "flowCache";

    public FlowEventsServiceImpl(TaskService taskService, TaskEngineService taskEngineService, HistoryService historyService, RuntimeService runtimeService, IAssigneeChooseService iAssigneeChooseService, RepositoryService repositoryService, ISysActUrgeTaskService iSysActUrgeTaskService, ISysActExtendPropertiesService iSysActExtendPropertiesService, FlowEventsServiceMapper flowEventsServiceMapper) {
        this.taskService = taskService;
        this.taskEngineService = taskEngineService;
        this.historyService = historyService;
        this.runtimeService = runtimeService;
        this.iAssigneeChooseService = iAssigneeChooseService;
        this.repositoryService = repositoryService;
        this.iSysActUrgeTaskService = iSysActUrgeTaskService;
        this.iSysActExtendPropertiesService = iSysActExtendPropertiesService;
        this.flowEventsServiceMapper = flowEventsServiceMapper;
    }

    @Override
    public BpmResponseResult todoList(String userId, String processDefinitionKey, String message, String sendUserId, String startTime, String endTime, Integer page, Integer limit, String type, String tenantId) {
        Page pages = new Page((long)page.intValue(), (long)limit.intValue());
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", userId);
        map.put("todoConfiguration", message);
        map.put("sendUserId", sendUserId);
        map.put("processDefinitionKey", processDefinitionKey);
        map.put("startTime", startTime);
        map.put("endTime", endTime);
        String dbType = this.url.split(":")[1];
        map.put("dbType", dbType);
        List<FlowTask> todoList = this.flowEventsServiceMapper.todoList(pages, map);
        ArrayList<String> taskIds = new ArrayList<String>();
        ArrayList<String> instIds = new ArrayList<String>();
        for (FlowTask flowTask : todoList) {
            taskIds.add(flowTask.getTaskId());
            instIds.add(flowTask.getProcessInstId());
        }
        List<Object> allVariables = new ArrayList();
        if (todoList.size() > 0) {
            allVariables = this.flowEventsServiceMapper.getAllToDoVariables(taskIds, instIds);
        }
        HashMap<String, ArrayList<Variables>> taskVariablesMap = new HashMap<String, ArrayList<Variables>>();
        HashMap<String, ArrayList<Variables>> processVariablesMap = new HashMap<String, ArrayList<Variables>>();
        for (Variables variables : allVariables) {
            List<Variables> list;
            if (variables.getTaskId() == null) {
                list = (ArrayList<Variables>)processVariablesMap.get(variables.getProcessInstanceId());
                if (list == null) {
                    list = new ArrayList<Variables>();
                }
                list.add(variables);
                processVariablesMap.put(variables.getProcessInstanceId(), (ArrayList<Variables>)list);
                continue;
            }
            list = (List)taskVariablesMap.get(variables.getTaskId());
            if (list == null) {
                list = new ArrayList();
            }
            list.add(variables);
            taskVariablesMap.put(variables.getTaskId(), (ArrayList<Variables>)list);
        }
        Iterator<Object> iterator = todoList.iterator();
        while (iterator.hasNext()) {
            FlowTask flowTask;
            flowTask.setTaskVariables(taskVariablesMap.get((flowTask = (FlowTask)iterator.next()).getTaskId()) == null ? new ArrayList<Variables>() : (List)taskVariablesMap.get(flowTask.getTaskId()));
            flowTask.setProcessVariables(processVariablesMap.get(flowTask.getProcessInstId()) == null ? new ArrayList<Variables>() : (List)processVariablesMap.get(flowTask.getProcessInstId()));
        }
        ArrayList<Map> resultData = new ArrayList<Map>();
        ArrayList<String> userIds = new ArrayList<String>();
        for (FlowTask flowTask : todoList) {
            Map result = (Map)JSON.parseObject((String)JSON.toJSONString((Object)flowTask), Map.class);
            if (ToolUtil.isNotEmpty(result.get("formKey"))) {
                result.putAll((Map)JSON.parse((String)String.valueOf(result.get("formKey"))));
            }
            result.put("taskVariables", flowTask.getTaskVariableMap());
            result.put("variables", flowTask.getProcessVariableMap());
            result.put("message", ((Map)result.get("taskVariables")).get("todoConfiguration"));
            userIds.add(String.valueOf(result.get("sendUser")));
            result.put("taskSourceFlag", flowTask.getTaskVariableMap().get("taskSourceFlag"));
            result.put("createTime", result.get("startTime") == null ? "" : format.format(result.get("startTime")));
            result.put("processStartTime", result.get("processStartTime") == null ? "" : format.format(result.get("processStartTime")));
            result.put("processInsId", result.get("processInstId"));
            result.remove("startTime");
            result.remove("processVariables");
            result.remove("todoConfiguartion");
            result.remove("processInstId");
            result.remove("processVariableMap");
            result.remove("taskVariableMap");
            resultData.add(result);
        }
        Map<String, String> map2 = this.iAssigneeChooseService.getUserListByUserId(userIds, tenantId);
        Iterator<FlowTask> iterator2 = resultData.iterator();
        while (iterator2.hasNext()) {
            Map result;
            result.put("sendUserName", map2.get((result = (Map)((Object)iterator2.next())).get("sendUser")) == null ? "" : map2.get(result.get("sendUser")));
        }
        HashMap<String, Serializable> data = new HashMap<String, Serializable>();
        data.put("data", resultData);
        data.put("count", Long.valueOf(pages.getTotal()));
        JSONArray jsonArray = new JSONArray();
        jsonArray.add(data);
        return InstallResult.getResult("1", "success", jsonArray);
    }

    @Override
    public BpmResponseResult todoBusinessList(Map<String, Object> listQuery) {
        Date date;
        int page = Integer.parseInt(listQuery.get("curr") == null ? "1" : (String)listQuery.get("curr"));
        int limit = Integer.parseInt(listQuery.get("nums") == null ? "10" : (String)listQuery.get("nums"));
        String processDefinitionKey = (String)listQuery.get("processDefinitionKey");
        String message = (String)listQuery.get("message");
        String startTime = (String)listQuery.get("startTime");
        String endTime = (String)listQuery.get("endTime");
        String userId = (String)listQuery.get("userId");
        String sendUserId = (String)listQuery.get("sendUserId");
        String tenantId = (String)listQuery.get("tenantId");
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        TaskQuery taskQuery = (TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().includeTaskLocalVariables()).taskCandidateOrAssigned(userId).includeProcessVariables()).orderByTaskCreateTime()).desc();
        if (ToolUtil.isNotEmpty((Object)processDefinitionKey)) {
            taskQuery.processDefinitionKey(processDefinitionKey);
        }
        if (ToolUtil.isNotEmpty((Object)message)) {
            taskQuery.taskVariableValueLike("todoConfiguration", "%" + message + "%");
        }
        if (ToolUtil.isNotEmpty((Object)sendUserId)) {
            taskQuery.taskVariableValueEquals("sendUser", (Object)sendUserId);
        }
        if (listQuery.size() != 0) {
            block36: for (Map.Entry<String, Object> query : listQuery.entrySet()) {
                String type;
                Map variable = null;
                try {
                    variable = (Map)JSONObject.parseObject((String)((String)query.getValue()), HashMap.class);
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                if (!ToolUtil.isNotEmpty(variable) || !ToolUtil.isNotEmpty((Object)(type = (String)variable.get("type")))) continue;
                String value = (String)variable.get("value");
                switch (type) {
                    case "equal": {
                        taskQuery.processVariableValueEquals(query.getKey(), (Object)value);
                        continue block36;
                    }
                    case "noEqual": {
                        taskQuery.processVariableValueNotEquals(query.getKey(), (Object)value);
                        continue block36;
                    }
                    case "like": {
                        taskQuery.processVariableValueLike(query.getKey(), "%" + value + "%");
                        continue block36;
                    }
                    case "lLike": {
                        taskQuery.processVariableValueLike(query.getKey(), value + "%");
                        continue block36;
                    }
                    case "rLike": {
                        taskQuery.processVariableValueLike(query.getKey(), "%" + value);
                        continue block36;
                    }
                    case "intLessThan": {
                        taskQuery.processVariableValueLessThan(query.getKey(), (Object)Integer.parseInt(value));
                        continue block36;
                    }
                    case "intLessThanOrEqual": {
                        taskQuery.processVariableValueLessThanOrEqual(query.getKey(), (Object)Integer.parseInt(value));
                        continue block36;
                    }
                    case "intGreaterThan": {
                        taskQuery.processVariableValueGreaterThan(query.getKey(), (Object)Integer.parseInt(value));
                        continue block36;
                    }
                    case "intGreaterThanOrEqual": {
                        taskQuery.processVariableValueGreaterThanOrEqual(query.getKey(), (Object)Integer.parseInt(value));
                        continue block36;
                    }
                    case "doubleLessThan": {
                        taskQuery.processVariableValueLessThan(query.getKey(), (Object)Double.parseDouble(value));
                        continue block36;
                    }
                    case "doubleLessThanOrEqual": {
                        taskQuery.processVariableValueLessThanOrEqual(query.getKey(), (Object)Double.parseDouble(value));
                        continue block36;
                    }
                    case "doubleGreaterThan": {
                        taskQuery.processVariableValueGreaterThan(query.getKey(), (Object)Double.parseDouble(value));
                        continue block36;
                    }
                    case "doubleGreaterThanOrEqual": {
                        taskQuery.processVariableValueGreaterThanOrEqual(query.getKey(), (Object)Double.parseDouble(value));
                        continue block36;
                    }
                }
                this.resolveDate(type, value, query.getKey(), taskQuery);
            }
        }
        if (ToolUtil.isNotEmpty((Object)startTime)) {
            date = null;
            try {
                date = format.parse(startTime);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            taskQuery.taskCreatedAfter(date);
        }
        if (ToolUtil.isNotEmpty((Object)endTime)) {
            date = null;
            try {
                date = format.parse(endTime);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            taskQuery.taskCreatedBefore(date);
        }
        Long count = taskQuery.count();
        List list = taskQuery.listPage((page - 1) * limit, limit);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("data", this.tasksToMap(list, null, tenantId));
        data.put("count", count);
        JSONArray jsonArray = new JSONArray();
        jsonArray.add(data);
        return InstallResult.getResult("1", "success", jsonArray);
    }

    private void resolveDate(String type, String value, String key, TaskQuery taskQuery) {
        String symbol = "-";
        if (value.contains("/")) {
            symbol = "/";
        }
        SimpleDateFormat variableFormat = null;
        variableFormat = value.length() == 7 ? new SimpleDateFormat("yyyy" + symbol + "MM") : (value.length() == 8 ? new SimpleDateFormat("HH:mm:SS") : (value.length() == 10 ? new SimpleDateFormat("yyyy" + symbol + "MM" + symbol + "dd") : new SimpleDateFormat("yyyy" + symbol + "MM" + symbol + "dd HH:mm:SS")));
        Date date = null;
        switch (type) {
            case "lessThan": {
                try {
                    date = variableFormat.parse(value);
                    taskQuery.processVariableValueLessThan(key, (Object)date);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                break;
            }
            case "lessThanOrEqual": {
                try {
                    date = variableFormat.parse(value);
                    taskQuery.processVariableValueLessThanOrEqual(key, (Object)date);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                break;
            }
            case "greaterThan": {
                try {
                    date = variableFormat.parse(value);
                    taskQuery.processVariableValueGreaterThan(key, (Object)date);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                break;
            }
            case "greaterThanOrEqual": {
                try {
                    date = variableFormat.parse(value);
                    taskQuery.processVariableValueGreaterThanOrEqual(key, (Object)date);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                break;
            }
        }
    }

    @Override
    public BpmResponseResult doneList(String userId, String processDefinitionKey, String message, String sendUserId, String startTime, String endTime, Integer page, Integer limit, String type, String tenantId) {
        Page pages = new Page((long)page.intValue(), (long)limit.intValue());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", userId);
        map.put("todoConfiguration", message);
        map.put("sendUserId", sendUserId);
        map.put("processDefinitionKey", processDefinitionKey);
        map.put("startTime", startTime);
        map.put("endTime", endTime);
        map.put("state", "0");
        String dbType = this.url.split(":")[1];
        map.put("dbType", dbType);
        List<FlowTask> doneList = this.flowEventsServiceMapper.doneList(pages, map);
        ArrayList<String> taskIds = new ArrayList<String>();
        ArrayList<String> instIds = new ArrayList<String>();
        for (FlowTask flowTask : doneList) {
            taskIds.add(flowTask.getTaskId());
            instIds.add(flowTask.getProcessInstId());
        }
        List<Object> allVariables = new ArrayList();
        if (doneList.size() > 0) {
            allVariables = this.flowEventsServiceMapper.getAllVariables(taskIds, instIds);
        }
        HashMap<String, ArrayList<Variables>> taskVariablesMap = new HashMap<String, ArrayList<Variables>>();
        HashMap<String, ArrayList<Variables>> processVariablesMap = new HashMap<String, ArrayList<Variables>>();
        for (Variables variables : allVariables) {
            List<Variables> list;
            if (variables.getTaskId() == null) {
                list = (ArrayList<Variables>)processVariablesMap.get(variables.getProcessInstanceId());
                if (list == null) {
                    list = new ArrayList<Variables>();
                }
                list.add(variables);
                processVariablesMap.put(variables.getProcessInstanceId(), (ArrayList<Variables>)list);
                continue;
            }
            list = (List)taskVariablesMap.get(variables.getTaskId());
            if (list == null) {
                list = new ArrayList();
            }
            list.add(variables);
            taskVariablesMap.put(variables.getTaskId(), (ArrayList<Variables>)list);
        }
        Iterator<Object> iterator = doneList.iterator();
        while (iterator.hasNext()) {
            FlowTask flowTask;
            flowTask.setTaskVariables(taskVariablesMap.get((flowTask = (FlowTask)iterator.next()).getTaskId()) == null ? new ArrayList<Variables>() : (List)taskVariablesMap.get(flowTask.getTaskId()));
            flowTask.setProcessVariables(processVariablesMap.get(flowTask.getProcessInstId()) == null ? new ArrayList<Variables>() : (List)processVariablesMap.get(flowTask.getProcessInstId()));
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("data", this.hisTasksToMap(doneList, tenantId));
        data.put("count", pages.getTotal());
        JSONArray jSONArray = new JSONArray();
        jSONArray.add(data);
        return InstallResult.getResult("1", "success", jSONArray);
    }

    private JSONArray tasksToMap(List<Task> tasks, String type, String tenantId) {
        JSONArray jsonArray = new JSONArray();
        HashSet<String> processInstanceIds = new HashSet<String>();
        ArrayList<String> userIds = new ArrayList<String>();
        Map<Object, Object> finalUsers = new HashMap();
        ArrayList<ProcessInstance> pis = new ArrayList();
        if (tasks != null && tasks.size() > 0) {
            for (Task t : tasks) {
                String sendUser;
                Map taskVariables = t.getTaskLocalVariables();
                String string = sendUser = taskVariables.get("sendUser") == null ? "" : taskVariables.get("sendUser").toString();
                if (ToolUtil.isNotEmpty((Object)sendUser)) {
                    userIds.add(sendUser);
                }
                processInstanceIds.add(t.getProcessInstanceId());
            }
            pis = this.runtimeService.createProcessInstanceQuery().processInstanceIds(processInstanceIds).list();
            finalUsers = this.iAssigneeChooseService.getUserListByUserId(userIds, tenantId);
            if (finalUsers == null) {
                finalUsers = new HashMap();
            }
        }
        if (tasks != null && tasks.size() > 0) {
            for (Task task : tasks) {
                JSONObject object;
                String formKey;
                String message;
                String sendUser;
                HashMap<String, Object> taskMap = new HashMap<String, Object>(16);
                Map variables = task.getProcessVariables();
                Map taskVariables = task.getTaskLocalVariables();
                ProcessInstance pi = this.getProcessInstance(pis, task.getProcessInstanceId());
                taskMap.put("taskId", task.getId());
                taskMap.put("name", task.getName());
                taskMap.put("processDefinitionKey", pi.getProcessDefinitionKey());
                taskMap.put("processDefinitionId", task.getProcessDefinitionId());
                taskMap.put("processDefinitionName", pi.getProcessDefinitionName());
                taskMap.put("taskDefinitionKey", task.getTaskDefinitionKey());
                taskMap.put("processInsId", task.getProcessInstanceId());
                taskMap.put("createTime", task.getCreateTime());
                taskMap.put("businessId", pi.getBusinessKey());
                taskMap.put("variables", variables);
                taskMap.put("taskVariables", taskVariables);
                taskMap.put("taskSourceFlag", taskVariables.get("taskSourceFlag"));
                String string = sendUser = taskVariables.get("sendUser") == null ? "" : taskVariables.get("sendUser").toString();
                if (ToolUtil.isNotEmpty((Object)sendUser)) {
                    taskMap.put("sendUser", sendUser);
                    taskMap.put("sendUserName", finalUsers.get(sendUser));
                }
                String string2 = message = taskVariables.get("todoConfiguration") == null ? "" : taskVariables.get("todoConfiguration").toString();
                if (ToolUtil.isNotEmpty((Object)message)) {
                    taskMap.put("message", message);
                }
                if (ToolUtil.isNotEmpty((Object)(formKey = task.getFormKey())) && ToolUtil.isNotEmpty((Object)(object = JSON.parseObject((String)formKey)))) {
                    for (String key : object.keySet()) {
                        taskMap.put(key, object.getString(key));
                    }
                }
                taskMap.put("formKey", task.getFormKey());
                jsonArray.add(taskMap);
            }
        }
        return jsonArray;
    }

    private List<Map<String, Object>> hisTasksToMap(List<FlowTask> lists, String tenantId) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        ArrayList<String> userIds = new ArrayList<String>();
        Map<Object, Object> finalUsers = new HashMap();
        Map<Object, Object> propertiesMap = new HashMap();
        ArrayList<String> ids = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(lists)) {
            for (FlowTask flowTask : lists) {
                Map<String, Object> taskVariables = flowTask.getTaskVariableMap();
                if (ToolUtil.isNotEmpty((Object)taskVariables.get("sendUser"))) {
                    userIds.add(String.valueOf(taskVariables.get("sendUser")));
                }
                userIds.add(flowTask.getUserId());
                ids.add(flowTask.getProcessDefinitionId() + flowTask.getTaskDefinitionKey());
            }
            propertiesMap = this.iSysActExtendPropertiesService.queryList(ids);
            finalUsers = this.iAssigneeChooseService.getUserListByUserId(userIds, tenantId);
        }
        if (ToolUtil.isNotEmpty(lists)) {
            for (FlowTask flowTask : lists) {
                JSONObject object;
                String message;
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                Map<String, Object> variables = flowTask.getProcessVariableMap();
                Map<String, Object> taskVariables = flowTask.getTaskVariableMap();
                map.put("taskId", flowTask.getTaskId());
                map.put("isNoticeTask", flowTask.getIsNoticeTask());
                map.put("name", flowTask.getName());
                map.put("assigneeId", flowTask.getUserId());
                map.put("assigneeName", finalUsers.get(flowTask.getUserId()));
                map.put("processDefinitionId", flowTask.getProcessDefinitionId());
                map.put("processDefinitionKey", flowTask.getProcessDefinitionKey());
                map.put("processDefinitionName", flowTask.getProcessDefinitionName());
                map.put("taskDefinitionKey", flowTask.getTaskDefinitionKey());
                map.put("processInsId", flowTask.getProcessInstId());
                map.put("startTime", flowTask.getStartTime());
                map.put("endTime", flowTask.getEndTime());
                map.put("processStartTime", flowTask.getProcessStartTime());
                map.put("processEndTime", flowTask.getProcessEndTime());
                map.put("businessId", flowTask.getBusinessId());
                map.put("variables", variables);
                map.put("taskVariables", taskVariables);
                map.put("taskSourceFlag", taskVariables.get("taskSourceFlag"));
                String scope = String.valueOf(taskVariables.get("taskSourceFlag"));
                scope = "reject".equals(scope) ? "\u5df2\u9a73\u56de" : (ToolUtil.isNotEmpty((Object)flowTask.getEndTime()) ? "\u5df2\u5b8c\u6210" : "\u672a\u5b8c\u6210");
                map.put("state", scope);
                map.put("sendUser", taskVariables.get("sendUser"));
                map.put("sendUserName", finalUsers.get(taskVariables.get("sendUser")));
                if (ToolUtil.isNotEmpty((Object)flowTask.getTodoConfiguration())) {
                    message = flowTask.getTodoConfiguration();
                } else {
                    String string = message = taskVariables.get("todoConfiguration") == null ? "" : taskVariables.get("todoConfiguration").toString();
                }
                if (ToolUtil.isNotEmpty((Object)message)) {
                    map.put("message", message);
                }
                map.put("formKey", flowTask.getFormKey());
                String formDetail = (String)propertiesMap.get(flowTask.getProcessDefinitionId() + flowTask.getTaskDefinitionKey());
                if (ToolUtil.isNotEmpty((Object)formDetail) && ToolUtil.isNotEmpty((Object)(object = JSON.parseObject((String)formDetail)))) {
                    for (String key : object.keySet()) {
                        map.put(key, object.getString(key));
                    }
                }
                map.put("formDetailKey", formDetail);
                list.add(map);
            }
        }
        return list;
    }

    private HistoricProcessInstance getHistoricProcessInstance(List<HistoricProcessInstance> pis, String processInstanceId) {
        if (pis != null && pis.size() > 0) {
            for (HistoricProcessInstance p : pis) {
                if (!p.getId().equals(processInstanceId)) continue;
                return p;
            }
        }
        return null;
    }

    private ProcessInstance getProcessInstance(List<ProcessInstance> pis, String processInstanceId) {
        if (pis != null && pis.size() > 0) {
            for (ProcessInstance p : pis) {
                if (!p.getId().equals(processInstanceId)) continue;
                return p;
            }
        }
        return null;
    }

    private Set<String> getAssigneeByTaskId(String taskId) {
        HashSet<String> users = new HashSet<String>();
        List identityLinkList = this.taskService.getIdentityLinksForTask(taskId);
        if (identityLinkList != null && identityLinkList.size() > 0) {
            for (IdentityLink identityLink : identityLinkList) {
                users.add(identityLink.getUserId());
            }
        }
        return users;
    }

    @Override
    @Cacheable(value={"flowCache"}, key="'workflowFlowType'")
    public List<ProcessDefinition> flowType() {
        return this.repositoryService.createProcessDefinitionQuery().latestVersion().active().list();
    }

    @Override
    public BpmResponseResult revokeTask(String historicTaskId, String userId) {
        BpmResponseResult check = this.taskEngineService.withdrawState(historicTaskId);
        if (check.getCode().equals("0")) {
            return check;
        }
        if (!((Boolean)check.getResult().get(0)).booleanValue()) {
            return InstallResult.getResult("0", "\u5f53\u524d\u8282\u70b9\u4e0d\u80fd\u64a4\u56de", null);
        }
        BpmResponseResult revoke = this.taskEngineService.revokeTask(historicTaskId, userId, "", true, null);
        if (revoke.getCode().equals("0")) {
            return revoke;
        }
        return InstallResult.getResult("1", "success", null);
    }

    @Override
    public BpmResponseResult urgeTask(String processInsId, String userId) {
        if (ToolUtil.isEmpty((Object)processInsId)) {
            return InstallResult.getResult("0", "\u6d41\u7a0b\u5b9e\u4f8bid\u4e3a\u7a7a", null);
        }
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInsId).singleResult();
        if (processInstance == null) {
            return InstallResult.getResult("0", "\u6d41\u7a0b\u5df2\u7ecf\u7ed3\u675f\uff0c\u65e0\u6cd5\u50ac\u529e", null);
        }
        List tasks = ((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().includeTaskLocalVariables()).includeProcessVariables()).processInstanceId(processInsId)).list();
        ArrayList<SysActUrgeTask> list = new ArrayList<SysActUrgeTask>();
        Date date = new Date();
        Timestamp ts = new Timestamp(date.getTime());
        for (Task task : tasks) {
            Set<String> users = this.getAssigneeByTaskId(task.getId());
            if (users.size() <= 0) continue;
            for (String user : users) {
                SysActUrgeTask sysActUrgeTask = new SysActUrgeTask();
                sysActUrgeTask.setId(IdWorker.get32UUID());
                sysActUrgeTask.setTaskId(task.getId());
                sysActUrgeTask.setProcInstId(task.getProcessInstanceId());
                sysActUrgeTask.setProcName(processInstance.getProcessDefinitionName());
                sysActUrgeTask.setTaskName(task.getName());
                sysActUrgeTask.setSendUser(userId);
                sysActUrgeTask.setReceiveUser(user);
                sysActUrgeTask.setSendTime(ts);
                sysActUrgeTask.setFormKey(task.getFormKey());
                sysActUrgeTask.setTaskDefKey(task.getTaskDefinitionKey());
                sysActUrgeTask.setProcDefKey(processInstance.getProcessDefinitionKey());
                sysActUrgeTask.setBusinessId(processInstance.getBusinessKey());
                Map map = task.getTaskLocalVariables();
                if (ToolUtil.isNotEmpty((Object)map)) {
                    sysActUrgeTask.setToDoConfig((String)map.get("todoConfiguration"));
                }
                list.add(sysActUrgeTask);
            }
        }
        if (list.size() > 0) {
            this.iSysActUrgeTaskService.saveBatch(list);
        }
        return InstallResult.getResult("1", "success", null);
    }
}

