/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.engine.util;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.activiti.engine.TaskService;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.IdentityLink;
import org.apache.commons.lang3.StringUtils;

public class SetAssigneeCmd
implements Command<Void> {
    protected Map<String, String> assigneeMap;
    protected String processInstanceId;
    private TaskService taskService = (TaskService)SpringContextHolder.getApplicationContext().getBean(TaskService.class);

    public SetAssigneeCmd(String processInstanceId, Map<String, String> assigneeMap) {
        this.assigneeMap = assigneeMap;
        this.processInstanceId = processInstanceId;
    }

    public Void execute(CommandContext commandContext) {
        if (this.assigneeMap != null) {
            for (TaskEntity taskEntity : Context.getCommandContext().getTaskEntityManager().findTasksByProcessInstanceId(this.processInstanceId)) {
                String assignee = this.assigneeMap.get(taskEntity.getTaskDefinitionKey());
                if (!StringUtils.isNotEmpty((CharSequence)assignee)) continue;
                Set<String> userSet = this.getAssigneeByTaskId(taskEntity.getId());
                for (String user : userSet) {
                    this.taskService.deleteCandidateUser(taskEntity.getId(), user);
                }
                List<String> assigneeList = Arrays.asList(assignee.split(","));
                taskEntity.addCandidateUsers(assigneeList);
            }
        }
        return null;
    }

    private Set<String> getAssigneeByTaskId(String taskId) {
        HashSet<String> users = new HashSet<String>();
        List identityLinkList = this.taskService.getIdentityLinksForTask(taskId);
        if (identityLinkList != null && identityLinkList.size() > 0) {
            for (IdentityLink identityLink : identityLinkList) {
                users.add(identityLink.getUserId());
            }
        }
        return users;
    }
}

