/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.engine.util;

import com.jxdinfo.hussar.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.activiti.engine.TaskService;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntityManager;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.PvmProcessElement;
import org.activiti.engine.impl.pvm.process.ActivityImpl;

public class ParallelJumpTaskCmd
implements Command<Void> {
    private TaskService taskService = (TaskService)SpringContextHolder.getApplicationContext().getBean(TaskService.class);
    protected String userId;
    private String executionId;
    protected String comment;
    protected String type;
    private ActivityImpl desActivity;
    private Map<String, Object> paramvar;
    private ActivityImpl currentActivity;
    private List<String> affectedTasks;
    private ActivityRedisTimerService activityRedisTimerService = (ActivityRedisTimerService)SpringContextHolder.getBean(ActivityRedisTimerService.class);

    public Void execute(CommandContext commandContext) {
        ExecutionEntity propagatingExecution;
        ExecutionEntityManager executionEntityManager = Context.getCommandContext().getExecutionEntityManager();
        ExecutionEntity executionEntity = executionEntityManager.findExecutionById(this.executionId);
        if (executionEntity.getParent() != null && (executionEntity = executionEntity.getParent()).getParent() != null) {
            executionEntity = executionEntity.getParent();
        }
        executionEntity.setVariables(this.paramvar);
        executionEntity.setEventSource((PvmProcessElement)this.currentActivity);
        executionEntity.setActivity(this.currentActivity);
        List taskEntities = Context.getCommandContext().getTaskEntityManager().findTasksByExecutionId(this.executionId);
        StringBuilder taskIds = new StringBuilder();
        for (Object taskEntity : taskEntities) {
            if (ToolUtil.isNotEmpty((Object)taskEntity.getDueDate())) {
                taskIds.append(",").append(taskEntity.getId());
            }
            taskEntity.fireEvent("complete");
            taskEntity.setVariableLocal("taskSourceFlag", (Object)this.type);
            if (ToolUtil.isNotEmpty((Object)this.comment)) {
                this.taskService.addComment(taskEntity.getId(), null, "complete", this.comment);
            }
            taskEntity.setAssignee(this.userId);
            Context.getCommandContext().getTaskEntityManager().deleteTask((TaskEntity)taskEntity, "ParallelJumpTaskCmd-Completed", false);
        }
        Context.getCommandContext().getHistoryManager().recordActivityEnd(executionEntity);
        List list = executionEntityManager.findChildExecutionsByProcessInstanceId(executionEntity.getProcessInstanceId());
        for (ExecutionEntity entity : list) {
            if (!ToolUtil.isEmpty((Object)entity.getParentId())) continue;
            list.remove(entity);
            break;
        }
        ArrayList<String> parentIds = new ArrayList<String>();
        ArrayList<String> ids = new ArrayList<String>();
        for (Object entity : list) {
            if (!entity.toString().contains("ScopeExecution")) continue;
            ids.add(entity.getId());
            parentIds.add(entity.getParentId());
        }
        ArrayList<ExecutionEntity> deleteList = new ArrayList<ExecutionEntity>();
        for (ExecutionEntity entity : list) {
            if (!parentIds.contains(entity.getId()) && !ids.contains(entity.getParentId())) continue;
            deleteList.add(entity);
        }
        list.removeAll(deleteList);
        for (ExecutionEntity ee : list) {
            if (ToolUtil.isNotEmpty(this.affectedTasks) && !this.affectedTasks.contains(ee.getActivityId())) continue;
            if (ee.toString().contains("ScopeExecution")) {
                List parent = executionEntityManager.findChildExecutionsByParentExecutionId(ee.getId());
                for (ExecutionEntity executionEntity3 : parent) {
                    List tasks = executionEntity3.getTasks();
                    if (tasks != null && tasks.size() > 0 && ToolUtil.isNotEmpty((Object)this.userId)) {
                        for (TaskEntity taskEntity : tasks) {
                            if (ToolUtil.isNotEmpty((Object)taskEntity.getDueDate())) {
                                taskIds.append(",").append(taskEntity.getId());
                            }
                            taskEntity.fireEvent("complete");
                            taskEntity.setVariableLocal("taskSourceFlag", (Object)this.type);
                            if (ToolUtil.isNotEmpty((Object)this.comment)) {
                                this.taskService.addComment(taskEntity.getId(), null, "complete", this.comment);
                            }
                            taskEntity.setAssignee(this.userId);
                            Context.getCommandContext().getTaskEntityManager().deleteTask(taskEntity, "ParallelJumpTaskCmd-Completed", false);
                        }
                    }
                    executionEntity3.remove();
                    Context.getCommandContext().getHistoryManager().recordActivityEnd(executionEntity3);
                }
                ee.remove();
                Context.getCommandContext().getHistoryManager().recordActivityEnd(ee);
                commandContext.getIdentityLinkEntityManager().deleteIdentityLinksByProcInstance(ee.getParentId());
                continue;
            }
            List tasks = ee.getTasks();
            taskIds = new StringBuilder();
            for (TaskEntity taskEntity : tasks) {
                if (ToolUtil.isNotEmpty((Object)taskEntity.getDueDate())) {
                    taskIds.append(",").append(taskEntity.getId());
                }
                taskEntity.fireEvent("complete");
                taskEntity.setVariableLocal("taskSourceFlag", (Object)this.type);
                if (ToolUtil.isNotEmpty((Object)this.comment)) {
                    this.taskService.addComment(taskEntity.getId(), null, "complete", this.comment);
                }
                taskEntity.setAssignee(this.userId);
                Context.getCommandContext().getTaskEntityManager().deleteTask(taskEntity, "ParallelJumpTaskCmd-Completed", false);
            }
            if (ToolUtil.isNotEmpty((Object)taskIds.toString())) {
                this.activityRedisTimerService.delTimeOutModel(taskIds.toString().substring(1));
            }
            ee.remove();
            Context.getCommandContext().getHistoryManager().recordActivityEnd(ee);
        }
        if (this.desActivity.isScope()) {
            propagatingExecution = executionEntity.createExecution();
            executionEntity.setTransition(null);
            executionEntity.setActivity(null);
            executionEntity.setActive(false);
            if (propagatingExecution.getActivity() == null) {
                propagatingExecution.setActivity(this.desActivity);
            }
            propagatingExecution.initialize();
        } else {
            propagatingExecution = executionEntity;
        }
        propagatingExecution.executeActivity((PvmActivity)this.desActivity);
        return null;
    }

    public ParallelJumpTaskCmd(String userId, String executionId, ActivityImpl desActivity, String type, String comment, Map<String, Object> paramvar, ActivityImpl currentActivity) {
        this.userId = userId;
        this.executionId = executionId;
        this.desActivity = desActivity;
        this.comment = comment;
        if (paramvar.get("affectedTasks") != null) {
            this.affectedTasks = (List)paramvar.get("affectedTasks");
            paramvar.remove("affectedTasks");
        }
        this.paramvar = paramvar;
        this.type = type;
        this.currentActivity = currentActivity;
    }
}

