/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.engine.util;

import com.jxdinfo.hussar.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.bpm.engine.dao.TaskEngineMapper;
import com.jxdinfo.hussar.bpm.engine.util.MultiInstancePercentUtils;
import com.jxdinfo.hussar.bpm.extend.ExtendParallelMultiInstanceBehavior;
import com.jxdinfo.hussar.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityBehavior;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.runtime.Execution;

public class MultiInstanceDelAssigneeCmd
implements Command<Void> {
    protected String executionId;
    protected String taskId;
    private TaskEngineMapper taskEngineMapper = (TaskEngineMapper)SpringContextHolder.getApplicationContext().getBean(TaskEngineMapper.class);
    private BpmConstantProperties bpmConstantProperties = (BpmConstantProperties)SpringContextHolder.getApplicationContext().getBean(BpmConstantProperties.class);

    public MultiInstanceDelAssigneeCmd(String executionId, String taskId) {
        this.executionId = executionId;
        this.taskId = taskId;
    }

    public Void execute(CommandContext commandContext) {
        ProcessEngineConfigurationImpl pec = commandContext.getProcessEngineConfiguration();
        RuntimeService runtimeService = pec.getRuntimeService();
        Execution execution = (Execution)runtimeService.createExecutionQuery().executionId(this.executionId).singleResult();
        ExecutionEntity ee = (ExecutionEntity)execution;
        int nrOfInstances = MultiInstancePercentUtils.getLoopVariable(ee, "nrOfInstances");
        if (nrOfInstances == 1) {
            throw new PublicClientException(this.bpmConstantProperties.getTheOnlyAssigneeInMulti(), false);
        }
        this.taskEngineMapper.updateMultiRevokeTaskHistory("'" + this.taskId + "'");
        ee.remove();
        Context.getCommandContext().getHistoryManager().recordActivityEnd(ee);
        Context.getCommandContext().getHistoryManager().recordActivityEnd(ee);
        commandContext.getIdentityLinkEntityManager().deleteIdentityLinksByProcInstance(this.executionId);
        int nrOfCompletedInstances = MultiInstancePercentUtils.getLoopVariable(ee, "nrOfCompletedInstances");
        MultiInstancePercentUtils.setLoopVariable(ee, "nrOfInstances", nrOfInstances - 1);
        MultiInstancePercentUtils.setLoopVariable(ee, "nrOfCompletedInstances", nrOfCompletedInstances - 1);
        ActivityBehavior activityBehavior = ee.getActivity().getActivityBehavior();
        if (activityBehavior instanceof ExtendParallelMultiInstanceBehavior) {
            ((ExtendParallelMultiInstanceBehavior)activityBehavior).leave((ActivityExecution)ee);
        }
        return null;
    }
}

