/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.engine.util;

import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.IdentityLink;

public class EntrustAssigneeCmd
implements Command<Void> {
    protected String taskId;
    protected String userId;
    protected String consignee;
    protected boolean isAdd;

    public EntrustAssigneeCmd(String taskId, String userId, String consignee, boolean isAdd) {
        this.taskId = taskId;
        this.userId = userId;
        this.consignee = consignee;
        this.isAdd = isAdd;
    }

    public Void execute(CommandContext commandContext) {
        TaskEntity taskEntity = Context.getCommandContext().getTaskEntityManager().findTaskById(this.taskId);
        if (taskEntity.getAssignee() != null) {
            taskEntity.setAssignee(this.consignee);
        } else {
            Set identityLinks = taskEntity.getCandidates();
            if (ToolUtil.isNotEmpty((Object)this.userId)) {
                taskEntity.deleteCandidateUser(this.userId);
                taskEntity.addCandidateUsers(Arrays.asList(this.consignee.split(",")));
            } else {
                ArrayList<String> users = new ArrayList<String>(Arrays.asList(this.consignee.split(",")));
                for (IdentityLink identityLink : identityLinks) {
                    if (this.isAdd) {
                        users.remove(identityLink.getUserId());
                        continue;
                    }
                    taskEntity.deleteCandidateUser(identityLink.getUserId());
                }
                if (users.size() > 0) {
                    taskEntity.addCandidateUsers(users);
                }
            }
        }
        return null;
    }
}

