/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.engine.util;

import com.jxdinfo.hussar.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.List;
import java.util.Map;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntityManager;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.PvmProcessElement;
import org.activiti.engine.impl.pvm.process.ActivityImpl;

public class CommonJumpTaskCmd
implements Command<Void> {
    private String executionId;
    protected String parentId;
    private ActivityImpl desActivity;
    private Map<String, Object> paramvar;
    private ActivityImpl currentActivity;
    private ActivityRedisTimerService activityRedisTimerService = (ActivityRedisTimerService)SpringContextHolder.getBean(ActivityRedisTimerService.class);

    public Void execute(CommandContext commandContext) {
        ExecutionEntity propagatingExecution;
        ExecutionEntityManager executionEntityManager = Context.getCommandContext().getExecutionEntityManager();
        ExecutionEntity executionEntity = executionEntityManager.findExecutionById(this.parentId);
        executionEntity.setVariables(this.paramvar);
        executionEntity.setEventSource((PvmProcessElement)this.currentActivity);
        executionEntity.setActivity(this.currentActivity);
        List taskEntities = Context.getCommandContext().getTaskEntityManager().findTasksByExecutionId(this.executionId);
        StringBuilder taskIds = new StringBuilder();
        for (TaskEntity taskEntity : taskEntities) {
            if (ToolUtil.isNotEmpty((Object)taskEntity.getDueDate())) {
                taskIds.append(",").append(taskEntity.getId());
            }
            taskEntity.fireEvent("complete");
            Context.getCommandContext().getTaskEntityManager().deleteTask(taskEntity, "CommonJumpTaskCmd-Completed", false);
        }
        if (ToolUtil.isNotEmpty((Object)taskIds.toString())) {
            this.activityRedisTimerService.delTimeOutModel(taskIds.toString().substring(1));
        }
        Context.getCommandContext().getHistoryManager().recordActivityEnd(executionEntity);
        if (this.desActivity.isScope()) {
            propagatingExecution = executionEntity.createExecution();
            executionEntity.setTransition(null);
            executionEntity.setActivity(null);
            executionEntity.setActive(false);
            propagatingExecution.initialize();
        } else {
            propagatingExecution = executionEntity;
        }
        propagatingExecution.executeActivity((PvmActivity)this.desActivity);
        return null;
    }

    public CommonJumpTaskCmd(String executionId, String parentId, ActivityImpl desActivity, Map<String, Object> paramvar, ActivityImpl currentActivity) {
        this.executionId = executionId;
        this.desActivity = desActivity;
        this.paramvar = paramvar;
        this.currentActivity = currentActivity;
        this.parentId = parentId;
    }
}

