/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.engine.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.bpm.comment.model.TaskComment;
import com.jxdinfo.hussar.bpm.comment.service.TaskCommentService;
import com.jxdinfo.hussar.bpm.common.constant.BpmConstant;
import com.jxdinfo.hussar.bpm.common.constant.BpmEnum;
import com.jxdinfo.hussar.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.bpm.common.utils.AnalyticalModelUtil;
import com.jxdinfo.hussar.bpm.definition.model.DefinitionModel;
import com.jxdinfo.hussar.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.bpm.engine.dao.TaskEngineMapper;
import com.jxdinfo.hussar.bpm.engine.model.BpmResponseResult;
import com.jxdinfo.hussar.bpm.engine.model.FlowTask;
import com.jxdinfo.hussar.bpm.engine.service.TaskEngineService;
import com.jxdinfo.hussar.bpm.engine.util.AddAssigneeCmd;
import com.jxdinfo.hussar.bpm.engine.util.CommonJumpTaskCmd;
import com.jxdinfo.hussar.bpm.engine.util.EntrustAssigneeCmd;
import com.jxdinfo.hussar.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.bpm.engine.util.MultiInstanceAddAssigneeCmd;
import com.jxdinfo.hussar.bpm.engine.util.MultiInstanceDelAssigneeCmd;
import com.jxdinfo.hussar.bpm.engine.util.MultiInstanceJumpTaskCmd;
import com.jxdinfo.hussar.bpm.engine.util.ParallelJumpTaskCmd;
import com.jxdinfo.hussar.bpm.extendproperties.service.ISysActExtendPropertiesService;
import com.jxdinfo.hussar.bpm.flowevents.dao.FlowEventsServiceMapper;
import com.jxdinfo.hussar.bpm.flowevents.model.Variables;
import com.jxdinfo.hussar.bpm.hisline.model.SysActHiLine;
import com.jxdinfo.hussar.bpm.processcount.dao.ProcessCountMapper;
import com.jxdinfo.hussar.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.bsp.taskmanager.model.TaskManager;
import com.jxdinfo.hussar.bsp.taskmanager.service.TaskManagerService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.CallActivity;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.ExclusiveGateway;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.Gateway;
import org.activiti.bpmn.model.InclusiveGateway;
import org.activiti.bpmn.model.ParallelGateway;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.HistoryService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricActivityInstanceQuery;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.bpmn.behavior.InclusiveGatewayActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.ParallelGatewayActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.ParallelMultiInstanceBehavior;
import org.activiti.engine.impl.bpmn.behavior.SequentialMultiInstanceBehavior;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.ReadOnlyProcessDefinition;
import org.activiti.engine.impl.pvm.delegate.ActivityBehavior;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskInfo;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class TaskEngineServiceImpl
implements TaskEngineService {
    @Value(value="${spring.datasource.url:}")
    private String url;
    private static Logger LOGGER = LoggerFactory.getLogger(TaskEngineServiceImpl.class);
    @Autowired
    private TaskService taskService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private ProcessEngine processEngine;
    @Autowired
    private IAssigneeChooseService iAssigneeChooseService;
    @Resource
    private ProcessCountMapper processCountMapper;
    @Autowired
    ISysActCcTaskService iSysActCcTaskService;
    @Autowired
    private ISysActExtendPropertiesService iSysActExtendPropertiesService;
    @Autowired
    private ProcessDefinitionsService processDefinitionsService;
    @Autowired
    private TaskManagerService taskManagerService;
    @Autowired
    private TaskEngineMapper taskEngineMapper;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Autowired
    private TaskCommentService taskCommentService;
    @Autowired
    private ActivityRedisTimerService activityRedisTimerService;
    @Autowired
    private FlowEventsServiceMapper flowEventsServiceMapper;
    public static final String CALL_REJECT_PREFIX = "main_process_";
    public static final String CALL_REJECT_NAME_PREFIX = "\u4e3b\u6d41\u7a0b";
    public static final List<String> CALL_REJECT_LIST = new ArrayList<String>();

    @Override
    public BpmResponseResult queryTask(String taskId, String tenantId) {
        String message;
        String sendUser;
        if (taskId == null) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).includeTaskLocalVariables()).includeProcessVariables()).singleResult();
        if (historicTaskInstance == null) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getTaskNotFound(), null);
        }
        JSONArray json = new JSONArray();
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        HistoricProcessInstance hpi = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(historicTaskInstance.getProcessInstanceId()).singleResult();
        Map variables = historicTaskInstance.getProcessVariables();
        Map taskVariables = historicTaskInstance.getTaskLocalVariables();
        map.put("taskId", historicTaskInstance.getId());
        map.put("name", historicTaskInstance.getName());
        ArrayList<String> userIds = new ArrayList<String>();
        userIds.add(hpi.getStartUserId());
        String string = sendUser = taskVariables.get("sendUser") == null ? "" : taskVariables.get("sendUser").toString();
        if (ToolUtil.isNotEmpty((Object)sendUser)) {
            userIds.add(sendUser);
            map.put("sendUser", sendUser);
        }
        Map<Object, Object> finalUsers = new HashMap();
        if (ToolUtil.isNotEmpty((Object)historicTaskInstance.getAssignee())) {
            userIds.add(historicTaskInstance.getAssignee());
            map.put("assigneeId", historicTaskInstance.getAssignee());
            finalUsers = this.iAssigneeChooseService.getUserListByUserId(userIds, tenantId);
            map.put("assigneeName", finalUsers.get(historicTaskInstance.getAssignee()));
        } else {
            Set<String> users = this.getAssigneeByTaskId(taskId);
            if (ToolUtil.isNotEmpty(users)) {
                userIds.addAll(users);
                finalUsers = this.iAssigneeChooseService.getUserListByUserId(userIds, tenantId);
                StringBuilder stringBuilder = new StringBuilder();
                StringBuilder stringBuilderName = new StringBuilder();
                for (String user : users) {
                    stringBuilder.append(",").append(user);
                    stringBuilderName.append(",").append((String)finalUsers.get(user));
                }
                map.put("assigneeId", stringBuilder.toString().substring(1));
                map.put("assigneeName", stringBuilderName.toString().substring(1));
            } else if (userIds.size() > 0) {
                finalUsers = this.iAssigneeChooseService.getUserListByUserId(userIds, tenantId);
            }
        }
        if (ToolUtil.isNotEmpty((Object)sendUser)) {
            map.put("sendUserName", finalUsers.get(sendUser));
        }
        map.put("processStartUserId", hpi.getStartUserId());
        map.put("processStartUserName", finalUsers.get(hpi.getStartUserId()));
        map.put("processDefinitionId", historicTaskInstance.getProcessDefinitionId());
        map.put("processDefinitionKey", hpi.getProcessDefinitionKey());
        map.put("processDefinitionName", hpi.getProcessDefinitionName());
        map.put("taskDefinitionKey", historicTaskInstance.getTaskDefinitionKey());
        map.put("processInsId", historicTaskInstance.getProcessInstanceId());
        map.put("claimTime", historicTaskInstance.getClaimTime());
        map.put("startTime", historicTaskInstance.getStartTime());
        map.put("endTime", historicTaskInstance.getEndTime());
        map.put("businessId", hpi.getBusinessKey());
        map.put("variables", variables);
        map.put("taskVariables", taskVariables);
        map.put("taskSourceFlag", taskVariables.get("taskSourceFlag"));
        String string2 = message = taskVariables.get("todoConfiguration") == null ? "" : taskVariables.get("todoConfiguration").toString();
        if (ToolUtil.isNotEmpty((Object)message)) {
            map.put("message", message);
        }
        map.put("formKey", historicTaskInstance.getFormKey());
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(historicTaskInstance.getProcessInstanceId() + historicTaskInstance.getTaskDefinitionKey());
        String formDetail = this.iSysActExtendPropertiesService.queryList(ids).get(historicTaskInstance.getProcessDefinitionId() + historicTaskInstance.getTaskDefinitionKey());
        map.put("formDetailKey", formDetail);
        json.add(map);
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult queryAllToDoTaskList(String processName, String processDefinitionKey, String startTime, String endTime, String isTimeOut, String suspension, String todoConfiguration, String tenantId, Integer page, Integer limit, String userId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("processName", processName);
        map.put("processDefinitionKey", processDefinitionKey);
        map.put("startTime", startTime);
        map.put("endTime", endTime);
        map.put("isTimeOut", isTimeOut);
        map.put("suspension", suspension);
        map.put("todoConfiguration", todoConfiguration);
        map.put("tenantId", tenantId);
        map.put("userId", userId);
        Page pages = new Page(page == null ? 1L : (long)page.intValue(), limit == null ? 10L : (long)limit.intValue());
        List<TaskManager> list = this.taskManagerService.getTask((Page<TaskManager>)pages, map);
        JSONObject object = new JSONObject();
        object.put("count", (Object)pages.getTotal());
        object.put("data", list);
        JSONArray jsonArray = new JSONArray();
        jsonArray.add((Object)object);
        return InstallResult.getResult("1", "success", jsonArray);
    }

    @Override
    public BpmResponseResult queryAllToDoTaskListByBusiness(String processName, String processDefinitionKey, String startTime, String endTime, String isTimeOut, String suspension, String todoConfiguration, List<String> businessList, String tenantId, Integer page, Integer limit) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("processName", processName);
        map.put("processDefinitionKey", processDefinitionKey);
        map.put("startTime", startTime);
        map.put("endTime", endTime);
        map.put("isTimeOut", isTimeOut);
        map.put("suspension", suspension);
        map.put("todoConfiguration", todoConfiguration);
        map.put("tenantId", tenantId);
        map.put("businessList", businessList.size() > 0 ? businessList : null);
        Page pages = new Page(page == null ? 1L : (long)page.intValue(), limit == null ? 10L : (long)limit.intValue());
        List<TaskManager> list = this.taskManagerService.getTask((Page<TaskManager>)pages, map);
        JSONObject object = new JSONObject();
        object.put("count", (Object)pages.getTotal());
        object.put("data", list);
        JSONArray jsonArray = new JSONArray();
        jsonArray.add((Object)object);
        return InstallResult.getResult("1", "success", jsonArray);
    }

    @Override
    public BpmResponseResult queryToDoTaskList(String userId, String processDefinitionKey, String definitionKey) {
        List tasks;
        JSONObject object = new JSONObject();
        JSONArray json = new JSONArray();
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        if (ToolUtil.isNotEmpty((Object)userId)) {
            taskQuery.taskCandidateOrAssigned(userId);
        }
        if (ToolUtil.isNotEmpty((Object)processDefinitionKey)) {
            taskQuery.processDefinitionKey(processDefinitionKey);
        }
        if (ToolUtil.isNotEmpty((Object)definitionKey)) {
            taskQuery.taskDefinitionKey(definitionKey);
        }
        if ((tasks = ((TaskQuery)((TaskQuery)taskQuery.orderByTaskCreateTime()).desc()).list()) != null) {
            List<Map<String, Object>> list = this.tasksToMap(tasks);
            object.put("data", list);
            object.put("count", (Object)tasks.size());
            json.add((Object)object);
        }
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult queryToDoTaskList(String userId, String processDefinitionKey, String definitionKey, Integer page, Integer rows) {
        JSONObject object = new JSONObject();
        JSONArray json = new JSONArray();
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        if (ToolUtil.isNotEmpty((Object)userId)) {
            taskQuery.taskCandidateOrAssigned(userId);
        }
        if (ToolUtil.isNotEmpty((Object)processDefinitionKey)) {
            taskQuery.processDefinitionKey(processDefinitionKey);
        }
        if (ToolUtil.isNotEmpty((Object)definitionKey)) {
            taskQuery.taskDefinitionKey(definitionKey);
        }
        long countTasks = taskQuery.count();
        List tasks = ((TaskQuery)((TaskQuery)taskQuery.orderByTaskCreateTime()).desc()).listPage((page - 1) * rows, rows.intValue());
        List<Map<String, Object>> list = this.tasksToMap(tasks);
        object.put("data", list);
        object.put("count", (Object)countTasks);
        json.add((Object)object);
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult queryToDoTaskList(String userId, List<String> businessIds) {
        JSONArray json = new JSONArray();
        JSONObject object = new JSONObject();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", userId);
        map.put("businessIds", businessIds);
        Page page = new Page();
        List<FlowTask> flowTasks = this.taskEngineMapper.queryToDoTaskList(page, map);
        if (flowTasks != null) {
            List<Map<String, Object>> list = this.getTodoResultMap(flowTasks);
            object.put("data", list);
            object.put("count", (Object)flowTasks.size());
            json.add((Object)object);
        }
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult queryFinishedTaskList(String userId, String processDefinitionKey, String definitionKey) {
        List hisTaskList;
        JSONObject object = new JSONObject();
        JSONArray json = new JSONArray();
        HistoricTaskInstanceQuery historicTaskInstanceQuery = this.historyService.createHistoricTaskInstanceQuery();
        if (ToolUtil.isNotEmpty((Object)userId)) {
            historicTaskInstanceQuery.taskAssignee(userId);
        }
        if (ToolUtil.isNotEmpty((Object)processDefinitionKey)) {
            historicTaskInstanceQuery.processDefinitionKey(processDefinitionKey);
        }
        if (ToolUtil.isNotEmpty((Object)definitionKey)) {
            historicTaskInstanceQuery.taskDefinitionKey(definitionKey);
        }
        if ((hisTaskList = ((HistoricTaskInstanceQuery)historicTaskInstanceQuery.orderByHistoricTaskInstanceEndTime().finished().desc()).list()) != null && hisTaskList.size() != 0) {
            List<Map<String, Object>> list = this.hisTasksToMap(hisTaskList);
            object.put("data", list);
            object.put("count", (Object)hisTaskList.size());
            json.add((Object)object);
        }
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult queryFinishedTaskList(String userId, String processDefinitionKey, String definitionKey, Integer page, Integer rows) {
        JSONObject object = new JSONObject();
        JSONArray json = new JSONArray();
        HistoricTaskInstanceQuery historicTaskInstanceQuery = this.historyService.createHistoricTaskInstanceQuery();
        if (ToolUtil.isNotEmpty((Object)userId)) {
            historicTaskInstanceQuery.taskAssignee(userId);
        }
        if (ToolUtil.isNotEmpty((Object)processDefinitionKey)) {
            historicTaskInstanceQuery.processDefinitionKey(processDefinitionKey);
        }
        if (ToolUtil.isNotEmpty((Object)definitionKey)) {
            historicTaskInstanceQuery.taskDefinitionKey(definitionKey);
        }
        long counthisList = historicTaskInstanceQuery.finished().count();
        List hisTaskList = ((HistoricTaskInstanceQuery)historicTaskInstanceQuery.finished().orderByHistoricTaskInstanceEndTime().desc()).listPage((page - 1) * rows, rows.intValue());
        if (hisTaskList != null && hisTaskList.size() != 0) {
            List<Map<String, Object>> list = this.hisTasksToMap(hisTaskList);
            object.put("data", list);
            object.put("count", (Object)counthisList);
            json.add((Object)object);
        }
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult queryUserTaskCount(String userId) {
        List<Map<String, String>> list = this.processCountMapper.getUserTask(userId);
        JSONArray json = new JSONArray();
        json.add(list);
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult queryUserTaskCountByNode(String userId) {
        List<Map<String, String>> list = this.processCountMapper.getUserTaskByNode(userId);
        JSONArray json = new JSONArray();
        json.add(list);
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult claimTask(String taskId, String userId) {
        this.taskService.claim(taskId, userId);
        this.activityRedisTimerService.updateTimeOutModel(taskId, userId, null, 0);
        return InstallResult.getResult("1", "success", null);
    }

    @Override
    public BpmResponseResult unClaimTask(String taskId) {
        this.taskService.unclaim(taskId);
        this.activityRedisTimerService.updateTimeOutModel(taskId, null, null, 1);
        return InstallResult.getResult("1", "success", null);
    }

    @Override
    public BpmResponseResult completeTask(String taskId, String userId, Map<String, Object> map) {
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getTaskNotFound(), null);
        }
        if (task.isSuspended()) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getTaskIsSuspended(), null);
        }
        boolean flag = this.auditAuthority(userId, taskId);
        if (!flag) {
            return InstallResult.getResult("0", "\u5f53\u524d\u7528\u6237(" + userId + ")\u6ca1\u6709\u529e\u7406\u6743\u9650", null);
        }
        if (task.getAssignee() == null) {
            this.taskService.claim(taskId, userId);
        }
        String processInstanceId = task.getProcessInstanceId();
        this.complete(task, map, userId);
        return this.installReturnValue(userId, processInstanceId, task.getTaskDefinitionKey(), map);
    }

    @Override
    public BpmResponseResult completeTask(String taskId, String userId, Map<String, String> assigneeMap, Map<String, Object> map) {
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getTaskNotFound(), null);
        }
        if (task.isSuspended()) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getTaskIsSuspended(), null);
        }
        boolean flag = this.auditAuthority(userId, taskId);
        if (!flag) {
            return InstallResult.getResult("0", "\u5f53\u524d\u7528\u6237(" + userId + ")\u6ca1\u6709\u529e\u7406\u6743\u9650", null);
        }
        if (task.getAssignee() == null) {
            this.taskService.claim(taskId, userId);
        }
        String processInstanceId = task.getProcessInstanceId();
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        if (ToolUtil.isNotEmpty(assigneeMap)) {
            newMap.put("appoint_assignee", assigneeMap);
        }
        this.complete(task, newMap, userId);
        return this.installReturnValue(userId, processInstanceId, task.getTaskDefinitionKey(), newMap);
    }

    @Override
    public BpmResponseResult completeTask(String taskId, String userId, Map<String, String> assigneeMap, String comment, Map<String, Object> map) {
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getTaskNotFound(), null);
        }
        if (task.isSuspended()) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getTaskIsSuspended(), null);
        }
        boolean flag = this.auditAuthority(userId, taskId);
        if (!flag) {
            return InstallResult.getResult("0", "\u5f53\u524d\u7528\u6237(" + userId + ")\u6ca1\u6709\u529e\u7406\u6743\u9650", null);
        }
        if (task.getAssignee() == null) {
            this.taskService.claim(taskId, userId);
        }
        String processInstanceId = task.getProcessInstanceId();
        this.addComment(taskId, comment);
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        if (ToolUtil.isNotEmpty(assigneeMap)) {
            newMap.put("appoint_assignee", assigneeMap);
        }
        this.complete(task, newMap, userId);
        return this.installReturnValue(userId, processInstanceId, task.getTaskDefinitionKey(), newMap);
    }

    @Override
    public BpmResponseResult completeTask(String taskId, String userId, Map<String, String> assigneeMap, Set<String> users, String comment, Map<String, Object> map) {
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getTaskNotFound(), null);
        }
        if (task.isSuspended()) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getTaskIsSuspended(), null);
        }
        boolean flag = this.auditAuthority(userId, taskId);
        if (!flag) {
            return InstallResult.getResult("0", "\u5f53\u524d\u7528\u6237(" + userId + ")\u6ca1\u6709\u529e\u7406\u6743\u9650", null);
        }
        if (task.getAssignee() == null) {
            this.taskService.claim(taskId, userId);
        }
        String processInstanceId = task.getProcessInstanceId();
        this.addComment(taskId, comment);
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        if (users != null && users.size() > 0) {
            newMap.put("cc_user", users);
        }
        if (ToolUtil.isNotEmpty(assigneeMap)) {
            newMap.put("appoint_assignee", assigneeMap);
        }
        this.complete(task, newMap, userId);
        return this.installReturnValue(userId, processInstanceId, task.getTaskDefinitionKey(), newMap);
    }

    @Override
    public BpmResponseResult completeTask(String taskId, String userId, String comment, Map<String, Object> map) {
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getTaskNotFound(), null);
        }
        if (task.isSuspended()) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getTaskIsSuspended(), null);
        }
        boolean flag = this.auditAuthority(userId, taskId);
        if (!flag) {
            return InstallResult.getResult("0", "\u5f53\u524d\u7528\u6237(" + userId + ")\u6ca1\u6709\u529e\u7406\u6743\u9650", null);
        }
        if (task.getAssignee() == null) {
            this.taskService.claim(taskId, userId);
        }
        String processInstanceId = task.getProcessInstanceId();
        this.addComment(taskId, comment);
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        this.complete(task, map, userId);
        return this.installReturnValue(userId, processInstanceId, task.getTaskDefinitionKey(), newMap);
    }

    @Override
    public BpmResponseResult completeTask(String taskId, String userId, String comment, String subProcesses, Map<String, Object> map) {
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getTaskNotFound(), null);
        }
        if (task.isSuspended()) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getTaskIsSuspended(), null);
        }
        boolean flag = this.auditAuthority(userId, taskId);
        if (!flag) {
            return InstallResult.getResult("0", "\u5f53\u524d\u7528\u6237(" + userId + ")\u6ca1\u6709\u529e\u7406\u6743\u9650", null);
        }
        if (task.getAssignee() == null) {
            this.taskService.claim(taskId, userId);
        }
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        String[] subs = subProcesses.split(",");
        JSONArray jsonArray = new JSONArray();
        for (String sub : subs) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("businessKey", (Object)"");
            jsonObject.put("processDefinitionKey", (Object)sub);
            jsonObject.put("userId", (Object)"");
            jsonArray.add((Object)jsonObject);
        }
        newMap.put("call_activity_info", jsonArray);
        String processInstanceId = task.getProcessInstanceId();
        this.addComment(taskId, comment);
        this.complete(task, newMap, userId);
        return this.installReturnValue(userId, processInstanceId, task.getTaskDefinitionKey(), newMap);
    }

    @Override
    public BpmResponseResult completeLeapTask(String taskId, String userId, Map<String, String> assigneeMap, String comment, Map<String, Object> map) {
        Task task = (Task)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().includeTaskLocalVariables()).taskId(taskId)).singleResult();
        if (task == null) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getTaskNotFound(), null);
        }
        if (task.isSuspended()) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getTaskIsSuspended(), null);
        }
        boolean flag = this.auditAuthority(userId, taskId);
        if (!flag) {
            return InstallResult.getResult("0", "\u5f53\u524d\u7528\u6237(" + userId + ")\u6ca1\u6709\u529e\u7406\u6743\u9650", null);
        }
        if (task.getAssignee() == null) {
            this.taskService.claim(taskId, userId);
        }
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        String processInstanceId = task.getProcessInstanceId();
        this.addComment(taskId, comment);
        if (ToolUtil.isNotEmpty(assigneeMap)) {
            newMap.put("appoint_assignee", assigneeMap);
        }
        Map variables = task.getTaskLocalVariables();
        String rejectFrom = "";
        String mainRejectFrom = "";
        String rejectType = "";
        if (variables != null) {
            rejectFrom = variables.get("reject_from") == null ? "" : variables.get("reject_from").toString();
            mainRejectFrom = variables.get("main_reject_from") == null ? "" : variables.get("main_reject_from").toString();
            String string = rejectType = variables.get("complete_type") == null ? "" : variables.get("complete_type").toString();
        }
        if ("reject".equals(rejectType)) {
            if (ToolUtil.isNotEmpty((Object)rejectFrom)) {
                BpmnModel bm;
                this.taskService.setVariableLocal(taskId, "taskSourceFlag", (Object)"complete");
                String processDefinition = task.getProcessDefinitionId();
                ReadOnlyProcessDefinition processDefinitionEntity = (ReadOnlyProcessDefinition)this.repositoryService.getProcessDefinition(processDefinition);
                ActivityImpl destinationActivity = (ActivityImpl)processDefinitionEntity.findActivity(rejectFrom);
                String executionId = task.getExecutionId();
                String parentId = task.getExecutionId();
                ActivityImpl currentActivity = (ActivityImpl)processDefinitionEntity.findActivity(task.getTaskDefinitionKey());
                if (rejectFrom != null && !this.canReject(bm = this.repositoryService.getBpmnModel(processDefinition), task.getTaskDefinitionKey(), rejectFrom, null, null, false) && !this.canReject(bm, task.getTaskDefinitionKey(), rejectFrom, null, null, true)) {
                    this.complete(task, newMap, userId);
                    return this.installReturnValue(userId, processInstanceId, task.getTaskDefinitionKey(), newMap);
                }
                newMap.put("sendUser", userId);
                this.processEngine.getManagementService().executeCommand((Command)new CommonJumpTaskCmd(executionId, parentId, destinationActivity, newMap, currentActivity));
            } else if (ToolUtil.isNotEmpty((Object)mainRejectFrom)) {
                BpmnModel bm;
                mainRejectFrom = CALL_REJECT_PREFIX + mainRejectFrom;
                Map<String, Object> result = this.backType(task, mainRejectFrom, false, userId, comment, "reject");
                int backType = (Integer)result.get("num");
                if (backType == 0) {
                    return InstallResult.getResult("0", this.bpmConstantProperties.getForbidReject(), null);
                }
                if (backType == 4) {
                    return InstallResult.getResult("0", this.bpmConstantProperties.getNotRejectToTargetNode(), null);
                }
                String processInstId = (String)result.get("processInstanceId");
                String processDefinitionId = (String)result.get("processDefinitionId");
                String taskDefinitionKey = (String)result.get("taskDefinitionKey");
                if (mainRejectFrom != null && !this.canReject(bm = this.repositoryService.getBpmnModel(processDefinitionId), taskDefinitionKey, mainRejectFrom.substring(CALL_REJECT_PREFIX.length()), null, null, true) && !this.canReject(bm, taskDefinitionKey, mainRejectFrom.substring(CALL_REJECT_PREFIX.length()), null, null, false)) {
                    this.complete(task, newMap, userId);
                    return this.installReturnValue(userId, processInstanceId, task.getTaskDefinitionKey(), newMap);
                }
                if (backType == 3) {
                    this.callActivitiReject((List)result.get("affectedTasks"), (Set)result.get("runningActivitiNodeIds"), processInstanceId, userId, comment, "complete");
                    newMap.put("affectedTasks", result.get("affectedTasks"));
                }
                if (mainRejectFrom.startsWith(CALL_REJECT_PREFIX)) {
                    newMap.put("executionId", result.get("executionId"));
                    newMap.put("processInstanceId", processInstId);
                    newMap.put("processDefinitionId", processDefinitionId);
                    newMap.put("taskDefinitionKey", taskDefinitionKey);
                }
                this.rejectTask(userId, task, mainRejectFrom, comment, newMap, backType, "complete");
            }
        } else {
            this.complete(task, newMap, userId);
        }
        return this.installReturnValue(userId, processInstanceId, task.getTaskDefinitionKey(), newMap);
    }

    @Override
    public BpmResponseResult completeLeapTask(String taskId, String userId, Map<String, String> assigneeMap, Set<String> users, String comment, Map<String, Object> map) {
        Task task = (Task)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().includeTaskLocalVariables()).taskId(taskId)).singleResult();
        if (task == null) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getTaskNotFound(), null);
        }
        if (task.isSuspended()) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getTaskIsSuspended(), null);
        }
        boolean flag = this.auditAuthority(userId, taskId);
        if (!flag) {
            return InstallResult.getResult("0", "\u5f53\u524d\u7528\u6237(" + userId + ")\u6ca1\u6709\u529e\u7406\u6743\u9650", null);
        }
        if (task.getAssignee() == null) {
            this.taskService.claim(taskId, userId);
        }
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        if (users != null && users.size() > 0) {
            newMap.put("cc_user", users);
        }
        String processInstanceId = task.getProcessInstanceId();
        this.addComment(taskId, comment);
        if (ToolUtil.isNotEmpty(assigneeMap)) {
            newMap.put("appoint_assignee", assigneeMap);
        }
        Map variables = task.getTaskLocalVariables();
        String rejectFrom = "";
        String mainRejectFrom = "";
        String rejectType = "";
        if (variables != null) {
            rejectFrom = variables.get("reject_from") == null ? "" : variables.get("reject_from").toString();
            mainRejectFrom = variables.get("main_reject_from") == null ? "" : variables.get("main_reject_from").toString();
            String string = rejectType = variables.get("complete_type") == null ? "" : variables.get("complete_type").toString();
        }
        if ("reject".equals(rejectType)) {
            if (ToolUtil.isNotEmpty((Object)rejectFrom)) {
                BpmnModel bm;
                this.taskService.setVariableLocal(taskId, "taskSourceFlag", (Object)"complete");
                String processDefinition = task.getProcessDefinitionId();
                ReadOnlyProcessDefinition processDefinitionEntity = (ReadOnlyProcessDefinition)this.repositoryService.getProcessDefinition(processDefinition);
                ActivityImpl destinationActivity = (ActivityImpl)processDefinitionEntity.findActivity(rejectFrom);
                String executionId = task.getExecutionId();
                String parentId = task.getExecutionId();
                ActivityImpl currentActivity = (ActivityImpl)processDefinitionEntity.findActivity(task.getTaskDefinitionKey());
                if (rejectFrom != null && !this.canReject(bm = this.repositoryService.getBpmnModel(processDefinition), task.getTaskDefinitionKey(), rejectFrom, null, null, false) && !this.canReject(bm, task.getTaskDefinitionKey(), rejectFrom, null, null, true)) {
                    this.complete(task, newMap, userId);
                    return this.installReturnValue(userId, processInstanceId, task.getTaskDefinitionKey(), newMap);
                }
                newMap.put("sendUser", userId);
                this.processEngine.getManagementService().executeCommand((Command)new CommonJumpTaskCmd(executionId, parentId, destinationActivity, newMap, currentActivity));
            } else if (ToolUtil.isNotEmpty((Object)mainRejectFrom)) {
                BpmnModel bm;
                mainRejectFrom = CALL_REJECT_PREFIX + mainRejectFrom;
                Map<String, Object> result = this.backType(task, mainRejectFrom, false, userId, comment, "reject");
                int backType = (Integer)result.get("num");
                if (backType == 0) {
                    return InstallResult.getResult("0", this.bpmConstantProperties.getForbidReject(), null);
                }
                if (backType == 4) {
                    return InstallResult.getResult("0", this.bpmConstantProperties.getNotRejectToTargetNode(), null);
                }
                String processInstId = (String)result.get("processInstanceId");
                String processDefinitionId = (String)result.get("processDefinitionId");
                String taskDefinitionKey = (String)result.get("taskDefinitionKey");
                if (mainRejectFrom != null && !this.canReject(bm = this.repositoryService.getBpmnModel(processDefinitionId), taskDefinitionKey, mainRejectFrom.substring(CALL_REJECT_PREFIX.length()), null, null, false) && !this.canReject(bm, taskDefinitionKey, mainRejectFrom.substring(CALL_REJECT_PREFIX.length()), null, null, true)) {
                    this.complete(task, newMap, userId);
                    return this.installReturnValue(userId, processInstanceId, task.getTaskDefinitionKey(), newMap);
                }
                if (backType == 3) {
                    this.callActivitiReject((List)result.get("affectedTasks"), (Set)result.get("runningActivitiNodeIds"), processInstanceId, userId, comment, "complete");
                    newMap.put("affectedTasks", result.get("affectedTasks"));
                }
                if (mainRejectFrom.startsWith(CALL_REJECT_PREFIX)) {
                    newMap.put("executionId", result.get("executionId"));
                    newMap.put("processInstanceId", processInstId);
                    newMap.put("processDefinitionId", processDefinitionId);
                    newMap.put("taskDefinitionKey", taskDefinitionKey);
                }
                this.rejectTask(userId, task, mainRejectFrom, comment, newMap, backType, "complete");
            }
        } else {
            this.complete(task, newMap, userId);
        }
        return this.installReturnValue(userId, processInstanceId, task.getTaskDefinitionKey(), newMap);
    }

    private boolean auditAuthority(String userId, String taskId) {
        boolean flag = false;
        Set<String> users = this.getAssigneeByTaskId(taskId);
        if (users.contains(userId)) {
            flag = true;
        }
        return flag;
    }

    private void complete(Task task, Map<String, Object> map, String userId) {
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        newMap.put("sendUser", userId);
        if (map != null) {
            newMap.putAll(map);
        }
        Map<String, Object> appointAssignee = new HashMap();
        if (newMap.get("appoint_assignee") != null) {
            appointAssignee = (Map)newMap.get("appoint_assignee");
        }
        if (ToolUtil.isEmpty(appointAssignee.get("static_appoint_assignee"))) {
            appointAssignee.put("static_appoint_assignee", null);
            newMap.put("appoint_assignee", appointAssignee);
        }
        String taskId = task.getId();
        this.taskService.setVariableLocal(taskId, "taskSourceFlag", (Object)"complete");
        if (ToolUtil.isNotEmpty(newMap) && (ToolUtil.isNotEmpty(newMap.get("multi_type")) || ToolUtil.isNotEmpty(newMap.get("multi_finish_condition")))) {
            String type = String.valueOf(newMap.get("multi_type"));
            String condition = String.valueOf(newMap.get("multi_finish_condition"));
            int updateMultCondition = this.taskEngineMapper.updateMultMessageType(taskId, type);
            if ((updateMultCondition += this.taskEngineMapper.updateMultMessageCondition(taskId, condition)) > 0) {
                newMap.remove("multi_type");
                newMap.remove("multi_finish_condition");
            }
        }
        if (task.getDelegationState() == null) {
            this.taskService.complete(taskId, newMap);
        } else {
            this.taskService.resolveTask(taskId, newMap);
            this.taskService.complete(taskId, newMap);
        }
        this.taskEngineMapper.updateMultMessage(taskId, this.url.split(":")[1]);
        if (ToolUtil.isNotEmpty((Object)task.getDueDate())) {
            this.activityRedisTimerService.delTimeOutModel(taskId);
        }
    }

    private void addComment(String taskId, String comment) {
        if (StringUtils.isNotEmpty((CharSequence)comment)) {
            this.taskService.addComment(taskId, null, "complete", comment);
        }
    }

    private BpmResponseResult installReturnValue(String userId, String processInstanceId, String taskDefinitionKey, Map<String, Object> variables) {
        Object processInstance;
        JSONArray json = new JSONArray();
        List<String> callActivityInstIds = this.taskEngineMapper.getCallActivityInstId(processInstanceId);
        callActivityInstIds.add(processInstanceId);
        List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceIdIn(callActivityInstIds)).includeTaskLocalVariables()).list();
        String superProcessInstanceId = null;
        List<Object> mainCallActivityInstIds = new ArrayList();
        if (ToolUtil.isEmpty((Object)tasks) && ToolUtil.isNotEmpty((Object)(processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult()).getSuperProcessInstanceId())) {
            superProcessInstanceId = processInstance.getSuperProcessInstanceId();
            mainCallActivityInstIds = this.taskEngineMapper.getCallActivityInstId(superProcessInstanceId);
            mainCallActivityInstIds.add(superProcessInstanceId);
            tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceIdIn(mainCallActivityInstIds)).includeTaskLocalVariables()).list();
            mainCallActivityInstIds.remove(superProcessInstanceId);
        }
        if (tasks != null && tasks.size() > 0) {
            for (Task t : tasks) {
                String completeType;
                Set<String> users = this.getAssigneeByTaskId(t.getId());
                Map map = t.getTaskLocalVariables() == null ? new HashMap(16) : t.getTaskLocalVariables();
                String string = completeType = map.get("complete_type") == null ? "" : map.get("complete_type").toString();
                if (ToolUtil.isEmpty((Object)completeType)) {
                    this.taskService.setVariableLocal(t.getId(), "complete_type", (Object)"complete");
                    this.taskService.setVariableLocal(t.getId(), "sendUser", (Object)userId);
                    if (taskDefinitionKey == null) {
                        if (ToolUtil.isEmpty(users)) {
                            this.taskService.setAssignee(t.getId(), userId);
                        }
                    } else if (t.getProcessInstanceId().equals(processInstanceId)) {
                        this.taskService.setVariableLocal(t.getId(), "complete_from", (Object)taskDefinitionKey);
                    } else if (callActivityInstIds.contains(t.getProcessInstanceId())) {
                        this.taskService.setVariable(t.getId(), "process_complete_type", (Object)"complete");
                        this.taskService.setVariableLocal(t.getId(), "call_complete_from", (Object)taskDefinitionKey);
                    } else {
                        List list = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(superProcessInstanceId).finished().activityType("callActivity").list();
                        for (HistoricActivityInstance historicActivityInstance : list) {
                            if (!historicActivityInstance.getCalledProcessInstanceId().equals(processInstanceId)) continue;
                            taskDefinitionKey = historicActivityInstance.getActivityId();
                            break;
                        }
                        if (mainCallActivityInstIds.contains(t.getProcessInstanceId())) {
                            this.taskService.setVariableLocal(t.getId(), "call_complete_from", (Object)taskDefinitionKey);
                        } else {
                            this.taskService.setVariableLocal(t.getId(), "complete_from", (Object)taskDefinitionKey);
                        }
                    }
                }
                JSONObject object = new JSONObject();
                object.put("processInstanceId", (Object)t.getProcessInstanceId());
                object.put("taskId", (Object)t.getId());
                object.put("userId", users);
                object.put("taskDefinitionKey", (Object)t.getTaskDefinitionKey());
                object.put("taskDefinitionName", (Object)t.getName());
                object.put("formKey", (Object)t.getFormKey());
                json.add((Object)object);
            }
        } else {
            JSONObject object = new JSONObject();
            object.put("taskDefinitionName", BpmConstant.END_NAME);
            object.put("endTime", (Object)new Date());
            json.add((Object)object);
        }
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult rejectToLastTask(String taskId, String userId, String comment, String assignees, boolean isSubmit, Map<String, Object> map) {
        boolean isFirst = false;
        String starterUserId = "";
        Task task = (Task)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).includeTaskLocalVariables()).singleResult();
        if (task == null) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getTaskNotFound(), null);
        }
        if (task.isSuspended()) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getTaskIsSuspended(), null);
        }
        String backActivityId = this.getLastActivityId(task, null);
        if ("".equals(backActivityId)) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getForbidReject(), null);
        }
        Map<String, Object> result = this.backType(task, backActivityId, false, userId, comment, "reject");
        int backType = (Integer)result.get("num");
        if (backType == 0) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getForbidReject(), null);
        }
        if (backType == 4) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getNotRejectToTargetNode(), null);
        }
        String processInstanceId = (String)result.get("processInstanceId");
        String processDefinitionId = (String)result.get("processDefinitionId");
        String taskDefinitionKey = (String)result.get("taskDefinitionKey");
        if (backActivityId != null) {
            String nodeId;
            BpmnModel bm = this.repositoryService.getBpmnModel(processDefinitionId);
            String string = nodeId = backActivityId.startsWith(CALL_REJECT_PREFIX) ? backActivityId.substring(CALL_REJECT_PREFIX.length()) : backActivityId;
            if (!this.canReject(bm, taskDefinitionKey, nodeId, null, null, true) && !this.canReject(bm, taskDefinitionKey, nodeId, null, null, false)) {
                return InstallResult.getResult("0", this.bpmConstantProperties.getNotRejectToTargetNode(), null);
            }
        }
        if (backActivityId != null && (backActivityId.equals(this.getFirstActivityId(processInstanceId, taskDefinitionKey)) || backActivityId.equals(CALL_REJECT_PREFIX + this.getFirstActivityId(processInstanceId, taskDefinitionKey)))) {
            starterUserId = this.getTaskStarterUserId(processInstanceId);
            isFirst = true;
        }
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        if (isSubmit) {
            assignees = this.getTaskCommitUser(processInstanceId, backActivityId);
        }
        if (ToolUtil.isNotEmpty((Object)assignees)) {
            newMap.put("reject_appoint_assignee", assignees);
        }
        if (backType == 3) {
            this.callActivitiReject((List)result.get("affectedTasks"), (Set)result.get("runningActivitiNodeIds"), processInstanceId, userId, comment, "reject");
            newMap.put("affectedTasks", result.get("affectedTasks"));
        }
        if (backActivityId.startsWith(CALL_REJECT_PREFIX)) {
            newMap.put("executionId", result.get("executionId"));
            newMap.put("processInstanceId", processInstanceId);
            newMap.put("processDefinitionId", processDefinitionId);
            newMap.put("taskDefinitionKey", taskDefinitionKey);
        }
        this.rejectTask(userId, task, backActivityId, comment, newMap, backType, "reject");
        BpmResponseResult bpmResponseResult = this.installRejectReturnValue(processInstanceId, isFirst, starterUserId, backActivityId, userId, taskDefinitionKey, "reject", (String)result.get("taskName"), task.getTaskDefinitionKey(), task.getName());
        JSONArray array = bpmResponseResult.getResult();
        boolean needReject = false;
        String rejectTaskId = "";
        if (ToolUtil.isNotEmpty((Object)array)) {
            for (int i = 0; i < array.size(); ++i) {
                JSONObject object = array.getJSONObject(i);
                if (!object.get((Object)"taskDefinitionKey").equals(backActivityId) || !ToolUtil.isEmpty((Object)object.get((Object)"userId"))) continue;
                needReject = true;
                rejectTaskId = object.get((Object)"taskId") == null ? "" : object.get((Object)"taskId").toString();
                break;
            }
        }
        if (needReject && (task = (Task)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskId(rejectTaskId)).includeTaskLocalVariables()).singleResult()) != null && !task.isSuspended() && !(backActivityId = this.getLastActivityId(task, null)).isEmpty()) {
            return this.rejectToLastTask(rejectTaskId, userId, comment, assignees, isSubmit, newMap);
        }
        return bpmResponseResult;
    }

    @Override
    public BpmResponseResult rejectToFirstTask(String taskId, String userId, String comment, String assignees, boolean isSubmit, Map<String, Object> map) {
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getTaskNotFound(), null);
        }
        if (task.isSuspended()) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getTaskIsSuspended(), null);
        }
        String firstTaskId = this.getFirstActivityId(task.getProcessInstanceId(), task.getTaskDefinitionKey());
        String starterUserId = this.getTaskStarterUserId(task.getProcessInstanceId());
        Map<String, Object> result = this.backType(task, "", true, userId, comment, "reject");
        int backType = (Integer)result.get("num");
        if (backType == 4) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getNotRejectToTargetNode(), null);
        }
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        if (ToolUtil.isNotEmpty((Object)assignees)) {
            newMap.put("reject_appoint_assignee", assignees);
        }
        if (isSubmit) {
            newMap.put("reject_appoint_assignee", this.getTaskCommitUser((String)result.get("processInstanceId"), firstTaskId));
        }
        if (backType == 3) {
            newMap.put("affectedTasks", result.get("affectedTasks"));
        }
        this.rejectTask(userId, task, firstTaskId, comment, newMap, backType, "reject");
        return this.installRejectReturnValue(task.getProcessInstanceId(), true, starterUserId, firstTaskId, userId, task.getTaskDefinitionKey(), "reject", task.getName(), task.getTaskDefinitionKey(), task.getName());
    }

    @Override
    public BpmResponseResult rejectToAnyTask(String taskId, String userId, String backActivityId, String comment, String assignees, boolean isSubmit, Map<String, Object> map) {
        boolean isFirst = false;
        String starterUserId = "";
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getTaskNotFound(), null);
        }
        if (task.isSuspended()) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getTaskIsSuspended(), null);
        }
        Map<String, Object> result = this.backType(task, backActivityId, false, userId, comment, "reject");
        int backType = (Integer)result.get("num");
        if (backType == -1) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getRejectToAnyCannotToAnotherBranch(), null);
        }
        if (backType == 4) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getNotRejectToTargetNode(), null);
        }
        String processInstanceId = (String)result.get("processInstanceId");
        String processDefinitionId = (String)result.get("processDefinitionId");
        String taskDefinitionKey = (String)result.get("taskDefinitionKey");
        if (backActivityId != null) {
            String nodeId;
            BpmnModel bm = this.repositoryService.getBpmnModel(processDefinitionId);
            String string = nodeId = backActivityId.startsWith(CALL_REJECT_PREFIX) ? backActivityId.substring(CALL_REJECT_PREFIX.length()) : backActivityId;
            if (!this.canReject(bm, taskDefinitionKey, nodeId, null, null, true) && !this.canReject(bm, taskDefinitionKey, nodeId, null, null, false)) {
                return InstallResult.getResult("0", this.bpmConstantProperties.getNotRejectToTargetNode(), null);
            }
        }
        if (backActivityId != null && (backActivityId.equals(this.getFirstActivityId(processInstanceId, taskDefinitionKey)) || backActivityId.equals(CALL_REJECT_PREFIX + this.getFirstActivityId(processInstanceId, taskDefinitionKey)))) {
            starterUserId = this.getTaskStarterUserId(processInstanceId);
            isFirst = true;
        }
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        if (isSubmit) {
            assignees = this.getTaskCommitUser(processInstanceId, backActivityId);
        }
        if (ToolUtil.isNotEmpty((Object)assignees)) {
            newMap.put("reject_appoint_assignee", assignees);
        }
        if (backType == 3) {
            this.callActivitiReject((List)result.get("affectedTasks"), (Set)result.get("runningActivitiNodeIds"), processInstanceId, userId, comment, "reject");
            newMap.put("affectedTasks", result.get("affectedTasks"));
        }
        if (backActivityId.startsWith(CALL_REJECT_PREFIX)) {
            newMap.put("executionId", result.get("executionId"));
            newMap.put("processInstanceId", processInstanceId);
            newMap.put("processDefinitionId", processDefinitionId);
            newMap.put("taskDefinitionKey", taskDefinitionKey);
        }
        this.rejectTask(userId, task, backActivityId, comment, newMap, backType, "reject");
        return this.installRejectReturnValue(processInstanceId, isFirst, starterUserId, backActivityId, userId, taskDefinitionKey, "reject", (String)result.get("taskName"), task.getTaskDefinitionKey(), task.getName());
    }

    @Override
    public BpmResponseResult queryRejectNode(String taskId) {
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getTaskNotFound(), null);
        }
        if (task.isSuspended()) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getTaskIsSuspended(), null);
        }
        BpmnModel bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
        if (bm != null) {
            List hisList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(task.getProcessInstanceId())).taskVariableValueNotEquals("taskSourceFlag", (Object)"skip")).orderByHistoricTaskInstanceEndTime().asc()).finished().list();
            List<String> hisTaskDefinitionKey = hisList.stream().map(TaskInfo::getTaskDefinitionKey).collect(Collectors.toList());
            List list = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(task.getProcessInstanceId()).activityType("callActivity").finished().list();
            for (HistoricActivityInstance historicActivityInstance : list) {
                if (!ToolUtil.isNotEmpty((Object)historicActivityInstance.getEndTime())) continue;
                hisTaskDefinitionKey.add(historicActivityInstance.getActivityId());
            }
            JSONArray json = new JSONArray();
            Process process = bm.getMainProcess();
            FlowNode userTask = (FlowNode)process.getFlowElement(task.getTaskDefinitionKey());
            HashSet<String> ids = new HashSet<String>();
            ids.add(task.getTaskDefinitionKey());
            ArrayList<List<String>> lists = new ArrayList<List<String>>();
            if (userTask == null) {
                return InstallResult.getResult("0", this.bpmConstantProperties.getRunningNodeNotFound(), null);
            }
            this.getAllhisNodeList(bm, userTask.getIncomingFlows(), hisTaskDefinitionKey, new ArrayList<String>(ids), new ArrayList<String>(), lists);
            List<String> finalList = this.getFinalList(lists);
            this.updateJsonResult(bm, json, finalList, false);
            HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
            if (ToolUtil.isNotEmpty((Object)processInstance.getSuperProcessInstanceId()) && (hisList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstance.getSuperProcessInstanceId())).taskVariableValueNotEquals("taskSourceFlag", (Object)"skip")).orderByHistoricTaskInstanceEndTime().asc()).finished().list()).size() > 0) {
                bm = this.repositoryService.getBpmnModel(((HistoricTaskInstance)hisList.get(0)).getProcessDefinitionId());
                hisTaskDefinitionKey = hisList.stream().map(TaskInfo::getTaskDefinitionKey).collect(Collectors.toList());
                list = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(((HistoricTaskInstance)hisList.get(0)).getProcessInstanceId()).activityType("callActivity").list();
                String taskDefinitionKey = "";
                for (HistoricActivityInstance historicActivityInstance : list) {
                    if (ToolUtil.isNotEmpty((Object)historicActivityInstance.getEndTime())) {
                        hisTaskDefinitionKey.add(historicActivityInstance.getActivityId());
                    }
                    if (!"".equals(taskDefinitionKey) || !processInstance.getId().equals(historicActivityInstance.getCalledProcessInstanceId())) continue;
                    taskDefinitionKey = historicActivityInstance.getActivityId();
                }
                hisTaskDefinitionKey = new ArrayList<String>(new HashSet<String>(hisTaskDefinitionKey));
                hisTaskDefinitionKey.remove(taskDefinitionKey);
                process = bm.getMainProcess();
                userTask = (FlowNode)process.getFlowElement(taskDefinitionKey);
                ids = new HashSet();
                ids.add(taskDefinitionKey);
                lists = new ArrayList();
                if (userTask == null) {
                    return InstallResult.getResult("0", this.bpmConstantProperties.getRunningNodeNotFound(), null);
                }
                this.getAllhisNodeList(bm, userTask.getIncomingFlows(), hisTaskDefinitionKey, new ArrayList<String>(ids), new ArrayList<String>(), lists);
                finalList = this.getFinalList(lists);
                this.updateJsonResult(bm, json, finalList, true);
            }
            return InstallResult.getResult("1", "success", json);
        }
        return InstallResult.getResult("0", this.bpmConstantProperties.getModelNotFound(), null);
    }

    private void getAllhisNodeList(BpmnModel bm, List<SequenceFlow> incomingFlows, List<String> hisTaskDefinitionKey, List<String> goneNode, List<String> hisNode, List<List<String>> allHisNode) {
        Process process = (Process)bm.getProcesses().get(0);
        for (SequenceFlow sequenceFlow : incomingFlows) {
            FlowElement flowElement = process.getFlowElement(sequenceFlow.getSourceRef());
            ArrayList<String> goneNodeSave = new ArrayList<String>(goneNode);
            ArrayList<String> hisNodeSave = new ArrayList<String>(hisNode);
            if (flowElement instanceof StartEvent) {
                allHisNode.add(hisNodeSave);
            }
            if (goneNode.contains(flowElement.getId())) continue;
            goneNodeSave.add(flowElement.getId());
            if (hisTaskDefinitionKey.contains(flowElement.getId())) {
                hisNodeSave.add(flowElement.getId());
            }
            this.getAllhisNodeList(bm, ((FlowNode)flowElement).getIncomingFlows(), hisTaskDefinitionKey, goneNodeSave, hisNodeSave, allHisNode);
        }
    }

    private List<String> getFinalList(List<List<String>> lists) {
        if (lists.size() == 0) {
            return new ArrayList<String>();
        }
        List<String> finalList = lists.get(0);
        for (int i = 1; i < lists.size(); ++i) {
            List<String> list = lists.get(i);
            int index = 0;
            for (String id : list) {
                if (finalList.contains(id)) {
                    index = finalList.indexOf(id) + 1;
                    continue;
                }
                finalList.add(index, id);
                ++index;
            }
        }
        return finalList;
    }

    private void updateJsonResult(BpmnModel bm, JSONArray json, List<String> finalList, boolean isRejectMain) {
        Process process = (Process)bm.getProcesses().get(0);
        String preFix = isRejectMain ? CALL_REJECT_PREFIX : "";
        String namePreFix = isRejectMain ? CALL_REJECT_NAME_PREFIX : "";
        for (String id : finalList) {
            FlowElement flowElement = process.getFlowElement(id);
            JSONObject object = new JSONObject();
            object.put("id", (Object)(preFix + flowElement.getId()));
            object.put("name", (Object)(namePreFix + flowElement.getName()));
            json.add((Object)object);
        }
    }

    private String getTaskCommitUser(String processInstanceId, String backActivityId) {
        List hisTaskList;
        StringBuilder assignee = new StringBuilder();
        if (backActivityId.startsWith(CALL_REJECT_PREFIX)) {
            backActivityId = backActivityId.substring(CALL_REJECT_PREFIX.length());
        }
        if ((hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).taskDefinitionKey(backActivityId)).finished().orderByHistoricTaskInstanceEndTime().desc()).list()) != null && hisTaskList.size() > 0) {
            HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)hisTaskList.get(0);
            Date start = historicTaskInstance.getStartTime();
            assignee.append(historicTaskInstance.getAssignee());
            for (int i = 1; i < hisTaskList.size(); ++i) {
                historicTaskInstance = (HistoricTaskInstance)hisTaskList.get(i);
                if (start.getTime() > historicTaskInstance.getEndTime().getTime()) break;
                assignee.append(",").append(historicTaskInstance.getAssignee());
            }
        }
        return assignee.toString();
    }

    private BpmResponseResult installRejectReturnValue(String processInstanceId, boolean isFirst, String starterUserId, String backActivityId, String userId, String taskDefinitionKey, String type, String name, String callTaskDefKey, String callTaskName) {
        if (backActivityId.startsWith(CALL_REJECT_PREFIX)) {
            backActivityId = backActivityId.substring(CALL_REJECT_PREFIX.length());
        }
        JSONArray json = new JSONArray();
        List<String> callActivityInstIds = this.taskEngineMapper.getCallActivityInstId(processInstanceId);
        callActivityInstIds.add(processInstanceId);
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceIdIn(callActivityInstIds)).list();
        Object completeFrom = null;
        Object callCompleteFrom = null;
        HashMap callCompleteFromMap = new HashMap();
        List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).taskDefinitionKey(backActivityId)).includeTaskLocalVariables()).finished().orderByHistoricTaskInstanceEndTime().desc()).listPage(0, 1);
        if (hisTaskList != null && hisTaskList.size() > 0) {
            HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)hisTaskList.get(0);
            completeFrom = historicTaskInstance.getTaskLocalVariables().get("complete_from");
            callCompleteFrom = historicTaskInstance.getTaskLocalVariables().get("call_complete_from");
        }
        callActivityInstIds.remove(processInstanceId);
        if (callActivityInstIds.size() > 0) {
            List callHisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceIdIn(callActivityInstIds)).taskVariableValueNotEquals("call_complete_from", null)).includeTaskLocalVariables()).finished().orderByHistoricTaskInstanceEndTime().desc()).list();
            for (HistoricTaskInstance historicTask : callHisTaskList) {
                if (callCompleteFromMap.get(historicTask.getProcessInstanceId()) != null) continue;
                callCompleteFromMap.put(historicTask.getProcessInstanceId(), historicTask.getTaskLocalVariables().get("call_complete_from"));
            }
        }
        if (tasks != null && tasks.size() > 0) {
            for (Task t : tasks) {
                Set<String> users = this.getAssigneeByTaskId(t.getId());
                if (t.getTaskDefinitionKey().equals(backActivityId) || !processInstanceId.equals(t.getProcessInstanceId())) {
                    if (isFirst && t.getAssignee() == null && StringUtils.isNotEmpty((CharSequence)starterUserId) && users.size() == 0) {
                        this.taskService.setAssignee(t.getId(), starterUserId);
                    }
                    this.taskService.setVariableLocal(t.getId(), "sendUser", (Object)userId);
                    if (processInstanceId.equals(t.getProcessInstanceId())) {
                        this.taskService.setVariableLocal(t.getId(), "reject_from", (Object)taskDefinitionKey);
                        if (completeFrom != null) {
                            this.taskService.setVariableLocal(t.getId(), "complete_from", completeFrom);
                        } else if (callCompleteFrom != null) {
                            this.taskService.setVariableLocal(t.getId(), "call_complete_from", callCompleteFrom);
                        }
                    } else {
                        this.taskService.setVariable(t.getId(), "process_complete_type", (Object)"reject");
                        this.taskService.setVariableLocal(t.getId(), "main_reject_from", (Object)taskDefinitionKey);
                        this.taskService.setVariableLocal(t.getId(), "call_complete_from", callCompleteFromMap.get(t.getProcessInstanceId()));
                    }
                    this.taskService.setVariableLocal(t.getId(), "complete_type", (Object)type);
                    this.taskService.setVariableLocal(t.getId(), "reject_name", (Object)name);
                }
                JSONObject object = new JSONObject();
                object.put("processInstanceId", (Object)t.getProcessInstanceId());
                object.put("taskId", (Object)t.getId());
                object.put("userId", users);
                object.put("taskDefinitionKey", (Object)t.getTaskDefinitionKey());
                object.put("taskDefinitionName", (Object)t.getName());
                object.put("formKey", (Object)t.getFormKey());
                json.add((Object)object);
            }
        }
        return InstallResult.getResult("1", "success", json);
    }

    public List<SysActHiLine> getResult(List<SysActHiLine> list, List<SysActHiLine> result, String startId, String endId) {
        List l1 = list.stream().filter(lineHis -> startId.equals(lineHis.getOutNode())).collect(Collectors.toList());
        if (l1.size() > 0) {
            if (endId.equals(((SysActHiLine)((Object)l1.get(0))).getInNode())) {
                result.add((SysActHiLine)((Object)l1.get(0)));
                return result;
            }
            if (!result.contains(l1.get(0))) {
                result.add((SysActHiLine)((Object)l1.get(0)));
                this.getResult(list, result, ((SysActHiLine)((Object)l1.get(0))).getInNode(), endId);
            }
        }
        return result;
    }

    private void rejectTask(String userId, Task task, String backActivityId, String comment, Map<String, Object> map, int backType, String type) {
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        newMap.put("sendUser", userId);
        Map<String, Object> appointAssignee = new HashMap<String, Object>();
        if (newMap.get("appoint_assignee") != null) {
            appointAssignee = (Map)newMap.get("appoint_assignee");
        }
        appointAssignee.put("static_appoint_assignee", null);
        newMap.put("appoint_assignee", appointAssignee);
        if (backActivityId.startsWith(CALL_REJECT_PREFIX)) {
            String executionId = (String)newMap.get("executionId");
            newMap.remove("executionId");
            String processDefinitionId = (String)newMap.get("processDefinitionId");
            newMap.remove("processDefinitionId");
            String taskDefinitionKey = (String)newMap.get("taskDefinitionKey");
            newMap.remove("taskDefinitionKey");
            this.callReject(userId, executionId, processDefinitionId, taskDefinitionKey, backActivityId, type, comment, newMap);
            if (ToolUtil.isNotEmpty((Object)task.getDueDate())) {
                this.activityRedisTimerService.delTimeOutModel(task.getId());
            }
            return;
        }
        this.taskService.setVariableLocal(task.getId(), "taskSourceFlag", (Object)type);
        if (StringUtils.isNotEmpty((CharSequence)comment)) {
            this.taskService.addComment(task.getId(), null, "complete", comment);
        }
        HashMap<String, Boolean> variables = new HashMap<String, Boolean>();
        variables.put("is_normal_commit", false);
        this.taskService.setVariablesLocal(task.getId(), variables);
        switch (backType) {
            case 2: {
                this.multiInstanceReject(userId, task, backActivityId, newMap);
                break;
            }
            case 3: {
                this.parallelReject(userId, task, backActivityId, type, comment, newMap);
                break;
            }
            default: {
                this.commonReject(userId, task, backActivityId, newMap);
            }
        }
        if (ToolUtil.isNotEmpty((Object)task.getDueDate())) {
            this.activityRedisTimerService.delTimeOutModel(task.getId());
        }
    }

    private void parallelReject(String userId, Task task, String backActivityId, String type, String comment, Map<String, Object> map) {
        if (ToolUtil.isNotEmpty((Object)userId) && ToolUtil.isEmpty((Object)task.getAssignee())) {
            this.claimTask(task.getId(), userId);
        }
        String processDefinition = task.getProcessDefinitionId();
        ReadOnlyProcessDefinition processDefinitionEntity = (ReadOnlyProcessDefinition)this.repositoryService.getProcessDefinition(processDefinition);
        ActivityImpl destinationActivity = (ActivityImpl)processDefinitionEntity.findActivity(backActivityId);
        String executionId = task.getExecutionId();
        ActivityImpl currentActivity = (ActivityImpl)processDefinitionEntity.findActivity(task.getTaskDefinitionKey());
        if (ToolUtil.isEmpty((Object)currentActivity)) {
            throw new PublicClientException(this.bpmConstantProperties.getNodeNotFound(), false);
        }
        this.processEngine.getManagementService().executeCommand((Command)new ParallelJumpTaskCmd(userId, executionId, destinationActivity, type, comment, map, currentActivity));
    }

    private void callReject(String userId, String executionId, String processDefinitionId, String taskDefinitionKey, String backActivityId, String type, String comment, Map<String, Object> map) {
        ReadOnlyProcessDefinition processDefinitionEntity = (ReadOnlyProcessDefinition)this.repositoryService.getProcessDefinition(processDefinitionId);
        ActivityImpl destinationActivity = (ActivityImpl)processDefinitionEntity.findActivity(backActivityId.substring(CALL_REJECT_PREFIX.length()));
        ActivityImpl currentActivity = (ActivityImpl)processDefinitionEntity.findActivity(taskDefinitionKey);
        if (ToolUtil.isEmpty((Object)currentActivity)) {
            throw new PublicClientException(this.bpmConstantProperties.getNodeNotFound(), false);
        }
        this.processEngine.getManagementService().executeCommand((Command)new ParallelJumpTaskCmd(userId, executionId, destinationActivity, type, comment, map, currentActivity));
    }

    private void commonReject(String userId, Task task, String backActivityId, Map<String, Object> map) {
        if (StringUtils.isNotEmpty((CharSequence)userId)) {
            this.claimTask(task.getId(), userId);
        }
        String processDefinition = task.getProcessDefinitionId();
        ReadOnlyProcessDefinition processDefinitionEntity = (ReadOnlyProcessDefinition)this.repositoryService.getProcessDefinition(processDefinition);
        ActivityImpl destinationActivity = (ActivityImpl)processDefinitionEntity.findActivity(backActivityId);
        String executionId = task.getExecutionId();
        String parentId = task.getExecutionId();
        ActivityImpl currentActivity = (ActivityImpl)processDefinitionEntity.findActivity(task.getTaskDefinitionKey());
        if (ToolUtil.isEmpty((Object)currentActivity)) {
            throw new PublicClientException(this.bpmConstantProperties.getNodeNotFound(), false);
        }
        this.processEngine.getManagementService().executeCommand((Command)new CommonJumpTaskCmd(executionId, parentId, destinationActivity, map, currentActivity));
    }

    private void multiInstanceReject(String userId, Task task, String backActivityId, Map<String, Object> map) {
        String processDefinition = task.getProcessDefinitionId();
        ReadOnlyProcessDefinition processDefinitionEntity = (ReadOnlyProcessDefinition)this.repositoryService.getProcessDefinition(processDefinition);
        ActivityImpl destinationActivity = (ActivityImpl)processDefinitionEntity.findActivity(backActivityId);
        String executionId = task.getExecutionId();
        List execution = this.runtimeService.createExecutionQuery().processInstanceId(task.getProcessInstanceId()).activityId(task.getTaskDefinitionKey()).listPage(0, 1);
        String parentId = ((Execution)execution.get(0)).getParentId();
        ActivityImpl currentActivity = (ActivityImpl)processDefinitionEntity.findActivity(task.getTaskDefinitionKey());
        if (ToolUtil.isEmpty((Object)currentActivity)) {
            throw new PublicClientException(this.bpmConstantProperties.getNodeNotFound(), false);
        }
        this.processEngine.getManagementService().executeCommand((Command)new MultiInstanceJumpTaskCmd(userId, executionId, parentId, destinationActivity, map, currentActivity, task.getId()));
    }

    private String getLastActivityId(Task task, Boolean isCallReject) {
        Map map;
        Map map2 = map = task.getTaskLocalVariables() == null ? new HashMap(16) : task.getTaskLocalVariables();
        if (map.get("complete_from") != null) {
            if (isCallReject == null) {
                if (!"0".equals(this.taskEngineMapper.getSuperOrCallProcessCount(task.getProcessInstanceId()))) {
                    Date date = task.getCreateTime();
                    int num = 1;
                    String completeType = (String)map.get("complete_type");
                    List<Map<String, Object>> activityMessage = this.taskEngineMapper.getActivitiMessage(task.getProcessInstanceId());
                    boolean findCallNode = false;
                    for (Map<String, Object> activity : activityMessage) {
                        if (((Date)activity.get("endTime")).getTime() > date.getTime()) continue;
                        date = (Date)activity.get("startTime");
                        if (ToolUtil.isNotEmpty((Object)activity.get("taskId")) || "callActivity".equals(activity.get("type"))) {
                            String type = (String)activity.get("taskSourceFlag");
                            if ("callActivity".equals(activity.get("type"))) {
                                if (findCallNode) {
                                    throw new PublicClientException("\u5b58\u5728\u8fde\u7eed\u7684\u5b50\u6d41\u7a0b\u8282\u70b9\u7684\u4efb\u52a1\uff0c\u83b7\u53d6\u9a73\u56de\u8282\u70b9\u53d7\u5f71\u54cd\uff01");
                                }
                                findCallNode = true;
                                type = completeType;
                            } else {
                                findCallNode = false;
                            }
                            if ("reject".equals(type) || "revoke".equals(type)) {
                                ++num;
                            } else if (!"skip".equals(type)) {
                                --num;
                            }
                        }
                        completeType = (String)activity.get("completeType");
                        if (num != 0) continue;
                        return (String)activity.get("id");
                    }
                    return CALL_REJECT_PREFIX + map.get("complete_from").toString();
                }
            } else if (isCallReject.booleanValue()) {
                return CALL_REJECT_PREFIX + map.get("complete_from").toString();
            }
            return map.get("complete_from").toString();
        }
        if (map.get("call_complete_from") != null) {
            return CALL_REJECT_PREFIX + map.get("call_complete_from");
        }
        return "";
    }

    private String getFirstActivityId(String processInstanceId, String taskDefinitionKey) {
        BpmResponseResult allNodeInfo = this.queryHistoryActByTaskId(null, processInstanceId);
        JSONArray jsonArray = allNodeInfo.getResult();
        JSONObject jsonObject = new JSONObject();
        if (jsonArray != null && jsonArray.size() > 0) {
            jsonObject = jsonArray.getJSONObject(jsonArray.size() - 1);
        }
        if (jsonArray != null && jsonArray.size() == 0) {
            return taskDefinitionKey;
        }
        return jsonObject.getString("nodeId") == null ? "" : jsonObject.getString("nodeId");
    }

    @Override
    public BpmResponseResult delegateTask(String taskId, String userId) {
        this.taskService.delegateTask(taskId, userId);
        this.activityRedisTimerService.updateTimeOutModel(taskId, userId, null, 1);
        return InstallResult.getResult("1", "success", null);
    }

    @Override
    public BpmResponseResult entrustTask(String taskId, String userId, String consignee) {
        if (ToolUtil.isOneEmpty((Object[])new Object[]{userId, taskId, consignee})) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getEntrustFailParameterCanNotNull(), null);
        }
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getTaskNotFound(), null);
        }
        if (task.isSuspended()) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getTaskIsSuspended(), null);
        }
        this.processEngine.getManagementService().executeCommand((Command)new EntrustAssigneeCmd(taskId, userId, consignee, false));
        this.activityRedisTimerService.updateTimeOutModel(taskId, consignee, userId, 0);
        return InstallResult.getResult("1", "success", null);
    }

    @Override
    public BpmResponseResult entrustTask(String taskId, String consignee, int state) {
        if (ToolUtil.isOneEmpty((Object[])new Object[]{taskId, consignee})) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getEntrustFailParameterCanNotNull(), null);
        }
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getTaskNotFound(), null);
        }
        if (task.isSuspended()) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getTaskIsSuspended(), null);
        }
        if (state != 0 && consignee.contains(",") && this.isMulti(task) == 2) {
            return InstallResult.getResult(String.valueOf(BpmEnum.ERROR_ENTRUST_ASSIGNEE.getCode()), String.valueOf(BpmEnum.ERROR_ENTRUST_ASSIGNEE.getCode()), null);
        }
        this.processEngine.getManagementService().executeCommand((Command)new EntrustAssigneeCmd(taskId, "", consignee, state == 0));
        this.activityRedisTimerService.updateTimeOutModel(taskId, consignee, null, state);
        return InstallResult.getResult("1", "success", null);
    }

    @Override
    public BpmResponseResult freeJump(String taskId, String activitiId, String userId, String assignees, boolean isSubmit, String comment, Map<String, Object> map) {
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getTaskNotFound(), null);
        }
        if (task.isSuspended()) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getTaskIsSuspended(), null);
        }
        Map<String, Object> result = this.backType(task, activitiId, false, userId, comment, "freejump");
        int backType = (Integer)result.get("num");
        if (backType == -1) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getRejectToAnyCannotToAnotherBranch(), null);
        }
        if (backType == 4) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getNotRejectToTargetNode(), null);
        }
        String processInstanceId = (String)result.get("processInstanceId");
        String processDefinitionId = (String)result.get("processDefinitionId");
        String taskDefinitionKey = (String)result.get("taskDefinitionKey");
        if (activitiId != null) {
            String nodeId;
            BpmnModel bm = this.repositoryService.getBpmnModel(processDefinitionId);
            String string = nodeId = activitiId.startsWith(CALL_REJECT_PREFIX) ? activitiId.substring(CALL_REJECT_PREFIX.length()) : activitiId;
            if (!this.canReject(bm, taskDefinitionKey, nodeId, null, null, true) && !this.canReject(bm, taskDefinitionKey, nodeId, null, null, false)) {
                return InstallResult.getResult("0", this.bpmConstantProperties.getNotRejectToTargetNode(), null);
            }
        }
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        if (isSubmit) {
            assignees = this.getTaskCommitUser(processInstanceId, activitiId);
        }
        if (ToolUtil.isNotEmpty((Object)assignees)) {
            newMap.put("reject_appoint_assignee", assignees);
        }
        if (backType == 3) {
            this.callActivitiReject((List)result.get("affectedTasks"), (Set)result.get("runningActivitiNodeIds"), processInstanceId, userId, comment, "freejump");
            newMap.put("affectedTasks", result.get("affectedTasks"));
        }
        if (activitiId.startsWith(CALL_REJECT_PREFIX)) {
            newMap.put("executionId", result.get("executionId"));
            newMap.put("processInstanceId", processInstanceId);
            newMap.put("processDefinitionId", processDefinitionId);
            newMap.put("taskDefinitionKey", taskDefinitionKey);
        }
        this.rejectTask(userId, task, activitiId, comment, newMap, backType, "freejump");
        return this.installReturnValue(userId, task.getProcessInstanceId(), task.getTaskDefinitionKey(), newMap);
    }

    @Override
    public BpmResponseResult multiInstanceAddAssignee(String taskId, List<String> assigneeList) {
        if (assigneeList == null || assigneeList.size() < 1) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getAppointAssigneesCanNotNull(), null);
        }
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getTaskNotFound(), null);
        }
        if (task.isSuspended()) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getTaskIsSuspended(), null);
        }
        int num = this.isMulti(task);
        if (num != 2) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getNotMultiCantAddAssignee(), null);
        }
        String outTimeType = null;
        long dueTime = 0L;
        if (ToolUtil.isNotEmpty((Object)task.getDueDate())) {
            BpmnModel bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
            FlowElement element = ((Process)bm.getProcesses().get(0)).getFlowElement(task.getTaskDefinitionKey());
            List timeOutStrategy = (List)element.getExtensionElements().get("TimeOutStrategy");
            if (ToolUtil.isNotEmpty((Object)task.getDueDate()) && ToolUtil.isNotEmpty((Object)timeOutStrategy)) {
                outTimeType = ((ExtensionAttribute)((List)((ExtensionElement)timeOutStrategy.get(0)).getAttributes().get("TimeOutStrategy")).get(0)).getValue();
            }
            dueTime = task.getDueDate().getTime() - task.getCreateTime().getTime();
        }
        this.processEngine.getManagementService().executeCommand((Command)new MultiInstanceAddAssigneeCmd(task.getExecutionId(), assigneeList, dueTime, outTimeType));
        return InstallResult.getResult("1", "success", null);
    }

    @Override
    public BpmResponseResult taskAddAssignee(String taskId, String assignees) {
        if (ToolUtil.isEmpty((Object)assignees)) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getAppointAssigneesCanNotNull(), null);
        }
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getTaskNotFound(), null);
        }
        if (task.isSuspended()) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getTaskIsSuspended(), null);
        }
        int num = this.isMulti(task);
        if (num != 2) {
            this.entrustTask(taskId, assignees, 0);
        } else {
            ArrayList<String> users = new ArrayList<String>(Arrays.asList(assignees.split(",")));
            List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(task.getProcessInstanceId())).taskDefinitionKey(task.getTaskDefinitionKey())).list();
            for (Task runningTask : tasks) {
                if (!ToolUtil.isNotEmpty((Object)runningTask.getAssignee())) continue;
                users.remove(runningTask.getAssignee());
            }
            String outTimeType = null;
            long dueTime = 0L;
            if (ToolUtil.isNotEmpty((Object)task.getDueDate())) {
                BpmnModel bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
                FlowElement element = ((Process)bm.getProcesses().get(0)).getFlowElement(task.getTaskDefinitionKey());
                List timeOutStrategy = (List)element.getExtensionElements().get("TimeOutStrategy");
                if (ToolUtil.isNotEmpty((Object)task.getDueDate()) && ToolUtil.isNotEmpty((Object)timeOutStrategy)) {
                    outTimeType = ((ExtensionAttribute)((List)((ExtensionElement)timeOutStrategy.get(0)).getAttributes().get("TimeOutStrategy")).get(0)).getValue();
                }
                dueTime = task.getDueDate().getTime() - task.getCreateTime().getTime();
            }
            if (ToolUtil.isNotEmpty(users)) {
                this.processEngine.getManagementService().executeCommand((Command)new MultiInstanceAddAssigneeCmd(task.getExecutionId(), users, dueTime, outTimeType));
            }
        }
        return InstallResult.getResult("1", "success", null);
    }

    @Override
    public BpmResponseResult queryProcessNodeByTaskId(String taskId) {
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getTaskNotFound(), null);
        }
        if (task.isSuspended()) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getTaskIsSuspended(), null);
        }
        JSONArray json = new JSONArray();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(task.getProcessDefinitionId()).singleResult();
        if (processDefinition == null) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getProcessNotFound(), null);
        }
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinition.getId());
        if (bpmnModel != null) {
            Collection flowElements = ((Process)bpmnModel.getProcesses().get(0)).getFlowElements();
            for (FlowElement flowElement : flowElements) {
                if (!(flowElement instanceof UserTask)) continue;
                JSONObject object = new JSONObject();
                object.put("id", (Object)flowElement.getId());
                object.put("name", (Object)flowElement.getName());
                json.add((Object)object);
            }
            return InstallResult.getResult("1", "success", json);
        }
        return InstallResult.getResult("0", this.bpmConstantProperties.getModelNotFound(), null);
    }

    @Override
    public BpmResponseResult queryAssigneeByTaskId(String taskId) {
        JSONArray json = new JSONArray();
        Set<String> users = this.getAssigneeByTaskId(taskId);
        json.add(users);
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult addAssignees(String taskId, String businessKey, String users) {
        if (ToolUtil.isEmpty((Object)users)) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getAppointAssigneesCanNotNull(), null);
        }
        if (ToolUtil.isNotEmpty((Object)taskId)) {
            this.processEngine.getManagementService().executeCommand((Command)new AddAssigneeCmd(taskId, users));
            this.activityRedisTimerService.updateTimeOutModel(taskId, users, null, 0);
        } else {
            if (businessKey == null) {
                return InstallResult.getResult("0", this.bpmConstantProperties.getNotNullParamIsNull(), null);
            }
            List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceBusinessKey(businessKey)).list();
            if (tasks.size() == 0) {
                return InstallResult.getResult("0", this.bpmConstantProperties.getTaskNotFound(), null);
            }
            for (Task task : tasks) {
                this.processEngine.getManagementService().executeCommand((Command)new AddAssigneeCmd(task.getId(), users));
                this.activityRedisTimerService.updateTimeOutModel(task.getId(), users, null, 0);
            }
        }
        return InstallResult.getResult("1", this.bpmConstantProperties.getAppointAssigneesSuccess(), null);
    }

    @Override
    public BpmResponseResult queryNextAssigneeByTaskIdAndNodeId(String taskId, String nodeId, String tenantId, Map<String, Object> map) {
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getTaskNotFound(), null);
        }
        if (task.isSuspended()) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getTaskIsSuspended(), null);
        }
        JSONArray jsonArray = new JSONArray();
        BpmnModel bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
        if (bm == null) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getModelNotFound(), null);
        }
        HashSet<String> users = AnalyticalModelUtil.getNextCandidateUser(task, bm, nodeId, tenantId, map);
        if (users.size() > 0) {
            jsonArray.addAll(this.iAssigneeChooseService.getUserListByUserIdWithSelect(new ArrayList<String>(users), tenantId));
        }
        return InstallResult.getResult("1", "success", jsonArray);
    }

    @Override
    public BpmResponseResult queryNextAssigneeByTaskIdAndNodeId(String processDefinitionKey, String taskId, String nodeId, String tenantId, Map<String, Object> map) {
        if (ToolUtil.isNotEmpty((Object)taskId)) {
            return this.queryNextAssigneeByTaskIdAndNodeId(taskId, nodeId, tenantId, map);
        }
        if (ToolUtil.isNotEmpty((Object)processDefinitionKey)) {
            String processDefinitionId = this.processDefinitionsService.getMainOrNew(processDefinitionKey).getId();
            BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitionId);
            if (bpmnModel == null) {
                return InstallResult.getResult("0", this.bpmConstantProperties.getModelNotFound(), null);
            }
            JSONArray jsonArray = new JSONArray();
            HashSet<String> users = AnalyticalModelUtil.getNextCandidateUserByModel(processDefinitionId, processDefinitionKey, bpmnModel, nodeId, tenantId, map);
            if (users.size() > 0) {
                jsonArray.addAll(this.iAssigneeChooseService.getUserListByUserIdWithSelect(new ArrayList<String>(users), tenantId));
            }
            return InstallResult.getResult("1", "success", jsonArray);
        }
        return InstallResult.getResult("0", this.bpmConstantProperties.getNotNullParamIsNull(), null);
    }

    private Set<String> getAssigneeByTaskId(String taskId) {
        HashSet<String> users = new HashSet<String>();
        List identityLinkList = this.taskService.getIdentityLinksForTask(taskId);
        if (identityLinkList != null && identityLinkList.size() > 0) {
            for (IdentityLink identityLink : identityLinkList) {
                users.add(identityLink.getUserId());
            }
        }
        return users;
    }

    @Override
    public BpmResponseResult queryHistoryActByTaskId(String taskId, String processInstanceId) {
        JSONArray json = new JSONArray();
        String newProcessInstanceId = processInstanceId;
        if (newProcessInstanceId == null) {
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
            if (task == null) {
                return InstallResult.getResult("0", this.bpmConstantProperties.getTaskNotFound(), null);
            }
            if (task.isSuspended()) {
                return InstallResult.getResult("0", this.bpmConstantProperties.getTaskIsSuspended(), null);
            }
            newProcessInstanceId = task.getProcessInstanceId();
        }
        try {
            List list = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(newProcessInstanceId)).orderByHistoricTaskInstanceEndTime().finished().desc()).list();
            if (list != null && list.size() > 0) {
                for (HistoricTaskInstance historyIns : list) {
                    JSONObject object = new JSONObject();
                    String tId = historyIns.getId();
                    if (tId.equals(taskId)) continue;
                    object.put("nodeId", (Object)historyIns.getTaskDefinitionKey());
                    object.put("nodeName", (Object)historyIns.getName());
                    object.put("taskId", (Object)tId);
                    object.put("count", (Object)list.size());
                    object.put("endTime", historyIns.getEndTime() == null ? null : Long.valueOf(historyIns.getEndTime().getTime()));
                    json.add((Object)object);
                }
            }
            return InstallResult.getResult("1", "success", json);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5386\u53f2\u73af\u8282\u4fe1\u606f\u63a5\u53e3\u51fa\u9519\uff1a" + e.getMessage());
            return InstallResult.getResult("0", e.getMessage(), null);
        }
    }

    @Override
    public BpmResponseResult getProcessDefinitionIdAndNodeId(String processDefinitionKey, String taskId) {
        String processDefinitionId = "";
        String nodeId = "";
        if (ToolUtil.isNotEmpty((Object)processDefinitionKey)) {
            DefinitionModel definitionModel = this.processDefinitionsService.getMainOrNew(processDefinitionKey);
            if (definitionModel != null) {
                processDefinitionId = definitionModel.getId();
            }
        } else {
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
            if (task != null) {
                if (task.isSuspended()) {
                    return InstallResult.getResult("0", this.bpmConstantProperties.getTaskIsSuspended(), null);
                }
                processDefinitionId = task.getProcessDefinitionId();
                nodeId = task.getTaskDefinitionKey();
            }
        }
        JSONArray json = new JSONArray();
        JSONObject object = new JSONObject();
        object.put("result", (Object)(processDefinitionId + nodeId));
        json.add((Object)object);
        return InstallResult.getResult("1", "success", json);
    }

    private List<Map<String, Object>> getTodoResultMap(List<FlowTask> datas) {
        ArrayList<Map<String, Object>> resultData = new ArrayList<Map<String, Object>>();
        for (FlowTask flowTask : datas) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("variables", flowTask.getProcessVariableMap());
            result.put("definitionName", flowTask.getProcessDefinitionName());
            result.put("formKey", flowTask.getFormKey());
            result.put("businessId", flowTask.getBusinessId());
            result.put("sendUser", flowTask.getSendUser());
            result.put("processInsId", flowTask.getProcessInstId());
            result.put("taskDefinitionKey", flowTask.getTaskDefinitionKey());
            result.put("taskDefinitionName", flowTask.getName());
            result.put("createTime", flowTask.getStartTime());
            result.put("taskVariables", flowTask.getTaskVariableMap());
            result.put("definitionKey", flowTask.getProcessDefinitionKey());
            result.put("taskSourceFlag", flowTask.getTaskVariableMap().get("taskSourceFlag"));
            result.put("taskId", flowTask.getTaskId());
            result.put("definitionId", flowTask.getProcessDefinitionId());
            resultData.add(result);
        }
        return resultData;
    }

    private List<Map<String, Object>> tasksToMap(List<Task> tasks) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        HashSet<String> processInstanceIds = new HashSet<String>();
        ArrayList<ProcessInstance> pis = new ArrayList();
        if (tasks != null && tasks.size() > 0) {
            for (Task t : tasks) {
                processInstanceIds.add(t.getProcessInstanceId());
            }
            pis = this.runtimeService.createProcessInstanceQuery().processInstanceIds(processInstanceIds).list();
        }
        if (tasks != null && tasks.size() > 0) {
            ArrayList<String> taskIds = new ArrayList<String>();
            ArrayList<String> instIds = new ArrayList<String>();
            for (Task task : tasks) {
                taskIds.add(task.getId());
                instIds.add(task.getProcessInstanceId());
            }
            List<Variables> allVariables = this.flowEventsServiceMapper.getAllVariables(taskIds, instIds);
            HashMap<String, ArrayList<Variables>> taskVariablesMap = new HashMap<String, ArrayList<Variables>>();
            HashMap<String, ArrayList<Variables>> processVariablesMap = new HashMap<String, ArrayList<Variables>>();
            for (Variables variables : allVariables) {
                List<Variables> list_variables;
                if (variables.getTaskId() == null) {
                    list_variables = (ArrayList<Variables>)processVariablesMap.get(variables.getProcessInstanceId());
                    if (list_variables == null) {
                        list_variables = new ArrayList<Variables>();
                    }
                    list_variables.add(variables);
                    processVariablesMap.put(variables.getProcessInstanceId(), (ArrayList<Variables>)list_variables);
                    continue;
                }
                list_variables = (List)taskVariablesMap.get(variables.getTaskId());
                if (list_variables == null) {
                    list_variables = new ArrayList();
                }
                list_variables.add(variables);
                taskVariablesMap.put(variables.getTaskId(), (ArrayList<Variables>)list_variables);
            }
            for (Task task : tasks) {
                String message;
                String sendUser;
                HashMap<String, Object> taskMap = new HashMap<String, Object>(16);
                ProcessInstance pi = this.getProcessInstance(pis, task.getProcessInstanceId());
                taskMap.put("taskId", task.getId());
                taskMap.put("taskDefinitionName", task.getName());
                taskMap.put("definitionKey", pi.getProcessDefinitionKey());
                taskMap.put("definitionId", task.getProcessDefinitionId());
                taskMap.put("definitionName", pi.getProcessDefinitionName());
                taskMap.put("taskDefinitionKey", task.getTaskDefinitionKey());
                taskMap.put("processInsId", task.getProcessInstanceId());
                taskMap.put("createTime", task.getCreateTime());
                taskMap.put("businessId", pi.getBusinessKey());
                taskMap.put("variables", this.getCorrectVariableMap((List)processVariablesMap.get(task.getProcessInstanceId())));
                Map<String, Object> taskCorrectVariablesMap = this.getCorrectVariableMap((List)taskVariablesMap.get(task.getId()));
                taskMap.put("taskVariables", taskCorrectVariablesMap);
                taskMap.put("taskSourceFlag", taskCorrectVariablesMap.get("taskSourceFlag"));
                String string = sendUser = taskCorrectVariablesMap.get("sendUser") == null ? "" : taskCorrectVariablesMap.get("sendUser").toString();
                if (ToolUtil.isNotEmpty((Object)sendUser)) {
                    taskMap.put("sendUser", sendUser);
                }
                String string2 = message = taskCorrectVariablesMap.get("todoConfiguration") == null ? "" : taskCorrectVariablesMap.get("todoConfiguration").toString();
                if (ToolUtil.isNotEmpty((Object)message)) {
                    taskMap.put("message", message);
                }
                taskMap.put("formKey", task.getFormKey());
                list.add(taskMap);
            }
        }
        return list;
    }

    private Map<String, Object> getCorrectVariableMap(List<Variables> list) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (ToolUtil.isNotEmpty(list)) {
            for (Variables variables : list) {
                if ("string".equals(variables.getVariableType())) {
                    map.put(variables.getName(), variables.getTextValue());
                }
                if ("integer".equals(variables.getVariableType())) {
                    map.put(variables.getName(), variables.getLongValue());
                }
                if ("double".equals(variables.getVariableType())) {
                    map.put(variables.getName(), variables.getDoubleValue());
                }
                if (!"boolean".equals(variables.getVariableType())) continue;
                long num = variables.getLongValue() == null ? 0L : variables.getLongValue();
                map.put(variables.getName(), 1L == num);
            }
        }
        return map;
    }

    private ProcessInstance getProcessInstance(List<ProcessInstance> pis, String processInstanceId) {
        if (pis != null && pis.size() > 0) {
            for (ProcessInstance p : pis) {
                if (!p.getId().equals(processInstanceId)) continue;
                return p;
            }
        }
        return null;
    }

    private List<Map<String, Object>> hisTasksToMap(List<HistoricTaskInstance> hs) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        HashSet<String> processInstanceIds = new HashSet<String>();
        ArrayList<String> instIds = new ArrayList<String>();
        ArrayList<HistoricProcessInstance> pis = new ArrayList();
        ArrayList<String> ids = new ArrayList<String>();
        if (hs != null && hs.size() > 0) {
            for (HistoricTaskInstance h : hs) {
                processInstanceIds.add(h.getProcessInstanceId());
                instIds.add(h.getProcessInstanceId());
                ids.add(h.getProcessDefinitionId() + h.getTaskDefinitionKey());
            }
            pis = this.historyService.createHistoricProcessInstanceQuery().processInstanceIds(processInstanceIds).list();
        }
        Map<String, String> propertiesMap = this.iSysActExtendPropertiesService.queryList(ids);
        List<Variables> allVariables = this.flowEventsServiceMapper.getAllVariables(ids, instIds);
        HashMap<String, ArrayList<Variables>> taskVariablesMap = new HashMap<String, ArrayList<Variables>>();
        HashMap<String, ArrayList<Variables>> processVariablesMap = new HashMap<String, ArrayList<Variables>>();
        for (Variables variables : allVariables) {
            List<Variables> list_variables;
            if (variables.getTaskId() == null) {
                list_variables = (ArrayList<Variables>)processVariablesMap.get(variables.getProcessInstanceId());
                if (list_variables == null) {
                    list_variables = new ArrayList<Variables>();
                }
                list_variables.add(variables);
                processVariablesMap.put(variables.getProcessInstanceId(), (ArrayList<Variables>)list_variables);
                continue;
            }
            list_variables = (List)taskVariablesMap.get(variables.getTaskId());
            if (list_variables == null) {
                list_variables = new ArrayList();
            }
            list_variables.add(variables);
            taskVariablesMap.put(variables.getTaskId(), (ArrayList<Variables>)list_variables);
        }
        if (hs != null && hs.size() > 0) {
            for (HistoricTaskInstance hsi : hs) {
                String message;
                String sendUser;
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                HistoricProcessInstance hpi = this.getHistoricProcessInstance(pis, hsi.getProcessInstanceId());
                Map<String, Object> variables = this.getCorrectVariableMap((List)processVariablesMap.get(hsi.getProcessInstanceId()));
                Map<String, Object> taskVariables = this.getCorrectVariableMap((List)taskVariablesMap.get(hsi.getId()));
                map.put("taskId", hsi.getId());
                map.put("taskDefinitionName", hsi.getName());
                map.put("assigneeId", hsi.getAssignee());
                map.put("definitionId", hsi.getProcessDefinitionId());
                map.put("definitionKey", hpi.getProcessDefinitionKey());
                map.put("definitionName", hpi.getProcessDefinitionName());
                map.put("taskDefinitionKey", hsi.getTaskDefinitionKey());
                map.put("processInsId", hsi.getProcessInstanceId());
                map.put("claimTime", hsi.getClaimTime());
                map.put("startTime", hsi.getStartTime());
                map.put("endTime", hsi.getEndTime());
                map.put("businessId", hpi.getBusinessKey());
                map.put("variables", variables);
                map.put("taskVariables", taskVariables);
                map.put("taskSourceFlag", taskVariables.get("taskSourceFlag"));
                String string = sendUser = taskVariables.get("sendUser") == null ? "" : taskVariables.get("sendUser").toString();
                if (ToolUtil.isNotEmpty((Object)sendUser)) {
                    map.put("sendUser", sendUser);
                }
                String string2 = message = taskVariables.get("todoConfiguration") == null ? "" : taskVariables.get("todoConfiguration").toString();
                if (ToolUtil.isNotEmpty((Object)message)) {
                    map.put("message", message);
                }
                map.put("formKey", hsi.getFormKey());
                map.put("formDetailKey", propertiesMap.get(hsi.getProcessDefinitionId() + hsi.getTaskDefinitionKey()));
                list.add(map);
            }
        }
        return list;
    }

    private HistoricProcessInstance getHistoricProcessInstance(List<HistoricProcessInstance> pis, String processInstanceId) {
        if (pis != null && pis.size() > 0) {
            for (HistoricProcessInstance p : pis) {
                if (!p.getId().equals(processInstanceId)) continue;
                return p;
            }
        }
        return null;
    }

    @Override
    public BpmResponseResult queryTaskIdByBusinessKey(String businessId) {
        JSONArray json = new JSONArray();
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceBusinessKey(businessId)).list();
        if (tasks != null) {
            for (Task task : tasks) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("taskId", (Object)task.getId());
                jsonObject.put("taskDefinitionKey", (Object)task.getTaskDefinitionKey());
                jsonObject.put("name", (Object)task.getName());
                jsonObject.put("processInstanceId", (Object)task.getProcessInstanceId());
                json.add((Object)jsonObject);
            }
        }
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult queryNextNode(String taskId) {
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getTaskNotFound(), null);
        }
        if (task.isSuspended()) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getTaskIsSuspended(), null);
        }
        JSONArray jsonArray = new JSONArray();
        BpmnModel bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
        if (bm == null) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getModelNotFound(), null);
        }
        Process process = (Process)bm.getProcesses().get(0);
        UserTask userTask = (UserTask)process.getFlowElement(task.getTaskDefinitionKey());
        if (userTask == null) {
            return InstallResult.getResult("1", "success", jsonArray);
        }
        List sequenceFlows = userTask.getOutgoingFlows();
        this.getUserTask(jsonArray, process, sequenceFlows);
        return InstallResult.getResult("1", "success", jsonArray);
    }

    @Override
    public BpmResponseResult queryNextNode(String processDefinitionKey, String taskId) {
        if (ToolUtil.isNotEmpty((Object)taskId)) {
            return this.queryNextNode(taskId);
        }
        JSONArray jsonArray = new JSONArray();
        if (ToolUtil.isNotEmpty((Object)processDefinitionKey)) {
            BpmnModel bpmnModel = this.repositoryService.getBpmnModel(this.processDefinitionsService.getMainOrNew(processDefinitionKey).getId());
            Process process = bpmnModel.getMainProcess();
            Collection flowElements = process.getFlowElements();
            for (FlowElement flowElement : flowElements) {
                List startOut;
                String firstUserTask;
                if (!(flowElement instanceof StartEvent) || !(process.getFlowElement(firstUserTask = ((SequenceFlow)(startOut = ((StartEvent)flowElement).getOutgoingFlows()).get(0)).getTargetRef()) instanceof UserTask)) continue;
                UserTask userTask = (UserTask)process.getFlowElement(firstUserTask);
                List sequenceFlows = userTask.getOutgoingFlows();
                this.getUserTask(jsonArray, process, sequenceFlows);
            }
            return InstallResult.getResult("1", "success", jsonArray);
        }
        return InstallResult.getResult("0", this.bpmConstantProperties.getNotNullParamIsNull(), jsonArray);
    }

    private void getUserTask(JSONArray jsonArray, Process process, List<SequenceFlow> sfs) {
        if (sfs != null && sfs.size() > 0) {
            for (SequenceFlow sequenceFlow : sfs) {
                List sequenceFlows;
                ExclusiveGateway exclusiveGateway;
                UserTask u;
                JSONObject jsonObject;
                String targetRef = sequenceFlow.getTargetRef();
                if (process.getFlowElement(targetRef) instanceof UserTask) {
                    jsonObject = new JSONObject();
                    u = (UserTask)process.getFlowElement(targetRef);
                    jsonObject.put("id", (Object)u.getId());
                    jsonObject.put("name", (Object)u.getName());
                    jsonArray.add((Object)jsonObject);
                }
                if (process.getFlowElement(targetRef) instanceof EndEvent) {
                    jsonObject = new JSONObject();
                    u = (EndEvent)process.getFlowElement(targetRef);
                    jsonObject.put("id", (Object)u.getId());
                    jsonObject.put("name", (Object)u.getName());
                    jsonArray.add((Object)jsonObject);
                }
                if (process.getFlowElement(targetRef) instanceof ExclusiveGateway) {
                    exclusiveGateway = (ExclusiveGateway)process.getFlowElement(targetRef);
                    sequenceFlows = exclusiveGateway.getOutgoingFlows();
                    this.getUserTask(jsonArray, process, sequenceFlows);
                }
                if (process.getFlowElement(targetRef) instanceof InclusiveGateway) {
                    exclusiveGateway = (InclusiveGateway)process.getFlowElement(targetRef);
                    sequenceFlows = exclusiveGateway.getOutgoingFlows();
                    this.getUserTask(jsonArray, process, sequenceFlows);
                }
                if (process.getFlowElement(targetRef) instanceof CallActivity) {
                    CallActivity callActivity = (CallActivity)process.getFlowElement(targetRef);
                    JSONObject jsonObject2 = new JSONObject();
                    jsonObject2.put("id", (Object)callActivity.getId());
                    jsonObject2.put("name", (Object)callActivity.getName());
                    jsonArray.add((Object)jsonObject2);
                }
                if (!(process.getFlowElement(targetRef) instanceof ParallelGateway)) continue;
                jsonObject = new JSONObject();
                ParallelGateway p = (ParallelGateway)process.getFlowElement(targetRef);
                jsonObject.put("id", (Object)p.getId());
                jsonObject.put("name", (Object)p.getName());
                jsonArray.add((Object)jsonObject);
            }
        }
    }

    @Override
    public BpmResponseResult withdrawState(String historicTaskId) {
        ProcessInstance instance;
        if (historicTaskId == null) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        JSONArray json = new JSONArray();
        boolean result = true;
        HistoricTaskInstance currTask = (HistoricTaskInstance)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(historicTaskId)).includeTaskLocalVariables()).singleResult();
        if (currTask == null) {
            LOGGER.error(this.bpmConstantProperties.getTaskNotFound());
            return InstallResult.getResult("0", this.bpmConstantProperties.getTaskNotFound(), null);
        }
        if ("skip".equals(currTask.getTaskLocalVariables().get("taskSourceFlag"))) {
            result = false;
        }
        if ((instance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(currTask.getProcessInstanceId()).singleResult()) == null) {
            LOGGER.error(this.bpmConstantProperties.getProcessEnd());
            return InstallResult.getResult("0", this.bpmConstantProperties.getProcessEnd(), null);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        map.put("processInstanceId", currTask.getProcessInstanceId());
        map.put("endTime", formatter.format(currTask.getEndTime()));
        map.put("taskDefinitionKey", currTask.getTaskDefinitionKey());
        map.put("dbType", this.url.split(":")[1]);
        map.put("isEnd", "true");
        if (!"0".equals(this.taskEngineMapper.withdrawState(map))) {
            result = false;
        }
        map.put("isEnd", "false");
        if ("0".equals(this.taskEngineMapper.withdrawState(map))) {
            result = false;
        }
        json.add((Object)result);
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult withdrawState(String businessKey, String userId, String taskId) {
        List hisTaskList;
        String completeFrom;
        if (ToolUtil.isOneEmpty((Object[])new Object[]{businessKey, taskId, userId})) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        ProcessInstance instance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey(businessKey).singleResult();
        if (instance == null) {
            LOGGER.error(this.bpmConstantProperties.getProcessEnd());
            return InstallResult.getResult("0", this.bpmConstantProperties.getProcessEnd(), null);
        }
        Task task = (Task)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).includeTaskLocalVariables()).singleResult();
        if (task == null) {
            LOGGER.error(this.bpmConstantProperties.getTaskNotFound());
            return InstallResult.getResult("0", this.bpmConstantProperties.getTaskNotFound(), null);
        }
        if (task.isSuspended()) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getTaskIsSuspended(), null);
        }
        Map map = task.getTaskLocalVariables() == null ? new HashMap(16) : task.getTaskLocalVariables();
        String string = completeFrom = map.get("complete_from") == null ? "" : map.get("complete_from").toString();
        if (ToolUtil.isNotEmpty((Object)completeFrom) && (hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(task.getProcessInstanceId())).taskDefinitionKey(completeFrom)).orderByHistoricTaskInstanceEndTime().finished().desc()).listPage(0, 1)) != null && hisTaskList.size() > 0 && ((HistoricTaskInstance)hisTaskList.get(0)).getAssignee().equals(userId)) {
            JSONArray json = new JSONArray();
            json.add((Object)((HistoricTaskInstance)hisTaskList.get(0)).getId());
            return InstallResult.getResult("1", "success", json);
        }
        return InstallResult.getResult("0", "error", null);
    }

    @Override
    public BpmResponseResult revokeTask(String historicTaskId, String userId, String comment, boolean isSubmit, Map<String, Object> map) {
        HistoricTaskInstance currTask = (HistoricTaskInstance)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(historicTaskId)).includeTaskLocalVariables()).singleResult();
        String taskSourceFlag = (String)currTask.getTaskLocalVariables().get("taskSourceFlag");
        boolean revokeReject = false;
        if ("reject".equals(taskSourceFlag)) {
            revokeReject = true;
        }
        if ("revoke".equals(taskSourceFlag) || "reject_revoke".equals(taskSourceFlag)) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getForbidRevoke(), null);
        }
        boolean isCallReject = false;
        List taskList = ((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(currTask.getProcessInstanceId())).taskVariableValueLike(revokeReject ? "reject_from" : "complete_from", currTask.getTaskDefinitionKey())).includeProcessVariables()).includeTaskLocalVariables()).listPage(0, 1);
        if (ToolUtil.isEmpty((Object)taskList)) {
            List list = this.historyService.createHistoricActivityInstanceQuery().unfinished().processInstanceId(currTask.getProcessInstanceId()).activityType("callActivity").list();
            ArrayList<String> procIds = new ArrayList<String>();
            for (HistoricActivityInstance historicActivityInstance : list) {
                procIds.add(historicActivityInstance.getCalledProcessInstanceId());
            }
            if (procIds.size() > 0) {
                isCallReject = true;
                taskList = ((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceIdIn(procIds)).taskVariableValueEquals(revokeReject ? "main_reject_from" : "call_complete_from", (Object)currTask.getTaskDefinitionKey())).includeProcessVariables()).includeTaskLocalVariables()).listPage(0, 1);
                if (taskList.size() == 0 && !revokeReject) {
                    taskList = ((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceIdIn(procIds)).taskVariableValueEquals("complete_from", (Object)currTask.getTaskDefinitionKey())).includeProcessVariables()).includeTaskLocalVariables()).listPage(0, 1);
                }
            }
        }
        if (taskList != null && taskList.size() > 0) {
            int backType;
            String backActivityId;
            Task task = (Task)taskList.get(0);
            task.setAssignee(userId);
            boolean isFirst = false;
            String starterUserId = "";
            if (revokeReject) {
                Map variables = task.getTaskLocalVariables() == null ? new HashMap(16) : task.getTaskLocalVariables();
                backActivityId = isCallReject ? CALL_REJECT_PREFIX + variables.get("main_reject_from").toString() : variables.get("reject_from").toString();
            } else {
                backActivityId = this.getLastActivityId(task, isCallReject);
            }
            if ("".equals(backActivityId)) {
                return InstallResult.getResult("0", this.bpmConstantProperties.getForbidRevoke(), null);
            }
            Map<String, Object> results = this.backType(task, backActivityId, false, userId, comment, revokeReject ? "reject_revoke" : "revoke");
            String processInstanceId = (String)results.get("processInstanceId");
            String processDefinitionId = (String)results.get("processDefinitionId");
            String taskDefinitionKey = (String)results.get("taskDefinitionKey");
            if (backActivityId != null) {
                String nodeId;
                BpmnModel bm = this.repositoryService.getBpmnModel(processDefinitionId);
                String string = nodeId = backActivityId.startsWith(CALL_REJECT_PREFIX) ? backActivityId.substring(CALL_REJECT_PREFIX.length()) : backActivityId;
                if (!this.canReject(bm, taskDefinitionKey, nodeId, null, null, true) && !this.canReject(bm, taskDefinitionKey, nodeId, null, null, false)) {
                    return InstallResult.getResult("0", this.bpmConstantProperties.getNotRevokeToTargetNode(), null);
                }
            }
            if (backActivityId != null && (backActivityId.equals(this.getFirstActivityId(processInstanceId, taskDefinitionKey)) || backActivityId.equals(CALL_REJECT_PREFIX + this.getFirstActivityId(processInstanceId, taskDefinitionKey)))) {
                starterUserId = this.getTaskStarterUserId(task.getProcessInstanceId());
                isFirst = true;
            }
            if ((backType = ((Integer)results.get("num")).intValue()) == 0) {
                return InstallResult.getResult("0", this.bpmConstantProperties.getForbidRevoke(), null);
            }
            if (backType == 4) {
                return InstallResult.getResult("0", this.bpmConstantProperties.getNotRevokeToTargetNode(), null);
            }
            HashMap<String, Object> newMap = new HashMap<String, Object>();
            if (map != null) {
                newMap.putAll(map);
            }
            if (!revokeReject && isSubmit) {
                newMap.put("reject_appoint_assignee", this.getTaskCommitUser((String)results.get("processInstanceId"), backActivityId));
            }
            if (backType == 3) {
                this.callActivitiReject((List)results.get("affectedTasks"), (Set)results.get("runningActivitiNodeIds"), processInstanceId, userId, comment, revokeReject ? "reject_revoke" : "revoke");
                newMap.put("affectedTasks", results.get("affectedTasks"));
            }
            if (backActivityId.startsWith(CALL_REJECT_PREFIX)) {
                newMap.put("executionId", results.get("executionId"));
                newMap.put("processInstanceId", processInstanceId);
                newMap.put("processDefinitionId", processDefinitionId);
                newMap.put("taskDefinitionKey", taskDefinitionKey);
            }
            this.rejectTask(userId, task, backActivityId, comment, newMap, backType, revokeReject ? "reject_revoke" : "revoke");
            BpmResponseResult result = this.installRejectReturnValue(processInstanceId, isFirst, starterUserId, backActivityId, userId, taskDefinitionKey, revokeReject ? "reject_revoke" : "revoke", (String)results.get("taskName"), task.getTaskDefinitionKey(), task.getName());
            return result;
        }
        return InstallResult.getResult("0", "error", null);
    }

    private String getTaskStarterUserId(String processInstanceId) {
        String starterUserId = "";
        HistoricProcessInstance hpi = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (hpi != null) {
            starterUserId = hpi.getStartUserId();
        }
        return starterUserId;
    }

    private int isMulti(Task task) {
        int num = 1;
        ProcessDefinitionEntity definition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(task.getProcessDefinitionId());
        if (definition == null) {
            LOGGER.error(this.bpmConstantProperties.getProcessNotFound());
            return 0;
        }
        ActivityImpl currActivity = definition.findActivity(task.getTaskDefinitionKey());
        ActivityBehavior activityBehavior = currActivity.getActivityBehavior();
        if (activityBehavior instanceof ParallelMultiInstanceBehavior || activityBehavior instanceof SequentialMultiInstanceBehavior) {
            num = 2;
        }
        return num;
    }

    private Map<String, Object> backType(Task task, String nodeId, boolean isRejectFirst, String userId, String comment, String type) {
        Map<String, Object> result = this.getBackTypeWithTasks(nodeId, task, isRejectFirst, userId, comment, type);
        int num = (Integer)result.get("num");
        if (nodeId.startsWith(CALL_REJECT_PREFIX)) {
            result.put("num", 3);
            return result;
        }
        if (num != 1) {
            return result;
        }
        ProcessInstance instance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
        if (instance == null) {
            LOGGER.error(this.bpmConstantProperties.getProcessEnd());
            num = 0;
            result.put("num", num);
            return result;
        }
        ProcessDefinitionEntity definition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(task.getProcessDefinitionId());
        if (definition == null) {
            LOGGER.error(this.bpmConstantProperties.getProcessNotFound());
            num = 0;
            result.put("num", num);
            return result;
        }
        ActivityImpl currActivity = definition.findActivity(task.getTaskDefinitionKey());
        if (currActivity == null) {
            throw new PublicClientException(this.bpmConstantProperties.getRunningNodeNotFound(), false);
        }
        ActivityBehavior activityBehavior = currActivity.getActivityBehavior();
        if (nodeId == null) {
            List incomingTransitions = currActivity.getIncomingTransitions();
            for (PvmTransition pvmTransition : incomingTransitions) {
                PvmActivity pvmActivity = pvmTransition.getSource();
                ActivityBehavior inActivity = ((ActivityImpl)pvmActivity).getActivityBehavior();
                if (!(inActivity instanceof ParallelGatewayActivityBehavior) && !(inActivity instanceof InclusiveGatewayActivityBehavior) || pvmActivity.getIncomingTransitions().size() <= 1) continue;
                num = 0;
                result.put("num", num);
                return result;
            }
        }
        if (activityBehavior instanceof ParallelMultiInstanceBehavior || activityBehavior instanceof SequentialMultiInstanceBehavior) {
            num = 2;
        }
        result.put("num", num);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, Object> getBackTypeWithTasks(String nodeId, Task task, boolean isRejectFirst, String userId, String comment, String type) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List<Object> affectedTasks = new ArrayList<String>();
        int newNum = 1;
        ArrayList<String> taskIds = new ArrayList<String>();
        HashSet<String> runningNodeIds = new HashSet<String>();
        ArrayList<String> finishedNodeIds = new ArrayList<String>();
        HashSet<String> runningActivitiNodeIds = new HashSet<String>();
        String processInstanceId = task.getProcessInstanceId();
        String processDefinitionId = task.getProcessDefinitionId();
        String taskDefinitionKey = task.getTaskDefinitionKey();
        String taskName = task.getName();
        if (nodeId.startsWith(CALL_REJECT_PREFIX)) {
            nodeId = nodeId.substring(CALL_REJECT_PREFIX.length());
            HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
            if (processInstance.getSuperProcessInstanceId() == null) {
                throw new PublicClientException("\u8be5\u6d41\u7a0b\u6ca1\u6709\u4e3b\u6d41\u7a0b");
            }
            Iterator list = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstance.getSuperProcessInstanceId()).unfinished().activityType("callActivity").list();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)iterator.next();
                runningActivitiNodeIds.add(historicActivityInstance.getActivityId());
                if (!historicActivityInstance.getCalledProcessInstanceId().equals(processInstanceId)) continue;
                taskDefinitionKey = historicActivityInstance.getActivityId();
                processDefinitionId = historicActivityInstance.getProcessDefinitionId();
                processInstanceId = processInstance.getSuperProcessInstanceId();
                taskName = historicActivityInstance.getActivityName();
                result.put("executionId", historicActivityInstance.getExecutionId());
            }
        } else {
            List list = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).unfinished().activityType("callActivity").list();
            for (HistoricActivityInstance historicActivityInstance : list) {
                runningActivitiNodeIds.add(historicActivityInstance.getActivityId());
            }
        }
        result.put("runningActivitiNodeIds", runningActivitiNodeIds);
        result.put("processInstanceId", processInstanceId);
        result.put("processDefinitionId", processDefinitionId);
        result.put("taskDefinitionKey", taskDefinitionKey);
        result.put("taskName", taskName);
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).list();
        for (Task runningTask : tasks) {
            runningNodeIds.add(runningTask.getTaskDefinitionKey());
        }
        List executions = this.runtimeService.createExecutionQuery().processInstanceId(processInstanceId).list();
        ArrayList<String> finishedExcutionIds = new ArrayList<String>();
        for (Execution execution : executions) {
            if (((ExecutionEntity)execution).isScope() || execution.getActivityId() == null) continue;
            if (!runningNodeIds.contains(execution.getActivityId()) && !runningActivitiNodeIds.contains(execution.getActivityId())) {
                finishedExcutionIds.add(execution.getId());
                continue;
            }
            taskIds.add(execution.getActivityId());
        }
        if (finishedExcutionIds.size() > 0) {
            void var22_24;
            List activityInstances = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(task.getProcessInstanceId()).orderByHistoricActivityInstanceStartTime().desc()).list();
            boolean bl = false;
            while (var22_24 < activityInstances.size()) {
                if (finishedExcutionIds.contains(((HistoricActivityInstance)activityInstances.get((int)var22_24)).getExecutionId()) && ("parallelGateway".equals(((HistoricActivityInstance)activityInstances.get((int)var22_24)).getActivityType()) || "inclusiveGateway".equals(((HistoricActivityInstance)activityInstances.get((int)var22_24)).getActivityType()))) {
                    Date date = ((HistoricActivityInstance)activityInstances.get((int)(var22_24 + true))).getStartTime();
                    for (void j = var22_24 + true; j < activityInstances.size(); ++j) {
                        if (((HistoricActivityInstance)activityInstances.get((int)j)).getEndTime() == null || ((HistoricActivityInstance)activityInstances.get((int)j)).getEndTime().getTime() >= ((HistoricActivityInstance)activityInstances.get((int)var22_24)).getStartTime().getTime() || j != var22_24 + true && ((HistoricActivityInstance)activityInstances.get((int)j)).getEndTime().getTime() <= date.getTime()) continue;
                        finishedNodeIds.add(((HistoricActivityInstance)activityInstances.get((int)j)).getActivityId());
                        taskIds.add(((HistoricActivityInstance)activityInstances.get((int)j)).getActivityId());
                        finishedExcutionIds.remove(((HistoricActivityInstance)activityInstances.get((int)var22_24)).getExecutionId());
                        break;
                    }
                    if (finishedExcutionIds.size() == 0) break;
                }
                ++var22_24;
            }
        }
        if ((taskIds = new ArrayList(new HashSet(taskIds))).size() > 1) {
            if (isRejectFirst) {
                result.put("affectedTasks", taskIds);
                result.put("num", 3);
                if (finishedNodeIds.size() > 0) {
                    result.put("num", 4);
                }
                return result;
            }
            BpmnModel bm = this.repositoryService.getBpmnModel(processDefinitionId);
            Process process = (Process)bm.getProcesses().get(0);
            if (ToolUtil.isEmpty((Object)process.getFlowElement(nodeId))) {
                throw new PublicClientException(this.bpmConstantProperties.getNodeNotFound(), false);
            }
            boolean isFindTask = false;
            affectedTasks = this.findAffectedTask(process, nodeId, true, taskIds);
            if (affectedTasks.contains(taskDefinitionKey)) {
                isFindTask = true;
                affectedTasks.remove(taskDefinitionKey);
            }
            if (affectedTasks.size() > 0) {
                newNum = 3;
            }
            if (!isFindTask) {
                List<Object> affetedAllTasks = new ArrayList();
                if (affectedTasks.size() > 0) {
                    affetedAllTasks = affectedTasks;
                }
                if ((affectedTasks = this.findAffectedTask(process, nodeId, false, taskIds)).contains(taskDefinitionKey)) {
                    isFindTask = true;
                    affectedTasks.remove(taskDefinitionKey);
                }
                if (affectedTasks.size() > 0) {
                    newNum = 3;
                }
                if (!isFindTask && affectedTasks.size() + affetedAllTasks.size() > 0) {
                    newNum = -1;
                }
            }
        }
        affectedTasks.add(taskDefinitionKey);
        if (newNum == 3) {
            for (String string : affectedTasks) {
                if (!finishedNodeIds.contains(string)) continue;
                newNum = 4;
                break;
            }
        }
        result.put("affectedTasks", affectedTasks);
        result.put("num", newNum);
        return result;
    }

    private void callActivitiReject(List<String> nodeIds, Set<String> callActivitiNodeIds, String processInstanceId, String userId, String comment, String type) {
        ArrayList<String> ids = new ArrayList<String>();
        for (String nodeId : nodeIds) {
            if (!callActivitiNodeIds.remove(nodeId)) continue;
            ids.add(nodeId);
        }
        if (ids.size() == 0) {
            return;
        }
        List list = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).unfinished().activityType("callActivity").list();
        for (HistoricActivityInstance historicActivityInstance : list) {
            if (!ids.contains(historicActivityInstance.getActivityId())) continue;
            CALL_REJECT_LIST.add(historicActivityInstance.getProcessInstanceId() + historicActivityInstance.getActivityId());
            this.endCallProcess(historicActivityInstance.getCalledProcessInstanceId(), userId, comment, type);
            CALL_REJECT_LIST.remove(historicActivityInstance.getProcessInstanceId() + historicActivityInstance.getActivityId());
        }
    }

    private void endCallProcess(String instanceId, String userId, String comment, String type) {
        List list = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(instanceId).unfinished().list();
        if (list.size() > 0) {
            for (HistoricActivityInstance historicActivityInstance : list) {
                if (!"callActivity".equals(historicActivityInstance.getActivityType())) continue;
                CALL_REJECT_LIST.add(historicActivityInstance.getProcessInstanceId() + historicActivityInstance.getActivityId());
                this.endCallProcess(historicActivityInstance.getCalledProcessInstanceId(), userId, comment, type);
                CALL_REJECT_LIST.remove(historicActivityInstance.getProcessInstanceId() + historicActivityInstance.getActivityId());
            }
            HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)list.get(0);
            ActivityImpl destinationActivity = null;
            ActivityImpl currentActivity = null;
            ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)this.repositoryService.getProcessDefinition(historicActivityInstance.getProcessDefinitionId());
            for (ActivityImpl activityImpl : processDefinition.getActivities()) {
                List pvmTransitionList = activityImpl.getOutgoingTransitions();
                if (pvmTransitionList.isEmpty()) {
                    destinationActivity = activityImpl;
                }
                if (!activityImpl.getId().equals(historicActivityInstance.getActivityId())) continue;
                currentActivity = activityImpl;
            }
            if (destinationActivity == null) {
                throw new PublicClientException(this.bpmConstantProperties.getEndNodeNotFound(), false);
            }
            this.processEngine.getManagementService().executeCommand((Command)new ParallelJumpTaskCmd(userId, historicActivityInstance.getExecutionId(), destinationActivity, type, comment, new HashMap<String, Object>(), currentActivity));
        }
    }

    private List<String> findAffectedTask(Process process, String nodeId, boolean isGoToNext, List<String> taskIds) {
        ArrayList<FlowElement> flowElements = new ArrayList<FlowElement>();
        ArrayList<String> affectedTasks = new ArrayList<String>();
        flowElements.add(process.getFlowElement(nodeId));
        for (int i = 0; i < flowElements.size(); ++i) {
            FlowElement flowElement = (FlowElement)flowElements.get(i);
            if (taskIds.contains(flowElement.getId())) {
                affectedTasks.add(flowElement.getId());
                continue;
            }
            if (flowElement instanceof EndEvent || flowElement instanceof StartEvent || !(flowElement instanceof FlowNode)) continue;
            if (isGoToNext) {
                for (SequenceFlow sequenceFlow : ((FlowNode)flowElement).getOutgoingFlows()) {
                    flowElements.add(process.getFlowElement(sequenceFlow.getTargetRef()));
                }
                continue;
            }
            for (SequenceFlow sequenceFlow : ((FlowNode)flowElement).getIncomingFlows()) {
                flowElements.add(process.getFlowElement(sequenceFlow.getSourceRef()));
            }
        }
        return affectedTasks;
    }

    @Override
    public BpmResponseResult editTaskComment(String taskId, String comment) {
        if (taskId == null) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).singleResult();
        if (ToolUtil.isEmpty((Object)historicTaskInstance)) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getTaskNotFound(), null);
        }
        if (ToolUtil.isEmpty((Object)historicTaskInstance.getEndTime())) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getUnfinishedTaskCanNotEditComment(), null);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"TASK_ID_", (Object)taskId)).eq((Object)"TYPE_", (Object)"complete")).eq((Object)"ACTION_", (Object)"AddComment");
        this.taskCommentService.saveOrUpdate((Object)new TaskComment(taskId, comment, comment.getBytes()), (Wrapper)queryWrapper);
        return InstallResult.getResult("1", "success", null);
    }

    private boolean canReject(BpmnModel bm, String startNodeId, String nodeId, List<String> nodes, List<String> freeJumpList, boolean isPre) {
        FlowElement element = ((Process)bm.getProcesses().get(0)).getFlowElement(startNodeId);
        ArrayList<String> newNodes = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(nodes)) {
            newNodes.addAll(nodes);
        }
        if (element instanceof ParallelGateway || element instanceof InclusiveGateway) {
            boolean isFreeJump = freeJumpList != null;
            boolean canFreeJump = true;
            for (SequenceFlow sequenceFlow : isPre ? ((Gateway)element).getIncomingFlows() : ((Gateway)element).getOutgoingFlows()) {
                String preNode = isPre ? sequenceFlow.getSourceRef() : sequenceFlow.getTargetRef();
                if (newNodes.contains(preNode)) continue;
                if (nodeId.equals(preNode)) {
                    if (freeJumpList == null) continue;
                    freeJumpList.add(nodeId);
                    continue;
                }
                newNodes.add(preNode);
                if (this.canReject(bm, preNode, nodeId, newNodes, freeJumpList, isPre)) continue;
                if (isFreeJump) {
                    canFreeJump = false;
                    continue;
                }
                return false;
            }
            return canFreeJump;
        }
        if (!(element instanceof StartEvent) && !(element instanceof EndEvent)) {
            for (SequenceFlow sequenceFlow : isPre ? ((FlowNode)element).getIncomingFlows() : ((FlowNode)element).getOutgoingFlows()) {
                String preNode = isPre ? sequenceFlow.getSourceRef() : sequenceFlow.getTargetRef();
                if (newNodes.contains(preNode)) continue;
                if (nodeId.equals(preNode)) {
                    if (freeJumpList != null) {
                        freeJumpList.add(nodeId);
                    }
                    return true;
                }
                newNodes.add(preNode);
                if (!this.canReject(bm, preNode, nodeId, newNodes, freeJumpList, isPre)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public BpmResponseResult multiInstanceDelAssignee(String taskId) {
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getTaskNotFound(), null);
        }
        if (task.isSuspended()) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getTaskIsSuspended(), null);
        }
        if (this.isMulti(task) != 2) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getNotMultiCanDelAssignee(), null);
        }
        if (task.getDueDate() != null) {
            this.activityRedisTimerService.delTimeOutModel(taskId);
        }
        this.processEngine.getManagementService().executeCommand((Command)new MultiInstanceDelAssigneeCmd(task.getExecutionId(), taskId));
        return InstallResult.getResult("1", "success", null);
    }

    @Override
    public Map<String, Integer> updateRejectForm(Map<String, Object> map) {
        List nodeIds = (List)map.get("nodeIds");
        String procDefId = (String)map.get("procDefId");
        List delNodeIds = (List)map.get("delNodeIds");
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        List list = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processDefinitionId(procDefId).unfinished().orderByActivityId().asc()).list();
        HashSet<String> instanceIds = new HashSet<String>();
        if (list.size() == 0) {
            return result;
        }
        String taskDefKey = ((HistoricActivityInstance)list.get(0)).getActivityId();
        HashSet<String> nodeInstanceId = new HashSet<String>();
        HashSet<String> allInstanceIds = new HashSet<String>();
        int processNumAll = 0;
        for (HistoricActivityInstance activityInstance : list) {
            instanceIds.add(activityInstance.getProcessInstanceId());
            if (!delNodeIds.contains(activityInstance.getActivityId())) continue;
            Object num = (Integer)result.get(activityInstance.getActivityId());
            if (num == null) {
                num = 0;
            }
            if (!taskDefKey.equals(activityInstance.getActivityId())) {
                nodeInstanceId = new HashSet();
                taskDefKey = activityInstance.getActivityId();
            }
            if (nodeInstanceId.add(activityInstance.getProcessInstanceId())) {
                Object object = num;
                Object object2 = num = Integer.valueOf((Integer)num + 1);
                result.put(activityInstance.getActivityId(), (Integer)num);
            }
            if (!allInstanceIds.add(activityInstance.getProcessInstanceId())) continue;
            ++processNumAll;
        }
        if (processNumAll > 0) {
            result.put("", processNumAll);
            return result;
        }
        List historicTaskInstances = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceIdIn(new ArrayList(instanceIds))).includeTaskLocalVariables()).orderByProcessInstanceId()).orderByTaskCreateTime()).asc()).list();
        HashMap<String, ArrayList<HistoricTaskInstance>> hisTaskMap = new HashMap<String, ArrayList<HistoricTaskInstance>>();
        for (HistoricTaskInstance historicTaskInstance : historicTaskInstances) {
            ArrayList<HistoricTaskInstance> hisTasks = (ArrayList<HistoricTaskInstance>)hisTaskMap.get(historicTaskInstance.getProcessInstanceId());
            if (hisTasks == null) {
                hisTasks = new ArrayList<HistoricTaskInstance>();
            }
            hisTasks.add(historicTaskInstance);
            hisTaskMap.put(historicTaskInstance.getProcessInstanceId(), hisTasks);
        }
        HashMap<String, List<String>> finishTaskId = new HashMap<String, List<String>>();
        HashMap<String, List<String>> unFinishTaskId = new HashMap<String, List<String>>();
        for (List hisTasks : hisTaskMap.values()) {
            for (int i = 0; i < hisTasks.size(); ++i) {
                ArrayList<String> taskIds;
                HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)hisTasks.get(i);
                String completeFrom = (String)historicTaskInstance.getTaskLocalVariables().get("complete_from");
                if (!ToolUtil.isNotEmpty((Object)completeFrom) || nodeIds.contains(completeFrom)) continue;
                String newCompleteFrom = completeFrom;
                boolean isDelFrom = i == 0;
                for (int j = i - 1; j > -1; --j) {
                    newCompleteFrom = (String)((HistoricTaskInstance)hisTasks.get(j)).getTaskLocalVariables().get("complete_from");
                    if (ToolUtil.isEmpty((Object)newCompleteFrom)) {
                        isDelFrom = true;
                        break;
                    }
                    if (nodeIds.contains(newCompleteFrom)) break;
                }
                if (isDelFrom) {
                    newCompleteFrom = "";
                }
                if ((taskIds = (ArrayList<String>)finishTaskId.get(newCompleteFrom)) == null) {
                    taskIds = new ArrayList<String>();
                }
                taskIds.add(historicTaskInstance.getId());
                finishTaskId.put(newCompleteFrom, taskIds);
                if (historicTaskInstance.getEndTime() != null) continue;
                ArrayList<String> unFinishTaskIds = (ArrayList<String>)unFinishTaskId.get(newCompleteFrom);
                if (unFinishTaskIds == null) {
                    unFinishTaskIds = new ArrayList<String>();
                }
                unFinishTaskIds.add(historicTaskInstance.getId());
                unFinishTaskId.put(newCompleteFrom, unFinishTaskIds);
            }
        }
        if (finishTaskId.size() > 0) {
            this.taskEngineMapper.updateCompleteFrom(finishTaskId, unFinishTaskId, this.url.split(":")[1]);
        }
        return result;
    }

    @Override
    public void reStartProcessUpdate(String processInstanceId, String businessKey, String processDefinitionId, String parentExecutionId, String tenantId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("processInstanceId", processInstanceId);
        map.put("businessKey", businessKey);
        map.put("tenantId", tenantId);
        map.put("parentExecutionId", parentExecutionId);
        map.put("processDefinitionId", processDefinitionId);
        map.put("dbType", this.url.split(":")[1]);
        this.taskEngineMapper.reStartProcessUpdate(map);
    }

    @Override
    public BpmResponseResult reStartProcess(String processInstanceId, String businessKey, String taskDefinitionKey, String userId, String assignee, boolean isSubmit, Map<String, Object> map) {
        if (ToolUtil.isAllEmpty((Object[])new Object[]{processInstanceId, businessKey})) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).processInstanceBusinessKey(businessKey).singleResult();
        if (historicProcessInstance != null) {
            if (ToolUtil.isEmpty((Object)historicProcessInstance.getEndTime())) {
                throw new PublicClientException(this.bpmConstantProperties.getProcessInstanceIsNotEnd(), false);
            }
            ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)this.repositoryService.getProcessDefinition(historicProcessInstance.getProcessDefinitionId());
            ActivityImpl destinationActivity = null;
            if (ToolUtil.isEmpty((Object)taskDefinitionKey)) {
                for (ActivityImpl activityImpl : processDefinition.getActivities()) {
                    if (!activityImpl.getIncomingTransitions().isEmpty()) continue;
                    destinationActivity = (ActivityImpl)((PvmTransition)activityImpl.getOutgoingTransitions().get(0)).getDestination();
                    break;
                }
            } else {
                for (ActivityImpl activityImpl : processDefinition.getActivities()) {
                    if (!taskDefinitionKey.equals(activityImpl.getId())) continue;
                    destinationActivity = activityImpl;
                }
                if (destinationActivity == null) {
                    return InstallResult.getResult("0", this.bpmConstantProperties.getNodeNotFound(), null);
                }
            }
            if (ToolUtil.isEmpty(map)) {
                map = new HashMap<String, Object>();
            }
            map.put("sendUser", userId);
            if (isSubmit && ToolUtil.isEmpty((Object)assignee)) {
                assignee = this.getTaskCommitUser(historicProcessInstance.getId(), destinationActivity.getId());
            }
            if (ToolUtil.isNotEmpty((Object)assignee)) {
                HashMap<String, String> appointAssignee = new HashMap<String, String>();
                appointAssignee.put("static_appoint_assignee", assignee);
                map.put("appoint_assignee", appointAssignee);
            }
            this.reStartProcessUpdate(historicProcessInstance.getId(), businessKey, historicProcessInstance.getProcessDefinitionId(), null, historicProcessInstance.getTenantId());
            this.processEngine.getManagementService().executeCommand((Command)new ParallelJumpTaskCmd(userId, historicProcessInstance.getId(), destinationActivity, null, null, map, null));
            return this.installReturnValue(userId, historicProcessInstance.getId(), null, map);
        }
        return InstallResult.getResult("0", this.bpmConstantProperties.getProcessNotFound(), null);
    }
}

