/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.engine.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.bpm.common.utils.AnalyticalModelUtil;
import com.jxdinfo.hussar.bpm.definition.model.ProcessDefinitionModel;
import com.jxdinfo.hussar.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.bpm.engine.dao.TaskEngineMapper;
import com.jxdinfo.hussar.bpm.engine.model.BpmResponseResult;
import com.jxdinfo.hussar.bpm.engine.service.InstanceEngineService;
import com.jxdinfo.hussar.bpm.engine.service.impl.TaskEngineServiceImpl;
import com.jxdinfo.hussar.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.bpm.engine.util.ParallelJumpTaskCmd;
import com.jxdinfo.hussar.bpm.flowevents.dao.FlowEventsServiceMapper;
import com.jxdinfo.hussar.bpm.flowevents.model.Variables;
import com.jxdinfo.hussar.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.bpm.urgetask.service.ISysActUrgeTaskService;
import com.jxdinfo.hussar.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.activiti.engine.HistoryService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricActivityInstanceQuery;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Comment;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskInfo;
import org.activiti.engine.task.TaskQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class InstanceEngineServiceImpl
implements InstanceEngineService {
    @Autowired
    private ProcessDefinitionsService processDefinitionsService;
    @Autowired
    private ProcessEngine processEngine;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private TaskEngineMapper taskEngineMapper;
    @Autowired
    private IdentityService identityService;
    @Autowired
    private IAssigneeChooseService iAssigneeChooseService;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Autowired
    private ActivityRedisTimerService activityRedisTimerService;
    @Autowired
    private ISysActUrgeTaskService iSysActUrgeTaskService;
    @Autowired
    private ISysActCcTaskService iSysActCcTaskService;
    @Autowired
    private FlowEventsServiceMapper flowEventsServiceMapper;
    private static final Map<String, String> TASK_SOURCE_FLAG = new HashMap<String, String>();
    private static final String FINISH_STATE = "finish";
    private static final String NOW_STATE = "complete";

    @Override
    public BpmResponseResult startProcessInstanceById(String processDefinitionId, String userId, String businessKey, String tenantId, Map<String, Object> variables) {
        List instance = this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessKey).listPage(0, 1);
        if (instance != null && instance.size() > 0) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getBusinessAlreadyStartProcess(), null);
        }
        boolean flag = this.validateAuthority(userId, processDefinitionId, tenantId, businessKey, variables);
        if (!flag) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getNoAuthorityStartProcess(), null);
        }
        this.identityService.setAuthenticatedUserId(userId);
        HashMap<String, Object> newVariables = new HashMap<String, Object>(this.installVariables(processDefinitionId, variables));
        newVariables.put("sendUser", userId);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinitionId, businessKey, newVariables);
        JSONArray json = this.installJson(processInstance.getProcessInstanceId(), userId, newVariables);
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult startProcessInstanceByKey(String processDefinitionKey, String userId, String businessKey, String tenantId, Map<String, Object> variables) {
        List instance = this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessKey).listPage(0, 1);
        if (instance != null && instance.size() > 0) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getBusinessAlreadyStartProcess(), null);
        }
        String processDefinitionId = this.processDefinitionsService.getMainOrNew(processDefinitionKey).getId();
        boolean flag = this.validateAuthority(userId, processDefinitionId, tenantId, businessKey, variables);
        if (!flag) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getNoAuthorityStartProcess(), null);
        }
        this.identityService.setAuthenticatedUserId(userId);
        HashMap<String, Object> newVariables = new HashMap<String, Object>(this.installVariables(processDefinitionId, variables));
        newVariables.put("sendUser", userId);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinitionId, businessKey, newVariables);
        JSONArray json = this.installJson(processInstance.getProcessInstanceId(), userId, newVariables);
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult validationStartProcess(String processDefinitionKey, String userId, String businessKey, String tenantId, Map<String, Object> variables) {
        List instance = this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey(businessKey).listPage(0, 1);
        if (instance != null && instance.size() > 0) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getBusinessAlreadyStartProcess(), null);
        }
        String processDefinitionId = this.processDefinitionsService.getMainOrNew(processDefinitionKey).getId();
        this.identityService.setAuthenticatedUserId(userId);
        HashMap<String, Object> newVariables = new HashMap<String, Object>(this.installVariables(processDefinitionId, variables));
        newVariables.put("sendUser", userId);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinitionId, businessKey, newVariables);
        JSONArray json = this.installJson(processInstance.getProcessInstanceId(), userId, newVariables);
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult checkProcessInstByBusinessKey(String businessKey) {
        List instance = this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessKey).listPage(0, 1);
        if (instance != null && instance.size() > 0) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getBusinessAlreadyStartProcess(), null);
        }
        return InstallResult.getResult("1", "success", null);
    }

    @Override
    public BpmResponseResult validateEditAuthority(String businessKey) {
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceBusinessKey(businessKey)).list();
        JSONArray jsonArray = new JSONArray();
        JSONObject object = new JSONObject();
        if (tasks != null && tasks.size() > 0) {
            List historicActivityInstances = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(((Task)tasks.get(0)).getProcessInstanceId()).orderByHistoricActivityInstanceStartTime().activityType("userTask").asc()).listPage(0, 1);
            HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)historicActivityInstances.get(0);
            for (Task task : tasks) {
                if (!task.getTaskDefinitionKey().equals(historicActivityInstance.getActivityId())) continue;
                object.put("processDefinitionKey", (Object)task.getProcessDefinitionId().substring(0, 21));
                object.put("taskDefinitionKey", (Object)task.getTaskDefinitionKey());
                object.put("businessKey", (Object)businessKey);
                object.put("taskId", (Object)task.getId());
                jsonArray.add((Object)object);
                return InstallResult.getResult("1", "success", jsonArray);
            }
            return InstallResult.getResult("0", this.bpmConstantProperties.getBusinessAlreadyStartProcess(), null);
        }
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessKey).singleResult();
        if (ToolUtil.isNotEmpty((Object)historicProcessInstance)) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getBusinessAlreadyStartProcess(), null);
        }
        jsonArray.add((Object)object);
        return InstallResult.getResult("1", "success", jsonArray);
    }

    @Override
    public BpmResponseResult validateDeleteByBusinessKey(String businessKey) {
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceBusinessKey(businessKey)).list();
        JSONArray jsonArray = new JSONArray();
        if (tasks != null && tasks.size() > 0) {
            List historicActivityInstances = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(((Task)tasks.get(0)).getProcessInstanceId()).orderByHistoricActivityInstanceStartTime().activityType("userTask").asc()).listPage(0, 1);
            HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)historicActivityInstances.get(0);
            for (Task task : tasks) {
                if (!task.getTaskDefinitionKey().equals(historicActivityInstance.getActivityId())) continue;
                jsonArray.add((Object)"1");
                return InstallResult.getResult("1", "success", jsonArray);
            }
            jsonArray.add((Object)"2");
            return InstallResult.getResult("1", this.bpmConstantProperties.getBusinessAlreadyStartProcess(), jsonArray);
        }
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessKey).singleResult();
        if (ToolUtil.isNotEmpty((Object)historicProcessInstance)) {
            jsonArray.add((Object)"2");
            return InstallResult.getResult("1", this.bpmConstantProperties.getBusinessAlreadyStartProcess(), jsonArray);
        }
        jsonArray.add((Object)"0");
        return InstallResult.getResult("1", "success", jsonArray);
    }

    private boolean validateAuthority(String userId, String processDefinitionId, String tenantId, String businessKey, Map<String, Object> variables) {
        String sql = AnalyticalModelUtil.queryFirstNodeAssigneeConfig(userId, tenantId, processDefinitionId, businessKey, variables);
        if (ToolUtil.isEmpty((Object)sql)) {
            return true;
        }
        List<String> users = this.iAssigneeChooseService.getCandidateUser(sql, tenantId);
        boolean flag = users != null && users.size() > 0 ? users.contains(userId) : true;
        return flag;
    }

    public Map<String, Object> installVariables(String processDefinitionId, Map<String, Object> variables) {
        if (ToolUtil.isEmpty((Object)processDefinitionId)) {
            return variables;
        }
        Map<String, String> map = AnalyticalModelUtil.getTodoConfiguration(processDefinitionId, null);
        if (map.size() == 0) {
            return variables;
        }
        if (variables == null || variables.size() <= 0) {
            HashMap<String, Object> newVariables = new HashMap<String, Object>(3);
            newVariables.put("todoConfiguration", map.get("todoConfiguration"));
            return newVariables;
        }
        String todo = AnalyticalModelUtil.getTodo(variables, map.get("todoConfiguration"));
        variables.put("todoConfiguration", todo);
        return variables;
    }

    private JSONArray installJson(String processInstanceId, String userId, Map<String, Object> variables) {
        JSONObject object = new JSONObject();
        JSONArray json = new JSONArray();
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).active().list();
        for (Task task : tasks) {
            List<String> users = this.getAssigneeByTaskId(task.getId());
            if (users.size() == 0) {
                this.taskService.setAssignee(task.getId(), userId);
            }
            this.taskService.setVariableLocal(task.getId(), "sendUser", (Object)userId);
            this.taskService.setVariableLocal(task.getId(), "complete_type", (Object)NOW_STATE);
            object.put("processInstanceId", (Object)processInstanceId);
            object.put("taskId", (Object)task.getId());
            object.put("userId", new HashSet<String>(this.getAssigneeByTaskId(task.getId())));
            object.put("taskDefinitionKey", (Object)task.getTaskDefinitionKey());
            object.put("taskDefinitionName", (Object)task.getName());
            object.put("formKey", (Object)task.getFormKey());
            json.add((Object)object);
        }
        return json;
    }

    private void setVariables(Task task, Map<String, Object> variables) {
        Map<String, String> map = AnalyticalModelUtil.getTodoConfiguration(task.getProcessDefinitionId(), task.getTaskDefinitionKey());
        if (map.size() == 0) {
            return;
        }
        HashMap<String, Object> newVariables = new HashMap<String, Object>();
        if (variables != null) {
            newVariables.putAll(variables);
        }
        Map processMap = task.getProcessVariables();
        Map taskMap = task.getTaskLocalVariables();
        newVariables.putAll(processMap);
        newVariables.putAll(taskMap);
        String todo = newVariables.size() > 0 ? AnalyticalModelUtil.getTodo(newVariables, map.get("todoConfiguration")) : map.get("todoConfiguration");
        this.taskService.setVariableLocal(task.getId(), "todoConfiguration", (Object)todo);
    }

    @Override
    public BpmResponseResult suspendProcessInstanceById(String processInstanceId) {
        this.runtimeService.suspendProcessInstanceById(processInstanceId);
        return InstallResult.getResult("1", "success", null);
    }

    @Override
    public BpmResponseResult activateProcessInstanceById(String processInstanceId) {
        this.runtimeService.activateProcessInstanceById(processInstanceId);
        return InstallResult.getResult("1", "success", null);
    }

    @Override
    public BpmResponseResult deleteProcessInstance(String processInstanceId, String reason) {
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).list();
        StringBuilder taskIds = new StringBuilder();
        for (Task task : tasks) {
            if (!ToolUtil.isNotEmpty((Object)task.getDueDate())) continue;
            taskIds.append(",").append(task.getId());
        }
        if (ToolUtil.isNotEmpty((Object)taskIds.toString())) {
            this.activityRedisTimerService.delTimeOutModel(taskIds.toString().substring(1));
        }
        this.runtimeService.deleteProcessInstance(processInstanceId, reason);
        return InstallResult.getResult("1", "success", null);
    }

    @Override
    public BpmResponseResult deleteFinishedProcessInstance(String processInstanceId) {
        this.historyService.deleteHistoricProcessInstance(processInstanceId);
        QueryWrapper ccQueryWrapper = new QueryWrapper();
        ccQueryWrapper.eq((Object)"PROC_INST_ID", (Object)processInstanceId);
        this.iSysActCcTaskService.remove((Wrapper)ccQueryWrapper);
        QueryWrapper urgeQueryWrapper = new QueryWrapper();
        urgeQueryWrapper.eq((Object)"PROC_INST_ID", (Object)processInstanceId);
        this.iSysActUrgeTaskService.remove((Wrapper)urgeQueryWrapper);
        return InstallResult.getResult("1", "success", null);
    }

    @Override
    public BpmResponseResult deleteProcessInstanceByBusinessKey(String businessKey) {
        if (businessKey == null) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessKey).singleResult();
        if (historicProcessInstance != null) {
            if (historicProcessInstance.getEndTime() != null) {
                this.historyService.deleteHistoricProcessInstance(historicProcessInstance.getId());
            } else {
                List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(historicProcessInstance.getId())).list();
                StringBuilder taskIds = new StringBuilder();
                for (Task task : tasks) {
                    if (!ToolUtil.isNotEmpty((Object)task.getDueDate())) continue;
                    taskIds.append(",").append(task.getId());
                }
                if (ToolUtil.isNotEmpty((Object)taskIds.toString())) {
                    this.activityRedisTimerService.delTimeOutModel(taskIds.toString().substring(1));
                }
                this.runtimeService.deleteProcessInstance(historicProcessInstance.getId(), "");
                this.historyService.deleteHistoricProcessInstance(historicProcessInstance.getId());
            }
            QueryWrapper ccQueryWrapper = new QueryWrapper();
            ccQueryWrapper.eq((Object)"PROC_INST_ID", (Object)historicProcessInstance.getId());
            this.iSysActCcTaskService.remove((Wrapper)ccQueryWrapper);
            QueryWrapper urgeQueryWrapper = new QueryWrapper();
            urgeQueryWrapper.eq((Object)"PROC_INST_ID", (Object)historicProcessInstance.getId());
            this.iSysActUrgeTaskService.remove((Wrapper)urgeQueryWrapper);
        }
        return InstallResult.getResult("1", "success", null);
    }

    @Override
    public BpmResponseResult queryFinishedProcessInstance(String processDefinitionKey, String businessKey, int page, int rows) {
        JSONObject object = new JSONObject();
        JSONArray json = new JSONArray();
        Long count = this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessKey).processDefinitionKey(processDefinitionKey).finished().count();
        List insts = this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessKey).processDefinitionKey(processDefinitionKey).finished().listPage((page - 1) * rows, rows);
        object.put("data", (Object)insts);
        object.put("count", (Object)count);
        json.add((Object)object);
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult queryProcessInstanceCompleteState(String processInstanceId) {
        JSONArray json = new JSONArray();
        boolean isEnded = true;
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (processInstance != null && !processInstance.isEnded()) {
            isEnded = false;
        }
        json.add((Object)isEnded);
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult queryProcessInstanceCompleteStateByBusinessKey(String businessKey) {
        JSONArray json = new JSONArray();
        boolean isEnded = true;
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey(businessKey).singleResult();
        if (processInstance != null && !processInstance.isEnded()) {
            isEnded = false;
        }
        json.add((Object)isEnded);
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult getProcessTrace(String processInstanceId, String tenantId) {
        if (processInstanceId == null) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        JSONArray jsonArray = new JSONArray();
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (processInstance == null) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getProcessNotFound(), null);
        }
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(processInstance.getProcessDefinitionId());
        List activitiList = processDefinition.getActivities();
        List hisList = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).activityType("userTask").orderByHistoricActivityInstanceStartTime().desc()).finished().list();
        List<String> userList = new ArrayList<String>();
        if (hisList != null && hisList.size() > 0) {
            userList = hisList.stream().map(HistoricActivityInstance::getAssignee).filter(Objects::nonNull).collect(Collectors.toList());
        }
        Map<String, String> finalUsersMap = this.iAssigneeChooseService.getUserListByUserId(userList, tenantId);
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).list();
        for (ActivityImpl activity : activitiList) {
            JSONObject object = new JSONObject();
            object.put("width", (Object)activity.getWidth());
            object.put("height", (Object)activity.getHeight());
            object.put("x", (Object)activity.getX());
            object.put("y", (Object)activity.getY());
            object.put("id", (Object)activity.getId());
            List taskList = null;
            if (tasks != null && tasks.size() > 0) {
                taskList = tasks.stream().filter(t -> t.getTaskDefinitionKey().equals(activity.getId())).collect(Collectors.toList());
            }
            if (taskList != null && taskList.size() > 0) {
                List<String> user = this.getAssigneeByTaskId(((Task)taskList.get(0)).getId());
                if (user.size() > 0) {
                    String assignee = this.iAssigneeChooseService.getUserNames(user, tenantId);
                    object.put("assignee", (Object)assignee);
                } else {
                    object.put("assignee", (Object)this.bpmConstantProperties.getNullAssignee());
                }
                object.put("state", (Object)NOW_STATE);
            } else {
                object.put("state", (Object)FINISH_STATE);
                List hisActivitList = null;
                if (hisList != null && hisList.size() > 0) {
                    hisActivitList = hisList.stream().filter(hai -> hai.getActivityId().equals(activity.getId())).collect(Collectors.toList());
                }
                if (hisActivitList == null || hisActivitList.size() <= 0) continue;
                hisActivitList.sort(Comparator.comparing(HistoricActivityInstance::getStartTime));
                JSONArray json = new JSONArray();
                for (HistoricActivityInstance historicActivityInstance : hisActivitList) {
                    List comments;
                    JSONObject o = new JSONObject();
                    String user = "";
                    if (historicActivityInstance.getAssignee() != null) {
                        user = finalUsersMap.get(historicActivityInstance.getAssignee());
                    }
                    if ((comments = this.taskService.getTaskComments(historicActivityInstance.getTaskId(), NOW_STATE)) != null && comments.size() > 0) {
                        o.put("comments", (Object)(((Comment)comments.get(0)).getFullMessage() == null ? this.bpmConstantProperties.getNullCommont() : ((Comment)comments.get(0)).getFullMessage()));
                    } else {
                        o.put("comments", (Object)this.bpmConstantProperties.getNullCommont());
                    }
                    o.put("assignee", (Object)user);
                    o.put("endTime", (Object)historicActivityInstance.getEndTime());
                    o.put("startTime", (Object)historicActivityInstance.getStartTime());
                    json.add((Object)o);
                }
                object.put("completeInfo", (Object)json);
            }
            jsonArray.add((Object)object);
        }
        return InstallResult.getResult("1", "success", jsonArray);
    }

    @Override
    public BpmResponseResult getAllProcessTrace(String processInstanceId, String tenantId) {
        if (processInstanceId == null) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        List hisTaskList = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).list();
        return this.getResult(hisTaskList, tenantId);
    }

    @Override
    public BpmResponseResult queryCallActivityTask(String businessKey, String processInstanceId, int type, String tenantId) {
        HistoricProcessInstance historicProcessInstance;
        if (ToolUtil.isAllEmpty((Object[])new Object[]{processInstanceId, businessKey})) {
            return InstallResult.getResult("1", this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        List<Object> queryInstIds = new ArrayList();
        if (type == 0) {
            if (ToolUtil.isEmpty((Object)processInstanceId)) {
                historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessKey).singleResult();
                if (historicProcessInstance == null) {
                    return InstallResult.getResult("0", this.bpmConstantProperties.getProcessNotFound(), null);
                }
                processInstanceId = historicProcessInstance.getId();
            }
            if ((queryInstIds = this.taskEngineMapper.getCallActivityInstId(processInstanceId)).size() == 0) {
                return InstallResult.getResult("1", "success", null);
            }
        } else {
            historicProcessInstance = ToolUtil.isEmpty((Object)processInstanceId) ? (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessKey).singleResult() : (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
            if (historicProcessInstance == null) {
                return InstallResult.getResult("0", this.bpmConstantProperties.getProcessNotFound(), null);
            }
            if (ToolUtil.isEmpty((Object)historicProcessInstance.getSuperProcessInstanceId())) {
                return InstallResult.getResult("1", "success", null);
            }
            queryInstIds.add(historicProcessInstance.getSuperProcessInstanceId());
        }
        List historicTaskInstances = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceIdIn(queryInstIds)).list();
        return this.getResult(historicTaskInstances, tenantId);
    }

    @Override
    public BpmResponseResult getAllProcessTraceByBusinessKey(String businessKey, String tenantId, int page, int size) {
        if (businessKey == null) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        Long count = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceBusinessKey(businessKey)).count();
        List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceBusinessKey(businessKey)).orderByHistoricTaskInstanceEndTime().asc()).listPage((page - 1) * size, size);
        BpmResponseResult bpmResponseResult = this.getResult(hisTaskList, tenantId);
        bpmResponseResult.setMsg(String.valueOf(count));
        return bpmResponseResult;
    }

    private BpmResponseResult getResult(List<HistoricTaskInstance> hisTaskList, String tenantId) {
        JSONArray json = new JSONArray();
        List<String> userList = new ArrayList<String>();
        if (hisTaskList != null && hisTaskList.size() > 0) {
            userList = hisTaskList.stream().map(TaskInfo::getAssignee).filter(Objects::nonNull).collect(Collectors.toList());
        }
        hisTaskList.sort((o1, o2) -> {
            if (!o1.getProcessInstanceId().equals(o2.getProcessInstanceId())) {
                return o1.getProcessInstanceId().compareTo(o2.getTaskDefinitionKey());
            }
            if (ToolUtil.isAllEmpty((Object[])new Object[]{o1.getEndTime(), o2.getEndTime()})) {
                return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
            }
            if (o1.getEndTime() == null && o2.getEndTime() != null) {
                return new Date(0L).compareTo(o2.getEndTime());
            }
            if (o1.getEndTime() != null && o2.getEndTime() == null) {
                return o1.getEndTime().compareTo(new Date(0L));
            }
            if (o1.getEndTime().equals(o2.getEndTime())) {
                return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
            }
            return o1.getEndTime().compareTo(o2.getEndTime());
        });
        Map<String, String> finalUsersMap = this.iAssigneeChooseService.getUserListByUserId(userList, tenantId);
        if (hisTaskList != null && hisTaskList.size() > 0) {
            ArrayList<String> hisTaskIds = new ArrayList<String>();
            for (HistoricTaskInstance hisTask : hisTaskList) {
                if (hisTask.getEndTime() == null) continue;
                hisTaskIds.add(hisTask.getId());
            }
            HashMap<String, String> taskComment = new HashMap<String, String>();
            if (ToolUtil.isNotEmpty(hisTaskIds)) {
                List<Map<String, String>> commentsMap = this.taskEngineMapper.getTaskComments(hisTaskIds);
                for (Map<String, String> commentMap : commentsMap) {
                    taskComment.put(commentMap.get("id"), commentMap.get("comments"));
                }
            }
            List<Object> allVariables = new ArrayList();
            if (ToolUtil.isNotEmpty(hisTaskIds)) {
                allVariables = this.flowEventsServiceMapper.getAllVariables(hisTaskIds, null);
            }
            HashMap<String, String> taskSourceFlagMap = new HashMap<String, String>();
            for (Variables variables : allVariables) {
                if (!"taskSourceFlag".equals(variables.getName())) continue;
                taskSourceFlagMap.put(variables.getTaskId(), variables.getTextValue());
            }
            for (HistoricTaskInstance hsi : hisTaskList) {
                String userId;
                String user;
                JSONObject object = new JSONObject();
                if (hsi.getAssignee() != null) {
                    user = finalUsersMap.get(hsi.getAssignee()) == null ? this.bpmConstantProperties.getNullComplete() : finalUsersMap.get(hsi.getAssignee());
                    userId = hsi.getAssignee();
                } else {
                    user = this.bpmConstantProperties.getNullComplete();
                    userId = this.bpmConstantProperties.getNullComplete();
                }
                String comment = (String)taskComment.get(hsi.getId());
                object.put("comments", (Object)(comment == null ? this.bpmConstantProperties.getNullCommont() : comment));
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                object.put("startTime", (Object)sdf.format(hsi.getStartTime()));
                if (hsi.getEndTime() != null) {
                    object.put("assignee", (Object)user);
                    object.put("assigneeId", (Object)userId);
                    object.put("endTime", (Object)sdf.format(hsi.getEndTime()));
                } else {
                    object.put("endTime", (Object)"");
                    List<String> users = this.getAssigneeByTaskId(hsi.getId());
                    if (user != null && users.size() > 0) {
                        String assignee = this.iAssigneeChooseService.getUserNames(users, tenantId);
                        if (ToolUtil.isNotEmpty((Object)assignee)) {
                            object.put("assignee", (Object)assignee);
                            object.put("assigneeId", users);
                        } else {
                            object.put("assignee", (Object)this.bpmConstantProperties.getNullComplete());
                            object.put("assigneeId", (Object)this.bpmConstantProperties.getNullComplete());
                        }
                    }
                    object.put("comments", (Object)"");
                }
                object.put("activityName", (Object)hsi.getName());
                object.put("activityId", (Object)hsi.getId());
                object.put("taskId", (Object)hsi.getId());
                object.put("taskDefinitionKey", (Object)hsi.getTaskDefinitionKey());
                object.put("processDefinitionId", (Object)hsi.getProcessDefinitionId());
                object.put("processInstanceId", (Object)hsi.getProcessInstanceId());
                String taskSourceFlag = (String)taskSourceFlagMap.get(hsi.getId());
                if ("reject_revoke".equals(taskSourceFlag)) {
                    taskSourceFlag = "revoke";
                }
                object.put("taskSourceFlag", (Object)(taskSourceFlag == null ? "" : TASK_SOURCE_FLAG.get(taskSourceFlag)));
                json.add((Object)object);
            }
        }
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult getAllProcessTraceByMicroApp(String processInstanceId, String tenantId) {
        JSONArray json = new JSONArray();
        List<String> userList = new ArrayList<String>();
        List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).orderByHistoricTaskInstanceEndTime().includeProcessVariables()).includeTaskLocalVariables()).asc()).list();
        ArrayList<HistoricTaskInstance> nullList = new ArrayList<HistoricTaskInstance>();
        for (HistoricTaskInstance historicTaskInstance : hisTaskList) {
            if (historicTaskInstance.getEndTime() != null) continue;
            nullList.add(historicTaskInstance);
        }
        hisTaskList.removeAll(nullList);
        for (HistoricTaskInstance hsi : nullList) {
            hisTaskList.add(hsi);
        }
        if (hisTaskList != null && hisTaskList.size() > 0) {
            userList = hisTaskList.stream().map(TaskInfo::getAssignee).filter(Objects::nonNull).collect(Collectors.toList());
        }
        Map<String, String> finalUsersMap = this.iAssigneeChooseService.getUserListByUserId(userList, tenantId);
        if (hisTaskList != null && hisTaskList.size() > 0) {
            for (HistoricTaskInstance hsi : hisTaskList) {
                JSONObject object = new JSONObject();
                String user = hsi.getAssignee() != null ? (finalUsersMap.get(hsi.getAssignee()) == null ? this.bpmConstantProperties.getNullComplete() : finalUsersMap.get(hsi.getAssignee())) : this.bpmConstantProperties.getNullComplete();
                List comments = this.taskService.getTaskComments(hsi.getId(), NOW_STATE);
                if (comments != null && comments.size() > 0) {
                    object.put("comments", (Object)(((Comment)comments.get(0)).getFullMessage() == null ? this.bpmConstantProperties.getNullCommont() : ((Comment)comments.get(0)).getFullMessage()));
                } else {
                    object.put("comments", (Object)this.bpmConstantProperties.getNullCommont());
                }
                Map variables = hsi.getTaskLocalVariables();
                if (ToolUtil.isEmpty(variables.get("taskSourceFlag"))) {
                    variables.put("taskSourceFlag", "");
                }
                hsi.getTaskLocalVariables();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                object.put("startTime", (Object)sdf.format(hsi.getStartTime()));
                if (hsi.getEndTime() != null) {
                    object.put("assignee", (Object)user);
                    object.put("endTime", (Object)sdf.format(hsi.getEndTime()));
                } else {
                    object.put("endTime", (Object)"");
                    List<String> users = this.getAssigneeByTaskId(hsi.getId());
                    if (user != null && users.size() > 0) {
                        String assignee = this.iAssigneeChooseService.getUserNames(users, tenantId);
                        object.put("assignee", (Object)assignee);
                    }
                    object.put("comments", (Object)"");
                }
                object.put("activityName", (Object)hsi.getName());
                object.put("activityId", (Object)hsi.getId());
                object.put("taskId", (Object)hsi.getId());
                object.put("taskDefinitionKey", (Object)hsi.getTaskDefinitionKey());
                object.put("processDefinitionId", (Object)hsi.getProcessDefinitionId());
                object.put("processInstanceId", (Object)hsi.getProcessInstanceId());
                String taskSourceFlag = (String)variables.get("taskSourceFlag");
                if ("reject_revoke".equals(taskSourceFlag)) {
                    variables.put("taskSourceFlag", "revoke");
                }
                object.put("variables", (Object)variables);
                object.put("taskSourceFlag", (Object)TASK_SOURCE_FLAG.get(variables.get("taskSourceFlag")));
                json.add((Object)object);
            }
        }
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult getDoneProcessTrace(String businessKey, String tenantId) {
        JSONArray json = new JSONArray();
        List<String> userList = new ArrayList<String>();
        List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceBusinessKey(businessKey)).orderByHistoricTaskInstanceEndTime().includeProcessVariables()).includeTaskLocalVariables()).asc()).list();
        ArrayList<HistoricTaskInstance> nullList = new ArrayList<HistoricTaskInstance>();
        for (HistoricTaskInstance historicTaskInstance : hisTaskList) {
            if (historicTaskInstance.getEndTime() != null) continue;
            nullList.add(historicTaskInstance);
        }
        hisTaskList.removeAll(nullList);
        if (hisTaskList != null && hisTaskList.size() > 0) {
            userList = hisTaskList.stream().map(TaskInfo::getAssignee).filter(Objects::nonNull).collect(Collectors.toList());
        }
        Map<String, String> finalUsersMap = this.iAssigneeChooseService.getUserListByUserId(userList, tenantId);
        if (hisTaskList != null && hisTaskList.size() > 0) {
            for (HistoricTaskInstance hsi : hisTaskList) {
                JSONObject object = new JSONObject();
                String user = hsi.getAssignee() != null ? (finalUsersMap.get(hsi.getAssignee()) == null ? this.bpmConstantProperties.getNullComplete() : finalUsersMap.get(hsi.getAssignee())) : this.bpmConstantProperties.getNullComplete();
                List comments = this.taskService.getTaskComments(hsi.getId(), NOW_STATE);
                if (comments != null && comments.size() > 0) {
                    object.put("comments", (Object)(((Comment)comments.get(0)).getFullMessage() == null ? this.bpmConstantProperties.getNullCommont() : ((Comment)comments.get(0)).getFullMessage()));
                } else {
                    object.put("comments", (Object)this.bpmConstantProperties.getNullCommont());
                }
                Map variables = hsi.getTaskLocalVariables();
                if (ToolUtil.isEmpty(variables.get("taskSourceFlag"))) {
                    variables.put("taskSourceFlag", "");
                }
                hsi.getTaskLocalVariables();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                object.put("startTime", (Object)sdf.format(hsi.getStartTime()));
                object.put("assignee", (Object)user);
                object.put("endTime", (Object)sdf.format(hsi.getEndTime()));
                object.put("time", (Object)(hsi.getEndTime().getTime() - hsi.getStartTime().getTime()));
                object.put("activityName", (Object)hsi.getName());
                object.put("activityId", (Object)hsi.getId());
                object.put("taskId", (Object)hsi.getId());
                object.put("taskDefinitionKey", (Object)hsi.getTaskDefinitionKey());
                object.put("processDefinitionId", (Object)hsi.getProcessDefinitionId());
                object.put("processInstanceId", (Object)hsi.getProcessInstanceId());
                String taskSourceFlag = (String)variables.get("taskSourceFlag");
                if ("reject_revoke".equals(taskSourceFlag)) {
                    variables.put("taskSourceFlag", "revoke");
                }
                object.put("variables", (Object)variables);
                object.put("taskSourceFlag", (Object)TASK_SOURCE_FLAG.get(variables.get("taskSourceFlag")));
                json.add((Object)object);
            }
        }
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult queryProcessDefinitionByInstanceId(String processInstanceId) {
        if (processInstanceId == null) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        JSONArray json = new JSONArray();
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (processInstance == null) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getProcessNotFound(), null);
        }
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(processInstance.getProcessDefinitionId()).singleResult();
        ProcessDefinitionModel processDefinitionModel = new ProcessDefinitionModel();
        processDefinitionModel.setKey(processDefinition.getKey());
        processDefinitionModel.setDescription(processDefinition.getDescription());
        processDefinitionModel.setVersion(String.valueOf(processDefinition.getVersion()));
        processDefinitionModel.setResourceName(processDefinition.getResourceName());
        processDefinitionModel.setDeploymentId(processDefinition.getDeploymentId());
        processDefinitionModel.setDiagramResourceName(processDefinition.getDiagramResourceName());
        processDefinitionModel.setHasStartFormKey(String.valueOf(processDefinition.hasStartFormKey()));
        processDefinitionModel.setHasGraphicalNotation(String.valueOf(processDefinition.hasGraphicalNotation()));
        processDefinitionModel.setIsSuspended(String.valueOf(processDefinition.isSuspended()));
        processDefinitionModel.setTenantId(processDefinition.getTenantId());
        json.add((Object)processDefinitionModel);
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult endProcess(String taskId, String userId, String reason) {
        if (ToolUtil.isEmpty((Object)taskId)) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getTaskIdNull(), null);
        }
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getTaskNotFound(), null);
        }
        if (task.isSuspended()) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getTaskIsSuspended(), null);
        }
        this.endCallProcess(task.getProcessInstanceId(), userId, reason);
        return InstallResult.getResult("1", "success", null);
    }

    private void endCallProcess(String instanceId, String userId, String reason) {
        List list = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(instanceId).unfinished().list();
        if (list.size() > 0) {
            for (HistoricActivityInstance historicActivityInstance : list) {
                if (!"callActivity".equals(historicActivityInstance.getActivityType())) continue;
                TaskEngineServiceImpl.CALL_REJECT_LIST.add(historicActivityInstance.getProcessInstanceId() + historicActivityInstance.getActivityId());
                this.endCallProcess(historicActivityInstance.getCalledProcessInstanceId(), userId, reason);
                TaskEngineServiceImpl.CALL_REJECT_LIST.remove(historicActivityInstance.getProcessInstanceId() + historicActivityInstance.getActivityId());
            }
            HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)list.get(0);
            ActivityImpl destinationActivity = null;
            ActivityImpl currentActivity = null;
            ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)this.repositoryService.getProcessDefinition(historicActivityInstance.getProcessDefinitionId());
            for (ActivityImpl activityImpl : processDefinition.getActivities()) {
                List pvmTransitionList = activityImpl.getOutgoingTransitions();
                if (pvmTransitionList.isEmpty()) {
                    destinationActivity = activityImpl;
                }
                if (!activityImpl.getId().equals(historicActivityInstance.getActivityId())) continue;
                currentActivity = activityImpl;
            }
            if (destinationActivity == null) {
                throw new PublicClientException(this.bpmConstantProperties.getEndNodeNotFound(), false);
            }
            this.processEngine.getManagementService().executeCommand((Command)new ParallelJumpTaskCmd(userId, historicActivityInstance.getExecutionId(), destinationActivity, "endProcess", reason, new HashMap<String, Object>(), currentActivity));
        }
    }

    private List<String> getAssigneeByTaskId(String taskId) {
        ArrayList<String> users = new ArrayList<String>();
        List identityLinkList = this.taskService.getIdentityLinksForTask(taskId);
        if (identityLinkList != null && identityLinkList.size() > 0) {
            for (IdentityLink identityLink : identityLinkList) {
                users.add(identityLink.getUserId());
            }
        }
        return users;
    }

    @Override
    public List<Map<String, String>> getCallNodeType(String procInstId) {
        return this.taskEngineMapper.getCallNodeType(procInstId);
    }

    static {
        TASK_SOURCE_FLAG.put(NOW_STATE, "\u529e\u7406");
        TASK_SOURCE_FLAG.put("revoke", "\u64a4\u56de");
        TASK_SOURCE_FLAG.put("skip", "\u8df3\u8fc7");
        TASK_SOURCE_FLAG.put("reject", "\u9a73\u56de");
        TASK_SOURCE_FLAG.put("freejump", "\u81ea\u7531\u8df3\u8f6c");
        TASK_SOURCE_FLAG.put("endProcess", "\u7ec8\u7ed3\u6d41\u7a0b");
    }
}

