/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.engine.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.bpm.definition.model.ProcessDefinitionModel;
import com.jxdinfo.hussar.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.bpm.engine.model.BpmResponseResult;
import com.jxdinfo.hussar.bpm.engine.service.DefinitionEngineService;
import com.jxdinfo.hussar.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.bpm.extend.ExtendBpmnJsonConverter;
import com.jxdinfo.hussar.bpm.model.dao.ModelMapper;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.Model;
import org.activiti.engine.repository.ModelQuery;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.repository.ProcessDefinitionQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class DefinitionEngineServiceImpl
implements DefinitionEngineService {
    private static Logger LOGGER = LoggerFactory.getLogger(DefinitionEngineServiceImpl.class);
    @Autowired
    private ProcessDefinitionsService processDefinitionsService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Resource
    private ModelMapper modelMapper;

    @Override
    public BpmResponseResult queryProcessName(String processDefinitionKey) {
        JSONObject object = new JSONObject();
        JSONArray json = new JSONArray();
        object.put("processName", (Object)this.processDefinitionsService.getMainOrNew(processDefinitionKey).getName());
        json.add((Object)object);
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult queryProcessDefListOfMainVersion(String processName) {
        JSONObject object = new JSONObject();
        JSONArray json = new JSONArray();
        List<ProcessDefinitionModel> deployments = this.processDefinitionsService.queryProcessDefListOfMainVersion(processName);
        ArrayList<ProcessDefinitionModel> result = new ArrayList<ProcessDefinitionModel>(deployments.size());
        for (ProcessDefinitionModel item : deployments) {
            if (item.getResourceName() != null) {
                String[] sourceArr = item.getResourceName().split("/");
                item.setResourceName(sourceArr[sourceArr.length - 1]);
            } else {
                item.setResourceName("");
            }
            if (item.getDiagramResourceName() != null) {
                String[] diagramArr = item.getDiagramResourceName().split("/");
                item.setDiagramResourceName(diagramArr[diagramArr.length - 1]);
            } else {
                item.setDiagramResourceName("");
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                Date date = sdf.parse(item.getDeploymentTime());
                String timeStr = sdf.format(date);
                item.setDeploymentTime(timeStr);
                result.add(item);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        object.put("data", result);
        object.put("count", (Object)result.size());
        json.add((Object)object);
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult queryProcessDefList(String processName) {
        JSONArray json = new JSONArray();
        List deployments = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().processDefinitionNameLike("%" + processName + "%").orderByProcessDefinitionName().desc()).list();
        ArrayList<ProcessDefinitionModel> result = new ArrayList<ProcessDefinitionModel>(deployments.size());
        for (ProcessDefinition deployment : deployments) {
            ProcessDefinitionModel item = new ProcessDefinitionModel();
            item.setId(deployment.getId());
            item.setProcessName(deployment.getName());
            item.setVersion(Integer.toString(deployment.getVersion()));
            item.setIsSuspended(Boolean.toString(deployment.isSuspended()));
            item.setDescription(deployment.getDescription());
            item.setCategory(deployment.getCategory());
            item.setDeploymentId(deployment.getDeploymentId());
            if (deployment.getResourceName() != null) {
                String[] sourceArr = deployment.getResourceName().split("/");
                item.setResourceName(sourceArr[sourceArr.length - 1]);
            } else {
                item.setResourceName("");
            }
            if (deployment.getDiagramResourceName() != null) {
                String[] diagramArr = deployment.getDiagramResourceName().split("/");
                item.setDiagramResourceName(diagramArr[diagramArr.length - 1]);
            } else {
                item.setDiagramResourceName("");
            }
            Deployment deploymentTime = (Deployment)this.repositoryService.createDeploymentQuery().deploymentId(deployment.getDeploymentId()).singleResult();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String timeStr = sdf.format(deploymentTime.getDeploymentTime());
            item.setDeploymentTime(timeStr);
            result.add(item);
        }
        json.add(result);
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult activateProcessDefinitionById(String processDefinitionId) {
        this.repositoryService.activateProcessDefinitionById(processDefinitionId);
        return InstallResult.getResult("1", "success", null);
    }

    @Override
    public BpmResponseResult suspendProcessDefinitionById(String processDefinitionId) {
        this.repositoryService.suspendProcessDefinitionById(processDefinitionId);
        return InstallResult.getResult("1", "success", null);
    }

    @Override
    public BpmResponseResult deleteProcessDefinition(String processDefinitionId) {
        if (processDefinitionId == null) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(processDefinitionId).singleResult();
        if (ToolUtil.isEmpty((Object)processDefinition)) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getProcessNotFound(), null);
        }
        if ("0".equals(this.modelMapper.getRunningCountWithModelId(null, processDefinitionId))) {
            this.repositoryService.deleteDeployment(processDefinition.getDeploymentId());
            return InstallResult.getResult("1", "success", null);
        }
        return InstallResult.getResult("0", this.bpmConstantProperties.getDeleteRunningFail(), null);
    }

    @Override
    public BpmResponseResult queryProcess() {
        JSONArray json = new JSONArray();
        List models = ((ModelQuery)this.repositoryService.createModelQuery().deployed().orderByLastUpdateTime().desc()).list();
        if (models != null) {
            ExtendBpmnJsonConverter jsonConverter = new ExtendBpmnJsonConverter();
            for (Model model : models) {
                JSONObject object = new JSONObject();
                byte[] arg0 = this.repositoryService.getModelEditorSource(model.getId());
                try {
                    String temp = new String(arg0, StandardCharsets.UTF_8).replace("undefined", "");
                    JsonNode editorNode = new ObjectMapper().readTree(temp.getBytes(StandardCharsets.UTF_8));
                    BpmnModel bpmnModel = jsonConverter.convertToBpmnModel(editorNode);
                    Process process = bpmnModel.getMainProcess();
                    object.put("id", (Object)process.getId());
                    object.put("name", (Object)process.getName());
                    json.add((Object)object);
                }
                catch (IOException e) {
                    LOGGER.error(e.getMessage());
                }
            }
        }
        return InstallResult.getResult("1", "success", json);
    }

    @Override
    public BpmResponseResult queryProcessLink(String processDefinitionKey) {
        JSONArray json = new JSONArray();
        String processDefinitionId = this.processDefinitionsService.getMainOrNew(processDefinitionKey).getId();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(processDefinitionId).latestVersion().singleResult();
        if (processDefinition == null) {
            return InstallResult.getResult("0", this.bpmConstantProperties.getProcessNotFound(), null);
        }
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinition.getId());
        if (bpmnModel != null) {
            Collection flowElements = ((Process)bpmnModel.getProcesses().get(0)).getFlowElements();
            for (FlowElement flowElement : flowElements) {
                if (!(flowElement instanceof UserTask)) continue;
                JSONObject object = new JSONObject();
                object.put("id", (Object)flowElement.getId());
                object.put("name", (Object)flowElement.getName());
                json.add((Object)object);
            }
            return InstallResult.getResult("1", "success", json);
        }
        return InstallResult.getResult("0", this.bpmConstantProperties.getModelNotFound(), null);
    }

    @Override
    public BpmResponseResult queryStartFormUrl(String processDefinitionKey) {
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(this.processDefinitionsService.getMainOrNew(processDefinitionKey).getId());
        Collection flowElements = bpmnModel.getMainProcess().getFlowElements();
        for (FlowElement flowElement : flowElements) {
            if (!(flowElement instanceof StartEvent)) continue;
            String formUrl = ((StartEvent)flowElement).getFormKey();
            jsonObject.put("formUrl", (Object)formUrl);
            jsonArray.add((Object)jsonObject);
            break;
        }
        return InstallResult.getResult("1", "success", jsonArray);
    }
}

