/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.definition.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.bpm.definition.dao.ProcessDefinitionsMapper;
import com.jxdinfo.hussar.bpm.definition.model.DefinitionModel;
import com.jxdinfo.hussar.bpm.definition.model.ProcessDefinitionModel;
import com.jxdinfo.hussar.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.bpm.model.service.ModelService;
import com.jxdinfo.hussar.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.core.exception.BizExceptionEnum;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.ProcessEngine;
import org.apache.commons.io.IOUtils;
import org.apache.tools.zip.ZipEntry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;

@Service
public class ProcessDefinitionsServiceImpl
implements ProcessDefinitionsService {
    @Value(value="${spring.datasource.url:}")
    private String url;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Autowired
    ProcessEngine processEngine;
    @Autowired
    ModelService modelService;
    @Autowired
    ProcessDefinitionsMapper processDefinitionsMapper;

    @Override
    public Map<String, Object> queryProcessDefinitionsList(String definitionName, Integer page, Integer limit) {
        List<Object> instList = new ArrayList();
        Page pages = new Page((long)page.intValue(), (long)limit.intValue());
        instList = this.processDefinitionsMapper.getList((Page<DefinitionModel>)pages, definitionName);
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("count", pages.getTotal());
        dataMap.put("data", instList);
        return dataMap;
    }

    @Override
    public DefinitionModel getMainOrNew(String processDefKey) {
        List<DefinitionModel> list = this.processDefinitionsMapper.getMainOrNew(processDefKey);
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        throw new PublicClientException(this.bpmConstantProperties.getProcessDefKeyError(), false);
    }

    @Override
    public int setMain(String processDefKey, String id) {
        int num = this.processDefinitionsMapper.setNotMain(processDefKey, null) + this.processDefinitionsMapper.setMain(id);
        num += this.processDefinitionsMapper.setModelMain(id);
        if ("oracle".equals(this.url.split(":")[1])) {
            this.processDefinitionsMapper.setNameOracle(processDefKey);
        } else {
            this.processDefinitionsMapper.setNameNotOracle(processDefKey);
        }
        return num;
    }

    @Override
    public int cancelMain(String processDefKey, String id) {
        int num = this.processDefinitionsMapper.setNotMain(processDefKey, id);
        if ("oracle".equals(this.url.split(":")[1])) {
            this.processDefinitionsMapper.setNameOracle(processDefKey);
        } else {
            this.processDefinitionsMapper.setNameNotOracle(processDefKey);
        }
        return num;
    }

    @Override
    public void downloadFiles(String tenantId, HttpServletRequest request, HttpServletResponse response) {
        String deploymentId = request.getParameter("deploymentId") == null ? "" : request.getParameter("deploymentId");
        String resourceName = request.getParameter("resourceName") == null ? "" : request.getParameter("resourceName");
        DefinitionModel processDefinitionModel = this.processDefinitionsMapper.getById(deploymentId);
        String key = processDefinitionModel.getId();
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        response.setContentType(MediaType.APPLICATION_OCTET_STREAM.toString());
        response.setHeader("Content-Disposition", "attachment; filename=\"model.zip\"");
        HashMap fileMap = new HashMap();
        ArrayList files = new ArrayList();
        fileMap.put(processDefinitionModel.getName(), files);
        String filename = processDefinitionModel.getName() + "_" + key.split(":")[0] + "/" + key.replace(":", "_") + ".bpmn20.xml";
        ZipEntry zipEntry = new ZipEntry(filename);
        try (ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)response.getOutputStream());
             ByteArrayInputStream in = (ByteArrayInputStream)this.processEngine.getProcessEngineConfiguration().getRepositoryService().getResourceAsStream(deploymentId, resourceName);){
            zipOutputStream.putNextEntry((java.util.zip.ZipEntry)zipEntry);
            IOUtils.copy((InputStream)in, (OutputStream)zipOutputStream);
            this.modelService.toFileZip(tenantId, null, key, zipOutputStream);
        }
        catch (IOException e) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.SERVER_ERROR);
        }
    }

    @Override
    public List<ProcessDefinitionModel> queryProcessDefListOfMainVersion(String processName) {
        List<ProcessDefinitionModel> list = this.processDefinitionsMapper.queryProcessDefListOfMainVersion(processName);
        ArrayList<ProcessDefinitionModel> newList = new ArrayList<ProcessDefinitionModel>();
        Boolean flag = false;
        for (ProcessDefinitionModel oldPro : list) {
            flag = false;
            for (ProcessDefinitionModel newPro : newList) {
                if (!ToolUtil.equals((Object)oldPro.getKey(), (Object)newPro.getKey())) continue;
                flag = true;
                break;
            }
            if (flag.booleanValue()) continue;
            newList.add(oldPro);
        }
        return newList;
    }

    @Override
    public int setVersionTemporary(String id) {
        return this.processDefinitionsMapper.setVersionTemporary(id);
    }

    @Override
    public void editTemporaryDefId(String defId, String instId, String version) {
        if ("mysql".equals(this.url.split(":")[1]) || "oscar".equals(this.url.split(":")[1])) {
            this.processDefinitionsMapper.editTemporaryDefIdMySql(defId, instId, version);
        } else {
            this.processDefinitionsMapper.editTemporaryDefIdOracle(defId, instId, version);
        }
    }
}

