/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.common.response;

import com.jxdinfo.hussar.bpm.common.constant.BpmEnum;
import com.jxdinfo.hussar.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.bpm.common.response.IResultCode;
import com.jxdinfo.hussar.bpm.common.response.ResultCode;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import java.io.Serializable;
import java.util.Optional;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;

public class ApiResponse<T>
implements Serializable {
    private static final long serialVersionUID = -5104378348955818552L;
    private int code;
    private boolean success;
    private T data;
    private String msg;
    private static BpmConstantProperties bpmConstantProperties = (BpmConstantProperties)SpringContextHolder.getBean(BpmConstantProperties.class);

    private ApiResponse(IResultCode resultCode) {
        this(resultCode, null, resultCode.getMessage());
    }

    private ApiResponse(IResultCode resultCode, String msg) {
        this(resultCode, null, msg);
    }

    private ApiResponse(IResultCode resultCode, T data, String msg) {
        this(resultCode.getCode(), data, msg);
    }

    private ApiResponse(Integer code, String message) {
        this(code, null, message);
    }

    public ApiResponse() {
    }

    private ApiResponse(int code, T data, String msg) {
        this.code = code;
        this.data = data;
        this.msg = msg;
        this.success = ResultCode.SUCCESS.code == code;
    }

    private ApiResponse(int code, T data, String msg, boolean flag) {
        this.code = code;
        this.data = data;
        this.msg = msg;
        this.success = flag;
    }

    public static boolean isSuccess(@Nullable ApiResponse<?> result) {
        return Optional.ofNullable(result).map(x -> ObjectUtils.nullSafeEquals((Object)ResultCode.SUCCESS.code, (Object)x.code)).orElse(Boolean.FALSE);
    }

    public static boolean isNotSuccess(@Nullable ApiResponse<?> result) {
        return !ApiResponse.isSuccess(result);
    }

    public static <T> ApiResponse<T> data(T data) {
        return ApiResponse.data(data, bpmConstantProperties.getDefaultSuccessMessage());
    }

    public static <T> ApiResponse<T> data(T data, String msg) {
        return ApiResponse.data(200, data, msg);
    }

    public static <T> ApiResponse<T> data(int code, T data, String msg) {
        return new ApiResponse<T>(code, data, data == null ? bpmConstantProperties.getDefaultNullMessage() : msg);
    }

    public static <T> ApiResponse<T> success(String msg) {
        return new ApiResponse<T>(ResultCode.SUCCESS, msg);
    }

    public static <T> ApiResponse<T> success(int code, String msg) {
        return new ApiResponse<Object>(code, null, msg, true);
    }

    public static <T> ApiResponse<T> success(IResultCode resultCode) {
        return new ApiResponse<T>(resultCode);
    }

    public static <T> ApiResponse<T> success(IResultCode resultCode, String msg) {
        return new ApiResponse<T>(resultCode, msg);
    }

    public static <T> ApiResponse<T> fail(String msg) {
        return new ApiResponse<T>(ResultCode.FAILURE, msg);
    }

    public static <T> ApiResponse<T> fail(int code, String msg) {
        return new ApiResponse<Object>(code, null, msg, false);
    }

    public static <T> ApiResponse<T> fail(IResultCode resultCode) {
        return new ApiResponse<T>(resultCode);
    }

    public static <T> ApiResponse<T> fail(IResultCode resultCode, String msg) {
        return new ApiResponse<T>(resultCode, msg);
    }

    public static <T> ApiResponse<T> status(boolean flag) {
        return flag ? ApiResponse.success(BpmEnum.DEFAULT_SUCCESS_MESSAGE.getMessage()) : ApiResponse.fail(BpmEnum.DEFAULT_FAILURE_MESSAGE.getMessage());
    }

    public static <T> ApiResponse<T> enumeration(BpmEnum bpmEnum) {
        return new ApiResponse<T>(bpmEnum.getCode(), bpmEnum.getMessage());
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public static long getSerialversionuid() {
        return -5104378348955818552L;
    }
}

