/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.common.properties;

import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="bpm")
public class LcdpBpmProperties {
    public static final String PREFIX = "bpm";
    private String defaultPass = "123456";
    private String fileUploadPathWindows = "d:/tmp";
    private String fileUploadPathLinux = "/tmp/hussar";
    private Boolean fileDateSplit = true;
    private Boolean haveCreatePath = false;
    private String modulePath = "modulePath";
    private String versionPath = "versionPath";
    private boolean standAlone;
    private boolean useRedis;
    private String version = "";

    public String getFileUploadPath() {
        String fileUploadPath = "";
        boolean fileDateSplit = this.getFileDateSplit();
        Properties prop = System.getProperties();
        String os = prop.getProperty("os.name");
        if (os != null) {
            fileUploadPath = os.toLowerCase().indexOf("windows") > -1 ? this.fileUploadPathWindows : this.fileUploadPathLinux;
        }
        if (fileDateSplit) {
            fileUploadPath = fileUploadPath + "/" + new SimpleDateFormat("yyyy/MM/dd").format(new Date());
        }
        if (ToolUtil.isEmpty((Object)fileUploadPath)) {
            return ToolUtil.getTempPath();
        }
        if (!fileUploadPath.endsWith(File.separator)) {
            fileUploadPath = fileUploadPath + File.separator;
        }
        if (!this.haveCreatePath.booleanValue()) {
            File file = new File(fileUploadPath);
            file.mkdirs();
            this.haveCreatePath = true;
        }
        return fileUploadPath;
    }

    public void setFileUploadPathWindows(String fileUploadPathWindows) {
        this.fileUploadPathWindows = fileUploadPathWindows;
    }

    public void setFileUploadPathLinux(String fileUploadPathLinux) {
        this.fileUploadPathLinux = fileUploadPathLinux;
    }

    public Boolean getFileDateSplit() {
        return this.fileDateSplit;
    }

    public void setFileDateSplit(Boolean fileDateSplit) {
        this.fileDateSplit = fileDateSplit;
    }

    public String getFileUploadPathWindows() {
        return this.fileUploadPathWindows;
    }

    public String getFileUploadPathLinux() {
        return this.fileUploadPathLinux;
    }

    public Boolean getHaveCreatePath() {
        return this.haveCreatePath;
    }

    public void setHaveCreatePath(Boolean haveCreatePath) {
        this.haveCreatePath = haveCreatePath;
    }

    public String getDefaultPass() {
        return this.defaultPass;
    }

    public void setDefaultPass(String defaultPass) {
        this.defaultPass = defaultPass;
    }

    public String getModulePath() {
        return this.modulePath;
    }

    public String getBpmListenerPath() {
        return null;
    }

    public void setModulePath(String modulePath) {
        this.modulePath = modulePath;
    }

    public String getVersionPath() {
        return this.versionPath;
    }

    public void setVersionPath(String versionPath) {
        this.versionPath = versionPath;
    }

    public boolean isStandAlone() {
        return this.standAlone;
    }

    public void setStandAlone(boolean standAlone) {
        this.standAlone = standAlone;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isUseRedis() {
        return this.useRedis;
    }

    public void setUseRedis(boolean useRedis) {
        this.useRedis = useRedis;
    }
}

