/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.cctask.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.bpm.cctask.dao.SysActCcTaskMapper;
import com.jxdinfo.hussar.bpm.cctask.model.SysActCcTask;
import com.jxdinfo.hussar.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SysActCcTaskServiceImpl
extends ServiceImpl<SysActCcTaskMapper, SysActCcTask>
implements ISysActCcTaskService {
    @Resource
    SysActCcTaskMapper sysActCcTaskMapper;
    @Autowired
    IAssigneeChooseService iAssigneeChooseService;
    @Value(value="${spring.datasource.url:}")
    private String url;

    @Override
    public List<SysActCcTask> query(Page<SysActCcTask> pages, String userId, String processDefinitionKey, String sendUser, String startTime, String endTime, String tenantId) {
        List<SysActCcTask> sysActUrgeTasks = this.sysActCcTaskMapper.queryOutside(pages, userId, processDefinitionKey, sendUser, startTime, endTime, this.url.split(":")[1]);
        if (sysActUrgeTasks != null && sysActUrgeTasks.size() > 0) {
            List<String> users = sysActUrgeTasks.stream().map(SysActCcTask::getSendUser).collect(Collectors.toList());
            Map<String, String> map = this.iAssigneeChooseService.getUserListByUserId(users, tenantId);
            if (map == null) {
                map = new HashMap<String, String>();
            }
            for (SysActCcTask sysActCcTask : sysActUrgeTasks) {
                JSONObject object;
                String userName = map.get(sysActCcTask.getSendUser());
                sysActCcTask.setSendUserName(userName);
                String formDetailKey = sysActCcTask.getFormDetailKey();
                if (!ToolUtil.isNotEmpty((Object)formDetailKey) || !ToolUtil.isNotEmpty((Object)(object = JSON.parseObject((String)formDetailKey)))) continue;
                sysActCcTask.setWeb(object.getString("web"));
                sysActCcTask.setMobile(object.getString("mobile"));
            }
        }
        return sysActUrgeTasks;
    }
}

