/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.assignee.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.jxdinfo.hussar.bpm.assignee.dao.AssigneeChooseMapper;
import com.jxdinfo.hussar.bpm.assignee.model.BpmTreeModel;
import com.jxdinfo.hussar.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.bpm.common.utils.HttpRequestUtil;
import com.jxdinfo.hussar.bpm.model.service.impl.ModelServiceImpl;
import com.jxdinfo.hussar.bsp.exception.GodAxeRequestException;
import com.jxdinfo.hussar.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.bsp.tenantconfig.model.TenantConfig;
import com.jxdinfo.hussar.bsp.tenantconfig.service.ITenantConfigService;
import com.jxdinfo.hussar.core.util.HussarBpmSM4Util;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class AssigneeChooseServiceImpl
implements IAssigneeChooseService {
    @Resource
    AssigneeChooseMapper assigneeChooseMapper;
    @Resource
    private ITenantConfigService iTenantConfigService;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    private static Logger LOGGER = LoggerFactory.getLogger(ModelServiceImpl.class);
    private static final String USER_TREE_URL = "/assignee/user";
    private static final String DEPT_TREE_URL = "/assignee/dept";
    private static final String ROLE_TREE_URL = "/assignee/role";
    private static final String USER_DETAIL_URL = "/assignee/userDetail";
    private static final String CANDIDATE_USER_URL = "/assignee/getCandidateUser";
    private static final String REAL_CANDIDATE_URL = "/assignee/getRealCondition";
    private static final String IS_MULTI_TENANT = "1";
    private static final String DEFAULT_PARENTID = "11";

    @Override
    public List<BpmTreeModel> userTree(String id, String tenantId, boolean isInterface) {
        String newId = StringUtils.isEmpty((Object)id) ? DEFAULT_PARENTID : id;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", newId);
        map.put("tenantId", HussarBpmSM4Util.encrypt(tenantId, "admin#$%^kopoiuy"));
        TenantConfig tenantConfig = this.iTenantConfigService.getTenantConfig(tenantId);
        if (tenantConfig == null) {
            return new ArrayList<BpmTreeModel>();
        }
        try {
            if (IS_MULTI_TENANT.equals(tenantConfig.getIsMultiTenant())) {
                return this.assigneeChooseMapper.userTree(newId);
            }
        }
        catch (Exception e) {
            throw new GodAxeRequestException(2);
        }
        return this.getRequestResult(tenantConfig.getProjectAddress() + USER_TREE_URL, isInterface, map);
    }

    @Override
    public List<BpmTreeModel> deptTree(String id, String tenantId, boolean isInterface) {
        String newId = StringUtils.isEmpty((Object)id) ? DEFAULT_PARENTID : id;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", newId);
        map.put("tenantId", HussarBpmSM4Util.encrypt(tenantId, "admin#$%^kopoiuy"));
        TenantConfig tenantConfig = this.iTenantConfigService.getTenantConfig(tenantId);
        if (tenantConfig == null) {
            return new ArrayList<BpmTreeModel>();
        }
        try {
            if (IS_MULTI_TENANT.equals(tenantConfig.getIsMultiTenant())) {
                return this.assigneeChooseMapper.deptTree(newId);
            }
        }
        catch (Exception e) {
            throw new GodAxeRequestException(2);
        }
        return this.getRequestResult(tenantConfig.getProjectAddress() + DEPT_TREE_URL, isInterface, map);
    }

    @Override
    public List<BpmTreeModel> roleTree(String tenantId, boolean isInterface) {
        TenantConfig tenantConfig = this.iTenantConfigService.getTenantConfig(tenantId);
        if (tenantConfig == null) {
            return new ArrayList<BpmTreeModel>();
        }
        try {
            if (IS_MULTI_TENANT.equals(tenantConfig.getIsMultiTenant())) {
                return this.assigneeChooseMapper.roleTree();
            }
        }
        catch (Exception e) {
            throw new GodAxeRequestException(2);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantId", HussarBpmSM4Util.encrypt(tenantId, "admin#$%^kopoiuy"));
        return this.getRequestResult(tenantConfig.getProjectAddress() + ROLE_TREE_URL, isInterface, map);
    }

    @Override
    public List<BpmTreeModel> userDetail(List<String> userIds, String tenantId, boolean isInterface) {
        if (ToolUtil.isEmpty(userIds)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userIds", String.join((CharSequence)",", userIds));
        map.put("tenantId", HussarBpmSM4Util.encrypt(tenantId, "admin#$%^kopoiuy"));
        TenantConfig tenantConfig = this.iTenantConfigService.getTenantConfig(tenantId);
        if (tenantConfig == null) {
            throw new PublicClientException(this.bpmConstantProperties.getTenantConfigNotExist(), false);
        }
        try {
            if (IS_MULTI_TENANT.equals(tenantConfig.getIsMultiTenant())) {
                return this.assigneeChooseMapper.userDetail(userIds);
            }
        }
        catch (Exception e) {
            throw new GodAxeRequestException(2);
        }
        return this.getRequestResult(tenantConfig.getProjectAddress() + USER_DETAIL_URL, isInterface, map);
    }

    @Override
    public String getStarterDept(String userIds, String tenantId) {
        String startDept = "";
        List<BpmTreeModel> list = this.userDetail(Collections.singletonList(userIds), tenantId, true);
        if (list != null && list.size() > 0) {
            BpmTreeModel bpmTreeModel = list.get(0);
            startDept = bpmTreeModel.getParentId() == null ? "" : bpmTreeModel.getParentId();
        }
        return startDept;
    }

    @Override
    public String getUserNames(List<String> userIds, String tenantId) {
        StringBuilder result = new StringBuilder();
        List<BpmTreeModel> list = this.userDetail(userIds, tenantId, false);
        if (list != null && list.size() > 0) {
            for (BpmTreeModel bpmTreeModel : list) {
                result.append(bpmTreeModel.getLabel()).append(",");
            }
            result = new StringBuilder(result.substring(0, result.length() - 1));
        }
        return result.toString();
    }

    @Override
    public List<Map<String, String>> getUserListByUserIdWithSelect(List<String> userList, String tenantId) {
        List<BpmTreeModel> list = this.userDetail(userList, tenantId, true);
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>();
        if (list != null && list.size() > 0) {
            for (BpmTreeModel bpmTreeModel : list) {
                HashMap<String, String> mapSelect = new HashMap<String, String>(2);
                mapSelect.put("id", bpmTreeModel.getId());
                mapSelect.put("name", bpmTreeModel.getLabel());
                resultList.add(mapSelect);
            }
        }
        return resultList;
    }

    @Override
    public Map<String, String> getUserListByUserId(List<String> userIds, String tenantId) {
        HashMap<String, String> map = new HashMap<String, String>();
        List<BpmTreeModel> list = this.userDetail(userIds, tenantId, false);
        if (list != null && list.size() > 0) {
            for (BpmTreeModel bpmTreeModel : list) {
                map.put(bpmTreeModel.getId(), bpmTreeModel.getLabel());
            }
        }
        return map;
    }

    @Override
    public List<String> getCandidateUser(String condition, String tenantId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("condition", HussarBpmSM4Util.encrypt(condition, "admin#$%^kopoiuy"));
        map.put("tenantId", HussarBpmSM4Util.encrypt(tenantId, "admin#$%^kopoiuy"));
        TenantConfig tenantConfig = this.iTenantConfigService.getTenantConfig(tenantId);
        if (tenantConfig == null) {
            throw new PublicClientException(this.bpmConstantProperties.getTenantConfigNotExist(), false);
        }
        if (condition.contains("@{")) {
            condition = HttpRequestUtil.getResult(tenantConfig.getProjectAddress() + REAL_CANDIDATE_URL, map);
        }
        if (IS_MULTI_TENANT.equals(tenantConfig.getIsMultiTenant())) {
            try {
                StringBuilder sb = new StringBuilder();
                sb.append(" SELECT O.ORGAN_ID AS userId ").append(" FROM HUSSAR_BPM_ORGAN_VIEW O ").append("  LEFT JOIN HUSSAR_BPM_USER_ROLE_VIEW R ON R.USER_ID = O.ORGAN_ID ").append("  WHERE O.TYPE = 'user'  ");
                sb.append(condition);
                return this.assigneeChooseMapper.getCandidateUsers(sb.toString());
            }
            catch (Exception e) {
                throw new GodAxeRequestException(2);
            }
        }
        try {
            String result = HttpRequestUtil.getResult(tenantConfig.getProjectAddress() + CANDIDATE_USER_URL, map);
            return JSONArray.parseArray((String)result, String.class);
        }
        catch (GodAxeRequestException e) {
            if (1 == e.getRequestErrorType()) {
                throw new GodAxeRequestException(3);
            }
            throw e;
        }
    }

    private List<BpmTreeModel> getRequestResult(String url, boolean isInterface, Map<String, Object> map) {
        try {
            String result = HttpRequestUtil.getResult(url, map);
            return JSONArray.parseArray((String)result, BpmTreeModel.class);
        }
        catch (GodAxeRequestException e) {
            if (isInterface) {
                if (1 == e.getRequestErrorType()) {
                    throw new GodAxeRequestException(3);
                }
                throw e;
            }
            LOGGER.error(this.bpmConstantProperties.getHttpRequestError());
            return new ArrayList<BpmTreeModel>();
        }
        catch (Exception e) {
            if (isInterface) {
                throw new GodAxeRequestException(3);
            }
            LOGGER.error(this.bpmConstantProperties.getHttpRequestError());
            return new ArrayList<BpmTreeModel>();
        }
    }
}

