/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.exception;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.bpm.common.constant.BpmEnum;
import com.jxdinfo.hussar.bpm.common.constant.BusinessLogType;
import com.jxdinfo.hussar.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.bpm.common.response.ApiResponse;
import com.jxdinfo.hussar.bpm.engine.model.BpmResponseResult;
import com.jxdinfo.hussar.bpm.engine.service.impl.DefinitionEngineServiceImpl;
import com.jxdinfo.hussar.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.bpm.interfacelog.aop.InterfaceLogAop;
import com.jxdinfo.hussar.bpm.interfacelog.factory.InterfaceLogManager;
import com.jxdinfo.hussar.bpm.interfacelog.factory.InterfaceLogTaskFactory;
import com.jxdinfo.hussar.bsp.exception.GodAxeRequestException;
import com.jxdinfo.hussar.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.bsp.exception.TenantException;
import com.jxdinfo.hussar.bsp.exception.TenantLackInfoException;
import com.jxdinfo.hussar.bsp.exception.TenantLockException;
import com.jxdinfo.hussar.core.support.HttpKit;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.el.PropertyNotFoundException;
import javax.servlet.http.HttpServletRequest;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.ActivitiTaskAlreadyClaimedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
@Order(value=0x7FFFFFFD)
public class BpmExceptionHander {
    private static BpmConstantProperties bpmConstantProperties;
    private static Logger LOGGER;

    /*
     * WARNING - void declaration
     */
    @ExceptionHandler(value={ActivitiTaskAlreadyClaimedException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public BpmResponseResult credentials(ActivitiTaskAlreadyClaimedException activitiTaskAlreadyClaimedException) {
        void a;
        LOGGER.error(a.getMessage());
        return InstallResult.getResult("0", bpmConstantProperties.getTaskAlreadyClaimed(), null);
    }

    @ExceptionHandler(value={TenantException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public ApiResponse<?> credentials(TenantException a) {
        return ApiResponse.fail(BpmEnum.ERROR_TENANT_INFORMATION.getCode(), BpmEnum.ERROR_TENANT_INFORMATION.getMessage());
    }

    public BpmExceptionHander() {
        BpmExceptionHander a;
    }

    /*
     * Enabled aggressive block sorting
     */
    @ExceptionHandler(value={GodAxeRequestException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public BpmResponseResult credentials(GodAxeRequestException a) {
        LOGGER.error(bpmConstantProperties.getHttpRequestError());
        switch (a.getRequestErrorType()) {
            case 0: {
                return InstallResult.getResult("0", bpmConstantProperties.getErrorProjectAddress(), null);
            }
            case 1: {
                return InstallResult.getResult("0", bpmConstantProperties.getErrorGodaxeVisitor(), null);
            }
            case 2: {
                return InstallResult.getResult("0", bpmConstantProperties.getErrorViewRequest(), null);
            }
        }
        return InstallResult.getResult("0", bpmConstantProperties.getErrorRequest(), null);
    }

    @ExceptionHandler(value={PublicClientException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public BpmResponseResult credentials(HttpServletRequest a, PublicClientException a2) {
        if (a2.getIsSaveLogger().booleanValue()) {
            Serializable serializable = a2.getStackTrace()[0];
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(a2.getReason());
            stringBuilder.append(InterfaceLogAop.implements("\u5f53\u5e51\u7c2a\u5464\uff4b")).append(((StackTraceElement)serializable).getClassName());
            stringBuilder.append(BusinessLogType.private("\u5f26\u5e34\u659d\u6cd9\u5429\uff16")).append(((StackTraceElement)serializable).getMethodName());
            stringBuilder.append(InterfaceLogAop.implements("j\u5f6b\u5e69\u65ee\u4ea7\u5464\uff4b")).append(((StackTraceElement)serializable).getFileName());
            stringBuilder.append(BusinessLogType.private("\u5f0e\u5e1c\u8840\u6554\uff16")).append(((StackTraceElement)serializable).getLineNumber());
            stringBuilder.append(InterfaceLogAop.implements("\u8ba6\u6c2b\u8dbe\u5fed\uff4b")).append(a.getRequestURL()).append(BusinessLogType.private("7"));
            serializable = new HashMap(a.getParameterMap());
            serializable.remove(InterfaceLogAop.implements("\u001d4\u00070\u0007%*8\u00199\f#"));
            Object object = serializable.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry = object.next();
                String[] stringArray = (String[])entry.getValue();
                if (stringArray.length == 0) {
                    serializable.put(entry.getKey(), null);
                    continue;
                }
                if (stringArray.length != 1) continue;
                serializable.put(entry.getKey(), stringArray[0]);
            }
            if (ToolUtil.isNotEmpty((Object)serializable)) {
                stringBuilder.append(BusinessLogType.private("\u8bfb\u6c66\u53ce\u6554\uff16")).append(JSONObject.toJSONString((Object)serializable)).append(InterfaceLogAop.implements("j"));
            }
            object = new HashMap<String, String>();
            object.put("userId", HttpKit.getIp());
            object.put("userAccount", HttpKit.getIp());
            object.put(BusinessLogType.private("M|"), HttpKit.getIp());
            object.put(InterfaceLogAop.implements("\u0019>\u001b%"), HttpKit.getPort());
            object.put(BusinessLogType.private("LcWx"), HttpKit.getHost());
            object.put(InterfaceLogAop.implements("=\u00062\b= !"), HttpKit.getLocalIp());
            object.put(BusinessLogType.private("`KoE`tcVx"), HttpKit.getLocalPort());
            object.put(InterfaceLogAop.implements("=\u00062\b=!>\u001a%"), HttpKit.getLocalHost());
            object.put(BusinessLogType.private("\u007fA\u007fWeKbmh"), HttpKit.getSeesionId());
            object.put("tenantId", a.getParameter("tenantId"));
            object.put(InterfaceLogAop.implements("\u001d4\u00070\u0007%*8\u00199\f#"), a.getParameter(BusinessLogType.private("PiJmJxgeTdA~")));
            InterfaceLogManager.me().executeLog(InterfaceLogTaskFactory.exceptionLog((Map<String, String>)object, stringBuilder.toString()));
            LOGGER.error(stringBuilder.toString());
            a2.printStackTrace();
        }
        return InstallResult.getResult("0", a2.getReason(), a2.getResult());
    }

    @ExceptionHandler(value={PropertyNotFoundException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public BpmResponseResult credentials(PropertyNotFoundException a) {
        LOGGER.error(a.getMessage());
        return InstallResult.getResult("0", bpmConstantProperties.getPropertyNotFound(), null);
    }

    static {
        LOGGER = LoggerFactory.getLogger(DefinitionEngineServiceImpl.class);
        bpmConstantProperties = (BpmConstantProperties)SpringContextHolder.getBean(BpmConstantProperties.class);
    }

    @ExceptionHandler(value={TenantLackInfoException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public ApiResponse<?> credentials(TenantLackInfoException a) {
        return ApiResponse.fail(BpmEnum.INCOMPLETE_TENANT_INFORMATION.getCode(), BpmEnum.INCOMPLETE_TENANT_INFORMATION.getMessage());
    }

    @ExceptionHandler(value={ActivitiException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public BpmResponseResult credentials(ActivitiException a) {
        LOGGER.error(a.getMessage());
        if (a.getMessage().startsWith(BusinessLogType.private("OEbJcP,WiP,WyW|AbWeKb\u0004\u007fPmPi\u0004+WyW|Ab@i@+\u0004jK~\u0004\\VcGiW\u007f`iBeJePeKbabPePu"))) {
            return InstallResult.getResult("0", bpmConstantProperties.getSuspendedProcessDefinitionEntityError(), null);
        }
        if (a.getMessage().startsWith(InterfaceLogAop.implements("*0\u0007?\u0006%I\"\f%I\"\u001c\"\u00194\u0007\"\u0000>\u0007q\u001a%\b%\fqN0\n%\u0000'\fvI7\u0006#I\u0001\u001b>\n4\u001a\"-4\u000f8\u00078\u001d8\u0006?,?\u001d8\u001d("))) {
            return InstallResult.getResult("0", bpmConstantProperties.getActiveProcessDefinitionEntityError(), null);
        }
        if (a.getMessage().startsWith(BusinessLogType.private("OEbJcP,WiP,WyW|AbWeKb\u0004\u007fPmPi\u0004+WyW|Ab@i@+\u0004jK~\u0004\\VcGiW\u007fmbWxEbGi"))) {
            return InstallResult.getResult("0", bpmConstantProperties.getSuspendedProcessProcessInstanceError(), null);
        }
        if (a.getMessage().startsWith(InterfaceLogAop.implements("*0\u0007?\u0006%I\"\f%I\"\u001c\"\u00194\u0007\"\u0000>\u0007q\u001a%\b%\fqN0\n%\u0000'\fvI7\u0006#I\u0001\u001b>\n4\u001a\" ?\u001a%\b?\n4"))) {
            return InstallResult.getResult("0", bpmConstantProperties.getActiveProcessProcessInstanceError(), null);
        }
        if (a.getMessage().startsWith(BusinessLogType.private("t~KoA\u007fW,MbWxEbGi\u0004eW,WxM`H,VyJbMbC \u0004oEbJcP,@iHiPi\u0004dM\u007fPcVeG,T~KoA\u007fW,MbWxEbGi"))) {
            return InstallResult.getResult("0", bpmConstantProperties.getProcessInstanceIsNotEnd(), null);
        }
        if (InterfaceLogAop.implements("\u0012\b?\u0007>\u001dq\n=\b8\u0004q\bq\u001a$\u001a!\f?\r4\rq\u001d0\u001a:").equals(a.getMessage())) {
            return InstallResult.getResult("0", bpmConstantProperties.getTaskIsSuspended(), null);
        }
        if (a.getMessage().startsWith(BusinessLogType.private("jc\u0004cQxCcMbC,WiUyAbGi\u0004jHcS,Kj"))) {
            return InstallResult.getResult("0", bpmConstantProperties.getNoOutgoingSequence(), null);
        }
        return InstallResult.getResult("0", a.getMessage(), null);
    }

    @ExceptionHandler(value={ActivitiObjectNotFoundException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public BpmResponseResult credentials(ActivitiObjectNotFoundException a) {
        LOGGER.error(a.getMessage());
        if (a.getMessage().startsWith(InterfaceLogAop.implements("\u0012\b?\u0007>\u001dq\u000f8\u00075I%\b\"\u0002q\u001e8\u001d9I8\rq"))) {
            return InstallResult.getResult("0", bpmConstantProperties.getTaskNotFound(), null);
        }
        if (a.getMessage().startsWith(BusinessLogType.private("gmJbKx\u0004jMb@,T~KoA\u007fW,@iBeJePeKb\u0004jK~\u0004e@,")) || a.getMessage().startsWith(InterfaceLogAop.implements("\u0007>I5\f!\u0005>\u00104\rq\u0019#\u00062\f\"\u001aq\r4\u000f8\u00078\u001d8\u0006?I7\u0006$\u00075I&\u0000%\u0001q\u00005"))) {
            return InstallResult.getResult("0", bpmConstantProperties.getModelNotFound(), null);
        }
        if (a.getMessage().startsWith(BusinessLogType.private("gmJbKx\u0004jMb@,T~KoA\u007fWEJ\u007fPmJoA,BcV,Mh")) || a.getMessage().startsWith(InterfaceLogAop.implements("'>I!\u001b>\n4\u001a\"I8\u0007\"\u001d0\u00072\fq\u000f>\u001c?\rq\u000f>\u001bq\u00005")) || a.getMessage().startsWith(BusinessLogType.private("jc\u0004dM\u007fPcVeG,T~KoA\u007fW,MbWxEbGi\u0004jKyJh\u0004{MxL,Mh"))) {
            return InstallResult.getResult("0", bpmConstantProperties.getProcessNotFound(), null);
        }
        return InstallResult.getResult("0", a.getMessage(), null);
    }

    @ExceptionHandler(value={ActivitiIllegalArgumentException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public BpmResponseResult credentials(ActivitiIllegalArgumentException a) {
        LOGGER.error(a.getMessage());
        if (a.getMessage().contains(InterfaceLogAop.implements("q\u0007$\u0005="))) {
            return InstallResult.getResult("0", bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        return InstallResult.getResult("0", a.getMessage(), null);
    }

    @ExceptionHandler(value={TenantLockException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public ApiResponse<?> credentials(TenantLockException a) {
        return ApiResponse.fail(BpmEnum.USER_HAS_BEEN_DISABLED.getCode(), BpmEnum.USER_HAS_BEEN_DISABLED.getMessage());
    }
}

