/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.model.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jxdinfo.hussar.bpm.common.constant.BpmEnum;
import com.jxdinfo.hussar.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.bpm.common.response.ApiResponse;
import com.jxdinfo.hussar.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.bpm.engine.model.BpmResponseResult;
import com.jxdinfo.hussar.bpm.engine.service.InstanceEngineService;
import com.jxdinfo.hussar.bpm.engine.service.TaskEngineService;
import com.jxdinfo.hussar.bpm.engine.util.DeleteProcessDefinitionCacheCmd;
import com.jxdinfo.hussar.bpm.extend.ExtendBpmnJsonConverter;
import com.jxdinfo.hussar.bpm.extendproperties.model.SysActExtendProperties;
import com.jxdinfo.hussar.bpm.extendproperties.service.ISysActExtendPropertiesService;
import com.jxdinfo.hussar.bpm.model.dao.ModelMapper;
import com.jxdinfo.hussar.bpm.model.model.ExportModel;
import com.jxdinfo.hussar.bpm.model.model.ModelBuild;
import com.jxdinfo.hussar.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.bpm.model.service.ModelService;
import com.jxdinfo.hussar.bpm.processfile.model.SysActProcessFile;
import com.jxdinfo.hussar.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.core.exception.BizExceptionEnum;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipOutputStream;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.Model;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.explorer.util.XmlUtil;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ModelServiceImpl
extends ServiceImpl<ModelMapper, ModelBuild>
implements ModelService {
    private static Logger LOGGER = LoggerFactory.getLogger(ModelServiceImpl.class);
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private ISysActExtendPropertiesService iSysActExtendPropertiesService;
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    @Resource
    private ModelMapper modelMapper;
    @Autowired
    ProcessEngine processEngine;
    @Autowired
    private SysActProcessFileService sysActProcessFileService;
    @Autowired
    private ProcessDefinitionsService processDefinitionsService;
    @Autowired
    private InstanceEngineService instanceEngineService;
    @Autowired
    private TaskEngineService taskEngineService;
    private static final String SUFFIX = ".bpmn20.xml";

    @Override
    public String deployModel(String modelId, String tenantId) {
        try {
            Model modelData = this.repositoryService.getModel(modelId);
            byte[] bytes = this.repositoryService.getModelEditorSource(modelData.getId());
            if (bytes == null) {
                LOGGER.error("\u6a21\u578b\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u5148\u8bbe\u8ba1\u6d41\u7a0b\u5e76\u6210\u529f\u4fdd\u5b58\uff0c\u518d\u8fdb\u884c\u53d1\u5e03\u3002");
                return null;
            }
            JsonNode editNode = new ObjectMapper().readTree(bytes);
            ExtendBpmnJsonConverter jsonConverter = new ExtendBpmnJsonConverter();
            jsonConverter.updateConvertersToBpmnMap();
            jsonConverter.updateConvertersToJsonMap();
            BpmnModel bpmnModel = jsonConverter.convertToBpmnModel(editNode);
            byte[] bpmnBytes = new BpmnXMLConverter().convertToXML(bpmnModel);
            String processName = modelData.getName() + SUFFIX;
            Deployment deployment = this.repositoryService.createDeployment().name(modelData.getName()).tenantId(tenantId).addString(processName, new String(bpmnBytes, StandardCharsets.UTF_8)).deploy(true);
            modelData.setDeploymentId(deployment.getId());
            this.repositoryService.saveModel(modelData);
            ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(modelData.getDeploymentId()).latestVersion().singleResult();
            this.saveModelExtendProperties(bpmnModel, processDefinition);
            WorkFlow workFlow = this.sysActProcessFileService.getFileByProcessKey(processDefinition.getKey(), tenantId, 0);
            workFlow.setProcDefId(processDefinition.getId());
            this.sysActProcessFileService.addFile(workFlow, tenantId, null);
            this.processDefinitionsService.cancelMain(processDefinition.getKey(), null);
            return processDefinition.getId();
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage());
            return null;
        }
    }

    @Override
    public ModelBuild queryModel(String modelId) {
        return this.modelMapper.queryModel(modelId);
    }

    @Override
    public void addNodeSaveModelExtendProperties(BpmnModel bpmnModel, String defId) {
        ProcessDefinition processDefinition = this.repositoryService.getProcessDefinition(defId);
        this.saveModelExtendProperties(bpmnModel, processDefinition);
    }

    @Override
    public void deployModelByWorkFlowXml(WorkFlow workFlow, BpmnModel bpmnModel, String modelId, String tenantId, String processInstanceId, String version) {
        Model modelData = this.repositoryService.getModel(modelId);
        String processName = modelData.getName() + SUFFIX;
        byte[] bpmnBytes = new BpmnXMLConverter().convertToXML(bpmnModel);
        Deployment deployment = this.repositoryService.createDeployment().name(modelData.getName()).tenantId(tenantId).addString(processName, new String(bpmnBytes, StandardCharsets.UTF_8)).deploy(false);
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId()).singleResult();
        this.saveModelExtendProperties(bpmnModel, processDefinition);
        workFlow.setProcDefId(processDefinition.getId());
        this.sysActProcessFileService.addFile(workFlow, tenantId, null);
        this.processDefinitionsService.setVersionTemporary(processDefinition.getId());
        this.processDefinitionsService.editTemporaryDefId(processDefinition.getId(), processInstanceId, version);
        this.processEngine.getManagementService().executeCommand((Command)new DeleteProcessDefinitionCacheCmd(processDefinition.getId()));
    }

    private void saveModelExtendProperties(BpmnModel model, ProcessDefinition processDefinition) {
        ArrayList<SysActExtendProperties> sysActExtendProperties = new ArrayList<SysActExtendProperties>();
        String procDefId = processDefinition.getId();
        if (model != null) {
            Collection flowElements = model.getMainProcess().getFlowElements();
            for (FlowElement node : flowElements) {
                if (!(node instanceof UserTask)) continue;
                UserTask userTask = (UserTask)node;
                String formDetailKey = this.getFormDetailKey(userTask);
                JSONObject object = new JSONObject();
                if (!ToolUtil.isNotEmpty((Object)formDetailKey)) continue;
                JSONObject jsonObject = JSON.parseObject((String)formDetailKey);
                if (jsonObject != null) {
                    for (String key : jsonObject.keySet()) {
                        object.put(key, jsonObject.getJSONObject(key).get((Object)"url"));
                    }
                }
                SysActExtendProperties asep = new SysActExtendProperties();
                asep.setId(procDefId + userTask.getId());
                asep.setTaskDefKey(userTask.getId());
                asep.setFormDetailKey(JSON.toJSONString((Object)object));
                asep.setTaskDefName(userTask.getName());
                asep.setProcDefId(procDefId);
                sysActExtendProperties.add(asep);
            }
        }
        if (sysActExtendProperties.size() > 0) {
            this.iSysActExtendPropertiesService.saveBatch(sysActExtendProperties);
        }
    }

    private String getFormDetailKey(UserTask userTask) {
        Map extensionElement = userTask.getExtensionElements();
        return ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElement.get("flowFormDetailKey")).get(0)).getAttributes().get("flowFormDetailKey")).get(0)).getValue();
    }

    @Override
    public Map<String, Object> queryModelList(String modelName, Integer page, Integer limit) {
        try {
            Page pages = new Page((long)page.intValue(), (long)limit.intValue());
            List<ModelBuild> list = this.modelMapper.queryModelList((Page<ModelBuild>)pages, modelName);
            HashMap<String, Object> map = new HashMap<String, Object>(4);
            map.put("count", pages.getTotal());
            map.put("code", 0);
            map.put("msg", "success");
            map.put("data", list);
            return map;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.SERVER_ERROR);
        }
    }

    @Override
    public ApiResponse<?> deleteModel(String tenantId, String modelId) {
        if ("0".equals(this.modelMapper.getRunningCountWithModelId(modelId, null))) {
            this.repositoryService.deleteModel(modelId);
            this.modelMapper.deleteModelDef(modelId, null);
            this.sysActProcessFileService.remove((Wrapper)new QueryWrapper().eq((Object)"MODEL_ID", (Object)modelId));
            return ApiResponse.success(BpmEnum.DELETE_SUCCESS.getCode(), BpmEnum.DELETE_SUCCESS.getMessage());
        }
        return ApiResponse.fail(BpmEnum.DELETE_RUNNING_FAIL.getCode(), BpmEnum.DELETE_RUNNING_FAIL.getMessage());
    }

    @Override
    public ApiResponse<?> deleteModelWithVersion(String tenantId, String processDefId) {
        if ("0".equals(this.modelMapper.getRunningCountWithModelId(null, processDefId))) {
            this.modelMapper.deleteModelDef(null, processDefId);
            this.sysActProcessFileService.remove((Wrapper)new QueryWrapper().eq((Object)"PROCESS_ID", (Object)processDefId));
            return ApiResponse.success(BpmEnum.DELETE_SUCCESS.getCode(), BpmEnum.DELETE_SUCCESS.getMessage());
        }
        return ApiResponse.fail(BpmEnum.DELETE_RUNNING_FAIL.getCode(), BpmEnum.DELETE_RUNNING_FAIL.getMessage());
    }

    @Override
    public String getIdByIdentity(String identity) {
        return this.modelMapper.getIdByIdentity(identity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> unZipFile(String zipFile, String filePath, HttpServletRequest request) {
        String clientChartSet = request.getCharacterEncoding();
        ArrayList<String> resultList = new ArrayList<String>();
        InputStream in = null;
        OutputStream out = null;
        try {
            File pathFile = new File(filePath);
            if (!pathFile.exists()) {
                pathFile.mkdirs();
            }
            long time = System.currentTimeMillis();
            ZipFile zip = new ZipFile(zipFile, "UTF-8");
            Enumeration entries = zip.getEntries();
            while (entries.hasMoreElements()) {
                int len;
                ZipEntry entry = (ZipEntry)entries.nextElement();
                String zipEntryName = entry.getName();
                in = zip.getInputStream(entry);
                String outPath = (filePath + time + File.separator + new String(zipEntryName.getBytes(clientChartSet))).replaceAll("\\*", File.separator);
                File file = new File(outPath);
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                if (new File(outPath).isDirectory()) continue;
                resultList.add(outPath);
                out = new FileOutputStream(outPath);
                byte[] buf1 = new byte[1024];
                while ((len = in.read(buf1)) > 0) {
                    out.write(buf1, 0, len);
                }
                in.close();
                out.close();
            }
            zip.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return resultList;
    }

    @Override
    public List<ModelBuild> getAllModel() {
        return this.modelMapper.getAllModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiResponse<?> importModel(String tenantId, MultipartFile file, HttpServletRequest request) {
        InputStream in = null;
        FileOutputStream out = null;
        String fileName = System.currentTimeMillis() + ".zip";
        try {
            in = file.getInputStream();
            File files = new File(this.lcdpBpmProperties.getFileUploadPath() + File.separator + fileName);
            if (!files.getParentFile().exists()) {
                files.getParentFile().mkdirs();
            }
            try {
                files.createNewFile();
            }
            catch (IOException e) {
                ApiResponse apiResponse = ApiResponse.fail(BpmEnum.UPLOAD_PATH_ERROR.getCode(), BpmEnum.UPLOAD_PATH_ERROR.getMessage());
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
                return apiResponse;
            }
            out = new FileOutputStream(files);
            IOUtils.copy((InputStream)in, (OutputStream)out);
            out.close();
            in.close();
            List<String> fileList = this.unZipFile(this.lcdpBpmProperties.getFileUploadPath() + File.separator + fileName, this.lcdpBpmProperties.getFileUploadPath(), request);
            for (String s : fileList) {
                if ("xml".equals(s.substring(s.length() - 3))) continue;
                files = new File(s);
                Map map = (Map)JSON.parseObject((String)FileUtils.readFileToString((File)files, (String)"UTF-8"), Map.class);
                if (!ToolUtil.equals((Object)"lcdpbpm", map.get("export_type"))) {
                    LOGGER.error("\u8bf7\u5bfc\u5165\u6b63\u786e\u7684\u5de5\u4f5c\u6d41\u538b\u7f29\u6587\u4ef6");
                    ApiResponse apiResponse = ApiResponse.fail(BpmEnum.ERROR_IMPORT.getCode(), BpmEnum.ERROR_IMPORT.getMessage());
                    return apiResponse;
                }
                JSONArray jsonArray = JSONArray.parseArray((String)JSON.toJSONString(map.get("file")));
                ArrayList<SysActProcessFile> wfdList = new ArrayList<SysActProcessFile>();
                ArrayList<SysActProcessFile> metaList = new ArrayList<SysActProcessFile>();
                for (Object o : jsonArray) {
                    SysActProcessFile sysActProcessFile = (SysActProcessFile)((Object)JSONObject.toJavaObject((JSON)((JSONObject)o), SysActProcessFile.class));
                    SysActProcessFile oldSysActProcessFile = (SysActProcessFile)((Object)this.sysActProcessFileService.getOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"VERSION", (Object)0)).eq((Object)"PROCESS_KEY", (Object)sysActProcessFile.getProcessKey())).eq((Object)"TYPE", (Object)sysActProcessFile.getType())));
                    if (ToolUtil.isNotEmpty((Object)((Object)oldSysActProcessFile))) {
                        sysActProcessFile.setFileId(oldSysActProcessFile.getFileId());
                    } else {
                        sysActProcessFile.setFileId(null);
                    }
                    sysActProcessFile.setVersion(0);
                    sysActProcessFile.setTenantId(tenantId);
                    if ("wfd".equals(sysActProcessFile.getType())) {
                        wfdList.add(sysActProcessFile);
                        continue;
                    }
                    metaList.add(sysActProcessFile);
                }
                ArrayList<SysActProcessFile> addList = new ArrayList<SysActProcessFile>();
                addList.addAll(wfdList);
                addList.addAll(metaList);
                this.sysActProcessFileService.saveOrUpdateBatch(addList);
            }
            for (String s : fileList) {
                if (!"xml".equals(s.substring(s.length() - 3))) continue;
                in = new FileInputStream(s);
                XMLInputFactory xif = XmlUtil.createSafeXmlInputFactory();
                XMLStreamReader xtr = xif.createXMLStreamReader(in);
                BpmnModel bpmnModel = new BpmnXMLConverter().convertToBpmnModel(xtr);
                String impModelName = ((Process)bpmnModel.getProcesses().get(0)).getName();
                String modelKey = ((Process)bpmnModel.getProcesses().get(0)).getId();
                String identityId = this.modelMapper.getIdByIdentity(modelKey);
                Model modelData = null;
                if (ToolUtil.isEmpty((Object)identityId)) {
                    modelData = this.repositoryService.newModel();
                    ObjectNode modelObjectNode = new ObjectMapper().createObjectNode();
                    modelObjectNode.put("name", impModelName);
                    modelObjectNode.put("description", ((Process)bpmnModel.getProcesses().get(0)).getDocumentation());
                    modelObjectNode.put("revision", 1);
                    modelData.setMetaInfo(modelObjectNode.toString());
                    modelData.setName(impModelName);
                    modelData.setKey(modelKey);
                    this.repositoryService.saveModel(modelData);
                }
                ExtendBpmnJsonConverter jsonConverter = new ExtendBpmnJsonConverter();
                jsonConverter.updateConvertersToBpmnMap();
                jsonConverter.updateConvertersToJsonMap();
                ObjectNode editorNode = jsonConverter.convertToJson(bpmnModel);
                identityId = identityId == null ? modelData.getId() : identityId;
                this.repositoryService.addModelEditorSource(identityId, editorNode.toString().getBytes(StandardCharsets.UTF_8));
                WorkFlow workFlow = this.sysActProcessFileService.getFileByProcessKey(modelKey, tenantId, 0);
                workFlow.setModelId(identityId);
                this.sysActProcessFileService.updateFile(workFlow, tenantId);
                this.deployModel(identityId, tenantId);
            }
            ApiResponse apiResponse = ApiResponse.success(BpmEnum.IMPORT_SUCCESS.getCode(), BpmEnum.IMPORT_SUCCESS.getMessage());
            return apiResponse;
        }
        catch (Exception e) {
            e.printStackTrace();
            ApiResponse apiResponse = ApiResponse.fail(BpmEnum.ERROR_IMPORT.getCode(), BpmEnum.ERROR_IMPORT.getMessage());
            return apiResponse;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void exportAllFileModel(String tenantId, String modelId, HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        ZipOutputStream zipOutputStream = null;
        ByteArrayInputStream in = null;
        List<ExportModel> models = this.modelMapper.getModelWithVersion(Arrays.asList(modelId.split(",")));
        try {
            response.setContentType(MediaType.APPLICATION_OCTET_STREAM.toString());
            response.setHeader("Content-Disposition", "attachment; filename=\"model.zip\"");
            HashMap fileMap = new HashMap();
            zipOutputStream = new ZipOutputStream((OutputStream)response.getOutputStream());
            for (ExportModel model : models) {
                ArrayList files = new ArrayList();
                if (ToolUtil.isNotEmpty(fileMap.get(model.getName()))) {
                    files.addAll((Collection)fileMap.get(model.getName()));
                }
                fileMap.put(model.getName(), files);
                in = (ByteArrayInputStream)this.processEngine.getProcessEngineConfiguration().getRepositoryService().getResourceAsStream(model.getDeploymentId(), model.getName() + SUFFIX);
                String filename = model.getName() + "_" + model.getBusinessKey() + "/" + model.getName() + "_" + model.getDeploymentId() + SUFFIX;
                ZipEntry zipEntry = new ZipEntry(filename);
                zipOutputStream.putNextEntry((java.util.zip.ZipEntry)zipEntry);
                IOUtils.copy((InputStream)in, (OutputStream)zipOutputStream);
                in.close();
            }
            this.toFileZip(tenantId, modelId, null, zipOutputStream);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.SERVER_ERROR);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (zipOutputStream != null) {
                try {
                    zipOutputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void toFileZip(String tenantId, String modelId, String procId, ZipOutputStream out) {
        List<SysActProcessFile> list;
        ZipOutputStream zipOutputStream = null;
        if (ToolUtil.isNotEmpty((Object)modelId)) {
            List<String> models = Arrays.asList(modelId.split(","));
            list = this.sysActProcessFileService.exportFileList(models, tenantId);
        } else {
            list = this.sysActProcessFileService.exportFile(procId, tenantId);
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("file", list);
        data.put("export_type", "lcdpbpm");
        zipOutputStream = out;
        try {
            zipOutputStream.putNextEntry((java.util.zip.ZipEntry)new ZipEntry("workflow_" + DateUtil.format((Date)new Date(), (String)"yyyyMMdd_HHmmss") + ".lcdpbpm"));
            ByteArrayInputStream in = new ByteArrayInputStream(JSONObject.toJSONBytes(data, (SerializerFeature[])new SerializerFeature[0]));
            IOUtils.copy((InputStream)in, (OutputStream)zipOutputStream);
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (zipOutputStream != null) {
                try {
                    zipOutputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public ApiResponse<?> validationProcess(String processDefinitionKey, String businessKey, String userId, Map<String, Object> variables, String tenantId) {
        BpmResponseResult startResult;
        String newUserId = userId;
        if (ToolUtil.isEmpty((Object)userId)) {
            newUserId = "superadmin";
        }
        if (ToolUtil.equals((Object)"0", (Object)(startResult = this.instanceEngineService.validationStartProcess(processDefinitionKey, newUserId, businessKey, tenantId, variables)).getCode())) {
            return ApiResponse.fail(startResult.getMsg());
        }
        return this.complete(startResult, variables, true);
    }

    private ApiResponse<?> complete(BpmResponseResult bpmResponseResult, Map<String, Object> variables, boolean isStart) {
        for (int i = 0; i < bpmResponseResult.getResult().size(); ++i) {
            BpmResponseResult completeResult;
            String taskDefinitionName = bpmResponseResult.getResult().getJSONObject(0).get((Object)"taskDefinitionName").toString();
            if (ToolUtil.equals((Object)"\u7ed3\u675f", (Object)taskDefinitionName)) {
                return ApiResponse.success(BpmEnum.PROCESS_END.getCode(), BpmEnum.PROCESS_END.getMessage());
            }
            ArrayList<String> userIdList = new ArrayList<String>((HashSet)bpmResponseResult.getResult().getJSONObject(i).get((Object)"userId"));
            String taskId = bpmResponseResult.getResult().getJSONObject(i).get((Object)"taskId").toString();
            if (userIdList.size() == 0) {
                if (isStart) {
                    userIdList.add("superadmin");
                } else {
                    return ApiResponse.fail("'" + taskDefinitionName + "'\u8282\u70b9\u6ca1\u6709\u53c2\u4e0e\u8005");
                }
            }
            if (ToolUtil.equals((Object)"0", (Object)(completeResult = this.taskEngineService.completeTask(taskId, (String)userIdList.get(0), variables)).getCode())) {
                return ApiResponse.fail(completeResult.getMsg());
            }
            this.complete(completeResult, variables, false);
        }
        return ApiResponse.success("");
    }

    @Override
    public ApiResponse<?> doneList(String businessKey, String tenantId) {
        BpmResponseResult bpmResponseResult = this.instanceEngineService.getDoneProcessTrace(businessKey, tenantId);
        if (ToolUtil.equals((Object)bpmResponseResult.getCode(), (Object)"1")) {
            return ApiResponse.data(bpmResponseResult.getResult());
        }
        return ApiResponse.fail(bpmResponseResult.getMsg());
    }

    @Override
    public String getRealVersion(String processDefId) {
        return this.modelMapper.getRealVersion(processDefId);
    }

    @Override
    public int updateCategory(String identity, String category) {
        return this.modelMapper.updateCategory(identity, category);
    }
}

