/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.exception;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.bpm.common.constant.BpmEnum;
import com.jxdinfo.hussar.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.bpm.common.response.ApiResponse;
import com.jxdinfo.hussar.bpm.engine.model.BpmResponseResult;
import com.jxdinfo.hussar.bpm.engine.service.impl.DefinitionEngineServiceImpl;
import com.jxdinfo.hussar.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.bpm.interfacelog.factory.InterfaceLogManager;
import com.jxdinfo.hussar.bpm.interfacelog.factory.InterfaceLogTaskFactory;
import com.jxdinfo.hussar.bsp.exception.GodAxeRequestException;
import com.jxdinfo.hussar.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.bsp.exception.TenantException;
import com.jxdinfo.hussar.bsp.exception.TenantLackInfoException;
import com.jxdinfo.hussar.bsp.exception.TenantLockException;
import com.jxdinfo.hussar.core.support.HttpKit;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.el.PropertyNotFoundException;
import javax.servlet.http.HttpServletRequest;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.ActivitiTaskAlreadyClaimedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
@Order(value=0x7FFFFFFD)
public class BpmExceptionHander {
    private static BpmConstantProperties bpmConstantProperties;
    private static Logger LOGGER;

    @ExceptionHandler(value={ActivitiTaskAlreadyClaimedException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public BpmResponseResult credentials(ActivitiTaskAlreadyClaimedException a) {
        LOGGER.error(a.getMessage());
        return InstallResult.getResult("0", bpmConstantProperties.getTaskAlreadyClaimed(), null);
    }

    /*
     * Enabled aggressive block sorting
     */
    @ExceptionHandler(value={GodAxeRequestException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public BpmResponseResult credentials(GodAxeRequestException a) {
        LOGGER.error(bpmConstantProperties.getHttpRequestError());
        switch (a.getRequestErrorType()) {
            case 0: {
                return InstallResult.getResult("0", bpmConstantProperties.getErrorProjectAddress(), null);
            }
            case 1: {
                return InstallResult.getResult("0", bpmConstantProperties.getErrorGodaxeVisitor(), null);
            }
            case 2: {
                return InstallResult.getResult("0", bpmConstantProperties.getErrorViewRequest(), null);
            }
        }
        return InstallResult.getResult("0", bpmConstantProperties.getErrorRequest(), null);
    }

    @ExceptionHandler(value={PublicClientException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public BpmResponseResult credentials(HttpServletRequest a, PublicClientException a2) {
        if (a2.getIsSaveLogger().booleanValue()) {
            Serializable serializable = a2.getStackTrace()[0];
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(a2.getReason());
            stringBuilder.append(TenantException.catch("\u5f75\u5e36\u7c0c\u5403\uff6d")).append(((StackTraceElement)serializable).getClassName());
            stringBuilder.append(GodAxeRequestException.goto("\u5f1d\u5e34\u65a6\u6cd9\u5412\uff16")).append(((StackTraceElement)serializable).getMethodName());
            stringBuilder.append(TenantException.catch("L\u5f0c\u5e4f\u6589\u4e81\u5403\uff6d")).append(((StackTraceElement)serializable).getFileName());
            stringBuilder.append(GodAxeRequestException.goto("\u5f0e\u5e27\u8840\u656f\uff16")).append(((StackTraceElement)serializable).getLineNumber());
            stringBuilder.append(TenantException.catch("\u8b80\u6c4c\u8d98\u5f8a\uff6d")).append(a.getRequestURL()).append(GodAxeRequestException.goto("7"));
            serializable = new HashMap(a.getParameterMap());
            serializable.remove(TenantException.catch("z\u0012`\u0016`\u0003M\u001e~\u001fk\u0005"));
            Object object = serializable.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry = object.next();
                String[] stringArray = (String[])entry.getValue();
                if (stringArray.length == 0) {
                    serializable.put(entry.getKey(), null);
                    continue;
                }
                if (stringArray.length != 1) continue;
                serializable.put(entry.getKey(), stringArray[0]);
            }
            if (ToolUtil.isNotEmpty((Object)serializable)) {
                stringBuilder.append(GodAxeRequestException.goto("\u8bfb\u6c5d\u53ce\u656f\uff16")).append(JSONObject.toJSONString((Object)serializable)).append(TenantException.catch("L"));
            }
            object = new HashMap<String, String>();
            object.put("userId", HttpKit.getIp());
            object.put("userAccount", HttpKit.getIp());
            object.put(GodAxeRequestException.goto("v|"), HttpKit.getIp());
            object.put(TenantException.catch("~\u0018|\u0003"), HttpKit.getPort());
            object.put(GodAxeRequestException.goto("wclx"), HttpKit.getHost());
            object.put(TenantException.catch("\u001ba\u0014o\u001bG\u0007"), HttpKit.getLocalIp());
            object.put(GodAxeRequestException.goto("`po~`Ocmx"), HttpKit.getLocalPort());
            object.put(TenantException.catch("\u001ba\u0014o\u001bF\u0018}\u0003"), HttpKit.getLocalHost());
            object.put(GodAxeRequestException.goto("\u007fz\u007flepbVh"), HttpKit.getSeesionId());
            object.put("tenantId", a.getParameter("tenantId"));
            object.put(TenantException.catch("z\u0012`\u0016`\u0003M\u001e~\u001fk\u0005"), a.getParameter(GodAxeRequestException.goto("kiqmqx\\eodz~")));
            InterfaceLogManager.me().executeLog(InterfaceLogTaskFactory.exceptionLog((Map<String, String>)object, stringBuilder.toString()));
            LOGGER.error(stringBuilder.toString());
            a2.printStackTrace();
        }
        return InstallResult.getResult("0", a2.getReason(), a2.getResult());
    }

    @ExceptionHandler(value={TenantLockException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public ApiResponse<?> credentials(TenantLockException a) {
        return ApiResponse.fail(BpmEnum.USER_HAS_BEEN_DISABLED.getCode(), BpmEnum.USER_HAS_BEEN_DISABLED.getMessage());
    }

    @ExceptionHandler(value={ActivitiIllegalArgumentException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public BpmResponseResult credentials(ActivitiIllegalArgumentException a) {
        LOGGER.error(a.getMessage());
        if (a.getMessage().contains(TenantException.catch("W`\u0002b\u001b"))) {
            return InstallResult.getResult("0", bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        return InstallResult.getResult("0", a.getMessage(), null);
    }

    @ExceptionHandler(value={TenantLackInfoException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public ApiResponse<?> credentials(TenantLackInfoException a) {
        return ApiResponse.fail(BpmEnum.INCOMPLETE_TENANT_INFORMATION.getCode(), BpmEnum.INCOMPLETE_TENANT_INFORMATION.getMessage());
    }

    @ExceptionHandler(value={PropertyNotFoundException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public BpmResponseResult credentials(PropertyNotFoundException a) {
        LOGGER.error(a.getMessage());
        return InstallResult.getResult("0", bpmConstantProperties.getPropertyNotFound(), null);
    }

    static {
        LOGGER = LoggerFactory.getLogger(DefinitionEngineServiceImpl.class);
        bpmConstantProperties = (BpmConstantProperties)SpringContextHolder.getBean(BpmConstantProperties.class);
    }

    @ExceptionHandler(value={TenantException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public ApiResponse<?> credentials(TenantException a) {
        return ApiResponse.fail(BpmEnum.ERROR_TENANT_INFORMATION.getCode(), BpmEnum.ERROR_TENANT_INFORMATION.getMessage());
    }

    @ExceptionHandler(value={ActivitiObjectNotFoundException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public BpmResponseResult credentials(ActivitiObjectNotFoundException a) {
        LOGGER.error(a.getMessage());
        if (a.getMessage().startsWith(TenantException.catch("4o\u0019`\u0018zWh\u001e`\u0013.\u0003o\u0004eWy\u001ez\u001f.\u001ejW"))) {
            return InstallResult.getResult("0", bpmConstantProperties.getTaskNotFound(), null);
        }
        if (a.getMessage().startsWith(GodAxeRequestException.goto("\\mqbpx?jvb{,o~poz\u007fl,{iyeqekepb?jp~?e{,")) || a.getMessage().startsWith(TenantException.catch("`\u0018.\u0013k\u0007b\u0018w\u0012jW~\u0005a\u0014k\u0004}Wj\u0012h\u001e`\u001ez\u001ea\u0019.\u0011a\u0002`\u0013.\u0000g\u0003fWg\u0013"))) {
            return InstallResult.getResult("0", bpmConstantProperties.getModelNotFound(), null);
        }
        if (a.getMessage().startsWith(GodAxeRequestException.goto("\\mqbpx?jvb{,o~poz\u007flEq\u007fkmqoz,ycm,vh")) || a.getMessage().startsWith(TenantException.catch("@\u0018.\u0007|\u0018m\u0012}\u0004.\u001e`\u0004z\u0016`\u0014kWh\u0018{\u0019jWh\u0018|Wg\u0013")) || a.getMessage().startsWith(GodAxeRequestException.goto("Qc?dv\u007fkcme|,o~poz\u007fl,vblx~b|i?jpyqh?{vxw,vh"))) {
            return InstallResult.getResult("0", bpmConstantProperties.getProcessNotFound(), null);
        }
        return InstallResult.getResult("0", a.getMessage(), null);
    }

    public BpmExceptionHander() {
        BpmExceptionHander a;
    }

    @ExceptionHandler(value={ActivitiException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public BpmResponseResult credentials(ActivitiException a) {
        LOGGER.error(a.getMessage());
        if (a.getMessage().startsWith(GodAxeRequestException.goto("O~bqck,lik,lyl|zblepb?\u007fkmki?+lyl|zb{i{+?jp~?\\mc|il\u007f[iyeqekepbZbkeku"))) {
            return InstallResult.getResult("0", bpmConstantProperties.getSuspendedProcessDefinitionEntityError(), null);
        }
        if (a.getMessage().startsWith(TenantException.catch("M\u0016`\u0019a\u0003.\u0004k\u0003.\u0004{\u0004~\u0012`\u0004g\u0018`W}\u0003o\u0003kW)\u0016m\u0003g\u0001kP.\u0011a\u0005.'|\u0018m\u0012}\u0004J\u0012h\u001e`\u001ez\u001ea\u0019K\u0019z\u001ez\u000e"))) {
            return InstallResult.getResult("0", bpmConstantProperties.getActiveProcessDefinitionEntityError(), null);
        }
        if (a.getMessage().startsWith(GodAxeRequestException.goto("O~bqck,lik,lyl|zblepb?\u007fkmki?+lyl|zb{i{+?jp~?\\mc|il\u007fVblx~b|i"))) {
            return InstallResult.getResult("0", bpmConstantProperties.getSuspendedProcessProcessInstanceError(), null);
        }
        if (a.getMessage().startsWith(TenantException.catch("M\u0016`\u0019a\u0003.\u0004k\u0003.\u0004{\u0004~\u0012`\u0004g\u0018`W}\u0003o\u0003kW)\u0016m\u0003g\u0001kP.\u0011a\u0005.'|\u0018m\u0012}\u0004G\u0019}\u0003o\u0019m\u0012"))) {
            return InstallResult.getResult("0", bpmConstantProperties.getActiveProcessProcessInstanceError(), null);
        }
        if (a.getMessage().startsWith(GodAxeRequestException.goto("O~poz\u007fl,vblx~b|i?el,lxv`s,myqbvbx ?o~bqck,{isiki?dv\u007fkcme|,o~poz\u007fl,vblx~b|i"))) {
            return InstallResult.getResult("0", bpmConstantProperties.getProcessInstanceIsNotEnd(), null);
        }
        if (TenantException.catch("4o\u0019`\u0018zWm\u001bo\u001ecWoW}\u0002}\u0007k\u0019j\u0012jWz\u0016}\u001c").equals(a.getMessage())) {
            return InstallResult.getResult("0", bpmConstantProperties.getTaskIsSuspended(), null);
        }
        if (a.getMessage().startsWith(GodAxeRequestException.goto("Qc?cjxxcvbx,linyzb|i?jsch,pj"))) {
            return InstallResult.getResult("0", bpmConstantProperties.getNoOutgoingSequence(), null);
        }
        return InstallResult.getResult("0", a.getMessage(), null);
    }
}

