/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.exception;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.bpm.common.constant.BpmEnum;
import com.jxdinfo.hussar.bpm.common.constant.BusinessLogType;
import com.jxdinfo.hussar.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.bpm.common.response.ApiResponse;
import com.jxdinfo.hussar.bpm.engine.model.BpmResponseResult;
import com.jxdinfo.hussar.bpm.engine.service.impl.DefinitionEngineServiceImpl;
import com.jxdinfo.hussar.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.bpm.interfacelog.factory.InterfaceLogManager;
import com.jxdinfo.hussar.bpm.interfacelog.factory.InterfaceLogTaskFactory;
import com.jxdinfo.hussar.bsp.exception.GodAxeRequestException;
import com.jxdinfo.hussar.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.bsp.exception.TenantException;
import com.jxdinfo.hussar.bsp.exception.TenantLackInfoException;
import com.jxdinfo.hussar.bsp.exception.TenantLockException;
import com.jxdinfo.hussar.core.support.HttpKit;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.el.PropertyNotFoundException;
import javax.servlet.http.HttpServletRequest;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.ActivitiTaskAlreadyClaimedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
@Order(value=0x7FFFFFFD)
public class BpmExceptionHander {
    private static BpmConstantProperties bpmConstantProperties;
    private static Logger LOGGER;

    @ExceptionHandler(value={ActivitiObjectNotFoundException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public BpmResponseResult credentials(ActivitiObjectNotFoundException a) {
        LOGGER.error(a.getMessage());
        if (a.getMessage().startsWith(LcdpBpmProperties.do("M\u0017`\u0018a\u0002.\u0010g\u0018jVz\u0017}\u001d.\u0001g\u0002fVg\u0012."))) {
            return InstallResult.getResult("0", bpmConstantProperties.getTaskNotFound(), null);
        }
        if (a.getMessage().startsWith(BusinessLogType.implements("[\u0015v\u001aw\u00008\u0012q\u001a|Th\u0006w\u0017}\u0007kT|\u0011~\u001dv\u001dl\u001dw\u001a8\u0012w\u00068\u001d|T")) || a.getMessage().startsWith(LcdpBpmProperties.do("\u0018aVj\u0013~\u001aa\u000fk\u0012.\u0006|\u0019m\u0013}\u0005.\u0012k\u0010g\u0018g\u0002g\u0019`Vh\u0019{\u0018jVy\u001fz\u001e.\u001fj"))) {
            return InstallResult.getResult("0", bpmConstantProperties.getModelNotFound(), null);
        }
        if (a.getMessage().startsWith(BusinessLogType.implements("[\u0015v\u001aw\u00008\u0012q\u001a|Th\u0006w\u0017}\u0007k=v\u0007l\u0015v\u0017}T~\u001bjTq\u0010")) || a.getMessage().startsWith(LcdpBpmProperties.do("8aV~\u0004a\u0015k\u0005}Vg\u0018}\u0002o\u0018m\u0013.\u0010a\u0003`\u0012.\u0010a\u0004.\u001fj")) || a.getMessage().startsWith(BusinessLogType.implements("V\u001b8\u001cq\u0007l\u001bj\u001d{Th\u0006w\u0017}\u0007kTq\u001ak\u0000y\u001a{\u00118\u0012w\u0001v\u00108\u0003q\u0000pTq\u0010"))) {
            return InstallResult.getResult("0", bpmConstantProperties.getProcessNotFound(), null);
        }
        return InstallResult.getResult("0", a.getMessage(), null);
    }

    @ExceptionHandler(value={PublicClientException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public BpmResponseResult credentials(HttpServletRequest a, PublicClientException a2) {
        if (a2.getIsSaveLogger().booleanValue()) {
            Serializable serializable = a2.getStackTrace()[0];
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(a2.getReason());
            stringBuilder.append(LcdpBpmProperties.do("\u5f0c\u5e4e\u7c75\u547b\uff14")).append(((StackTraceElement)serializable).getClassName());
            stringBuilder.append(BusinessLogType.implements("\u5f1a\u5e4c\u65a1\u6ca1\u5415\uff6e")).append(((StackTraceElement)serializable).getMethodName());
            stringBuilder.append(LcdpBpmProperties.do("5\u5f74\u5e36\u65f1\u4ef8\u547b\uff14")).append(((StackTraceElement)serializable).getFileName());
            stringBuilder.append(BusinessLogType.implements("\u5f76\u5e20\u8838\u6568\uff6e")).append(((StackTraceElement)serializable).getLineNumber());
            stringBuilder.append(LcdpBpmProperties.do("\u8bf9\u6c34\u8de1\u5ff2\uff14")).append(a.getRequestURL()).append(BusinessLogType.implements("O"));
            serializable = new HashMap(a.getParameterMap());
            serializable.remove(LcdpBpmProperties.do("\u0002k\u0018o\u0018z5g\u0006f\u0013|"));
            Object object = serializable.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry = object.next();
                String[] stringArray = (String[])entry.getValue();
                if (stringArray.length == 0) {
                    serializable.put(entry.getKey(), null);
                    continue;
                }
                if (stringArray.length != 1) continue;
                serializable.put(entry.getKey(), stringArray[0]);
            }
            if (ToolUtil.isNotEmpty((Object)serializable)) {
                stringBuilder.append(BusinessLogType.implements("\u8b83\u6c5a\u53b6\u6568\uff6e")).append(JSONObject.toJSONString((Object)serializable)).append(LcdpBpmProperties.do("5"));
            }
            object = new HashMap<String, String>();
            object.put("userId", HttpKit.getIp());
            object.put("userAccount", HttpKit.getIp());
            object.put(BusinessLogType.implements("q\u0004"), HttpKit.getIp());
            object.put(LcdpBpmProperties.do("\u0006a\u0004z"), HttpKit.getPort());
            object.put(BusinessLogType.implements("p\u001bk\u0000"), HttpKit.getHost());
            object.put(LcdpBpmProperties.do("b\u0019m\u0017b?~"), HttpKit.getLocalIp());
            object.put(BusinessLogType.implements("\u0018w\u0017y\u0018H\u001bj\u0000"), HttpKit.getLocalPort());
            object.put(LcdpBpmProperties.do("b\u0019m\u0017b>a\u0005z"), HttpKit.getLocalHost());
            object.put(BusinessLogType.implements("\u0007}\u0007k\u001dw\u001aQ\u0010"), HttpKit.getSeesionId());
            object.put("tenantId", a.getParameter("tenantId"));
            object.put(LcdpBpmProperties.do("\u0002k\u0018o\u0018z5g\u0006f\u0013|"), a.getParameter(BusinessLogType.implements("l\u0011v\u0015v\u0000[\u001dh\u001c}\u0006")));
            InterfaceLogManager.me().executeLog(InterfaceLogTaskFactory.exceptionLog((Map<String, String>)object, stringBuilder.toString()));
            LOGGER.error(stringBuilder.toString());
            a2.printStackTrace();
        }
        return InstallResult.getResult("0", a2.getReason(), a2.getResult());
    }

    @ExceptionHandler(value={TenantLackInfoException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public ApiResponse<?> credentials(TenantLackInfoException a) {
        return ApiResponse.fail(BpmEnum.INCOMPLETE_TENANT_INFORMATION.getCode(), BpmEnum.INCOMPLETE_TENANT_INFORMATION.getMessage());
    }

    @ExceptionHandler(value={ActivitiIllegalArgumentException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public BpmResponseResult credentials(ActivitiIllegalArgumentException a) {
        LOGGER.error(a.getMessage());
        if (a.getMessage().contains(LcdpBpmProperties.do(".\u0018{\u001ab"))) {
            return InstallResult.getResult("0", bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        return InstallResult.getResult("0", a.getMessage(), null);
    }

    static {
        LOGGER = LoggerFactory.getLogger(DefinitionEngineServiceImpl.class);
        bpmConstantProperties = (BpmConstantProperties)SpringContextHolder.getBean(BpmConstantProperties.class);
    }

    /*
     * WARNING - void declaration
     */
    @ExceptionHandler(value={PropertyNotFoundException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public BpmResponseResult credentials(PropertyNotFoundException propertyNotFoundException) {
        void a;
        LOGGER.error(a.getMessage());
        return InstallResult.getResult("0", bpmConstantProperties.getPropertyNotFound(), null);
    }

    @ExceptionHandler(value={TenantException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public ApiResponse<?> credentials(TenantException a) {
        return ApiResponse.fail(BpmEnum.ERROR_TENANT_INFORMATION.getCode(), BpmEnum.ERROR_TENANT_INFORMATION.getMessage());
    }

    public BpmExceptionHander() {
        BpmExceptionHander a;
    }

    @ExceptionHandler(value={TenantLockException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public ApiResponse<?> credentials(TenantLockException a) {
        return ApiResponse.fail(BpmEnum.USER_HAS_BEEN_DISABLED.getCode(), BpmEnum.USER_HAS_BEEN_DISABLED.getMessage());
    }

    @ExceptionHandler(value={ActivitiException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public BpmResponseResult credentials(ActivitiException a) {
        LOGGER.error(a.getMessage());
        if (a.getMessage().startsWith(BusinessLogType.implements("7y\u001av\u001blTk\u0011lTk\u0001k\u0004}\u001ak\u001dw\u001a8\u0007l\u0015l\u00118Sk\u0001k\u0004}\u001a|\u0011|S8\u0012w\u00068$j\u001b{\u0011k\u0007\\\u0011~\u001dv\u001dl\u001dw\u001a]\u001al\u001dl\r"))) {
            return InstallResult.getResult("0", bpmConstantProperties.getSuspendedProcessDefinitionEntityError(), null);
        }
        if (a.getMessage().startsWith(LcdpBpmProperties.do("5o\u0018`\u0019zV}\u0013zV}\u0003}\u0006k\u0018}\u001fa\u0018.\u0005z\u0017z\u0013.Qo\u0015z\u001fx\u0013)Vh\u0019|V^\u0004a\u0015k\u0005}2k\u0010g\u0018g\u0002g\u0019`3`\u0002g\u0002w"))) {
            return InstallResult.getResult("0", bpmConstantProperties.getActiveProcessDefinitionEntityError(), null);
        }
        if (a.getMessage().startsWith(BusinessLogType.implements("7y\u001av\u001blTk\u0011lTk\u0001k\u0004}\u001ak\u001dw\u001a8\u0007l\u0015l\u00118Sk\u0001k\u0004}\u001a|\u0011|S8\u0012w\u00068$j\u001b{\u0011k\u0007Q\u001ak\u0000y\u001a{\u0011"))) {
            return InstallResult.getResult("0", bpmConstantProperties.getSuspendedProcessProcessInstanceError(), null);
        }
        if (a.getMessage().startsWith(LcdpBpmProperties.do("5o\u0018`\u0019zV}\u0013zV}\u0003}\u0006k\u0018}\u001fa\u0018.\u0005z\u0017z\u0013.Qo\u0015z\u001fx\u0013)Vh\u0019|V^\u0004a\u0015k\u0005}?`\u0005z\u0017`\u0015k"))) {
            return InstallResult.getResult("0", bpmConstantProperties.getActiveProcessProcessInstanceError(), null);
        }
        if (a.getMessage().startsWith(BusinessLogType.implements("H\u0006w\u0017}\u0007kTq\u001ak\u0000y\u001a{\u00118\u001dkTk\u0000q\u0018tTj\u0001v\u001aq\u001a\u007fX8\u0017y\u001av\u001blT|\u0011t\u0011l\u00118\u001cq\u0007l\u001bj\u001d{Th\u0006w\u0017}\u0007kTq\u001ak\u0000y\u001a{\u0011"))) {
            return InstallResult.getResult("0", bpmConstantProperties.getProcessInstanceIsNotEnd(), null);
        }
        if (LcdpBpmProperties.do("M\u0017`\u0018a\u0002.\u0015b\u0017g\u001b.\u0017.\u0005{\u0005~\u0013`\u0012k\u0012.\u0002o\u0005e").equals(a.getMessage())) {
            return InstallResult.getResult("0", bpmConstantProperties.getTaskIsSuspended(), null);
        }
        if (a.getMessage().startsWith(BusinessLogType.implements("V\u001b8\u001bm\u0000\u007f\u001bq\u001a\u007fTk\u0011i\u0001}\u001a{\u00118\u0012t\u001boTw\u0012"))) {
            return InstallResult.getResult("0", bpmConstantProperties.getNoOutgoingSequence(), null);
        }
        return InstallResult.getResult("0", a.getMessage(), null);
    }

    /*
     * Enabled aggressive block sorting
     */
    @ExceptionHandler(value={GodAxeRequestException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public BpmResponseResult credentials(GodAxeRequestException a) {
        LOGGER.error(bpmConstantProperties.getHttpRequestError());
        switch (a.getRequestErrorType()) {
            case 0: {
                return InstallResult.getResult("0", bpmConstantProperties.getErrorProjectAddress(), null);
            }
            case 1: {
                return InstallResult.getResult("0", bpmConstantProperties.getErrorGodaxeVisitor(), null);
            }
            case 2: {
                return InstallResult.getResult("0", bpmConstantProperties.getErrorViewRequest(), null);
            }
        }
        return InstallResult.getResult("0", bpmConstantProperties.getErrorRequest(), null);
    }

    @ExceptionHandler(value={ActivitiTaskAlreadyClaimedException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public BpmResponseResult credentials(ActivitiTaskAlreadyClaimedException a) {
        LOGGER.error(a.getMessage());
        return InstallResult.getResult("0", bpmConstantProperties.getTaskAlreadyClaimed(), null);
    }
}

