/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bpm.engine.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.bpm.definition.model.ProcessDefinitionModel;
import com.jxdinfo.hussar.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.bpm.engine.model.BpmResponseResult;
import com.jxdinfo.hussar.bpm.engine.service.DefinitionEngineService;
import com.jxdinfo.hussar.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.bpm.extend.ExtendBpmnJsonConverter;
import com.jxdinfo.hussar.bpm.interfacelog.aop.InterfaceLogAop;
import com.jxdinfo.hussar.bpm.model.dao.ModelMapper;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import javax.annotation.Resource;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.Model;
import org.activiti.engine.repository.ModelQuery;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.repository.ProcessDefinitionQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class DefinitionEngineServiceImpl
implements DefinitionEngineService {
    @Autowired
    private RepositoryService repositoryService;
    @Resource
    private ModelMapper modelMapper;
    @Autowired
    private ProcessDefinitionsService processDefinitionsService;
    private static Logger LOGGER = LoggerFactory.getLogger(DefinitionEngineServiceImpl.class);
    @Autowired
    private BpmConstantProperties bpmConstantProperties;

    @Override
    public BpmResponseResult deleteProcessDefinition(String a) {
        DefinitionEngineServiceImpl a2;
        if (a == null) {
            return InstallResult.getResult("0", a2.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        ProcessDefinition processDefinition = (ProcessDefinition)a2.repositoryService.createProcessDefinitionQuery().processDefinitionId(a).singleResult();
        if (ToolUtil.isEmpty((Object)processDefinition)) {
            return InstallResult.getResult("0", a2.bpmConstantProperties.getProcessNotFound(), null);
        }
        if ("0".equals(a2.modelMapper.getRunningCountWithModelId(null, a))) {
            a2.repositoryService.deleteDeployment(processDefinition.getDeploymentId());
            return InstallResult.getResult("1", "success", null);
        }
        return InstallResult.getResult("0", a2.bpmConstantProperties.getDeleteRunningFail(), null);
    }

    @Override
    public BpmResponseResult queryProcess() {
        DefinitionEngineServiceImpl a;
        JSONArray jSONArray = new JSONArray();
        Object object = ((ModelQuery)a.repositoryService.createModelQuery().deployed().orderByLastUpdateTime().desc()).list();
        if (object != null) {
            ExtendBpmnJsonConverter extendBpmnJsonConverter = new ExtendBpmnJsonConverter();
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = (Model)object.next();
                JSONObject jSONObject = new JSONObject();
                object2 = a.repositoryService.getModelEditorSource(object2.getId());
                try {
                    object2 = new String((byte[])object2, StandardCharsets.UTF_8).replace(InterfaceLogAop.strictfp("F%W.U\"].W"), "");
                    object2 = new ObjectMapper().readTree(((String)object2).getBytes(StandardCharsets.UTF_8));
                    Process process = extendBpmnJsonConverter.convertToBpmnModel((JsonNode)object2).getMainProcess();
                    JSONObject jSONObject2 = jSONObject;
                    jSONObject.put(InstallResult.class("X\u000b"), (Object)process.getId());
                    jSONObject2.put(InterfaceLogAop.strictfp("%R&V"), (Object)process.getName());
                    jSONArray.add((Object)jSONObject2);
                }
                catch (IOException iOException) {
                    LOGGER.error(iOException.getMessage());
                }
            }
        }
        return InstallResult.getResult("1", "success", jSONArray);
    }

    @Override
    public BpmResponseResult activateProcessDefinitionById(String a) {
        DefinitionEngineServiceImpl a2;
        a2.repositoryService.activateProcessDefinitionById(a);
        return InstallResult.getResult("1", "success", null);
    }

    @Override
    public BpmResponseResult queryProcessDefList(String a) {
        DefinitionEngineServiceImpl a2;
        JSONArray jSONArray = new JSONArray();
        a = ((ProcessDefinitionQuery)a2.repositoryService.createProcessDefinitionQuery().processDefinitionNameLike(new StringBuilder().insert(0, InstallResult.class("J")).append((String)((Object)a)).append(InterfaceLogAop.strictfp("\u0016")).toString()).orderByProcessDefinitionName().desc()).list();
        ArrayList<ProcessDefinitionModel> arrayList = new ArrayList<ProcessDefinitionModel>(a.size());
        Iterator iterator = a = a.iterator();
        while (iterator.hasNext()) {
            DefinitionEngineServiceImpl definitionEngineServiceImpl;
            ProcessDefinition processDefinition;
            Deployment deployment;
            Object object = (ProcessDefinition)a.next();
            ProcessDefinitionModel processDefinitionModel = new ProcessDefinitionModel();
            ProcessDefinition processDefinition2 = object;
            ProcessDefinitionModel processDefinitionModel2 = processDefinitionModel;
            ProcessDefinition processDefinition3 = object;
            ProcessDefinitionModel processDefinitionModel3 = processDefinitionModel;
            ProcessDefinition processDefinition4 = object;
            processDefinitionModel.setId(processDefinition4.getId());
            processDefinitionModel3.setProcessName(processDefinition4.getName());
            processDefinitionModel3.setVersion(Integer.toString(object.getVersion()));
            processDefinitionModel.setIsSuspended(Boolean.toString(processDefinition3.isSuspended()));
            processDefinitionModel2.setDescription(processDefinition3.getDescription());
            processDefinitionModel2.setCategory(object.getCategory());
            processDefinitionModel.setDeploymentId(processDefinition2.getDeploymentId());
            if (processDefinition2.getResourceName() != null) {
                Deployment deployment2 = deployment = object.getResourceName().split(InstallResult.class("@"));
                processDefinitionModel.setResourceName(deployment2[((String[])deployment2).length - 1]);
                processDefinition = object;
            } else {
                processDefinitionModel.setResourceName("");
                processDefinition = object;
            }
            if (processDefinition.getDiagramResourceName() != null) {
                Deployment deployment3 = deployment = object.getDiagramResourceName().split(InterfaceLogAop.strictfp("\u001c"));
                processDefinitionModel.setDiagramResourceName((String)deployment3[((String[])deployment3).length - 1]);
                definitionEngineServiceImpl = a2;
            } else {
                processDefinitionModel.setDiagramResourceName("");
                definitionEngineServiceImpl = a2;
            }
            deployment = (Deployment)definitionEngineServiceImpl.repositoryService.createDeploymentQuery().deploymentId(object.getDeploymentId()).singleResult();
            object = new SimpleDateFormat(InstallResult.class("\u0016H\u0016HB|\"\u001c\u000bUOy'\u000b\u0002\\UB\u001c")).format(deployment.getDeploymentTime());
            iterator = a;
            ProcessDefinitionModel processDefinitionModel4 = processDefinitionModel;
            processDefinitionModel4.setDeploymentTime((String)object);
            arrayList.add(processDefinitionModel4);
        }
        jSONArray.add(arrayList);
        return InstallResult.getResult("1", "success", jSONArray);
    }

    @Override
    public BpmResponseResult queryProcessLink(String a) {
        DefinitionEngineServiceImpl a2;
        JSONArray jSONArray = new JSONArray();
        DefinitionEngineServiceImpl definitionEngineServiceImpl = a2;
        a = definitionEngineServiceImpl.processDefinitionsService.getMainOrNew((String)a).getId();
        a = (ProcessDefinition)definitionEngineServiceImpl.repositoryService.createProcessDefinitionQuery().processDefinitionId((String)a).latestVersion().singleResult();
        if (a == null) {
            return InstallResult.getResult("0", a2.bpmConstantProperties.getProcessNotFound(), null);
        }
        if ((a = a2.repositoryService.getBpmnModel(a.getId())) != null) {
            for (FlowElement flowElement : ((Process)a.getProcesses().get(0)).getFlowElements()) {
                if (!(flowElement instanceof UserTask)) continue;
                JSONObject jSONObject = new JSONObject();
                jSONObject.put(InstallResult.class("X\u000b"), (Object)flowElement.getId());
                jSONObject.put(InterfaceLogAop.strictfp("%R&V"), (Object)flowElement.getName());
                jSONArray.add((Object)jSONObject);
            }
            return InstallResult.getResult("1", "success", jSONArray);
        }
        return InstallResult.getResult("0", a2.bpmConstantProperties.getModelNotFound(), null);
    }

    @Override
    public BpmResponseResult queryProcessDefListOfMainVersion(String a) {
        DefinitionEngineServiceImpl a2;
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        a = a2.processDefinitionsService.queryProcessDefListOfMainVersion((String)((Object)a));
        ArrayList<ProcessDefinitionModel> arrayList = new ArrayList<ProcessDefinitionModel>(a.size());
        a = a.iterator();
        while (a.hasNext()) {
            ProcessDefinitionModel processDefinitionModel;
            Object object;
            ProcessDefinitionModel processDefinitionModel2 = (ProcessDefinitionModel)a.next();
            if (processDefinitionModel2.getResourceName() != null) {
                ProcessDefinitionModel processDefinitionModel3 = processDefinitionModel2;
                object = processDefinitionModel3.getResourceName().split(InstallResult.class("@"));
                processDefinitionModel3.setResourceName(object[((String[])object).length - 1]);
                processDefinitionModel = processDefinitionModel2;
            } else {
                ProcessDefinitionModel processDefinitionModel4 = processDefinitionModel2;
                processDefinitionModel = processDefinitionModel4;
                processDefinitionModel4.setResourceName("");
            }
            if (processDefinitionModel.getDiagramResourceName() != null) {
                ProcessDefinitionModel processDefinitionModel5 = processDefinitionModel2;
                object = processDefinitionModel5.getDiagramResourceName().split(InterfaceLogAop.strictfp("\u001c"));
                processDefinitionModel5.setDiagramResourceName(object[((String[])object).length - 1]);
            } else {
                processDefinitionModel2.setDiagramResourceName("");
            }
            object = new SimpleDateFormat(InstallResult.class("\u0016H\u0016HB|\"\u001c\u000bUOy'\u000b\u0002\\UB\u001c"));
            try {
                Object object2 = object;
                object = ((DateFormat)object2).parse(processDefinitionModel2.getDeploymentTime());
                String string = ((DateFormat)object2).format((Date)object);
                ProcessDefinitionModel processDefinitionModel6 = processDefinitionModel2;
                processDefinitionModel6.setDeploymentTime(string);
                arrayList.add(processDefinitionModel6);
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
            }
        }
        jSONObject.put(InterfaceLogAop.strictfp("/R?R"), arrayList);
        jSONObject.put("count", (Object)arrayList.size());
        jSONArray.add((Object)jSONObject);
        return InstallResult.getResult("1", "success", jSONArray);
    }

    @Override
    public BpmResponseResult queryProcessName(String a) {
        DefinitionEngineServiceImpl a2;
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        jSONObject.put(InterfaceLogAop.strictfp("C9\\(V8@\u0005R&V"), (Object)a2.processDefinitionsService.getMainOrNew(a).getName());
        jSONArray.add((Object)jSONObject);
        return InstallResult.getResult("1", "success", jSONArray);
    }

    @Override
    public BpmResponseResult suspendProcessDefinitionById(String a) {
        DefinitionEngineServiceImpl a2;
        a2.repositoryService.suspendProcessDefinitionById(a);
        return InstallResult.getResult("1", "success", null);
    }

    public DefinitionEngineServiceImpl() {
        DefinitionEngineServiceImpl a;
    }

    @Override
    public BpmResponseResult queryStartFormUrl(String a) {
        DefinitionEngineServiceImpl a2;
        JSONArray jSONArray = new JSONArray();
        JSONObject jSONObject = new JSONObject();
        DefinitionEngineServiceImpl definitionEngineServiceImpl = a2;
        for (Object object : definitionEngineServiceImpl.repositoryService.getBpmnModel(definitionEngineServiceImpl.processDefinitionsService.getMainOrNew((String)a).getId()).getMainProcess().getFlowElements()) {
            if (!(object instanceof StartEvent)) continue;
            object = ((StartEvent)object).getFormKey();
            jSONObject.put(InstallResult.class("\t^\u001d\\:C\u0003"), object);
            jSONArray.add((Object)jSONObject);
            break;
        }
        return InstallResult.getResult("1", "success", jSONArray);
    }
}

