/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.process.controller;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.response.ApiResponse;
import com.jxdinfo.hussar.util.BpmConfigRead;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"bpmModel"})
public class HussarBpmProcessController {
    private static final String GOD_AXE_MODEL = "/godaxeModel/";
    private static final String INSTANCE = "/instance/";
    private static Logger LOGGER = LogManager.getLogger(HussarBpmProcessController.class);

    @RequestMapping(value={"/validationProcess"})
    public ApiResponse<?> validationProcess(@RequestBody Map<String, Object> body) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("processDefinitionKey", body.get("processDefinitionKey"));
        map.put("businessKey", body.get("businessKey"));
        map.put("userId", body.get("userId"));
        map.put("variables", body.get("variables"));
        return HussarBpmProcessController.executeModel(map, "validationProcess");
    }

    @RequestMapping(value={"/doneList"})
    public ApiResponse<?> doneList(@RequestBody Map<String, Object> body) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("businessKey", body.get("businessKey"));
        return HussarBpmProcessController.executeModel(map, "doneList");
    }

    @RequestMapping(value={"/deleteProcessInstanceByBusinessKey"})
    public ApiResponse<?> deleteProcessInstanceByBusinessKey(@RequestBody Map<String, Object> body) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("businessKey", body.get("businessKey"));
        return HussarBpmProcessController.executeInstance(map, "deleteProcessInstanceByBusinessKey");
    }

    private static ApiResponse<?> executeModel(Map<String, Object> map, String url) {
        BpmConfigRead bpmConfigRead = new BpmConfigRead();
        map.put("tenantId", bpmConfigRead.getTenantId());
        map.put("tenantCipher", bpmConfigRead.getTenantCipher());
        String finalUrl = bpmConfigRead.getUrl() + GOD_AXE_MODEL + url;
        LOGGER.info("\u6d41\u7a0b\u56fe\u529f\u80fd\u5f00\u59cb");
        System.out.println("\u6d41\u7a0b\u56fe\u529f\u80fd\u5f00\u59cb");
        LOGGER.info("\u8def\u5f84\u4fe1\u606f\uff1a" + finalUrl);
        LOGGER.info("\u53c2\u6570\u4fe1\u606f\uff1a" + JSON.toJSONString(map));
        System.out.println("\u8def\u5f84\u4fe1\u606f" + finalUrl);
        Long start = System.currentTimeMillis();
        String result = HttpUtil.get((String)finalUrl, map, (int)bpmConfigRead.getDataPushTimeOut());
        Long end = System.currentTimeMillis();
        LOGGER.info("\u6d41\u7a0b\u56fe\u529f\u80fd\u7ed3\u675f");
        System.out.println("\u6d41\u7a0b\u56fe\u529f\u80fd\u7ed3\u675f");
        LOGGER.info("\u6d41\u7a0b\u56fe\u529f\u80fd\u8017\u65f6\uff1a" + (end - start) + "s");
        System.out.println("\u6d41\u7a0b\u56fe\u529f\u80fd\u8017\u65f6\uff1a" + (end - start) + "s");
        return (ApiResponse)JSON.parseObject((String)result, ApiResponse.class);
    }

    private static ApiResponse<?> executeInstance(Map<String, Object> map, String url) {
        BpmConfigRead bpmConfigRead = new BpmConfigRead();
        map.put("tenantId", bpmConfigRead.getTenantId());
        map.put("tenantCipher", bpmConfigRead.getTenantCipher());
        String finalUrl = bpmConfigRead.getUrl() + INSTANCE + url;
        LOGGER.info("instance\u529f\u80fd\u5f00\u59cb");
        System.out.println("instance\u529f\u80fd\u5f00\u59cb");
        LOGGER.info("\u8def\u5f84\u4fe1\u606f\uff1a" + finalUrl);
        LOGGER.info("\u53c2\u6570\u4fe1\u606f\uff1a" + JSON.toJSONString(map));
        System.out.println("\u8def\u5f84\u4fe1\u606f" + finalUrl);
        Long start = System.currentTimeMillis();
        String result = HttpUtil.get((String)finalUrl, map, (int)bpmConfigRead.getDataPushTimeOut());
        Long end = System.currentTimeMillis();
        LOGGER.info("instance\u529f\u80fd\u7ed3\u675f");
        System.out.println("instance\u529f\u80fd\u7ed3\u675f");
        LOGGER.info("instance\u529f\u80fd\u8017\u65f6\uff1a" + (end - start) + "s");
        System.out.println("instance\u529f\u80fd\u8017\u65f6\uff1a" + (end - start) + "s");
        return (ApiResponse)JSON.parseObject((String)result, ApiResponse.class);
    }
}

