/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.assignee.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.jxdinfo.hussar.assignee.dao.AssigneeMapper;
import com.jxdinfo.hussar.assignee.model.BpmTreeModel;
import com.jxdinfo.hussar.assignee.service.AssigneeService;
import com.jxdinfo.hussar.assignee.visitor.AssigneeVisitor;
import com.jxdinfo.hussar.assignee.visitor.AssigneeVisitorBeanUtil;
import com.jxdinfo.hussar.util.HussarBpmSM4Util;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class AssigneeServiceImpl
implements AssigneeService {
    private static final Pattern REGEX = Pattern.compile("\\@\\{([^@]|[^}]\\@)*\\}\\@");
    @Resource
    AssigneeMapper assigneeMapper;
    String key = "admin#$%^kopoiuy";

    @Override
    public List<BpmTreeModel> userTree(String id) {
        if (StringUtils.isEmpty((Object)id)) {
            id = "11";
        }
        return this.assigneeMapper.userTree(id);
    }

    @Override
    public List<BpmTreeModel> deptTree(String id) {
        if (StringUtils.isEmpty((Object)id)) {
            id = "11";
        }
        return this.assigneeMapper.deptTree(id);
    }

    @Override
    public List<BpmTreeModel> roleTree() {
        return this.assigneeMapper.roleTree();
    }

    @Override
    public List<BpmTreeModel> userDetail(List<String> userIds) {
        return this.assigneeMapper.userDetail(userIds);
    }

    @Override
    public List<String> getCandidateUser(String condition) {
        StringBuilder sb = new StringBuilder();
        String realCondition = this.getRealCondition(condition);
        sb.append(" SELECT o.USER_ID AS userId ");
        sb.append(" FROM SYS_USERS o ");
        if (realCondition.contains("GRANTED_ROLE")) {
            sb.append("  LEFT JOIN SYS_USER_ROLE r ON r.USER_ID = o.USER_ID ");
        }
        sb.append("  WHERE o.ACCOUNT_STATUS <> '2'  ");
        sb.append(realCondition);
        return new ArrayList<String>(new HashSet<String>(this.assigneeMapper.getCandidateUser(sb.toString())));
    }

    @Override
    public String getRealCondition(String condition) {
        String realCondition = HussarBpmSM4Util.decrypt(condition, this.key);
        if (realCondition.contains("@{")) {
            Matcher matcher = REGEX.matcher(realCondition);
            while (matcher.find()) {
                String message = matcher.group().substring(1, matcher.group().length() - 1);
                CharSequence[] messages = message.split(":");
                for (int j = 0; j < messages.length; ++j) {
                    String str = messages[j];
                    if (j != messages.length - 1) {
                        if (str.lastIndexOf("','") == str.indexOf("','")) continue;
                        str = str.replace("','", ",");
                        int num = str.lastIndexOf(",");
                        messages[j] = str.substring(0, num) + "','" + str.substring(num + 1);
                        continue;
                    }
                    messages[j] = str.replace("','", ",");
                }
                message = String.join((CharSequence)":", messages);
                List<String> userList = this.functionUser((Map)JSONArray.parse((String)message));
                StringBuilder users = new StringBuilder();
                String functionUsers = "";
                if (userList != null && userList.size() > 0) {
                    for (String user : userList) {
                        users.append(user).append("','");
                    }
                    functionUsers = users.toString().substring(0, users.toString().length() - 3);
                } else {
                    functionUsers = "";
                }
                realCondition = realCondition.replace(matcher.group(), functionUsers);
            }
        }
        realCondition = realCondition.replace("ORGAN_ID", "USER_ID").replace("PARENT_ID", "CORPORATION_ID");
        return realCondition;
    }

    public List<String> functionUser(Map<String, Object> message) {
        AssigneeVisitor hussarBpmVariablesVisitor;
        String beanId = new ArrayList<String>(message.keySet()).get(0);
        try {
            hussarBpmVariablesVisitor = AssigneeVisitorBeanUtil.getVisitorBean(beanId);
        }
        catch (NoSuchBeanDefinitionException e) {
            return new ArrayList<String>();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<String>();
        }
        return hussarBpmVariablesVisitor.visit((Map)message.get(beanId));
    }
}

