/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.vector.milvus.util;

import com.jxdinfo.hussar.vector.milvus.annotation.MilvusCollection;
import com.jxdinfo.hussar.vector.milvus.annotation.MilvusField;
import com.jxdinfo.hussar.vector.milvus.util.MSFunction;
import io.milvus.v2.common.DataType;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MilvusUtil {
    private static final Map<MSFunction<?, ?>, String> LAMBDA_FIELD_CACHE = new ConcurrentHashMap();

    public static String getFieldName(Class<?> clazz, MSFunction<?, ?> getter) {
        String fieldName = MilvusUtil.resolveFieldName(getter);
        try {
            Field field = clazz.getDeclaredField(fieldName);
            MilvusField mf = field.getAnnotation(MilvusField.class);
            if (mf == null) {
                throw new RuntimeException("\u5b57\u6bb5\u5fc5\u987b\u6709MilvusField\u6ce8\u89e3");
            }
            if (!mf.name().isEmpty()) {
                fieldName = mf.name();
            }
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Class " + clazz.getName() + " \u6ca1\u6709\u5b57\u6bb5 " + fieldName, e);
        }
        return fieldName;
    }

    public static String resolveFieldName(MSFunction<?, ?> func) {
        return LAMBDA_FIELD_CACHE.computeIfAbsent(func, f -> {
            try {
                Method writeReplace = f.getClass().getDeclaredMethod("writeReplace", new Class[0]);
                writeReplace.setAccessible(true);
                SerializedLambda lambda = (SerializedLambda)writeReplace.invoke(f, new Object[0]);
                String methodName = lambda.getImplMethodName();
                if (methodName.startsWith("get")) {
                    return Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
                }
                if (methodName.startsWith("is")) {
                    return Character.toLowerCase(methodName.charAt(2)) + methodName.substring(3);
                }
                throw new RuntimeException("\u65e0\u6cd5\u8bc6\u522b\u7684getter: " + methodName);
            }
            catch (Exception e) {
                throw new RuntimeException("\u65e0\u6cd5\u4eceLambda\u83b7\u53d6\u5b57\u6bb5\u540d: " + func, e);
            }
        });
    }

    public static List<String> getNotVectorFields(Class<?> clazz) {
        ArrayList<String> notVectorFields = new ArrayList<String>();
        for (Field field : clazz.getDeclaredFields()) {
            MilvusField mf = field.getAnnotation(MilvusField.class);
            if (mf == null || MilvusUtil.isVectorType(mf.dataType())) continue;
            notVectorFields.add(mf.name().isEmpty() ? field.getName() : mf.name());
        }
        return notVectorFields;
    }

    public static String getCollectionName(Class<?> clazz, String id) {
        MilvusCollection mc = clazz.getAnnotation(MilvusCollection.class);
        if (mc == null) {
            throw new RuntimeException("\u7f3a\u5c11'@MilvusCollection'\u6ce8\u89e3\uff0c\u65e0\u6cd5\u83b7\u53d6\u96c6\u5408\u4fe1\u606f");
        }
        String collectionName = mc.name();
        if (collectionName.trim().isEmpty()) {
            collectionName = clazz.getSimpleName();
        }
        if (id != null && !id.trim().isEmpty()) {
            collectionName = collectionName + mc.separator() + id;
        }
        return collectionName;
    }

    public static String generateIndexName(String fieldName) {
        return fieldName + "_index";
    }

    public static String generateBM25FieldName(String fieldName) {
        return fieldName + "_bm25";
    }

    public static String generateBM25FunctionName(String fieldName) {
        return fieldName + "_bm25_func";
    }

    public static String generateBM25IndexName(String fieldName) {
        return fieldName + "_bm25_index";
    }

    public static boolean isVectorType(DataType type) {
        return type == DataType.FloatVector || type == DataType.Float16Vector || type == DataType.BFloat16Vector || type == DataType.BinaryVector || type == DataType.SparseFloatVector;
    }
}

