/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.vector.factory.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.config.AiDocumentLibrary;
import com.jxdinfo.hussar.common.config.AiGraphRagLibrary;
import com.jxdinfo.hussar.common.util.IqaHttpClientUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.vector.dto.EmbedDTO;
import com.jxdinfo.hussar.vector.dto.SearchParam;
import com.jxdinfo.hussar.vector.factory.RetrieveRecall;
import com.jxdinfo.hussar.vector.util.VectorUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component(value="ModelRetrieveRecall")
public class ModelRetrieveRecall
implements RetrieveRecall {
    @Resource
    private AiDocumentLibrary docLibraryConfig;
    @Resource
    private AiGraphRagLibrary aiGraphRagLibrary;

    @Override
    public Map<String, Object> fragmentRetrieveRecall(String question, List<Long> dataSourceIds, String processingMode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if ("rag".equals(processingMode)) {
            Map<String, Object> mapRag = this.getRagMapResult(question, dataSourceIds);
            map.putAll(mapRag);
        } else if ("graph".equals(processingMode)) {
            Map<String, Object> mapGraph = this.getGraphMapResult(question, dataSourceIds);
            map.putAll(mapGraph);
        } else if ("kag".equals(processingMode)) {
            Map<String, Object> mapRag = this.getRagMapResult(question, dataSourceIds);
            map.putAll(mapRag);
            Map<String, Object> mapGraph = this.getGraphMapResult(question, dataSourceIds);
            map.putAll(mapGraph);
        }
        return map;
    }

    private Map<String, Object> getRagMapResult(String question, List<Long> dataSourceIds) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        EmbedDTO embedDTO = VectorUtil.getVectorMap(Collections.singletonList(question), this.docLibraryConfig.getEmbedUrl());
        List<Float> floats = embedDTO.getDense().get(0);
        int min = 10;
        if (dataSourceIds.size() > 1) {
            min = Math.min(dataSourceIds.size() * 5, 20);
        }
        List<String> dataSourceIdStrList = dataSourceIds.stream().map(String::valueOf).collect(Collectors.toList());
        SearchParam searchParam = new SearchParam(floats, min, dataSourceIdStrList);
        String searchResult = IqaHttpClientUtil.httpPost((String)this.docLibraryConfig.getSearchUrl(), (String)JSONObject.toJSONString((Object)searchParam), new HashMap());
        JSONObject searchObject = JSON.parseObject((String)searchResult);
        Integer code = searchObject.getInteger("code");
        if (code != 2000) {
            throw new HussarException("\u672a\u627e\u5230\u76f8\u5173\u77e5\u8bc6" + searchResult);
        }
        String retrieveResult = searchObject.getString("retrieve_result");
        ArrayList<String> list = new ArrayList<String>();
        List texts = JSONObject.parseArray((String)retrieveResult, JSONObject.class);
        for (JSONObject text : texts) {
            list.add(text.getString("text"));
        }
        HashMap<String, Object> inParam = new HashMap<String, Object>();
        inParam.put("query", question);
        inParam.put("docs", list);
        inParam.put("top_number", 5);
        String result = IqaHttpClientUtil.httpPost((String)this.docLibraryConfig.getRerankUrl(), (String)JSONObject.toJSONString(inParam), new HashMap());
        ArrayList<String> answers = new ArrayList<String>();
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        if ("200".equals(jsonObject.getString("code"))) {
            JSONArray jsonArray = jsonObject.getJSONArray("docs");
            for (Object o : jsonArray) {
                answers.add(((JSONObject)o).getString("text"));
            }
        }
        map.put("texts", texts);
        map.put("answers", answers);
        return map;
    }

    private Map<String, Object> getGraphMapResult(String question, List<Long> dataSourceIds) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, String> inParam = new HashMap<String, String>();
        inParam.put("knowledge_base_id", String.valueOf(dataSourceIds.get(0)));
        inParam.put("query", question);
        String result = IqaHttpClientUtil.httpPost((String)this.aiGraphRagLibrary.getSearchChunkUrl(), (String)JSONObject.toJSONString(inParam), new HashMap());
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        if (!"200".equals(jsonObject.getString("code"))) {
            throw new HussarException("\u672a\u627e\u5230\u76f8\u5173\u77e5\u8bc6");
        }
        JSONObject dataObject = jsonObject.getJSONObject("data");
        JSONArray entitiesArray = dataObject.getJSONArray("entities");
        JSONArray relationshipsArray = dataObject.getJSONArray("relationships");
        map.put("entitiesArray", entitiesArray);
        map.put("relationshipsArray", relationshipsArray);
        return map;
    }
}

