/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.vector.factory.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.config.AiDocumentLibrary;
import com.jxdinfo.hussar.common.config.AiGraphRagLibrary;
import com.jxdinfo.hussar.common.util.IqaHttpClientUtil;
import com.jxdinfo.hussar.vector.dto.DocVectorStorageDTO;
import com.jxdinfo.hussar.vector.dto.EmbedDTO;
import com.jxdinfo.hussar.vector.dto.EmbedParam;
import com.jxdinfo.hussar.vector.factory.FragmentStorage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component(value="ModelFragmentStorage")
public class ModelFragmentStorage
implements FragmentStorage {
    @Resource
    private AiDocumentLibrary docLibraryConfig;
    @Resource
    private AiGraphRagLibrary aiGraphRagLibrary;

    @Override
    public String docomentFragmentStorage(DocVectorStorageDTO dto) {
        String result = "";
        String docBaseId = dto.getDocBaseId();
        String fileName = dto.getFileName();
        String processingMode = dto.getProcessingMode();
        if ("rag".equals(processingMode)) {
            EmbedDTO embedDTO = dto.getEmbedDTO();
            List<List<Float>> dense = embedDTO.getDense();
            List<String> contents = embedDTO.getContents();
            ArrayList<EmbedParam> embedParams = new ArrayList<EmbedParam>();
            for (int i = 0; i < contents.size(); ++i) {
                EmbedParam embedParam = new EmbedParam(docBaseId, contents.get(i), dense.get(i), fileName);
                embedParams.add(embedParam);
            }
            HashMap<String, ArrayList<EmbedParam>> inmap = new HashMap<String, ArrayList<EmbedParam>>();
            inmap.put("items", embedParams);
            String inParam = JSONObject.toJSONString(inmap);
            result = IqaHttpClientUtil.httpPost((String)this.docLibraryConfig.getBatchAddDataUrl(), (String)inParam, new HashMap());
        } else if ("graph".equals(processingMode)) {
            HashMap<String, Object> inmap = new HashMap<String, Object>();
            inmap.put("knowledge_base_id", docBaseId);
            inmap.put("chunks", dto.getChunks());
            inmap.put("types", dto.getEntityExtractionRule());
            String inParam = JSONObject.toJSONString(inmap);
            result = IqaHttpClientUtil.httpPost((String)this.aiGraphRagLibrary.getInsertChunkUrl(), (String)inParam, new HashMap());
        } else if ("kag".equals(processingMode)) {
            EmbedDTO embedDTO = dto.getEmbedDTO();
            List<List<Float>> dense = embedDTO.getDense();
            List<String> contents = embedDTO.getContents();
            ArrayList<EmbedParam> embedParams = new ArrayList<EmbedParam>();
            for (int i = 0; i < contents.size(); ++i) {
                EmbedParam embedParam = new EmbedParam(docBaseId, contents.get(i), dense.get(i), fileName);
                embedParams.add(embedParam);
            }
            HashMap<String, Object> inmap = new HashMap<String, Object>();
            inmap.put("items", embedParams);
            String inParam = JSONObject.toJSONString(inmap);
            result = IqaHttpClientUtil.httpPost((String)this.docLibraryConfig.getBatchAddDataUrl(), (String)inParam, new HashMap());
            JSONObject jsonObject = JSONObject.parseObject((String)result);
            if (jsonObject.getInteger("code") != 2000) {
                jsonObject.put("message", (Object)"RAG\u5411\u91cf\u5316\u5165\u5e93\u5931\u8d25");
                return jsonObject.toJSONString();
            }
            inmap = new HashMap();
            inmap.put("knowledge_base_id", docBaseId);
            inmap.put("chunks", dto.getChunks());
            inmap.put("types", dto.getEntityExtractionRule());
            inParam = JSONObject.toJSONString(inmap);
            result = IqaHttpClientUtil.httpPost((String)this.aiGraphRagLibrary.getInsertChunkUrl(), (String)inParam, new HashMap());
        }
        return result;
    }
}

