/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.vector.service.impl;

import com.jxdinfo.hussar.common.config.AiDocumentLibrary;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.vector.dto.DocVectorStorageDTO;
import com.jxdinfo.hussar.vector.dto.EmbedDTO;
import com.jxdinfo.hussar.vector.factory.FragmentStorageFactory;
import com.jxdinfo.hussar.vector.factory.impl.DynamicFragmentStorageFactory;
import com.jxdinfo.hussar.vector.service.DocVectorStorageService;
import com.jxdinfo.hussar.vector.util.VectorUtil;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class DocVectorStorageServiceImpl
implements DocVectorStorageService {
    @Resource
    private AiDocumentLibrary docLibraryConfig;
    private final FragmentStorageFactory fragmentStorageFactory = new DynamicFragmentStorageFactory();

    @Override
    public String docVectorStorage(DocVectorStorageDTO dto) {
        String processingMode = dto.getProcessingMode();
        if (processingMode == null || processingMode.isEmpty()) {
            throw new HussarException("\u4f20\u5165\u7684\u5904\u7406\u6a21\u5f0fprocessingMode\u7684\u503c\u4e3a\u7a7a!");
        }
        String result = "";
        if ("rag".equals(processingMode) || "kag".equals(processingMode)) {
            EmbedDTO embedDTO = VectorUtil.getVectorMap(dto.getTexts(), this.docLibraryConfig.getEmbedUrl());
            dto.setEmbedDTO(embedDTO);
        }
        String type = dto.getType();
        result = this.fragmentStorageFactory.getFragmentStorage(type).docomentFragmentStorage(dto);
        return result;
    }
}

