/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.vector.milvus.wrapper;

import com.jxdinfo.hussar.vector.milvus.annotation.MilvusBM25;
import com.jxdinfo.hussar.vector.milvus.annotation.MilvusField;
import com.jxdinfo.hussar.vector.milvus.util.MSFunction;
import com.jxdinfo.hussar.vector.milvus.util.MilvusUtil;
import com.jxdinfo.hussar.vector.milvus.wrapper.MilvusQueryWrapper;
import io.milvus.v2.service.vector.request.SearchReq;
import io.milvus.v2.service.vector.request.data.BaseVector;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class MilvusSearchWrapper<T>
extends MilvusQueryWrapper<T> {
    private BaseVector data;
    private final Map<String, Object> searchParams = new HashMap<String, Object>();
    private int topK;
    private String annsField;

    public MilvusSearchWrapper(Class<T> clazz, String id) {
        super(clazz, id);
    }

    public MilvusSearchWrapper(Class<T> clazz) {
        super(clazz);
    }

    public SearchReq buildSearchReq() {
        SearchReq sr = SearchReq.builder().collectionName(this.getCollectionName()).data(Collections.singletonList(this.data)).topK(this.topK < 1 ? 10 : this.topK).searchParams(this.searchParams).build();
        if (this.annsField != null && !this.annsField.isEmpty()) {
            sr.setAnnsField(this.annsField);
        }
        if (!this.outputFields.isEmpty()) {
            sr.setOutputFields(this.outputFields);
        } else if (!this.queryVector) {
            sr.setOutputFields(this.getNotVectorFields());
        }
        if (this.filterExpression.length() > 0 && !this.filterExpression.toString().trim().isEmpty()) {
            sr.setFilter(this.filterExpression.toString().trim());
        }
        return sr;
    }

    public MilvusSearchWrapper<T> data(BaseVector data) {
        this.data = data;
        return this;
    }

    public MilvusSearchWrapper<T> searchParams(Map<String, Object> searchParams) {
        if (searchParams == null || searchParams.isEmpty()) {
            return this;
        }
        this.searchParams.putAll(searchParams);
        return this;
    }

    public MilvusSearchWrapper<T> topK(int topK) {
        this.topK = topK;
        return this;
    }

    public MilvusSearchWrapper<T> annsField(MSFunction<T, ?> getter) {
        this.annsField = this.getVectorFieldName(getter);
        return this;
    }

    private String getVectorFieldName(MSFunction<T, ?> getter) {
        String fieldName = MilvusUtil.resolveFieldName(getter);
        try {
            Field field = this.clazz.getDeclaredField(fieldName);
            MilvusField mf = field.getAnnotation(MilvusField.class);
            if (mf == null) {
                throw new RuntimeException("\u5b57\u6bb5\u5fc5\u987b\u6709MilvusField\u6ce8\u89e3");
            }
            String string = fieldName = mf.name().isEmpty() ? fieldName : mf.name();
            if (MilvusUtil.isVectorType(mf.dataType())) {
                return fieldName;
            }
            MilvusBM25 bm = field.getAnnotation(MilvusBM25.class);
            if (bm == null) {
                return fieldName;
            }
            this.searchParams.put("metric_type", "BM25");
            if (!this.searchParams.containsKey("analyzer_name")) {
                this.searchParams.put("analyzer_name", "cn");
            }
            return MilvusUtil.generateBM25FieldName(fieldName);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

