/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.vector.milvus.wrapper;

import com.jxdinfo.hussar.vector.milvus.annotation.MilvusCollection;
import com.jxdinfo.hussar.vector.milvus.util.MSFunction;
import com.jxdinfo.hussar.vector.milvus.util.MilvusUtil;
import com.jxdinfo.hussar.vector.milvus.wrapper.MilvusSearchWrapper;
import io.milvus.v2.service.vector.request.DeleteReq;
import io.milvus.v2.service.vector.request.QueryReq;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class MilvusQueryWrapper<T> {
    protected final Class<T> clazz;
    private String id = "";
    protected final List<String> outputFields = new ArrayList<String>();
    private List<Object> ids = new ArrayList<Object>();
    protected final StringBuilder filterExpression = new StringBuilder();
    private long offset;
    private long limit;
    protected boolean queryVector = false;

    public MilvusQueryWrapper(Class<T> clazz) {
        MilvusCollection mc = clazz.getAnnotation(MilvusCollection.class);
        if (mc == null) {
            throw new RuntimeException("\u7c7b\u5fc5\u987b\u6709MilvusCollection\u6ce8\u89e3");
        }
        this.clazz = clazz;
    }

    public MilvusQueryWrapper(Class<T> clazz, String id) {
        this(clazz);
        this.id = id;
    }

    public DeleteReq buildDeleteReq() {
        DeleteReq dr = DeleteReq.builder().collectionName(this.getCollectionName()).build();
        if (this.ids != null && !this.ids.isEmpty()) {
            dr.setIds(this.ids);
        }
        if (this.filterExpression.length() > 0 && !this.filterExpression.toString().trim().isEmpty()) {
            dr.setFilter(this.filterExpression.toString().trim());
        }
        return dr;
    }

    public QueryReq buildQueryReq() {
        QueryReq req = QueryReq.builder().collectionName(this.getCollectionName()).build();
        if (!this.outputFields.isEmpty()) {
            req.setOutputFields(this.outputFields);
        } else if (!this.queryVector) {
            req.setOutputFields(this.getNotVectorFields());
        }
        if (this.ids != null && !this.ids.isEmpty()) {
            req.setIds(this.ids);
        }
        if (this.filterExpression.length() > 0 && !this.filterExpression.toString().trim().isEmpty()) {
            req.setFilter(this.filterExpression.toString().trim());
        }
        if (this.limit > 0L) {
            req.setLimit(this.limit);
        }
        if (this.offset > 0L) {
            req.setOffset(this.offset);
        }
        return req;
    }

    public Class<T> getClazz() {
        return this.clazz;
    }

    public String getCollectionName() {
        return MilvusUtil.getCollectionName(this.clazz, this.id);
    }

    public MilvusSearchWrapper<T> toSearchWrapper() {
        return (MilvusSearchWrapper)this;
    }

    public MilvusQueryWrapper<T> queryVector(boolean queryVector) {
        this.queryVector = queryVector;
        return this;
    }

    public MilvusQueryWrapper<T> isNull(MSFunction<T, ?> getter) {
        this.addCondition(getter, "IS NULL", null);
        return this;
    }

    public MilvusQueryWrapper<T> isNotNull(MSFunction<T, ?> getter) {
        this.addCondition(getter, "IS NOT NULL", null);
        return this;
    }

    public MilvusQueryWrapper<T> offset(long offset) {
        this.offset = offset;
        return this;
    }

    public MilvusQueryWrapper<T> limit(long limit) {
        this.limit = limit;
        return this;
    }

    public MilvusQueryWrapper<T> eq(MSFunction<T, ?> getter, Object value) {
        this.addCondition(getter, "==", value);
        return this;
    }

    public MilvusQueryWrapper<T> ne(MSFunction<T, ?> getter, Object value) {
        this.addCondition(getter, "!=", value);
        return this;
    }

    public MilvusQueryWrapper<T> in(MSFunction<T, ?> getter, List<?> values) {
        String valueStr = values.stream().map(this::formatValue).collect(Collectors.joining(", "));
        this.addCondition(getter, "in", "[" + valueStr + "]");
        return this;
    }

    public MilvusQueryWrapper<T> gt(MSFunction<T, ?> getter, Object value) {
        this.addCondition(getter, ">", value);
        return this;
    }

    public MilvusQueryWrapper<T> lt(MSFunction<T, ?> getter, Object value) {
        this.addCondition(getter, "<", value);
        return this;
    }

    public MilvusQueryWrapper<T> ge(MSFunction<T, ?> getter, Object value) {
        this.addCondition(getter, ">=", value);
        return this;
    }

    public MilvusQueryWrapper<T> le(MSFunction<T, ?> getter, Object value) {
        this.addCondition(getter, "<=", value);
        return this;
    }

    public MilvusQueryWrapper<T> and() {
        if (this.filterExpression.length() > 0) {
            this.filterExpression.append(" AND ");
        }
        return this;
    }

    public MilvusQueryWrapper<T> and(Function<MilvusQueryWrapper<T>, MilvusQueryWrapper<T>> nestedCondition) {
        if (this.filterExpression.length() > 0) {
            this.filterExpression.append(" AND ");
        }
        MilvusQueryWrapper<T> nestedWrapper = new MilvusQueryWrapper<T>(this.clazz);
        nestedCondition.apply(nestedWrapper);
        this.filterExpression.append("(").append(nestedWrapper.getFilterExpression()).append(")");
        return this;
    }

    public MilvusQueryWrapper<T> or() {
        if (this.filterExpression.length() > 0) {
            this.filterExpression.append(" OR ");
        }
        return this;
    }

    public MilvusQueryWrapper<T> or(Function<MilvusQueryWrapper<T>, MilvusQueryWrapper<T>> nestedCondition) {
        if (this.filterExpression.length() > 0) {
            this.filterExpression.append(" OR ");
        }
        MilvusQueryWrapper<T> nestedWrapper = new MilvusQueryWrapper<T>(this.clazz);
        nestedCondition.apply(nestedWrapper);
        this.filterExpression.append("(").append(nestedWrapper.getFilterExpression()).append(")");
        return this;
    }

    public MilvusQueryWrapper<T> nested(Function<MilvusQueryWrapper<T>, MilvusQueryWrapper<T>> nestedCondition) {
        MilvusQueryWrapper<T> nestedWrapper = new MilvusQueryWrapper<T>(this.clazz);
        nestedCondition.apply(nestedWrapper);
        if (this.filterExpression.length() > 0) {
            this.filterExpression.append(" AND ");
        }
        this.filterExpression.append("(").append(nestedWrapper.getFilterExpression()).append(")");
        return this;
    }

    public MilvusQueryWrapper<T> apply(String customCondition) {
        if (this.filterExpression.length() > 0) {
            this.filterExpression.append(" AND ");
        }
        this.filterExpression.append("(").append(customCondition).append(")");
        return this;
    }

    public String getFilterExpression() {
        return this.filterExpression.toString();
    }

    public MilvusQueryWrapper<T> clear() {
        this.filterExpression.setLength(0);
        return this;
    }

    private void addCondition(MSFunction<T, ?> getter, String operator, Object value) {
        String currentExpression;
        String fieldName = this.getFieldName(getter);
        if (this.filterExpression.length() > 0 && !(currentExpression = this.filterExpression.toString().trim()).endsWith(" AND") && !currentExpression.endsWith(" OR")) {
            this.filterExpression.append(" AND ");
        }
        if ("in".equals(operator)) {
            this.filterExpression.append(fieldName).append(" ").append(operator).append(" ").append(value);
        } else {
            this.filterExpression.append(fieldName).append(" ").append(operator).append(" ").append(this.formatValue(value));
        }
    }

    private String formatValue(Object value) {
        if (value == null) {
            return "''";
        }
        if (value instanceof String) {
            return MilvusQueryWrapper.escapeMilvusString(value.toString());
        }
        if (value instanceof Number || value instanceof Boolean) {
            return value.toString();
        }
        return "'" + value + "'";
    }

    public MilvusQueryWrapper<T> ids(List<Object> ids) {
        this.ids = ids;
        return this;
    }

    @SafeVarargs
    public final MilvusQueryWrapper<T> outputFields(MSFunction<T, ?> ... fields) {
        for (MSFunction<T, ?> func : fields) {
            this.outputFields.add(this.getFieldName(func));
        }
        return this;
    }

    public final MilvusQueryWrapper<T> outputFields(String ... fields) {
        this.outputFields.addAll(Arrays.asList(fields));
        return this;
    }

    public static String escapeMilvusString(String input) {
        if (input == null) {
            return "''";
        }
        String escaped = input.replace("\\", "\\\\").replace("\r\n", "\\r\\n").replace("\r", "\\r").replace("\t", "\\t").replace("\n", "\\n").replace("'", "\\'");
        return "'" + escaped + "'";
    }

    protected List<String> getNotVectorFields() {
        return MilvusUtil.getNotVectorFields(this.clazz);
    }

    protected String getFieldName(MSFunction<T, ?> getter) {
        return MilvusUtil.getFieldName(this.clazz, getter);
    }
}

