/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.vector.milvus.wrapper;

import com.google.gson.Gson;
import com.jxdinfo.hussar.vector.milvus.annotation.MilvusCollection;
import com.jxdinfo.hussar.vector.milvus.util.MSFunction;
import com.jxdinfo.hussar.vector.milvus.util.MilvusUtil;
import io.milvus.v2.service.vector.request.AnnSearchReq;
import io.milvus.v2.service.vector.request.HybridSearchReq;
import io.milvus.v2.service.vector.request.data.BaseVector;
import io.milvus.v2.service.vector.request.ranker.BaseRanker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class MilvusHybridSearchWrapper<T> {
    protected final Class<T> clazz;
    private String id = "";
    protected final List<String> outputFields = new ArrayList<String>();
    private List<AnnSearchReq> searchRequests = new ArrayList<AnnSearchReq>();
    private BaseRanker reranker;
    private int topK;
    private int roundDecimal;
    protected boolean queryVector = false;

    public MilvusHybridSearchWrapper(Class<T> clazz) {
        MilvusCollection mc = clazz.getAnnotation(MilvusCollection.class);
        if (mc == null) {
            throw new RuntimeException("\u7c7b\u5fc5\u987b\u6709MilvusCollection\u6ce8\u89e3");
        }
        this.clazz = clazz;
    }

    public MilvusHybridSearchWrapper(Class<T> clazz, String id) {
        this(clazz);
        this.id = id;
    }

    public HybridSearchReq buildHybridSearchReq() {
        HybridSearchReq h = HybridSearchReq.builder().collectionName(MilvusUtil.getCollectionName(this.clazz, this.id)).searchRequests(this.searchRequests).topK(this.topK).build();
        if (!this.outputFields.isEmpty()) {
            h.setOutFields(this.outputFields);
        } else if (!this.queryVector) {
            h.setOutFields(MilvusUtil.getNotVectorFields(this.clazz));
        }
        if (this.reranker != null) {
            h.setRanker(this.reranker);
        }
        if (this.roundDecimal > 0) {
            h.setRoundDecimal(this.roundDecimal);
        }
        return h;
    }

    public MilvusHybridSearchWrapper<T> reranker(BaseRanker reranker) {
        this.reranker = reranker;
        return this;
    }

    public MilvusHybridSearchWrapper<T> topK(int topK) {
        this.topK = topK;
        return this;
    }

    public MilvusHybridSearchWrapper<T> roundDecimal(int roundDecimal) {
        this.roundDecimal = roundDecimal;
        return this;
    }

    public MilvusHybridSearchWrapper<T> addSearchRequest(AnnSearchReq searchRequest) {
        this.searchRequests.add(searchRequest);
        return this;
    }

    public MilvusHybridSearchWrapper<T> addSearchRequests(List<AnnSearchReq> searchRequests) {
        this.searchRequests.addAll(searchRequests);
        return this;
    }

    public MilvusHybridSearchWrapper<T> addSearchRequest(MSFunction<T, ?> vectorFieldName, BaseVector vector, int topK, Map<String, Object> searchParams) {
        this.addSearchRequest(MilvusUtil.getFieldName(this.clazz, vectorFieldName), vector, topK, searchParams);
        return this;
    }

    public MilvusHybridSearchWrapper<T> addSearchRequest(String vectorFieldName, BaseVector vector, int topK, Map<String, Object> searchParams) {
        AnnSearchReq r = AnnSearchReq.builder().vectorFieldName(vectorFieldName).vectors(Collections.singletonList(vector)).topK(topK).build();
        if (searchParams != null && !searchParams.isEmpty()) {
            r.setParams(new Gson().toJson(searchParams));
        }
        this.searchRequests.add(r);
        return this;
    }

    public MilvusHybridSearchWrapper<T> queryVector(boolean queryVector) {
        this.queryVector = queryVector;
        return this;
    }

    public MilvusHybridSearchWrapper<T> outputFields(String ... outputFields) {
        this.outputFields.addAll(Arrays.asList(outputFields));
        return this;
    }

    @SafeVarargs
    public final MilvusHybridSearchWrapper<T> outputFields(MSFunction<T, ?> ... fields) {
        for (MSFunction<T, ?> getter : fields) {
            this.outputFields.add(MilvusUtil.getFieldName(this.clazz, getter));
        }
        return this;
    }
}

