/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.vector.milvus.config;

import com.jxdinfo.hussar.vector.milvus.config.MilvusProperties;
import io.milvus.v2.client.ConnectConfig;
import io.milvus.v2.client.MilvusClientV2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
public class MilvusConfig {
    private static final Logger logger = LoggerFactory.getLogger(MilvusConfig.class);
    private final MilvusProperties milvusProperties;

    public MilvusConfig(MilvusProperties milvusProperties) {
        this.milvusProperties = milvusProperties;
    }

    @Bean
    @Primary
    public MilvusClientV2 milvusServiceClientV2() {
        MilvusClientV2 client = null;
        try {
            client = new MilvusClientV2(ConnectConfig.builder().uri("http://" + this.milvusProperties.getHost() + ":" + this.milvusProperties.getPort()).build());
            logger.info("\u5411\u91cf\u5e93MilvusClientV2\u521d\u59cb\u5316\u6210\u529f, host={}, port={}, dbName={}", new Object[]{this.milvusProperties.getHost(), this.milvusProperties.getPort(), this.milvusProperties.getDbName()});
        }
        catch (Exception e) {
            logger.error("\u5411\u91cf\u5e93MilvusClientV2\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
        }
        return client;
    }
}

