/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.vector.factory.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.config.AiDocumentLibrary;
import com.jxdinfo.hussar.common.config.AiGraphRagLibrary;
import com.jxdinfo.hussar.common.util.IqaHttpClientUtil;
import com.jxdinfo.hussar.vector.dto.DocDeleteStorageDTO;
import com.jxdinfo.hussar.vector.factory.DeleteFragmentStorage;
import java.util.HashMap;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component(value="ModelDeleteFragmentStorage")
public class ModelDeleteFragmentStorage
implements DeleteFragmentStorage {
    @Resource
    private AiDocumentLibrary docLibraryConfig;
    @Resource
    private AiGraphRagLibrary aiGraphRagLibrary;

    @Override
    public String deleteFragmentStorage(DocDeleteStorageDTO dto) {
        String delResult = "";
        String processingMode = dto.getProcessingMode();
        if ("rag".equals(processingMode)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("document_name", dto.getFileName());
            map.put("knowledge_name", dto.getDocBaseId());
            delResult = IqaHttpClientUtil.httpPost((String)this.docLibraryConfig.getDeleteByDocumentNameUrl(), (String)JSONObject.toJSONString(map), new HashMap());
        } else if ("graph".equals(processingMode)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("human_readable_ids", dto.getHuman_readable_ids());
            map.put("knowledge_base_id", dto.getDocBaseId());
            delResult = IqaHttpClientUtil.httpPost((String)this.aiGraphRagLibrary.getDeleteChunkUrl(), (String)JSONObject.toJSONString(map), new HashMap());
        } else if ("kag".equals(processingMode)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("document_name", dto.getFileName());
            map.put("knowledge_name", dto.getDocBaseId());
            delResult = IqaHttpClientUtil.httpPost((String)this.docLibraryConfig.getDeleteByDocumentNameUrl(), (String)JSONObject.toJSONString(map), new HashMap());
            JSONObject jsonObject = JSON.parseObject((String)delResult);
            if (jsonObject.getInteger("code") != 2000) {
                jsonObject.put("message", (Object)"\u5220\u9664 rag \u6a21\u578b\u5931\u8d25\uff01");
                return jsonObject.toJSONString();
            }
            HashMap<String, Object> mapGraph = new HashMap<String, Object>();
            mapGraph.put("human_readable_ids", dto.getHuman_readable_ids());
            mapGraph.put("knowledge_base_id", dto.getDocBaseId());
            delResult = IqaHttpClientUtil.httpPost((String)this.aiGraphRagLibrary.getDeleteChunkUrl(), (String)JSONObject.toJSONString(mapGraph), new HashMap());
        }
        return delResult;
    }
}

