/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.strategy.docParsing.impl;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.strategy.docParsing.ParsingStrategy;
import com.jxdinfo.hussar.strategy.docParsing.impl.LocalParsingForXlsx;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="LocalParsingForXls")
public class LocalParsingForXls
implements ParsingStrategy {
    private static final Logger logger = LoggerFactory.getLogger(LocalParsingForXls.class);

    @Override
    public HashMap<String, LinkedHashMap<String, String>> fileToMap(File file, HashMap<String, Object> params) {
        String type = (String)params.get("type");
        String name = file.getName();
        HSSFWorkbook wk = null;
        HashMap<String, LinkedHashMap<String, String>> resultMap = new HashMap<String, LinkedHashMap<String, String>>();
        try {
            FileInputStream is = new FileInputStream(file);
            wk = new HSSFWorkbook((InputStream)is);
            if (HussarUtils.isNotEmpty((Object)wk)) {
                LocalParsingForXlsx localParsingForXlsx = new LocalParsingForXlsx();
                if ("3".equals(type)) {
                    Integer paragraphLength = Integer.valueOf(params.get("paragraphLength").toString());
                    resultMap = localParsingForXlsx.parsingByLength((Workbook)wk, name, paragraphLength);
                }
                if ("4".equals(type)) {
                    resultMap = localParsingForXlsx.parsingBySheet((Workbook)wk, name);
                }
            }
        }
        catch (IOException e) {
            throw new HussarException("xls\u6587\u6863+\u3010" + name + "\u3011\u52a0\u8f7d\u5f02\u5e38\uff01" + e);
        }
        finally {
            try {
                if (wk != null) {
                    wk.close();
                }
            }
            catch (IOException e) {
                logger.error("\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)e);
            }
        }
        return resultMap;
    }

    public static void main(String[] args) {
        LocalParsingForXls localparsingForXls = new LocalParsingForXls();
        File file = new File("D:\\\u6d4b\u8bd5xls.xls");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "4");
        map.put("paragraphLength", 500);
        HashMap<String, LinkedHashMap<String, String>> stringLinkedHashMapHashMap = localparsingForXls.fileToMap(file, map);
        System.out.println(stringLinkedHashMapHashMap);
    }
}

