/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.strategy.docParsing.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.config.AiDocumentLibrary;
import com.jxdinfo.hussar.common.util.IqaFileUtil;
import com.jxdinfo.hussar.common.util.IqaHttpClientUtil;
import com.jxdinfo.hussar.common.util.IqaLibreOfficePDFConvert;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.strategy.docParsing.ParsingFactory;
import com.jxdinfo.hussar.strategy.docParsing.ParsingModel;
import com.jxdinfo.hussar.strategy.docParsing.ParsingStrategy;
import com.jxdinfo.hussar.strategy.model.QADocSplittingStrategy;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RemoteParsing
implements ParsingModel {
    @Resource
    private AiDocumentLibrary docStrategyLibraryConfig;
    private static final Logger logger = LoggerFactory.getLogger(RemoteParsing.class);

    @Override
    public HashMap<String, HashMap<String, LinkedHashMap<String, String>>> fileToMap(List<File> files, QADocSplittingStrategy splittingStrategy) {
        HashMap<String, HashMap<String, LinkedHashMap<String, String>>> resultMap = new HashMap<String, HashMap<String, LinkedHashMap<String, String>>>();
        HashMap<String, String> param = new HashMap<String, String>();
        String type = splittingStrategy.getType();
        if ("1".equals(type)) {
            param.put("text_spliter", "ChapterTextSplitter");
        } else {
            param.put("text_spliter", "TitleParaTextSplitter");
        }
        HashSet<String> wpsExtensions = new HashSet<String>();
        wpsExtensions.add("wps");
        wpsExtensions.add("wpt");
        wpsExtensions.add("dot");
        ArrayList<File> convertFiles = new ArrayList<File>();
        for (File file : files) {
            String fileExtension = IqaFileUtil.getFileExtension((String)file.getName());
            if (wpsExtensions.contains(fileExtension)) {
                File docxFile = Paths.get(file.getPath() + ".docx", new String[0]).toFile();
                try {
                    IqaLibreOfficePDFConvert.doDocToFdpLibre((File)file, (File)docxFile);
                }
                catch (Exception e) {
                    throw new HussarException("\u8f6c\u6362\u5f02\u5e38\uff1a", (Throwable)e);
                }
                convertFiles.add(docxFile);
                continue;
            }
            convertFiles.add(file);
        }
        String result = IqaHttpClientUtil.httpFilesPost((String)this.docStrategyLibraryConfig.getSplittingDocUrl(), convertFiles, param, new HashMap());
        HussarException.throwByNull((Object)result, (String)"\u5927\u6a21\u578b\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        if ("200".equals(jsonObject.getString("code"))) {
            ParsingFactory parsingFactory = new ParsingFactory();
            logger.info("\u5207\u5206\u5931\u8d25\u6587\u4ef6=======\u300b" + jsonObject.getJSONObject("data").getString("failed_files"));
            for (int i = 0; i < files.size(); ++i) {
                JSONArray textJsonArray;
                File file = files.get(i);
                String fileName = file.getName();
                if (wpsExtensions.contains(IqaFileUtil.getFileExtension((String)fileName))) {
                    fileName = fileName + ".docx";
                }
                HashMap<String, Object> params = new HashMap<String, Object>();
                JSONObject data = jsonObject.getJSONObject("data");
                if (!HussarUtils.isNotEmpty((Object)data.getJSONObject("results")) || !HussarUtils.isNotEmpty((Object)(textJsonArray = data.getJSONObject("results").getJSONArray(fileName)))) continue;
                params.put("text", textJsonArray);
                params.put("image", data.getJSONObject("file_images").getJSONArray(fileName));
                params.put("text_spliter", param.get("text_spliter"));
                String fileExtension = IqaFileUtil.getFileExtension((String)file.getName());
                ParsingStrategy instance = parsingFactory.getInstance("RemoteParsingFor" + IqaFileUtil.capitalizeFirstLetter((String)fileExtension));
                resultMap.put(file.getName(), instance.fileToMap((File)convertFiles.get(i), params));
            }
        } else {
            HashMap map = new HashMap();
            LinkedHashMap<String, String> error = new LinkedHashMap<String, String>();
            error.put("code", jsonObject.getString("code"));
            map.put("error", error);
            resultMap.put("error", map);
        }
        return resultMap;
    }
}

