/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.strategy.docParsing.impl;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.strategy.docParsing.ParsingStrategy;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.opencsv.CSVReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="LocalParsingForCsv")
public class LocalParsingForCsv
implements ParsingStrategy {
    private static final Logger logger = LoggerFactory.getLogger(LocalParsingForCsv.class);

    @Override
    public HashMap<String, LinkedHashMap<String, String>> fileToMap(File file, HashMap<String, Object> params) {
        String fileName = file.getName();
        String path = file.getPath();
        HashMap<String, LinkedHashMap<String, String>> resultMap = new HashMap<String, LinkedHashMap<String, String>>();
        LinkedHashMap<String, String> textMap = new LinkedHashMap<String, String>();
        try {
            CSVReader reader = new CSVReader((Reader)new FileReader(path));
            ArrayList<String> headers = new ArrayList<String>();
            String[] nextLine = reader.readNext();
            if (nextLine != null) {
                for (String header : nextLine) {
                    if (!HussarUtils.isNotEmpty((Object)header)) continue;
                    headers.add(header);
                }
            }
            int headerLength = headers.size();
            int index = 0;
            while ((nextLine = reader.readNext()) != null) {
                ++index;
                int rowLength = nextLine.length;
                int maxLength = Math.max(headerLength, rowLength);
                StringBuilder rowBuilder = new StringBuilder();
                for (int i = 0; i < maxLength; ++i) {
                    String arrayItem;
                    String listItem = i < headers.size() ? (String)headers.get(i) : "";
                    String string = arrayItem = i < nextLine.length ? nextLine[i] : "";
                    if (!HussarUtils.isNotEmpty((Object)listItem) && !HussarUtils.isNotEmpty((Object)arrayItem)) continue;
                    rowBuilder.append(listItem).append(":").append(arrayItem).append("\n");
                }
                textMap.put(index + "", rowBuilder.toString());
            }
            resultMap.put("0", textMap);
            LinkedHashMap picTreeMap = new LinkedHashMap();
            resultMap.put("3", picTreeMap);
        }
        catch (Exception e) {
            throw new HussarException("csv\u6587\u6863+\u3010" + fileName + "\u3011\u52a0\u8f7d\u5f02\u5e38\uff01");
        }
        return resultMap;
    }

    public static void main(String[] args) throws Exception {
        File file = new File("D:\\ai_opportunity.csv");
        LocalParsingForCsv csv = new LocalParsingForCsv();
        HashMap<String, LinkedHashMap<String, String>> resultMap = csv.fileToMap(file, new HashMap<String, Object>());
    }
}

