/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.strategy.docHander.model;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.strategy.docHander.model.Element;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class TreeNode {
    private Element data;
    private TreeNode parent;
    private List<TreeNode> children;

    public TreeNode(Element data) {
        this.data = data;
        this.children = new ArrayList<TreeNode>();
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public Element getData() {
        return this.data;
    }

    public void setData(Element data) {
        this.data = data;
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public void setParent(TreeNode parent) {
        this.parent = parent;
    }

    public List<TreeNode> getChildren() {
        return this.children;
    }

    public void addChild(TreeNode child) {
        child.setParent(this);
        this.children.add(child);
    }

    public boolean removeChild(TreeNode child) {
        return this.children.remove(child);
    }

    public void updateData(Element newData) {
        this.data = newData;
    }

    public TreeNode findChild(Element data) {
        for (TreeNode child : this.children) {
            if (child.getData() != data) continue;
            return child;
        }
        return null;
    }

    public TreeNode getParentNode() {
        return this.parent;
    }

    public TreeNode getRoot() {
        TreeNode currentNode = this;
        while (currentNode.getParent() != null) {
            currentNode = currentNode.getParent();
        }
        return currentNode;
    }

    public void printTree(TreeNode node, String indent, boolean last) {
        System.out.print(indent);
        if (last) {
            System.out.print("\u2514\u2500\u2500 ");
            indent = indent + "    ";
        } else {
            System.out.print("\u251c\u2500\u2500 ");
            indent = indent + "|   ";
        }
        System.out.println(node.getData());
        int i = 0;
        for (TreeNode child : node.getChildren()) {
            boolean isLast = ++i == node.getChildren().size();
            this.printTree(child, indent, isLast);
        }
    }

    private void findLeafNodePaths(TreeNode node, List<Element> currentPath, List<List<Element>> contents) {
        if (node == null) {
            return;
        }
        currentPath.add(node.getData());
        if (node.getChildren().isEmpty()) {
            contents.add(new ArrayList<Element>(currentPath));
        } else {
            for (TreeNode child : node.getChildren()) {
                this.findLeafNodePaths(child, currentPath, contents);
            }
        }
        currentPath.remove(currentPath.size() - 1);
    }

    public void findLeafNodePathsByType(TreeNode node, List<Element> currentPath, Integer level, List<List<Element>> contents, Map<List<Element>, List<List<Element>>> contentsMap) {
        if (node == null) {
            return;
        }
        currentPath.add(node.getData());
        if (!node.getChildren().isEmpty()) {
            for (TreeNode child : node.getChildren()) {
                ArrayList<Element> key;
                if (Objects.equals(child.getData().getLevel(), level)) {
                    this.findLeafNodePaths(child, currentPath, contents);
                    key = new ArrayList<Element>(currentPath);
                    key.add(child.getData());
                    if (HussarUtils.isNotEmpty(contentsMap.get(key))) {
                        contentsMap.get(key).addAll(new ArrayList<List<Element>>(new ArrayList<List<Element>>(contents)));
                    } else {
                        contentsMap.put(key, new ArrayList<List<Element>>(new ArrayList<List<Element>>(contents)));
                    }
                    contents.clear();
                    continue;
                }
                if (child.getData().getLevel() > level) {
                    this.findLeafNodePaths(child, currentPath, contents);
                    key = new ArrayList<Element>(currentPath);
                    if (HussarUtils.isNotEmpty(contentsMap.get(key))) {
                        contentsMap.get(key).addAll(new ArrayList<List<Element>>(new ArrayList<List<Element>>(contents)));
                    } else {
                        contentsMap.put(key, new ArrayList<List<Element>>(new ArrayList<List<Element>>(contents)));
                    }
                    contents.clear();
                    continue;
                }
                this.findLeafNodePathsByType(child, currentPath, level, contents, contentsMap);
            }
        } else {
            ArrayList<Element> key = new ArrayList<Element>(currentPath);
            contentsMap.put(key, new ArrayList<List<Element>>(new ArrayList<List<Element>>(contents)));
        }
        currentPath.remove(currentPath.size() - 1);
    }

    public int maxDepth(TreeNode root) {
        if (root == null) {
            return 0;
        }
        int max = 0;
        for (TreeNode child : root.children) {
            max = Math.max(max, this.maxDepth(child));
        }
        return max + 1;
    }

    public static void main(String[] args) {
        TreeNode root = new TreeNode(new Element(1, "a", "1", 1));
        TreeNode child1 = new TreeNode(new Element(2, "b", "0", 2));
        TreeNode child2 = new TreeNode(new Element(3, "c", "2", 2));
        TreeNode child4 = new TreeNode(new Element(4, "d", "0", 3));
        TreeNode child3 = new TreeNode(new Element(5, "e", "1", 9));
        TreeNode child5 = new TreeNode(new Element(6, "f", "2", 9));
        TreeNode child6 = new TreeNode(new Element(7, "g", "1", 9));
        TreeNode child7 = new TreeNode(new Element(8, "h", "0", 9));
        root.addChild(child2);
        root.addChild(child1);
        child2.addChild(child4);
        child2.addChild(child6);
        child2.addChild(child7);
        child4.addChild(child5);
        child1.addChild(child3);
        root.printTree(root, "", false);
        ArrayList<List<Element>> list = new ArrayList<List<Element>>();
        root.findLeafNodePaths(child6, new ArrayList<Element>(), list);
        list.forEach((Consumer<List<Element>>)((Consumer<List>)System.out::println));
        HashMap<List<Element>, List<List<Element>>> contentsMap = new HashMap<List<Element>, List<List<Element>>>();
        root.findLeafNodePathsByType(root, new ArrayList<Element>(), 8, new ArrayList<List<Element>>(), contentsMap);
        System.out.println("----");
        contentsMap.forEach((k, v) -> System.out.println(k + ":" + v));
    }
}

