/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.strategy.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.poi.xwpf.usermodel.BodyElementType;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LatexUtil {
    private static final Logger log = LoggerFactory.getLogger(LatexUtil.class);

    public static void main(String[] args) throws Exception {
        LatexUtil.wordAnalysis(new FileInputStream("C:\\Users\\25350\\Desktop\\doc1.docx"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void wordAnalysis(InputStream inputStream) throws Exception {
        try (XWPFDocument word = new XWPFDocument(inputStream);){
            for (IBodyElement ibodyelement : word.getBodyElements()) {
                if (ibodyelement.getElementType().equals((Object)BodyElementType.PARAGRAPH)) {
                    XWPFParagraph paragraph = (XWPFParagraph)ibodyelement;
                    String string = LatexUtil.parseParagraph(paragraph);
                    continue;
                }
                if (!ibodyelement.getElementType().equals((Object)BodyElementType.TABLE)) continue;
                XWPFTable table = (XWPFTable)ibodyelement;
                for (XWPFTableRow row : table.getRows()) {
                    for (XWPFTableCell cell : row.getTableCells()) {
                        ArrayList<String> cellMath = new ArrayList<String>(16);
                        for (XWPFParagraph paragraph : cell.getParagraphs()) {
                            String paragraphStr = LatexUtil.parseParagraph(paragraph);
                            if ("".equals(paragraphStr.trim())) continue;
                            cellMath.add(paragraphStr);
                        }
                        log.info("\u5f53\u524dcell\u6709{}\u4e2a\u516c\u5f0f", (Object)cellMath.size());
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getFormulaMap(InputStream inputStream) throws IOException, DocumentException {
        HashMap result = new HashMap();
        ArrayList<String> mathMLList = new ArrayList<String>(16);
        try (XWPFDocument word = new XWPFDocument(inputStream);){
            for (IBodyElement ibodyelement : word.getBodyElements()) {
                if (ibodyelement.getElementType().equals((Object)BodyElementType.PARAGRAPH)) {
                    XWPFParagraph paragraph = (XWPFParagraph)ibodyelement;
                    List<String> mathList = LatexUtil.parseMathParagraph(paragraph);
                    mathMLList.addAll(mathList);
                    continue;
                }
                if (!ibodyelement.getElementType().equals((Object)BodyElementType.TABLE)) continue;
                XWPFTable table = (XWPFTable)ibodyelement;
                for (XWPFTableRow row : table.getRows()) {
                    for (XWPFTableCell cell : row.getTableCells()) {
                        ArrayList cellMath = new ArrayList(16);
                        for (XWPFParagraph paragraph : cell.getParagraphs()) {
                            List<String> mathList = LatexUtil.parseMathParagraph(paragraph);
                            mathMLList.addAll(mathList);
                        }
                    }
                }
            }
        }
        log.info("\u5f53\u524d\u6587\u6863\u4e00\u5171\u6709{}\u4e2a\u516c\u5f0f", (Object)mathMLList.size());
        return mathMLList;
    }

    public static List<String> parseMathParagraph(XWPFParagraph xwpfParagraph) throws DocumentException {
        CTP ctp = xwpfParagraph.getCTP();
        String xmlText = ctp.xmlText();
        ArrayList<String> mathList = new ArrayList<String>();
        if (xmlText.contains("<m:oMath>")) {
            SAXReader saxReader = new SAXReader();
            Document doc = saxReader.read((InputStream)new ByteArrayInputStream(xmlText.getBytes()));
            Element root = doc.getRootElement();
            List omMaths = root.selectNodes("//m:oMath");
            for (Node ele : omMaths) {
                String xml = ele.asXML();
                String mml = LatexUtil.convertOMML2MML(xml);
                String latex = LatexUtil.convertMML2Latex(mml);
                mathList.add(latex);
                log.info("late\u8868\u8fbe\u5f0f\uff1a{}", (Object)latex);
            }
        }
        return mathList;
    }

    public static String parseParagraph(XWPFParagraph xwpfParagraph) {
        List omMaths;
        CTP ctp = xwpfParagraph.getCTP();
        String xmlText = ctp.xmlText();
        StringBuilder sb = new StringBuilder();
        sb.append(xwpfParagraph.getParagraphText());
        SAXReader saxReader = new SAXReader();
        Document doc = null;
        try {
            doc = saxReader.read((InputStream)new ByteArrayInputStream(xmlText.getBytes()));
        }
        catch (DocumentException e) {
            throw new RuntimeException(e);
        }
        Element root = doc.getRootElement();
        HashMap<String, String> nsMap = new HashMap<String, String>();
        for (Object ns : root.declaredNamespaces()) {
            if (!(ns instanceof Namespace)) continue;
            Namespace n = (Namespace)ns;
            nsMap.put(n.getPrefix(), n.getURI());
        }
        if (!nsMap.containsKey("m")) {
            root.add(new Namespace("m", "http://schemas.openxmlformats.org/officeDocument/2006/math"));
        }
        if ((omMaths = root.selectNodes("//m:oMath")) != null && !omMaths.isEmpty()) {
            for (Node ele : omMaths) {
                String xml = ele.asXML();
                String mathml = LatexUtil.convertOMML2MML(xml);
                String latex = LatexUtil.convertMML2Latex(mathml);
                sb.append("$").append(latex).append("$");
                log.info("latex\u8868\u8fbe\u5f0f\uff1a{}", (Object)latex);
            }
        }
        log.info("\u516c\u5f0f\u4e2a\u6570\uff1a{},\u89e3\u6790\u5185\u5bb9\uff1a{}", (Object)omMaths.size(), (Object)sb.toString());
        return sb.toString();
    }

    public static String xslConvert(String s, String xslpath, URIResolver uriResolver) {
        TransformerFactory tFac = TransformerFactory.newInstance();
        if (uriResolver != null) {
            tFac.setURIResolver(uriResolver);
        }
        StreamSource xslSource = new StreamSource(LatexUtil.class.getResourceAsStream(xslpath));
        StringWriter writer = new StringWriter();
        try {
            Transformer t = tFac.newTransformer(xslSource);
            StreamSource source = new StreamSource(new StringReader(s));
            StreamResult result = new StreamResult(writer);
            t.transform(source, result);
        }
        catch (TransformerException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return writer.getBuffer().toString();
    }

    public static String convertMML2Latex(String mml) {
        URIResolver r;
        String latex = LatexUtil.xslConvert(mml = mml.substring(mml.indexOf("?>") + 2, mml.length()), "/conventer/mml2tex/mmltex.xsl", r = new URIResolver(){

            @Override
            public Source resolve(String href, String base) throws TransformerException {
                File f = new File("/conventer/mml2tex/" + href);
                InputStream inputStream = LatexUtil.class.getResourceAsStream("/conventer/mml2tex/" + href);
                return new StreamSource(inputStream);
            }
        });
        if (latex != null && latex.length() > 1) {
            latex = latex.substring(1, latex.length() - 1);
        }
        return latex;
    }

    public static String convertOMML2MML(String xml) {
        String result = LatexUtil.xslConvert(xml, "/OMML2MML.XSL", null);
        return result;
    }
}

