/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.strategy.util;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.strategy.docHander.model.Element;
import com.jxdinfo.hussar.strategy.docHander.model.RegexModel;
import com.jxdinfo.hussar.strategy.docHander.model.TreeNode;
import com.jxdinfo.hussar.strategy.docHander.model.WordNumbering;
import com.jxdinfo.hussar.strategy.docHander.model.WordNumberingValue;
import com.jxdinfo.hussar.strategy.util.NumberConverter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;

public class CommonUtil {
    public static final String PIC_SEPARATE = "<picSeparate/>";

    public static HashMap<String, LinkedHashMap<String, String>> treeToMap(String fileName, int splitLevel, Map<List<Element>, List<List<Element>>> contentsMap, String prefix) {
        HashMap<String, LinkedHashMap<String, String>> result = new HashMap<String, LinkedHashMap<String, String>>();
        int i = 0;
        for (List<Element> keys : contentsMap.keySet()) {
            HashMap<String, String> map;
            ++i;
            List<List<Element>> vals = contentsMap.get(keys);
            if (splitLevel == 9) {
                map = CommonUtil.joinLastElements(vals, vals.get(0).size() - 1, fileName);
                LinkedHashMap<String, String> textTreeMap = new LinkedHashMap<String, String>();
                if (HussarUtils.isNotEmpty((Object)map.get("\u6bb5\u843d9999"))) {
                    for (String key : map.keySet()) {
                        if (!key.contains("\u6bb5\u843d")) continue;
                        textTreeMap.put(prefix + CommonUtil.joinWithSeparator(keys, " ") + "\u3002-" + i, map.get(key));
                        ++i;
                    }
                }
                if (HussarUtils.isNotEmpty(textTreeMap)) {
                    if (result.containsKey("0")) {
                        result.get("0").putAll(textTreeMap);
                    } else {
                        result.put("0", textTreeMap);
                    }
                }
                map.remove("0");
                if (!HussarUtils.isNotEmpty(map)) continue;
                if (result.containsKey("3")) {
                    result.get("3").putAll(map);
                    continue;
                }
                result.put("3", new LinkedHashMap<String, String>(map));
                continue;
            }
            map = CommonUtil.joinLastElements(vals, keys.size(), fileName);
            LinkedHashMap<String, String> picTreeMap = new LinkedHashMap<String, String>();
            if (HussarUtils.isNotEmpty((Object)map.get(fileName))) {
                picTreeMap.put(fileName, map.get(fileName));
            }
            if (HussarUtils.isNotEmpty(picTreeMap)) {
                if (result.containsKey("images_el")) {
                    result.get("images_el").putAll(picTreeMap);
                } else {
                    result.put("images_el", picTreeMap);
                }
            }
            LinkedHashMap<String, String> textTreeMap = new LinkedHashMap<String, String>();
            if (HussarUtils.isNotEmpty((Object)map.get("\u6bb5\u843d9999"))) {
                for (String key : map.keySet()) {
                    if (!key.contains("\u6bb5\u843d")) continue;
                    textTreeMap.put(prefix + CommonUtil.joinWithSeparatorLast(keys, " ") + "\u3002-" + i, map.get(key));
                    ++i;
                }
            }
            if (HussarUtils.isNotEmpty(textTreeMap)) {
                if (result.containsKey("0")) {
                    result.get("0").putAll(textTreeMap);
                } else {
                    result.put("0", textTreeMap);
                }
            }
            map.remove("0");
            if (!HussarUtils.isNotEmpty(map)) continue;
            if (result.containsKey("3")) {
                result.get("3").putAll(map);
                continue;
            }
            result.put("3", new LinkedHashMap<String, String>(map));
        }
        return result;
    }

    private static String joinWithSeparatorLast(List<Element> list, String separator) {
        if (list.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < list.size(); ++i) {
            sb.append(list.get(i).getContent());
            if (i >= list.size() - 1) continue;
            sb.append(separator);
        }
        Element element = list.get(list.size() - 1);
        if ("3".equals(element.getType())) {
            sb.append(separator).append(element.getContent().split(PIC_SEPARATE)[0]);
        }
        return sb.toString();
    }

    private static String joinWithSeparator(List<Element> list, String separator) {
        if (list.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < list.size() - 1; ++i) {
            sb.append(list.get(i).getContent());
            if (i >= list.size() - 2) continue;
            sb.append(separator);
        }
        Element element = list.get(list.size() - 1);
        if ("3".equals(element.getType())) {
            sb.append(separator).append(element.getContent().split(PIC_SEPARATE)[0]);
        }
        return sb.toString();
    }

    private static HashMap<String, String> joinLastElements(List<List<Element>> lists, int n, String fileName) {
        HashMap<String, String> result = new HashMap<String, String>();
        StringBuilder sb = new StringBuilder();
        ArrayList picStrList = new ArrayList();
        int m = 0;
        for (List<Element> sublist : lists) {
            ++m;
            StringBuilder picSb = new StringBuilder();
            int size = sublist.size();
            int start = Math.max(0, n);
            if (sb.length() > 0) {
                sb.append(System.lineSeparator());
            }
            if (picSb.length() > 0) {
                picSb.append(System.lineSeparator());
            }
            for (int i = start; i < size; ++i) {
                if (i > start) {
                    sb.append(" ");
                    picSb.append(" ");
                }
                Element element = sublist.get(i);
                String picPrefix = "";
                String picSuffix = "";
                if ("3".equals(element.getType()) && element.getContent().contains(PIC_SEPARATE)) {
                    String[] split;
                    Element we;
                    for (int j = i - 1; j >= 0; --j) {
                        we = sublist.get(j);
                        if (Objects.equals(we.getType(), "3")) continue;
                        picPrefix = we.getContent();
                        break;
                    }
                    for (int k = i + 1; k < size; ++k) {
                        we = sublist.get(k);
                        if (Objects.equals(we.getType(), "3")) continue;
                        picSuffix = we.getContent();
                        break;
                    }
                    if ((split = element.getContent().split(PIC_SEPARATE)).length > 2) {
                        picSb.append(picPrefix).append("<imagetxt>").append(split[0]).append("</imagetxt>").append("<image>").append(split[1]).append("</image>").append(picSuffix);
                        result.put(split[1], split[2]);
                    } else {
                        picSb.append(picPrefix).append("<image>").append(split[0]).append("</image>").append(picSuffix);
                        result.put(split[0], split[1]);
                    }
                    sb.append((CharSequence)picSb);
                    continue;
                }
                String content = element.getContent();
                if (sb.length() + content.length() > 1000 && !sb.toString().trim().isEmpty()) {
                    result.put("\u6bb5\u843d" + m, sb.toString());
                    sb = new StringBuilder();
                }
                sb.append(content);
            }
        }
        result.put("\u6bb5\u843d9999", HussarUtils.isNotEmpty((Object)sb.toString().trim()) ? sb.toString().trim() : "---");
        result.put(fileName, JSONObject.toJSONString(picStrList));
        return CommonUtil.sortHashMapWithStream(result);
    }

    public static LinkedHashMap<String, String> sortHashMapWithStream(HashMap<String, String> map) {
        return map.entrySet().stream().sorted(Comparator.comparing(entry -> {
            String key = (String)entry.getKey();
            if (key.startsWith("\u6bb5\u843d")) {
                return CommonUtil.extractNumber(key);
            }
            return Integer.MAX_VALUE;
        })).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
    }

    private static int extractNumber(String key) {
        String numberPart = key.replaceAll("[^0-9]", "");
        return numberPart.isEmpty() ? 0 : Integer.parseInt(numberPart);
    }

    public static int getTitleLevel(XWPFDocument doc, XWPFParagraph para) {
        String style = para.getStyleID();
        if (style == null) {
            return 0;
        }
        String name = doc.getStyles().getStyle(style).getName();
        if (name != null && name.startsWith("heading")) {
            return Integer.parseInt(name.replaceAll("\\D", ""));
        }
        return 0;
    }

    public static RegexModel getPatterLevel(String content, LinkedHashMap<String, Integer> patterMap) {
        if (!CommonUtil.isTitle(content).booleanValue()) {
            return new RegexModel(0, content, null);
        }
        LinkedHashMap<String, Integer> reverseMap = new LinkedHashMap<String, Integer>();
        ArrayList<String> keys = new ArrayList<String>(patterMap.keySet());
        for (int i = keys.size() - 1; i >= 0; --i) {
            String key = (String)keys.get(i);
            Integer value = patterMap.get(key);
            reverseMap.put(key, value);
        }
        for (Map.Entry entry : reverseMap.entrySet()) {
            Pattern compile = Pattern.compile((String)entry.getKey());
            Matcher matcher = compile.matcher(content);
            if (!matcher.find()) continue;
            return new RegexModel((Integer)entry.getValue(), matcher.group(0), content.substring(matcher.group(0).length()));
        }
        return new RegexModel(0, content, null);
    }

    private static Boolean isTitle(String content) {
        String[] symbols;
        boolean flag = false;
        for (String symbol : symbols = new String[]{" ", "\u3000"}) {
            int idx = content.indexOf(symbol);
            if (idx == -1) continue;
            flag = true;
            break;
        }
        String noTitle1 = "^\\d+(\\.\\d+)? ?([a-zA-Z]{1,3}|\u514b|\u5343\u514b|\u5428|\u516c\u65a4|\u65a4|\u7c73|\u5343\u7c73|\u5398\u7c73|\u6beb\u7c73|\u5e74|\u6708|\u65e5|\u5c0f\u65f6|\u65f6|\u5206\u949f|\u5206|\u79d2|\u6beb\u79d2|\u00b0|\u2103)$";
        String noTitle2 = "^\\d+(\\.\\d+) ??[~-\u2014\u2014\u81f3] ?\\d+(\\.\\d+)?([a-zA-Z]{1,3}|\u514b|\u5343\u514b|\u5428|\u516c\u65a4|\u65a4|\u7c73|\u5343\u7c73|\u5398\u7c73|\u6beb\u7c73)?$";
        String noTitle3 = "^\\s*\\d{4}\\s*[-~:\u2014\u2014]?\\s*\\d{1,2}\\s*[-~:\u2014\u2014]?\\s*\\d{1,2}\\s*|\\s*\\d{4}\\s*[-~:\u2014\u2014]?\\s*\\d{1,2}\\s*|\\s*\\d{4}\\s*|\\s*\\d{1,2}\\s*[-~:\u2014\u2014]?\\s*\\d{1,2}\\s*|\\s*\\d{1,2}\\s*$";
        String noTitle4 = ".*[\uff0c\u3002\uff1b\u3001\uff1f?,.;]";
        String noTitle5 = "^\\d{2,4}\\s*\u5e74?\\s*\\d{1,2}\\s*\u6708?\\s*\\d{1,2}\\s*\u65e5?$|^\\d{2,4}\\s*\u5e74?\\s*\\d{1,2}\\s*\u6708?$|^\\d{2,4}\\s*\u5e74?$|^\\d{1,2}\\s*\u6708?\\s*\\d{1,2}\\s*\u65e5?$|^\\d{1,2}\\s*\u6708?$|^\\d{1,2}\\s*\u65e5?$";
        String noTitle6 = "^\\d+(\\.\\d+)?\\s*(m|cm|mm|km|in|ft|yd|g|kg|lb|oz|s|min|h|d|y|c|f|k|l|ml|gal|v|a|w|hz|\u514b|\u5343\u514b|\u5428|\u516c\u65a4|\u65a4|\u7c73|\u5343\u7c73|\u5398\u7c73|\u6beb\u7c73|\u5e74|\u6708|\u65e5|\u5c0f\u65f6|\u65f6|\u5206\u949f|\u5206|\u79d2|\u6beb\u79d2|\u00b0|\u2103).*";
        return !(!flag && content.matches(noTitle4) || !flag && content.length() > 30 || content.matches(noTitle1) || content.matches(noTitle2) || content.matches(noTitle3) || content.matches(noTitle5) || content.matches(noTitle6));
    }

    private static Boolean isTitleFlag(String content, LinkedHashMap<String, Integer> patterMap) {
        boolean flag = false;
        ArrayList<String> keys = new ArrayList<String>(patterMap.keySet());
        ArrayList<String> symbols = new ArrayList<String>();
        symbols.add(" ");
        symbols.add("\u3000");
        for (String key : keys) {
            if (key.endsWith(".*")) continue;
            symbols.add(key.substring(key.length() - 1));
        }
        for (String symbol : symbols) {
            int idx = content.indexOf(symbol);
            if (idx == -1) continue;
            flag = true;
            break;
        }
        String noTitle1 = "^\\d+(\\.\\d+)? ?([a-zA-Z]{1,3}|\u514b|\u5343\u514b|\u5428|\u516c\u65a4|\u65a4|\u7c73|\u5343\u7c73|\u5398\u7c73|\u6beb\u7c73|\u5e74|\u6708|\u65e5|\u5c0f\u65f6|\u65f6|\u5206\u949f|\u5206|\u79d2|\u6beb\u79d2|\u00b0|\u2103)$";
        String noTitle2 = "^\\d+(\\.\\d+) ??[~-\u2014\u2014\u81f3] ?\\d+(\\.\\d+)?([a-zA-Z]{1,3}|\u514b|\u5343\u514b|\u5428|\u516c\u65a4|\u65a4|\u7c73|\u5343\u7c73|\u5398\u7c73|\u6beb\u7c73)?$";
        String noTitle3 = "^\\s*\\d{4}\\s*[-~:\u2014\u2014]?\\s*\\d{1,2}\\s*[-~:\u2014\u2014]?\\s*\\d{1,2}\\s*|\\s*\\d{4}\\s*[-~:\u2014\u2014]?\\s*\\d{1,2}\\s*|\\s*\\d{4}\\s*|\\s*\\d{1,2}\\s*[-~:\u2014\u2014]?\\s*\\d{1,2}\\s*|\\s*\\d{1,2}\\s*$";
        String noTitle4 = ".*[\uff0c\u3002\uff1b\u3001\uff1f?,.;]";
        String noTitle5 = "^\\d{2,4}\\s*\u5e74?\\s*\\d{1,2}\\s*\u6708?\\s*\\d{1,2}\\s*\u65e5?$|^\\d{2,4}\\s*\u5e74?\\s*\\d{1,2}\\s*\u6708?$|^\\d{2,4}\\s*\u5e74?$|^\\d{1,2}\\s*\u6708?\\s*\\d{1,2}\\s*\u65e5?$|^\\d{1,2}\\s*\u6708?$|^\\d{1,2}\\s*\u65e5?$";
        String noTitle6 = "^\\d+(\\.\\d+)?\\s*(m|cm|mm|km|in|ft|yd|g|kg|lb|oz|s|min|h|d|y|c|f|k|l|ml|gal|v|a|w|hz|\u514b|\u5343\u514b|\u5428|\u516c\u65a4|\u65a4|\u7c73|\u5343\u7c73|\u5398\u7c73|\u6beb\u7c73|\u5e74|\u6708|\u65e5|\u5c0f\u65f6|\u65f6|\u5206\u949f|\u5206|\u79d2|\u6beb\u79d2|\u00b0|\u2103).*";
        return !(!flag && content.matches(noTitle4) || !flag && content.length() > 30 || content.matches(noTitle1) || content.matches(noTitle2) || content.matches(noTitle3) || content.matches(noTitle5) || content.matches(noTitle6));
    }

    public static void assembleTree(TreeNode root, Integer pLevel, List<String> elements, LinkedHashMap<String, Integer> patterMap) {
        int id = 0;
        for (String paragraphText : elements) {
            String content;
            RegexModel regexModel = CommonUtil.getPatterLevel(paragraphText, patterMap);
            Integer level = regexModel.getLevel();
            paragraphText = regexModel.getTitle();
            if (level == 0) {
                root.addChild(new TreeNode(new Element(id++, paragraphText, paragraphText.contains("<image>") ? "3" : "0", 9)));
            } else if (level > pLevel) {
                TreeNode treeNode = new TreeNode(new Element(id++, paragraphText, paragraphText.contains("<image>") ? "3" : "0", level));
                root.addChild(treeNode);
                root = treeNode;
                pLevel = level;
            } else if (level.equals(pLevel)) {
                TreeNode child = new TreeNode(new Element(id++, paragraphText, paragraphText.contains("<image>") ? "3" : "0", level));
                root.getParentNode().addChild(child);
                root = child;
            } else {
                TreeNode node = new TreeNode(new Element(id++, paragraphText, paragraphText.contains("<image>") ? "3" : "0", level));
                while (HussarUtils.isNotEmpty((Object)root.getParentNode())) {
                    if (level < root.getParentNode().getData().getLevel()) {
                        root = root.getParentNode();
                        continue;
                    }
                    root = HussarUtils.isNotEmpty((Object)root.getParentNode().getParentNode()) ? root.getParentNode().getParentNode() : root.getParentNode();
                    root.addChild(node);
                    break;
                }
                root = node;
                pLevel = level;
            }
            if (!HussarUtils.isNotEmpty((Object)(content = regexModel.getContent()))) continue;
            root.addChild(new TreeNode(new Element(id++, content, paragraphText.contains("<image>") ? "3" : "0", 9)));
        }
    }

    public static LinkedHashMap<String, Integer> getDefaultPatternMap() {
        return new LinkedHashMap<String, Integer>(){
            {
                this.put("^(\\d[a-zA-Z\\u4e00-\\u9fa5]+|\u7b2c([\u96f6\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341])+\u7ae0.*+|([\u96f6\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341])+\u3001|\u7b2c([\u96f6\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341])+\u90e8\u5206\\s+).*", 1);
                this.put("[0-9]+\\.[0-9]+[ a-zA-Z\\u4e00-\\u9fa5]+", 2);
                this.put("[0-9]+\\.[0-9]+\\.[0-9]+[ a-zA-Z\\u4e00-\\u9fa5]+", 3);
                this.put("[0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+[ a-zA-Z\\u4e00-\\u9fa5]+", 4);
                this.put("[0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+[ a-zA-Z\\u4e00-\\u9fa5]+", 5);
                this.put("[0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+[ a-zA-Z\\u4e00-\\u9fa5]+", 6);
            }
        };
    }

    public static String replacePercent(HashMap<WordNumbering, WordNumberingValue> map, XWPFParagraph xwpfParagraph) {
        WordNumberingValue wordNumberingValue;
        BigInteger numID = xwpfParagraph.getNumID();
        String numLevelText = xwpfParagraph.getNumLevelText();
        String numFmt = xwpfParagraph.getNumFmt();
        BigInteger numIlvl = xwpfParagraph.getNumIlvl();
        if (numID == null || numLevelText == null || numFmt == null || numIlvl == null) {
            return "";
        }
        WordNumbering wordNumbering = new WordNumbering(numID, numIlvl);
        if (map.containsKey(wordNumbering)) {
            wordNumberingValue = map.get(wordNumbering);
            wordNumberingValue.setSeq(wordNumberingValue.getSeq() + 1);
            wordNumberingValue.setValue(NumberConverter.convertNumber(wordNumberingValue.getSeq(), numFmt));
        } else {
            wordNumberingValue = new WordNumberingValue(numFmt, numLevelText, NumberConverter.convertNumber(1, numFmt), 1);
            map.put(wordNumbering, wordNumberingValue);
        }
        WordNumbering wordNumberingAfter = new WordNumbering(numID, BigInteger.valueOf(numIlvl.intValue() + 1));
        while (map.containsKey(wordNumberingAfter)) {
            map.remove(wordNumberingAfter);
            wordNumberingAfter = new WordNumbering(numID, BigInteger.valueOf(wordNumberingAfter.getNumIlvl().intValue() + 1));
        }
        for (int i = numIlvl.intValue(); i >= 0; --i) {
            String maxNumberedPercent = CommonUtil.findMaxPercent(numLevelText);
            WordNumberingValue wordNumberingValue2 = map.get(new WordNumbering(numID, BigInteger.valueOf(i)));
            if (!HussarUtils.isNotEmpty((Object)wordNumberingValue2) || !HussarUtils.isNotEmpty((Object)maxNumberedPercent)) continue;
            numLevelText = numLevelText.replace(maxNumberedPercent, wordNumberingValue2.getValue());
        }
        numLevelText = CommonUtil.replacePercentNumbers(numLevelText, NumberConverter.convertNumber(1, numFmt));
        return numLevelText;
    }

    public static String findMaxPercent(String str) {
        Pattern pattern = Pattern.compile("%(\\d+)");
        Matcher matcher = pattern.matcher(str);
        int maxPercentValue = -1;
        String maxPercentStr = "";
        while (matcher.find()) {
            int percentValue = Integer.parseInt(matcher.group(1));
            if (percentValue <= maxPercentValue) continue;
            maxPercentValue = percentValue;
            maxPercentStr = matcher.group();
        }
        return maxPercentStr;
    }

    private static String replacePercentNumbers(String input, String replacement) {
        Pattern pattern = Pattern.compile("%(\\d+)");
        Matcher matcher = pattern.matcher(input);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(result, replacement);
        }
        matcher.appendTail(result);
        return result.toString();
    }
}

