/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.strategy.docHander.impl;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.strategy.docHander.WordExtractorService;
import com.jxdinfo.hussar.strategy.docHander.model.WordContent;
import com.jxdinfo.hussar.strategy.docHander.model.WordTable;
import com.jxdinfo.hussar.strategy.docHander.model.WordTableCell;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.usermodel.Paragraph;
import org.apache.poi.hwpf.usermodel.Range;
import org.apache.poi.hwpf.usermodel.Table;
import org.apache.poi.hwpf.usermodel.TableCell;
import org.apache.poi.hwpf.usermodel.TableIterator;
import org.apache.poi.hwpf.usermodel.TableRow;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblGridCol;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblWidth;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTrPr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WordExtractorServiceImpl
implements WordExtractorService {
    private static final Logger log = LoggerFactory.getLogger(WordExtractorServiceImpl.class);
    private static final int DEFAULT_HEIGHT = 500;
    private static final int DEFAULT_WIDTH = 1000;
    private static final int DEFAULT_DIV = 1;
    private static final Float DEFAULT_FONT_SIZE = Float.valueOf(12.0f);
    private static final String WORD_BLANK = "[\u00a0|\u3000| |\b|\t]";
    private static final String WORD_LINE_BREAK = "[\u000b|\r]";
    private static final String WORD_TABLE_FILTER = "[\\t|\\n|\\r|\\s+|\u00a0+]";
    private static final Float TABLE_EXCURSION = Float.valueOf(5.0f);
    private static final String splitter = "[\\t|\\n|\\r|\\s+|\u00a0+]";
    private static final String regexClearBeginBlank = "^[\\t|\\n|\\r|\\s+|\u00a0+]*|[\\t|\\n|\\r|\\s+|\u00a0+]*$";

    @Override
    public WordContent adaptDocxToPdfTable(InputStream inputStream) throws IOException {
        XWPFDocument docx = new XWPFDocument(inputStream);
        return this.getWordContentByDocx(docx);
    }

    @Override
    public WordContent adaptDocToPdfTable(File file) throws IOException {
        HWPFDocument doc = new HWPFDocument((InputStream)new FileInputStream(file.getAbsoluteFile()));
        return this.getWordContentByDoc(doc);
    }

    @Override
    public WordContent adaptDocxToPdfTable(BufferedInputStream in) throws IOException {
        XWPFDocument docx = new XWPFDocument((InputStream)in);
        return this.getWordContentByDocx(docx);
    }

    @Override
    public WordContent adaptDocToPdfTable(BufferedInputStream in) throws IOException {
        HWPFDocument doc = new HWPFDocument((InputStream)in);
        return this.getWordContentByDoc(doc);
    }

    private WordContent getWordContentByDoc(HWPFDocument doc) throws IOException {
        Pair<String, List<WordTable>> pair = this.getDocTableCell(doc);
        WordContent wordContent = new WordContent();
        wordContent.setText((String)pair.getLeft());
        wordContent.setWordTableList((List)pair.getRight());
        return wordContent;
    }

    private WordContent getWordContentByDocx(XWPFDocument docx) throws IOException {
        Pair<String, List<WordTable>> pair = this.getDocxTableCell(docx);
        WordContent wordContent = new WordContent();
        wordContent.setText((String)pair.getLeft());
        wordContent.setWordTableList((List)pair.getRight());
        return wordContent;
    }

    private Pair<String, List<WordTable>> getDocTableCell(HWPFDocument doc) {
        ArrayList<WordTable> allWordTableCellList = new ArrayList<WordTable>();
        Range range = doc.getRange();
        TableIterator it = new TableIterator(range);
        while (it.hasNext()) {
            Table table = it.next();
            WordTable wordTable = new WordTable();
            ArrayList<WordTableCell> wordTableCellList = new ArrayList<WordTableCell>();
            float x = 0.0f;
            float y = 0.0f;
            for (int i = 0; i < table.numRows(); ++i) {
                TableRow tableRow = table.getRow(i);
                int currentRowHeight = this.getDocRowHeight(table, i) / 1;
                for (int j = 0; j < tableRow.numCells(); ++j) {
                    TableCell cell = tableRow.getCell(j);
                    int width = cell.getWidth() / 1;
                    if (!this.docIsContinue(cell)) {
                        int height = this.docIsRestart(cell) ? currentRowHeight + this.getDocContinueRowHeight(table, i, j, 0) : currentRowHeight;
                        StringBuilder text = new StringBuilder();
                        for (int k = 0; k < cell.numParagraphs(); ++k) {
                            Paragraph para = cell.getParagraph(k);
                            text.append(para.text());
                        }
                        WordTableCell wordTableCell = this.buildWordCellContent(Float.valueOf(height), Float.valueOf(width), text.toString(), DEFAULT_FONT_SIZE, Float.valueOf(x), Float.valueOf(y));
                        wordTableCellList.add(wordTableCell);
                    }
                    x += (float)width;
                }
                if (i + 1 == table.numRows()) {
                    wordTable.setHeight(Float.valueOf(y));
                    wordTable.setWidth(Float.valueOf(x));
                }
                x = 0.0f;
                y += (float)currentRowHeight;
            }
            wordTable.setWordTableCellList(wordTableCellList);
            allWordTableCellList.add(wordTable);
        }
        allWordTableCellList.forEach(this::fillSpan);
        StringBuilder docText = new StringBuilder();
        for (int i = 0; i < range.numParagraphs(); ++i) {
            Paragraph paragraph = range.getParagraph(i);
            if (!paragraph.isInTable()) {
                String text = paragraph.text();
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)text)) continue;
                String textWithSameBlankAndBreak = text.replaceAll(WORD_BLANK, " ").replaceAll(WORD_LINE_BREAK, "\n");
                String clearBeginBlank = textWithSameBlankAndBreak.replaceAll(regexClearBeginBlank, "");
                docText.append(clearBeginBlank).append("\n");
                continue;
            }
            try {
                int index;
                int endIndex = index = i;
                StringBuilder tableOriginText = new StringBuilder(paragraph.text());
                while (index < range.numParagraphs()) {
                    Paragraph tableParagraph = range.getParagraph(index);
                    if (!tableParagraph.isInTable() || tableParagraph.getTableLevel() < 1) {
                        endIndex = index;
                        break;
                    }
                    tableOriginText.append(tableParagraph.text());
                    ++index;
                }
                i = endIndex - 1;
                String string = tableOriginText.toString().replaceAll("[\\t|\\n|\\r|\\s+|\u00a0+]", "");
                continue;
            }
            catch (Exception e) {
                throw new HussarException("doc\u62bd\u8868\u6570\u636e\u4e0e\u5bf9\u5e94\u7684\u8868\u683c\u4f4d\u7f6e\u4e0d\u4e00\u81f4");
            }
        }
        return Pair.of((Object)docText.toString(), allWordTableCellList);
    }

    private Pair<String, List<WordTable>> getDocxTableCell(XWPFDocument docx) {
        ArrayList<WordTable> allWordTableCellList = new ArrayList<WordTable>();
        Iterator it = docx.getTablesIterator();
        ArrayList originTableTextList = new ArrayList();
        while (it.hasNext()) {
            try {
                int i;
                XWPFTable table = (XWPFTable)it.next();
                WordTable wordTable = new WordTable();
                ArrayList<WordTableCell> wordTableCellList = new ArrayList<WordTableCell>();
                float x = 0.0f;
                float y = 0.0f;
                boolean isTblGridExist = true;
                List tableGridColList = null;
                int tableHeaderCount = 0;
                int gridWidthStart = 0;
                int gridWidthEnd = 0;
                int totalGridWidth = 0;
                try {
                    tableGridColList = table.getCTTbl().getTblGrid().getGridColList();
                    for (CTTblGridCol ctTblGridCol : tableGridColList) {
                        totalGridWidth += ctTblGridCol.getW().intValue();
                    }
                    tableHeaderCount = tableGridColList.size();
                    gridWidthStart = ((CTTblGridCol)tableGridColList.get(0)).getW().intValue();
                    gridWidthEnd = ((CTTblGridCol)tableGridColList.get(tableHeaderCount - 1)).getW().intValue();
                }
                catch (Exception e) {
                    log.info("\u8be5docx\u8868\u683c\u65e0\u8fb9\u6846");
                    isTblGridExist = false;
                }
                if (isTblGridExist) {
                    for (i = 0; i < table.getNumberOfRows(); ++i) {
                        int colNums = table.getRow(i).getTableCells().size();
                        CTTrPr trPr = table.getRow(i).getCtRow().getTrPr();
                        float totalWidth = 0.0f;
                        for (int l = 0; l < colNums; ++l) {
                            XWPFTableCell cell = table.getRow(i).getCell(l);
                            totalWidth += (float)cell.getWidth();
                        }
                        int currentRowHeight = this.getDocxRowHeight(table, i) / 1;
                        boolean minCellNums = false;
                        for (int j = 0; j < colNums; ++j) {
                            List wAfterList;
                            WordTableCell wordTableCell;
                            int height;
                            List wBeforeList;
                            BigInteger girdSpanBigInteger;
                            XWPFTableCell cell = table.getRow(i).getCell(j);
                            int spanNumber = 1;
                            try {
                                girdSpanBigInteger = cell.getCTTc().getTcPr().getGridSpan().getVal();
                            }
                            catch (Exception e) {
                                girdSpanBigInteger = null;
                            }
                            if (girdSpanBigInteger != null) {
                                spanNumber = girdSpanBigInteger.intValue();
                            }
                            boolean widthByGrid = false;
                            int width = cell.getWidth();
                            if (HussarUtils.isNotEmpty((Object)trPr) && HussarUtils.isNotEmpty((Object)(wBeforeList = trPr.getWBeforeList()))) {
                                height = this.getDocxCellHeight(table, currentRowHeight, i, j);
                                wordTableCell = this.buildWordCellContent(Float.valueOf(height), Float.valueOf(((CTTblWidth)wBeforeList.get(0)).getW().intValue()), cell.getText(), DEFAULT_FONT_SIZE, Float.valueOf(x), Float.valueOf(y));
                                wordTableCellList.add(wordTableCell);
                                x += (float)gridWidthStart;
                            }
                            if (!this.docxIsContinue(cell)) {
                                int height2 = this.getDocxCellHeight(table, currentRowHeight, i, j);
                                WordTableCell wordTableCell2 = this.buildWordCellContent(Float.valueOf(height2), Float.valueOf(width), cell.getText(), DEFAULT_FONT_SIZE, Float.valueOf(x), Float.valueOf(y));
                                wordTableCellList.add(wordTableCell2);
                            }
                            x += (float)width;
                            if (!HussarUtils.isNotEmpty((Object)trPr) || !HussarUtils.isNotEmpty((Object)(wAfterList = trPr.getWAfterList())) || j != colNums - 1) continue;
                            height = this.getDocxCellHeight(table, currentRowHeight, i, j);
                            wordTableCell = this.buildWordCellContent(Float.valueOf(height), Float.valueOf(((CTTblWidth)wAfterList.get(0)).getW().intValue()), cell.getText(), DEFAULT_FONT_SIZE, Float.valueOf(x), Float.valueOf(y));
                            wordTableCellList.add(wordTableCell);
                            x += (float)gridWidthEnd;
                        }
                        if (i + 1 == table.getNumberOfRows()) {
                            wordTable.setHeight(Float.valueOf(y));
                            wordTable.setWidth(Float.valueOf(x));
                        }
                        x = 0.0f;
                        y += (float)currentRowHeight;
                    }
                } else {
                    for (i = 0; i < table.getNumberOfRows(); ++i) {
                        int colNums = table.getRow(i).getTableCells().size();
                        int currentRowHeight = this.getDocxRowHeight(table, i) / 1;
                        for (int j = 0; j < colNums; ++j) {
                            XWPFTableCell cell = table.getRow(i).getCell(j);
                            int width = this.getDocxCellWidth(table, i, j) / 1;
                            if (width <= 0) {
                                width = 1000;
                            }
                            if (!this.docxIsContinue(cell)) {
                                int height = this.getDocxCellHeight(table, currentRowHeight, i, j);
                                WordTableCell wordTableCell = this.buildWordCellContent(Float.valueOf(height), Float.valueOf(width), cell.getText(), DEFAULT_FONT_SIZE, Float.valueOf(x), Float.valueOf(y));
                                wordTableCellList.add(wordTableCell);
                            }
                            x += (float)width;
                        }
                        if (i + 1 == table.getNumberOfRows()) {
                            wordTable.setHeight(Float.valueOf(y));
                            wordTable.setWidth(Float.valueOf(x));
                        }
                        x = 0.0f;
                        y += (float)currentRowHeight;
                    }
                }
                wordTable.setWordTableCellList(wordTableCellList);
                allWordTableCellList.add(wordTable);
            }
            catch (Exception e) {
                log.error("docx\u8868\u683c\u89e3\u6790\u9519\u8bef", (Throwable)e);
                allWordTableCellList.add(null);
            }
        }
        allWordTableCellList.forEach(this::fillSpan);
        StringBuilder docxText = new StringBuilder();
        Iterator iter = docx.getBodyElementsIterator();
        int count = 0;
        while (iter.hasNext()) {
            IBodyElement element = (IBodyElement)iter.next();
            if (element instanceof XWPFParagraph) {
                XWPFParagraph paragraph = (XWPFParagraph)element;
                String text = paragraph.getText();
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)text)) continue;
                String textWithSameBlankAndBreak = text.replaceAll(WORD_BLANK, " ").replaceAll(WORD_LINE_BREAK, "\n").replaceAll("\n+", "\n");
                String textClearBeginBlank = textWithSameBlankAndBreak.replaceAll(regexClearBeginBlank, "");
                docxText.append(textClearBeginBlank).append("\n");
                continue;
            }
            if (!(element instanceof XWPFTable)) continue;
            try {
                ++count;
            }
            catch (Exception e) {
                throw new HussarException("docx\u62bd\u8868\u6570\u636e\u4e0e\u5bf9\u5e94\u7684\u8868\u683c\u4f4d\u7f6e\u4e0d\u4e00\u81f4");
            }
        }
        return Pair.of((Object)docxText.toString(), allWordTableCellList);
    }

    private WordTableCell buildWordCellContent(Float height, Float width, String text, Float fontSize, Float x, Float y) {
        WordTableCell wordTableCell = new WordTableCell();
        wordTableCell.setHeight(height);
        wordTableCell.setWidth(width);
        wordTableCell.setText(text);
        wordTableCell.setFontSize(fontSize);
        wordTableCell.setX(x);
        wordTableCell.setY(y);
        return wordTableCell;
    }

    private int getDocCellToLeftWidth(Table table, int row, int col) {
        int leftWidth = 0;
        for (int i = 0; i < col; ++i) {
            leftWidth += this.getDocCellWidth(table, row, i);
        }
        return leftWidth;
    }

    private int getDocCellWidth(Table table, int row, int col) {
        int width = table.getRow(row).getCell(col).getWidth() / 1;
        if (width < 0) {
            width = Math.abs(width);
            log.info("doc\u53d6\u51fa\u7684\u5bbd\u5ea6\u4e3a\u8d1f\u6570");
        }
        return width == 0 ? 1000 : width;
    }

    private int getDocRowHeight(Table table, int row) {
        int height = table.getRow(row).getRowHeight();
        if (height < 0) {
            log.info("\u51fa\u73b0height\u5c0f\u4e8e0");
            height = Math.abs(height);
        }
        return height == 0 ? 500 : height;
    }

    private int getDocContinueRowHeight(Table table, int row, int col, int rowHeight) {
        int nextRow = row + 1;
        if (nextRow >= table.numRows()) {
            return rowHeight;
        }
        int nextRowHeight = this.getDocRowHeight(table, nextRow) / 1;
        int nextColNums = table.getRow(nextRow).numCells();
        for (int j = 0; j < nextColNums; ++j) {
            TableCell nextRowCell = table.getRow(nextRow).getCell(j);
            if (!this.docIsContinue(nextRowCell) || this.getDocCellWidth(table, nextRow, j) != this.getDocCellWidth(table, row, col) || this.getDocCellToLeftWidth(table, nextRow, j) != this.getDocCellToLeftWidth(table, row, col)) continue;
            return this.getDocContinueRowHeight(table, nextRow, j, rowHeight += nextRowHeight);
        }
        return rowHeight;
    }

    private boolean docIsContinue(TableCell cell) {
        return cell.isVerticallyMerged() && !cell.isFirstVerticallyMerged();
    }

    private boolean docIsRestart(TableCell cell) {
        return cell.isFirstVerticallyMerged();
    }

    private int getDocxCellToLeftWidth(XWPFTable table, int row, int col) {
        int leftWidth = 0;
        for (int i = 0; i < col; ++i) {
            leftWidth += this.getDocxCellWidth(table, row, i);
        }
        return leftWidth;
    }

    private int getDocxCellWidth(XWPFTable table, int row, int col) {
        try {
            int width = table.getRow(row).getCell(col).getCTTc().getTcPr().getTcW().getW().intValue();
            if (width < 0) {
                width = Math.abs(width);
                log.info("docx\u53d6\u51fa\u7684\u5bbd\u5ea6\u4e3a\u8d1f\u6570");
            }
            return width;
        }
        catch (Exception e) {
            return 0;
        }
    }

    private int getDocxRowHeight(XWPFTable table, int row) {
        int height = table.getRow(row).getHeight();
        if (height < 0) {
            log.info("\u51fa\u73b0height\u5c0f\u4e8e0");
            height = Math.abs(height);
        }
        return height == 0 ? 500 : height;
    }

    private int getDocxCellHeight(XWPFTable table, int currentRowHeight, int row, int col) {
        XWPFTableCell cell = table.getRow(row).getCell(col);
        int height = this.docxIsRestart(cell) ? currentRowHeight + this.getDocxContinueRowHeight(table, row, col, 0) : currentRowHeight;
        return height;
    }

    private int getDocxContinueRowHeight(XWPFTable table, int row, int col, int rowHeight) {
        int nextRow = row + 1;
        if (nextRow >= table.getNumberOfRows()) {
            return rowHeight;
        }
        int nextRowHeight = this.getDocxRowHeight(table, nextRow) / 1;
        int nextColNums = table.getRow(nextRow).getTableCells().size();
        for (int j = 0; j < nextColNums; ++j) {
            XWPFTableCell nextRowCell = table.getRow(nextRow).getCell(j);
            if (!this.docxIsContinue(nextRowCell) || this.getDocxCellWidth(table, nextRow, j) != this.getDocxCellWidth(table, row, col) || this.getDocxCellToLeftWidth(table, nextRow, j) != this.getDocxCellToLeftWidth(table, row, col)) continue;
            return this.getDocxContinueRowHeight(table, nextRow, j, rowHeight += nextRowHeight);
        }
        return rowHeight;
    }

    private boolean docxIsContinue(XWPFTableCell cell) {
        CTTcPr tcPr = cell.getCTTc().getTcPr();
        if (tcPr.getVMerge() == null) {
            return false;
        }
        return tcPr.getVMerge().getVal() == null || StringUtils.equals((CharSequence)tcPr.getVMerge().getVal().toString(), (CharSequence)"continue");
    }

    private boolean docxIsRestart(XWPFTableCell cell) {
        CTTcPr tcPr = cell.getCTTc().getTcPr();
        return tcPr.getVMerge() != null && tcPr.getVMerge().getVal() != null && StringUtils.equals((CharSequence)tcPr.getVMerge().getVal().toString(), (CharSequence)"restart");
    }

    private void fillSpan(WordTable wordTable) {
        HashSet rowYSet = new HashSet();
        HashSet colXSet = new HashSet();
        wordTable.getWordTableCellList().forEach(cell -> {
            rowYSet.add(cell.getY());
            rowYSet.add(Float.valueOf(cell.getY().floatValue() + cell.getHeight().floatValue()));
            colXSet.add(cell.getX());
            colXSet.add(Float.valueOf(cell.getX().floatValue() + cell.getWidth().floatValue()));
        });
        Object[] rowY = rowYSet.toArray(new Float[0]);
        Object[] colX = colXSet.toArray(new Float[0]);
        Arrays.sort(rowY);
        Arrays.sort(colX);
        wordTable.getWordTableCellList().forEach(arg_0 -> this.lambda$fillSpan$1((Float[])rowY, (Float[])colX, arg_0));
    }

    public int binarySearch(Float[] arr, Float target, Float diff) {
        int start = 0;
        int end = arr.length - 1;
        while (start <= end) {
            int mid = (start + end) / 2;
            if (Math.abs(arr[mid].floatValue() - target.floatValue()) < diff.floatValue()) {
                return mid;
            }
            if (arr[mid].floatValue() > target.floatValue()) {
                end = mid - 1;
                continue;
            }
            start = mid + 1;
        }
        return -1;
    }

    public static void main(String[] args) {
        File file = new File("C:\\Users\\25350\\Desktop\\doc1.docx");
        WordExtractorServiceImpl wordExtractorService = new WordExtractorServiceImpl();
        try {
            System.out.println(1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private /* synthetic */ void lambda$fillSpan$1(Float[] rowY, Float[] colX, WordTableCell cell) {
        int topYIndex = this.binarySearch(rowY, cell.getY(), TABLE_EXCURSION);
        int bottomYIndex = this.binarySearch(rowY, Float.valueOf(cell.getY().floatValue() + cell.getHeight().floatValue()), TABLE_EXCURSION);
        int leftXIndex = this.binarySearch(colX, cell.getX(), TABLE_EXCURSION);
        int rightXIndex = this.binarySearch(colX, Float.valueOf(cell.getX().floatValue() + cell.getWidth().floatValue()), TABLE_EXCURSION);
        cell.setRow(topYIndex);
        cell.setCol(leftXIndex);
        cell.setRowspan(bottomYIndex - topYIndex == 0 ? 1 : bottomYIndex - topYIndex);
        cell.setColspan(rightXIndex - leftXIndex == 0 ? 1 : rightXIndex - leftXIndex);
        if (cell.getRowspan() < 0) {
            cell.setRowspan(1);
        }
        if (cell.getColspan() < 0) {
            cell.setColspan(1);
        }
    }
}

