/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.strategy.docHander.impl;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.strategy.docHander.FileHandler;
import com.jxdinfo.hussar.strategy.docHander.model.Element;
import com.jxdinfo.hussar.strategy.docHander.model.RegexModel;
import com.jxdinfo.hussar.strategy.docHander.model.TreeNode;
import com.jxdinfo.hussar.strategy.util.CommonUtil;
import com.jxdinfo.hussar.strategy.util.SplittingStrategyUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class MdHandlerImpl
implements FileHandler {
    @Override
    public HashMap<String, LinkedHashMap<String, String>> analysis(File file, String fileName, String splitMode, int splitLevel, LinkedHashMap<String, Integer> patterMap, String preprocess, String preRegular) {
        List<String> splitModes = SplittingStrategyUtil.getList(splitMode);
        int maxParagraph = Integer.MAX_VALUE;
        int windowSize = Math.min(maxParagraph, 50);
        if (patterMap == null) {
            patterMap = new LinkedHashMap();
        }
        if (splitModes != null && splitModes.contains("1")) {
            ArrayList<Map.Entry<String, Integer>> entryList = new ArrayList<Map.Entry<String, Integer>>(patterMap.entrySet());
            ListIterator iterator = entryList.listIterator(entryList.size());
            LinkedHashMap<String, Integer> updatedMap = new LinkedHashMap<String, Integer>();
            while (iterator.hasPrevious()) {
                Map.Entry entry2 = (Map.Entry)iterator.previous();
                String key = (String)entry2.getKey();
                Integer value = (Integer)entry2.getValue();
                patterMap.remove(key);
                if (!MdHandlerImpl.isValidRegex(key)) continue;
                updatedMap.put("(" + key + ")", value);
            }
            if (splitModes.contains("0")) {
                patterMap.put("^# (.*)", 1);
                patterMap.put("^## (.*)", 2);
                patterMap.put("^### (.*)", 3);
                patterMap.put("^#### (.*)", 4);
                patterMap.put("^##### (.*)", 5);
                patterMap.put("^###### (.*)", 6);
            }
            patterMap.putAll(updatedMap);
        } else if (splitModes == null || splitModes.contains("0")) {
            patterMap.put("^# (.*)", 1);
            patterMap.put("^## (.*)", 2);
            patterMap.put("^### (.*)", 3);
            patterMap.put("^#### (.*)", 4);
            patterMap.put("^##### (.*)", 5);
            patterMap.put("^###### (.*)", 6);
        }
        LinkedHashMap<String, Integer> resortMap = new LinkedHashMap<String, Integer>();
        patterMap.entrySet().stream().sorted(Map.Entry.comparingByValue()).forEachOrdered(entry -> {
            Integer cfr_ignored_0 = (Integer)resortMap.put((String)entry.getKey(), (Integer)entry.getValue());
        });
        try {
            Path filePath = file.toPath();
            List<String> lines = Files.readAllLines(filePath);
            StringBuilder content = new StringBuilder();
            int id = 0;
            int pLevel = -1;
            TreeNode root = new TreeNode(new Element(id++, fileName, "-1", -1));
            ArrayList<Element> elements = new ArrayList<Element>();
            String picRegex = "(!\\[.*?]\\(([^\\s()]+(?:\\.[a-zA-Z]{2,})(\\s+[^)]+)?)\\)|<img\\s+src=[\"']([^\"']+)['\"].*?>)";
            Pattern pattern = Pattern.compile(picRegex);
            ArrayList<String> uuids = new ArrayList<String>();
            for (int i = 0; i < lines.size(); ++i) {
                lines.set(i, this.replaceDoubleDollar(lines.get(i)));
                String line = lines.get(i);
                Matcher matcher = pattern.matcher(line);
                while (matcher.find()) {
                    String randomUUID;
                    String paragraphText;
                    String imageUrl;
                    if (matcher.group(2) != null) {
                        imageUrl = matcher.group(2).trim();
                        paragraphText = this.getParagraphText(lines, i);
                        randomUUID = HussarUtils.randomUUID();
                        uuids.add(randomUUID);
                        line = line.replace(matcher.group(1).trim(), this.convertMarkdownPic(randomUUID, paragraphText));
                        continue;
                    }
                    if (matcher.group(4) != null) {
                        imageUrl = matcher.group(4).trim();
                        paragraphText = this.getParagraphText(lines, i);
                        randomUUID = HussarUtils.randomUUID();
                        uuids.add(randomUUID);
                        line = line.replace(matcher.group(1).trim(), this.convertMarkdownPic(randomUUID, paragraphText));
                        continue;
                    }
                    lines.set(i, line);
                }
                RegexModel rx = CommonUtil.getPatterLevel(line, resortMap);
                Element element = null;
                String last = null;
                if (0 != rx.getLevel()) {
                    element = new Element(id, rx.getTitle(), "0", rx.getLevel() == 0 ? 9 : rx.getLevel());
                    last = rx.getContent();
                }
                if (element == null) {
                    content.append(line).append("\n");
                    if (i != lines.size() - 1) continue;
                    id = this.putElementContentIntoElements(elements, content, id, maxParagraph, windowSize);
                    continue;
                }
                if (!"".contentEquals(content)) {
                    id = this.putElementContentIntoElements(elements, content, id, maxParagraph, windowSize);
                }
                element.setId(id++);
                content = new StringBuilder(HussarUtils.isEmpty(last) ? "" : last);
                elements.add(element);
                if (i != lines.size() - 1 || content.length() <= 0) continue;
                id = this.putElementContentIntoElements(elements, content, id, maxParagraph, windowSize);
            }
            for (Element element : elements) {
                Integer level = element.getLevel();
                if (level == 9) {
                    root.addChild(new TreeNode(element));
                    continue;
                }
                if (level > pLevel) {
                    TreeNode treeNode = new TreeNode(element);
                    root.addChild(treeNode);
                    root = treeNode;
                    pLevel = level;
                    continue;
                }
                if (level == pLevel) {
                    TreeNode child = new TreeNode(element);
                    root.getParentNode().addChild(child);
                    root = child;
                    continue;
                }
                TreeNode node = new TreeNode(element);
                while (HussarUtils.isNotEmpty((Object)root.getParentNode())) {
                    if (level < root.getParentNode().getData().getLevel()) {
                        root = root.getParentNode();
                        continue;
                    }
                    if (level.equals(root.getParentNode().getData().getLevel())) {
                        root = HussarUtils.isNotEmpty((Object)root.getParentNode().getParentNode()) ? root.getParentNode().getParentNode() : root.getParentNode();
                        root.addChild(node);
                        break;
                    }
                    root = root.getParentNode();
                    root.addChild(node);
                    break;
                }
                root = node;
                pLevel = level;
            }
            String prefix = "\u4ee5\u4e0b\u662f " + fileName + " \u7684\u6587\u6863\u8bf4\u660e\u3002\u8be5\u90e8\u5206\u5185\u5bb9\u5173\u4e8e";
            LinkedHashMap<List<Element>, List<List<Element>>> contentsMap = new LinkedHashMap<List<Element>, List<List<Element>>>();
            root.printTree(root.getRoot(), "", true);
            root.findLeafNodePathsByType(root.getRoot(), new ArrayList<Element>(), splitLevel, new ArrayList<List<Element>>(), contentsMap);
            HashMap<String, LinkedHashMap<String, String>> resultMap = CommonUtil.treeToMap(fileName, splitLevel, contentsMap, prefix);
            for (int i = 0; i < uuids.size(); ++i) {
                String s = (String)uuids.get(i);
                resultMap.get("3").put(s, " ");
            }
            return resultMap;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private int putElementContentIntoElements(List<Element> elements, StringBuilder content, int id, int maxParagraph, int windowSize) {
        if (content == null || content.length() == 0 || content.toString().trim().isEmpty()) {
            return id;
        }
        String contentStr = content.toString();
        String tableRegex = "(?:^|\\n)\\s*\\|(.+)\\|\\s*\\n\\s*\\|(\\s*:?-+:?\\s*\\|)+\\s*\\n(\\s*\\|(.+)\\|\\s*\\n)*";
        Pattern tablePattern = Pattern.compile(tableRegex);
        Matcher matcher = tablePattern.matcher(contentStr);
        if (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            String prefix = contentStr.substring(0, start);
            String tableBlock = contentStr.substring(start, end);
            String suffix = contentStr.substring(end);
            id = this.putElementContentIntoElements(elements, new StringBuilder(prefix), id, maxParagraph, windowSize);
            String convertedTable = this.convertMarkdownTable(tableBlock.trim());
            elements.add(this.getContentElement(convertedTable, id++));
            id = this.putElementContentIntoElements(elements, new StringBuilder(suffix), id, maxParagraph, windowSize);
            return id;
        }
        List<Integer> divPoints = this.divAlgByWindowSize(new StringBuilder(content), maxParagraph, windowSize);
        int last = 0;
        for (Integer point : divPoints) {
            elements.add(this.getContentElement(content.substring(last, point), id++));
            last = point;
        }
        elements.add(this.getContentElement(content.substring(last), id++));
        return id;
    }

    private List<Integer> divAlgByWindowSize(StringBuilder content, int maxParagraph, int windowSize) {
        ArrayList<Integer> resultList = new ArrayList<Integer>();
        int totalOffset = 0;
        HashSet<Character> delimiters = new HashSet<Character>(Arrays.asList(Character.valueOf('\n'), Character.valueOf('\u3002'), Character.valueOf('\uff1b'), Character.valueOf('\uff01'), Character.valueOf('.'), Character.valueOf(';'), Character.valueOf('!')));
        while (content.length() > maxParagraph) {
            int startSearch = Math.max(0, maxParagraph - windowSize);
            int endSearch = maxParagraph;
            int splitPos = -1;
            for (int i = endSearch - 1; i >= startSearch; --i) {
                char c = content.charAt(i);
                if (!delimiters.contains(Character.valueOf(c))) continue;
                splitPos = i + 1;
                break;
            }
            if (splitPos == -1) {
                splitPos = maxParagraph;
            }
            resultList.add(totalOffset + splitPos);
            content.delete(0, splitPos);
            totalOffset += splitPos;
        }
        return resultList;
    }

    public static boolean isValidRegex(String regex) {
        try {
            Pattern.compile(regex);
            return true;
        }
        catch (PatternSyntaxException e) {
            return false;
        }
    }

    private Element getContentElement(String line, Integer id) {
        return new Element(id, line, "1", 9);
    }

    public String convertMarkdownTable(String markdown) {
        String[] lines = markdown.split("\n");
        StringBuilder result = new StringBuilder("\u3010\u8868\u683ctable\u3011\u8fd9\u662f\u4e00\u4e2a" + (lines.length - 1) + "\u884c" + (lines[0].split("\\|").length - 2) + "\u5217\u7684\u8868\u683c1\u3001row\u4ee3\u8868\u884c\u6570\uff0ccol\u4ee3\u8868\u5355\u5143\u683c\u6240\u5728\u5217\u6570\uff0c\u6bcf\u5bf9<row></rowend>\u6807\u7b7e\u5305\u88f9\u4e00\u884c\u5185\u5bb9\uff0ccol\u503c\u76f8\u540c\u7684\u5355\u5143\u683c\u4e3a\u4e00\u5217\u30022\u3001\u6bcf\u4e2a\u6807\u7b7e<col></col>\u5305\u88f9\u4e00\u4e2a\u5355\u5143\u683c\u3002\u8868\u683c\u5982\u4e0b\uff1a<table>");
        ArrayList<String> tableTitles = new ArrayList<String>();
        for (int i = 0; i < lines.length; ++i) {
            if (i == 1) continue;
            String line = lines[i].trim();
            String[] columns = line.split("\\|");
            if (i == 0) {
                result.append("<row=").append(i + 1).append(">");
            } else {
                result.append("<row=").append(i).append(">");
            }
            for (int j = 1; j < columns.length; ++j) {
                if (!columns[j].trim().isEmpty()) {
                    if (i == 0) {
                        tableTitles.add(columns[j].trim());
                        result.append("<col=").append(j).append(">").append(columns[j].trim()).append("</col>");
                        continue;
                    }
                    if (j - 1 < tableTitles.size()) {
                        result.append("<col=").append(j).append(">(").append((String)tableTitles.get(j - 1)).append(")").append(columns[j].trim()).append("</col>");
                        continue;
                    }
                    result.append("<col=").append(j).append(">").append(columns[j].trim()).append("</col>");
                    continue;
                }
                result.append("<col=").append(j).append("></col>");
            }
            result.append("</rowend>");
        }
        result.append("</table>\u8bf7\u4ed4\u7ec6\u9605\u8bfb\u4ee5\u4e0a\u8868\u683c\uff0c\u51c6\u786e\u56de\u7b54\u6211\u7684\u95ee\u9898\uff0c\u4e0d\u7528\u7ed9\u51fa\u8fc7\u7a0b\uff0c\u76f4\u63a5\u56de\u7b54\u7ed3\u679c\u5373\u53ef\u3002");
        return result.toString();
    }

    private String getParagraphText(List<String> lines, int i) {
        StringBuilder context = new StringBuilder();
        int start = Math.max(0, i - 2);
        int end = Math.min(lines.size() - 1, i + 2);
        for (int j = start; j <= end; ++j) {
            if ("".equals(lines.get(j)) || j == i) continue;
            context.append(lines.get(j)).append("\n");
        }
        return context.toString().trim();
    }

    private String replaceDoubleDollar(String input) {
        return input.replace("$$", "$");
    }

    public String convertMarkdownPic(String randomUUID, String paragraphText) {
        return "\u3010\u56fe\u7247\u3011<image>" + randomUUID + "</image><imagetxt>\u8fd9\u662f\u4e00\u5f20\u56fe\u7247\uff0c\u56fe\u7247\u4e0a\u4e0b\u6587\u4e3a\uff1a" + paragraphText + "</imagetxt>";
    }

    public static void main(String[] args) {
        String fileName = "test";
        String splitMode = "[\"0\", \"1\"]";
        int splitLevel = 6;
        LinkedHashMap<String, Integer> patterMap = new LinkedHashMap<String, Integer>();
        String filePath = "C:\\Users\\81067\\Desktop\\\u6cd5\u5f8b\u6761\u6587.md";
        File file = new File(filePath);
        patterMap.put("^\u7b2c[^\u7ae0]+\u7ae0.*", 1);
        patterMap.put("^\u7b2c[^\u6761]+\u6761", 2);
        patterMap.put("^\uff08[^\uff09]+\uff09", 3);
        MdHandlerImpl mdHandler = new MdHandlerImpl();
        mdHandler.analysis(file, fileName, splitMode, splitLevel, patterMap, null, null);
    }
}

