/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.strategy.docParsing.impl;

import com.jxdinfo.hussar.common.config.AiDocumentLibrary;
import com.jxdinfo.hussar.common.util.IqaFileUtil;
import com.jxdinfo.hussar.strategy.docParsing.ParsingFactory;
import com.jxdinfo.hussar.strategy.docParsing.ParsingModel;
import com.jxdinfo.hussar.strategy.docParsing.ParsingStrategy;
import com.jxdinfo.hussar.strategy.model.QADocSplittingStrategy;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class LocalParsing
implements ParsingModel {
    @Resource
    private AiDocumentLibrary docStrategyLibraryConfig;

    @Override
    public HashMap<String, HashMap<String, LinkedHashMap<String, String>>> fileToMap(List<File> files, QADocSplittingStrategy splittingStrategy) {
        HashMap<String, HashMap<String, LinkedHashMap<String, String>>> map = new HashMap<String, HashMap<String, LinkedHashMap<String, String>>>();
        ParsingFactory parsingFactory = new ParsingFactory();
        for (File file : files) {
            String fileName = file.getName();
            String fileExtension = IqaFileUtil.getFileExtension((String)fileName);
            ParsingStrategy instance = parsingFactory.getInstance("LocalParsingFor" + IqaFileUtil.capitalizeFirstLetter((String)fileExtension));
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("ParsingStrategyFilePath", this.docStrategyLibraryConfig.getUploadPath());
            params.put("TitleAnalysis", splittingStrategy.getTitleAnalysis());
            params.put("MinTitleSplit", splittingStrategy.getMinTitleSplit());
            params.put("TitleAnalysisRegular", splittingStrategy.getTitleAnalysisRegular());
            params.put("type", splittingStrategy.getType());
            params.put("paragraphLength", splittingStrategy.getParagraphLength());
            params.put("ocrUrl", this.docStrategyLibraryConfig.getOcrUrl());
            params.put("preprocess", splittingStrategy.getPreprocess());
            params.put("preRegular", splittingStrategy.getPreRegular());
            map.put(fileName, instance.fileToMap(file, params));
        }
        return map;
    }
}

