/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.strategy.util;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.strategy.docHander.model.CellAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TableConvertUtil {
    public static String convert(String tableContent, String fileName) {
        String tableConet = "";
        if (HussarUtils.isNotEmpty((Object)tableContent)) {
            String regex = "<cell\\s+row=(\\d+)\\s+col=(\\d+)\\s+rowspan=(\\d+)\\s+colspan=(\\d+)>(.*?)<\\/cell>";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(tableContent);
            ArrayList<CellAttributes> cellAttributesList = new ArrayList<CellAttributes>();
            while (matcher.find()) {
                int row = Integer.parseInt(matcher.group(1));
                int col = Integer.parseInt(matcher.group(2));
                int rowspan = Integer.parseInt(matcher.group(3));
                int colspan = Integer.parseInt(matcher.group(4));
                String content = matcher.group(5);
                CellAttributes attributes = new CellAttributes();
                attributes.setCol(col);
                attributes.setRow(row);
                attributes.setColspan(colspan);
                attributes.setRowspan(rowspan);
                attributes.setContent(content);
                cellAttributesList.add(attributes);
            }
            HashMap rowMaps = new HashMap();
            boolean isRowSpan = false;
            boolean isColSpan = false;
            for (CellAttributes wordTableCell : cellAttributesList) {
                int i;
                int rowspan = wordTableCell.getRowspan();
                int colspan = wordTableCell.getColspan();
                int row = wordTableCell.getRow();
                int col = wordTableCell.getCol();
                ArrayList<String> cols = new ArrayList<String>();
                if (!isRowSpan && rowspan > 1) {
                    isRowSpan = true;
                }
                if (!isColSpan && colspan > 1) {
                    isColSpan = true;
                }
                for (i = 0; i < colspan; ++i) {
                    String colString = "<col=" + (col + i) + ">" + wordTableCell.getContent() + "</col>";
                    cols.add(colString);
                }
                for (i = 0; i < rowspan; ++i) {
                    if (rowMaps.containsKey(row + i)) {
                        ArrayList<String> strings = new ArrayList<String>((Collection)rowMaps.get(row + i));
                        strings.addAll(cols);
                        rowMaps.put(row + i, strings);
                        continue;
                    }
                    rowMaps.put(row + i, cols);
                }
            }
            StringBuilder tableString = new StringBuilder("<table>");
            for (int i = 0; i < rowMaps.size(); ++i) {
                tableString.append("<row=").append(i + 1).append(">");
                for (String col : (List)rowMaps.get(i + 1)) {
                    tableString.append(col);
                }
                tableString.append("</rowend>");
            }
            tableString.append("</table>");
            StringBuilder prefixBuilder = new StringBuilder();
            prefixBuilder.append("\u4ee5\u4e0b\u662f ").append(fileName).append(" \u7684\u6587\u6863\u8bf4\u660e\u3002");
            prefixBuilder.append("\u3010\u8868\u683ctable\u3011\u8fd9\u662f\u4e00\u4e2a").append(rowMaps.size()).append("\u884c").append(((List)rowMaps.get(1)).size()).append("\u5217\u7684\u8868\u683c\uff0c");
            if (isRowSpan) {
                prefixBuilder.append("\u5b58\u5728\u884c\u5408\u5e76\uff0c");
            }
            if (isColSpan) {
                prefixBuilder.append("\u5b58\u5728\u5217\u5408\u5e76\uff0c");
            }
            prefixBuilder.append("1\u3001row\u4ee3\u8868\u884c\u6570\uff0ccol\u4ee3\u8868\u5355\u5143\u683c\u6240\u5728\u5217\u6570 \uff0c\u6bcf\u5bf9<row></rowend>\u6807\u7b7e\u5305\u88f9\u4e00\u884c\u5185\u5bb9\uff0ccol\u503c\u76f8\u540c\u7684\u5355\u5143\u683c\u4e3a\u4e00\u5217\u30022\u3001\u6bcf\u4e2a\u6807\u7b7e<col></col>\u5305\u88f9\u4e00\u4e2a\u5355\u5143\u683c\u3002\u8868\u683c\u5982\u4e0b\uff1a");
            tableConet = prefixBuilder.append((CharSequence)tableString).toString();
        }
        return tableConet;
    }

    public static void main(String[] args) {
        String input = "<table><cell row=1 col=1 rowspan=1 colspan=1>\u59d3\u540d</cell><cell row=1 col=2 rowspan=1 colspan=1>\u6027\u522b</cell><cell row=1 col=3 rowspan=1 colspan=1>\u5e74\u9f84</cell><cell row=1 col=4 rowspan=1 colspan=1>\u7231\u597d</cell><cell row=2 col=1 rowspan=1 colspan=1>\u5f20\u4e09</cell><cell row=2 col=2 rowspan=1 colspan=1>\u7537</cell><cell row=2 col=3 rowspan=1 colspan=1>30</cell><cell row=2 col=4 rowspan=1 colspan=1>\u5531\u6b4c</cell><cell row=3 col=1 rowspan=1 colspan=1>\u674e\u56db</cell><cell row=3 col=2 rowspan=1 colspan=1>\u5973</cell><cell row=3 col=3 rowspan=1 colspan=1>26</cell><cell row=3 col=4 rowspan=2 colspan=1>\u8df3\u821e\u65e0</cell><cell row=4 col=1 rowspan=1 colspan=1>\u738b\u4e94</cell><cell row=4 col=2 rowspan=1 colspan=1>\u7537</cell><cell row=4 col=3 rowspan=1 colspan=1>28</cell></table>";
        String convert = TableConvertUtil.convert(input, "1111");
        System.out.println(convert);
    }
}

