/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.openApi.service.impl;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.openApi.common.AiUrlProperties;
import com.jxdinfo.hussar.openApi.common.ApiResponse;
import com.jxdinfo.hussar.openApi.dto.DialogueQa;
import com.jxdinfo.hussar.openApi.dto.IgAddDialogueQaDTO;
import com.jxdinfo.hussar.openApi.dto.IgAppInfoDTO;
import com.jxdinfo.hussar.openApi.dto.IgDelDialogueDTO;
import com.jxdinfo.hussar.openApi.dto.IgDelDialogueQaDTO;
import com.jxdinfo.hussar.openApi.dto.IgDialogueCreateDTO;
import com.jxdinfo.hussar.openApi.dto.IgDialogueDTO;
import com.jxdinfo.hussar.openApi.dto.IgFeedbackDTO;
import com.jxdinfo.hussar.openApi.dto.IgPageApiResponse;
import com.jxdinfo.hussar.openApi.dto.IgSqlQaDTO;
import com.jxdinfo.hussar.openApi.dto.IgStreamQaDTO;
import com.jxdinfo.hussar.openApi.dto.IgUpdateDialogueNameDTO;
import com.jxdinfo.hussar.openApi.dto.QaFaqModel;
import com.jxdinfo.hussar.openApi.service.IAiQAService;
import com.jxdinfo.hussar.openApi.util.HttpClientUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Service
public class AiQAServiceImpl
implements IAiQAService {
    @Override
    public ApiResponse<IgAppInfoDTO> getAppInfo(Long systemId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("systemId", systemId);
        return (ApiResponse)JSON.parseObject((String)HttpClientUtil.doGet(Api.getAppInfo, map), ApiResponse.class);
    }

    @Override
    public ApiResponse<List<IgDialogueDTO>> getDialogues(Long systemId, String userId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("systemId", systemId);
        map.put("userId", userId);
        return (ApiResponse)JSON.parseObject((String)HttpClientUtil.doGet(Api.getDialogues, map), ApiResponse.class);
    }

    @Override
    public ApiResponse<?> createDialogue(IgDialogueCreateDTO dialogueCreateDTO) {
        return (ApiResponse)JSON.parseObject((String)HttpClientUtil.doPostJson(Api.createDialogue, JSON.toJSONString((Object)dialogueCreateDTO)), ApiResponse.class);
    }

    @Override
    public IgPageApiResponse<DialogueQa> getDialogueQaList(Page<DialogueQa> page, Long dialogueId, String userId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("page", page);
        map.put("dialogueId", dialogueId);
        map.put("userId", userId);
        return (IgPageApiResponse)JSON.parseObject((String)HttpClientUtil.doGet(Api.getDialogueQaList, map), IgPageApiResponse.class);
    }

    @Override
    public ApiResponse<String> getFaqList(Page<QaFaqModel> page, Long scenarioId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("page", page);
        map.put("scenarioId", scenarioId);
        return (ApiResponse)JSON.parseObject((String)HttpClientUtil.doGet(Api.getFaqList, map), ApiResponse.class);
    }

    @Override
    public ApiResponse<?> delDialogueQa(IgDelDialogueQaDTO igDelDialogueQaDTO) {
        return (ApiResponse)JSON.parseObject((String)HttpClientUtil.doPostJson(Api.delDialogueQa, JSON.toJSONString((Object)igDelDialogueQaDTO)), ApiResponse.class);
    }

    @Override
    public ApiResponse<?> delDialogue(IgDelDialogueDTO igDelDialogueDTO) {
        return (ApiResponse)JSON.parseObject((String)HttpClientUtil.doPostJson(Api.delDialogue, JSONObject.toJSONString((Object)igDelDialogueDTO, (JSONWriter.Feature[])new JSONWriter.Feature[0])), ApiResponse.class);
    }

    @Override
    public ApiResponse<?> feedback(IgFeedbackDTO igFeedbackDTO) {
        return (ApiResponse)JSON.parseObject((String)HttpClientUtil.doPostJson(Api.feedback, JSONObject.toJSONString((Object)igFeedbackDTO, (JSONWriter.Feature[])new JSONWriter.Feature[0])), ApiResponse.class);
    }

    @Override
    public ApiResponse<?> updateDialogueName(IgUpdateDialogueNameDTO igUpdateDialogueNameDTO) {
        return (ApiResponse)JSON.parseObject((String)HttpClientUtil.doPostJson(Api.updateDialogueName, JSONObject.toJSONString((Object)igUpdateDialogueNameDTO, (JSONWriter.Feature[])new JSONWriter.Feature[0])), ApiResponse.class);
    }

    @Override
    public ApiResponse<Long> addDialogueQa(IgAddDialogueQaDTO igAddDialogueQaDTO) {
        return (ApiResponse)JSON.parseObject((String)HttpClientUtil.doPostJson(Api.addDialogueQa, JSONObject.toJSONString((Object)igAddDialogueQaDTO, (JSONWriter.Feature[])new JSONWriter.Feature[0])), ApiResponse.class);
    }

    @Override
    public ApiResponse<Map<String, Object>> inference(IgSqlQaDTO sqlQaDTO) {
        return (ApiResponse)JSON.parseObject((String)HttpClientUtil.doPostJson(Api.inference, JSONObject.toJSONString((Object)sqlQaDTO, (JSONWriter.Feature[])new JSONWriter.Feature[0])), ApiResponse.class);
    }

    @Override
    public SseEmitter knowledgeBaseChat(IgStreamQaDTO igStreamQaDTO) {
        return (SseEmitter)JSON.parseObject((String)HttpClientUtil.doPostJson(Api.knowledgeBaseChat, JSONObject.toJSONString((Object)igStreamQaDTO, (JSONWriter.Feature[])new JSONWriter.Feature[0])), SseEmitter.class);
    }

    private static final class Api {
        public static final String version = AiUrlProperties.getUrl() + "/qa_chat/v1";
        public static final String getAppInfo = version + "/get_app_info";
        public static final String getDialogues = version + "/get_dialogues";
        public static final String createDialogue = version + "/create_dialogue";
        public static final String getDialogueQaList = version + "/get_dialogue_qa_list";
        public static final String inference = version + "/inference";
        public static final String knowledgeBaseChat = version + "/knowledge_base_chat";
        public static final String getFaqList = version + "/get_faq_list";
        public static final String delDialogueQa = version + "/del_dialogue_qa";
        public static final String delDialogue = version + "/del_dialogue";
        public static final String feedback = version + "/feedback";
        public static final String addDialogueQa = version + "/add_dialogue_qa";
        public static final String updateDialogueName = version + "/update_dialogue_name";

        private Api() {
        }
    }
}

