/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.openApi.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;

public class HttpClientUtil {
    private static final CloseableHttpClient httpClient;

    public static String doGet(String url) {
        HttpGet httpGet = new HttpGet(url);
        return HttpClientUtil.doHttp((HttpRequestBase)httpGet);
    }

    public static String doGet(String url, Map<String, Object> params) {
        List<NameValuePair> pairs = HttpClientUtil.covertParamsToList(params);
        HttpGet httpGet = null;
        try {
            URIBuilder ub = new URIBuilder(url);
            ub.setParameters(pairs);
            httpGet = new HttpGet(ub.build());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return HttpClientUtil.doHttp((HttpRequestBase)httpGet);
    }

    public static String doGet(String url, Map<String, Object> headers, Map<String, Object> params) {
        List<NameValuePair> pairs = HttpClientUtil.covertParamsToList(params);
        HttpGet httpGet = null;
        try {
            URIBuilder ub = new URIBuilder(url);
            ub.setParameters(pairs);
            httpGet = new HttpGet(ub.build());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        for (Map.Entry<String, Object> param : headers.entrySet()) {
            httpGet.addHeader(param.getKey(), String.valueOf(param.getValue()));
        }
        return HttpClientUtil.doHttp((HttpRequestBase)httpGet);
    }

    public static String doPost(String url) {
        HttpPost httpPost = new HttpPost(url);
        return HttpClientUtil.doHttp((HttpRequestBase)httpPost);
    }

    public static String doPost(String url, Map<String, Object> params) {
        List<NameValuePair> pairs = HttpClientUtil.covertParamsToList(params);
        HttpPost httpPost = new HttpPost(url);
        try {
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, StandardCharsets.UTF_8.name()));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return HttpClientUtil.doHttp((HttpRequestBase)httpPost);
    }

    public static String doPost(String url, Map<String, Object> headers, Map<String, Object> params) throws Exception {
        List<NameValuePair> pairs = HttpClientUtil.covertParamsToList(params);
        HttpPost httpPost = new HttpPost(url);
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, StandardCharsets.UTF_8.name()));
        for (Map.Entry<String, Object> param : headers.entrySet()) {
            httpPost.addHeader(param.getKey(), String.valueOf(param.getValue()));
        }
        return HttpClientUtil.doHttp((HttpRequestBase)httpPost);
    }

    public static String doPostJson(String url, String param) {
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("Content-Type", "application/json; charset=UTF-8");
        httpPost.setEntity((HttpEntity)new StringEntity(param, StandardCharsets.UTF_8.name()));
        return HttpClientUtil.doHttp((HttpRequestBase)httpPost);
    }

    public static String doPostXml(String url, String param) throws Exception {
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("Content-Type", "application/xml; charset=UTF-8");
        httpPost.setEntity((HttpEntity)new StringEntity(param, StandardCharsets.UTF_8.name()));
        return HttpClientUtil.doHttp((HttpRequestBase)httpPost);
    }

    public static String doHttpsPost(String url, String param, String path, String password) throws Exception {
        HttpPost httpPost = new HttpPost(url);
        httpPost.setEntity((HttpEntity)new StringEntity(param, StandardCharsets.UTF_8.name()));
        return HttpClientUtil.doHttps((HttpRequestBase)httpPost, path, password);
    }

    public static String doHttpsPostXml(String url, String param, String path, String password) throws Exception {
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("Content-Type", "application/xml; charset=UTF-8");
        httpPost.setEntity((HttpEntity)new StringEntity(param, StandardCharsets.UTF_8.name()));
        return HttpClientUtil.doHttps((HttpRequestBase)httpPost, path, password);
    }

    private static String doHttps(HttpRequestBase request, String path, String password) throws Exception {
        SSLConnectionSocketFactory csf = HttpClientUtil.getHttpsFactory(path, password);
        CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)csf).build();
        return HttpClientUtil.doRequest(httpClient, request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SSLConnectionSocketFactory getHttpsFactory(String path, String password) throws Exception {
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        try (FileInputStream input = new FileInputStream(new File(path));){
            keyStore.load(input, password.toCharArray());
        }
        SSLContext sslContext = SSLContexts.custom().loadKeyMaterial(keyStore, password.toCharArray()).build();
        SSLConnectionSocketFactory sslCsf = new SSLConnectionSocketFactory(sslContext, new String[]{"SSLv2Hello", "SSLv3", "TLSv1", "TLSv1.2"}, null, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
        return sslCsf;
    }

    private static String doHttp(HttpRequestBase request) {
        return HttpClientUtil.doRequest(httpClient, request);
    }

    private static String doRequest(CloseableHttpClient httpClient, HttpRequestBase request) {
        String result = null;
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                request.abort();
                throw new RuntimeException("HttpClient error status code: " + statusCode);
            }
            HttpEntity entity = response.getEntity();
            result = EntityUtils.toString((HttpEntity)entity, (String)StandardCharsets.UTF_8.name());
            EntityUtils.consume((HttpEntity)entity);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static String covertMapToQueryStr(Map<String, Object> params) {
        List<NameValuePair> pairs = HttpClientUtil.covertParamsToList(params);
        return URLEncodedUtils.format(pairs, (String)StandardCharsets.UTF_8.name());
    }

    public static List<NameValuePair> covertParamsToList(Map<String, Object> params) {
        ArrayList<NameValuePair> pairs = new ArrayList<NameValuePair>();
        for (Map.Entry<String, Object> param : params.entrySet()) {
            pairs.add((NameValuePair)new BasicNameValuePair(param.getKey(), String.valueOf(param.getValue())));
        }
        return pairs;
    }

    static {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(30000).setSocketTimeout(15000).build();
        httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
    }
}

