/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.network.factory.impl;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.jxdinfo.hussar.common.model.QaResponseChunk;
import com.jxdinfo.hussar.network.dto.NetworkReferenceChunk;
import com.jxdinfo.hussar.network.dto.NetworkRequest;
import com.jxdinfo.hussar.network.dto.ReferenceItem;
import com.jxdinfo.hussar.network.factory.NetworkProvider;
import com.jxdinfo.hussar.network.factory.NetworkProviderService;
import com.jxdinfo.hussar.network.factory.impl.BaiduProvider;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;

@Service
public class BaiduProviderServiceImpl
implements NetworkProviderService {
    private static final Logger logger = LoggerFactory.getLogger(BaiduProviderServiceImpl.class);
    private static final Gson gson = new Gson();
    private static final String url = "https://qianfan.baidubce.com/v2/ai_search/chat/completions";
    private static final int topK = 10;
    private static final String model = "deepseek-r1";
    private final BaiduProvider baiduProvider;

    public BaiduProviderServiceImpl(BaiduProvider baiduProvider) {
        this.baiduProvider = baiduProvider;
    }

    @Override
    public NetworkProvider getProvider() {
        return this.baiduProvider;
    }

    @Override
    public Flux<QaResponseChunk> sendRequest(NetworkRequest request) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("Accept", "text/event-stream");
        headers.add("X-Appbuilder-Authorization", "Bearer " + request.getApiKey());
        JsonObject body = new JsonObject();
        JsonArray messages = new JsonArray();
        JsonObject msg = new JsonObject();
        msg.addProperty("content", request.getContent());
        msg.addProperty("role", "user");
        messages.add((JsonElement)msg);
        body.add("messages", (JsonElement)messages);
        body.addProperty("model", model);
        body.addProperty("stream", Boolean.valueOf(true));
        JsonArray filters = new JsonArray();
        JsonObject webFilter = new JsonObject();
        webFilter.addProperty("type", "web");
        webFilter.addProperty("top_k", (Number)10);
        filters.add((JsonElement)webFilter);
        body.add("resource_type_filter", (JsonElement)filters);
        WebClient webClient = WebClient.builder().baseUrl(url).defaultHeaders(h -> h.putAll((Map)headers)).build();
        return webClient.post().bodyValue((Object)body.toString()).accept(new MediaType[]{MediaType.TEXT_EVENT_STREAM}).retrieve().bodyToFlux(String.class).map(BaiduProviderServiceImpl::getQaResponseChunk);
    }

    private static QaResponseChunk getQaResponseChunk(String line) {
        JsonObject block = (JsonObject)gson.fromJson(line, JsonObject.class);
        if (block.has("code") && block.has("message")) {
            logger.error("\u767e\u5ea6ai-search\u670d\u52a1\u8c03\u7528\u5f02\u5e38: {} ", (Object)line);
            throw new RuntimeException("\u5904\u7406\u767e\u5ea6ai-search\u6d41\u5f0f\u54cd\u5e94\u7ed3\u679c\u5f02\u5e38: " + line);
        }
        try {
            if (block.has("references") && !block.get("references").isJsonNull()) {
                NetworkReferenceChunk referenceChunk = new NetworkReferenceChunk();
                Type referenceListType = new TypeToken<List<ReferenceItem>>(){}.getType();
                referenceChunk.setReferences((List)gson.fromJson(block.get("references"), referenceListType));
                return referenceChunk;
            }
            QaResponseChunk chunk = new QaResponseChunk();
            if (block.has("choices") && !block.get("choices").isJsonNull()) {
                JsonArray choices = block.getAsJsonArray("choices");
                JsonObject choice = choices.get(0).getAsJsonObject();
                if (choice.has("delta") && !choice.get("delta").isJsonNull()) {
                    JsonObject delta = choice.getAsJsonObject("delta");
                    if (delta.has("reasoning_content") && !delta.get("reasoning_content").isJsonNull()) {
                        chunk.setReasoning_content(delta.get("reasoning_content").getAsString());
                    }
                    if (delta.has("content") && !delta.get("content").isJsonNull()) {
                        chunk.setContent(delta.get("content").getAsString());
                    }
                }
                if (choice.has("finish_reason") && !choice.get("finish_reason").isJsonNull()) {
                    chunk.setDone("stop".equals(choice.get("finish_reason").getAsString()));
                }
            }
            return chunk;
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u767e\u5ea6ai-search\u6d41\u5f0f\u54cd\u5e94\u7ed3\u679c\u5f02\u5e38: {} ", (Object)e.getMessage());
            throw new RuntimeException("\u5904\u7406\u767e\u5ea6ai-search\u6d41\u5f0f\u54cd\u5e94\u7ed3\u679c\u5f02\u5e38: " + e.getMessage(), e);
        }
    }
}

