/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.network.factory.impl;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.jxdinfo.hussar.common.model.QaResponseChunk;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.network.dto.NetworkReferenceChunk;
import com.jxdinfo.hussar.network.dto.NetworkRequest;
import com.jxdinfo.hussar.network.dto.ReferenceItem;
import com.jxdinfo.hussar.network.factory.NetworkProvider;
import com.jxdinfo.hussar.network.factory.NetworkProviderService;
import com.jxdinfo.hussar.network.factory.impl.ZhipuProvider;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;

@Service
public class ZhipuProviderServiceImpl
implements NetworkProviderService {
    private static final Logger logger = LoggerFactory.getLogger(ZhipuProviderServiceImpl.class);
    private static final Gson gson = new Gson();
    private static final String url = "https://open.bigmodel.cn/api/paas/v4/chat/completions";
    private static final String model = "GLM-4.5-Flash";
    private static final int topK = 10;
    private final ZhipuProvider zhipuProvider;

    public ZhipuProviderServiceImpl(ZhipuProvider zhipuProvider) {
        this.zhipuProvider = zhipuProvider;
    }

    @Override
    public NetworkProvider getProvider() {
        return this.zhipuProvider;
    }

    @Override
    public Flux<QaResponseChunk> sendRequest(NetworkRequest request) {
        logger.debug("ZhipuProviderServiceImpl.sendRequest");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("Accept", "text/event-stream");
        headers.add("Authorization", "Bearer " + request.getApiKey());
        JsonObject body = new JsonObject();
        body.addProperty("model", model);
        JsonArray messages = new JsonArray();
        JsonObject msg = new JsonObject();
        msg.addProperty("content", request.getContent());
        msg.addProperty("role", "user");
        messages.add((JsonElement)msg);
        body.add("messages", (JsonElement)messages);
        body.addProperty("stream", Boolean.valueOf(true));
        JsonArray tools = new JsonArray();
        JsonObject tool = new JsonObject();
        tool.addProperty("type", "web_search");
        JsonObject web_search = new JsonObject();
        web_search.addProperty("enable", Boolean.valueOf(true));
        web_search.addProperty("search_engine", request.getSearchEngine());
        web_search.addProperty("count", (Number)10);
        web_search.addProperty("search_result", Boolean.valueOf(true));
        web_search.addProperty("result_sequence", "before");
        tool.add("web_search", (JsonElement)web_search);
        tools.add((JsonElement)tool);
        body.add("tools", (JsonElement)tools);
        WebClient webClient = WebClient.builder().baseUrl(url).defaultHeaders(h -> h.putAll((Map)headers)).build();
        Flux response = webClient.post().bodyValue((Object)body.toString()).accept(new MediaType[]{MediaType.TEXT_EVENT_STREAM}).retrieve().bodyToFlux(String.class).map(ZhipuProviderServiceImpl::getQaResponseChunk);
        return this.processThink((Flux<QaResponseChunk>)response);
    }

    private static QaResponseChunk getQaResponseChunk(String line) {
        if ("[DONE]".equals(line)) {
            return new QaResponseChunk("", true);
        }
        JsonObject block = (JsonObject)gson.fromJson(line, JsonObject.class);
        try {
            if (block.has("web_search") && !block.get("web_search").isJsonNull()) {
                NetworkReferenceChunk referenceChunk = new NetworkReferenceChunk();
                ArrayList<ReferenceItem> referenceList = new ArrayList<ReferenceItem>();
                JsonArray webSearchs = block.getAsJsonArray("web_search");
                for (int i = 0; i < webSearchs.size(); ++i) {
                    JsonObject webSearch = webSearchs.get(i).getAsJsonObject();
                    ReferenceItem referenceItem = new ReferenceItem();
                    int id = Integer.parseInt(webSearch.get("refer").getAsString().split("_")[1]);
                    referenceItem.setId(id);
                    referenceItem.setTitle(webSearch.get("title").getAsString());
                    String url = webSearch.get("link").getAsString();
                    if (url != null && !url.isEmpty()) {
                        referenceItem.setUrl(url);
                    }
                    referenceItem.setContent(webSearch.get("content").getAsString());
                    referenceItem.setDate(webSearch.get("publish_date").getAsString());
                    referenceItem.setIcon(webSearch.get("icon").getAsString());
                    referenceItem.setImage(webSearch.get("media").getAsString());
                    referenceItem.setVideo(webSearch.get("media").getAsString());
                    referenceList.add(referenceItem);
                }
                referenceChunk.setReferences(referenceList);
                return referenceChunk;
            }
            QaResponseChunk chunk = new QaResponseChunk();
            if (block.has("choices") && !block.get("choices").isJsonNull()) {
                JsonObject delta;
                JsonArray choices = block.getAsJsonArray("choices");
                JsonObject choice = choices.get(0).getAsJsonObject();
                if (choice.has("delta") && !choice.get("delta").isJsonNull() && (delta = choice.getAsJsonObject("delta")).has("content") && !delta.get("content").isJsonNull()) {
                    chunk.setContent(delta.get("content").getAsString());
                }
                if (choice.has("finish_reason") && !choice.get("finish_reason").isJsonNull()) {
                    chunk.setDone("stop".equals(choice.get("finish_reason").getAsString()));
                }
            }
            return chunk;
        }
        catch (JsonSyntaxException e) {
            logger.error("\u5904\u7406\u667a\u8c31ai-search\u6d41\u5f0f\u54cd\u5e94\u7ed3\u679c\u5f02\u5e38: {} ", (Object)e.getMessage());
            throw new HussarException("\u5904\u7406\u667a\u8c31ai-search\u6d41\u5f0f\u54cd\u5e94\u7ed3\u679c\u5f02\u5e38: " + e.getMessage(), (Throwable)e);
        }
    }

    public Flux<QaResponseChunk> processThink(Flux<QaResponseChunk> originStream) {
        StringBuilder cacheStart = new StringBuilder();
        StringBuilder cacheEnd = new StringBuilder();
        AtomicBoolean startThink = new AtomicBoolean(false);
        AtomicBoolean isContent = new AtomicBoolean(false);
        AtomicBoolean cacheEndFlag = new AtomicBoolean(false);
        AtomicInteger firstEndCacheLength = new AtomicInteger();
        return originStream.flatMap(chunk -> {
            if (chunk instanceof NetworkReferenceChunk) {
                return Flux.just((Object)chunk);
            }
            if (isContent.get()) {
                return Flux.just((Object)chunk);
            }
            if (startThink.get()) {
                if (cacheEndFlag.get()) {
                    cacheEnd.append(chunk.getContent());
                    if (cacheEnd.length() > 8 + firstEndCacheLength.get()) {
                        String cacheEndStr = cacheEnd.toString();
                        if (cacheEndStr.contains("</think>")) {
                            isContent.set(true);
                            int thinkIndex = cacheEndStr.indexOf("</think>");
                            String beforeThink = cacheEndStr.substring(0, thinkIndex);
                            String afterThink = cacheEndStr.substring(thinkIndex + "</think>".length());
                            beforeThink = beforeThink.replaceAll("\\s+$", "");
                            afterThink = afterThink.replaceAll("^\\s+", "");
                            QaResponseChunk endThinkChunk = new QaResponseChunk();
                            endThinkChunk.setReasoning_content(beforeThink);
                            QaResponseChunk content = new QaResponseChunk();
                            content.setContent(afterThink);
                            return Flux.just((Object[])new QaResponseChunk[]{endThinkChunk, content});
                        }
                        int searchStart = firstEndCacheLength.get();
                        int idx = cacheEndStr.indexOf(60, searchStart);
                        if (idx != -1) {
                            String reasoningContent = cacheEndStr.substring(0, idx);
                            QaResponseChunk thinkChunk = new QaResponseChunk();
                            thinkChunk.setReasoning_content(reasoningContent);
                            cacheEnd.setLength(0);
                            cacheEnd.append(reasoningContent.substring(idx));
                            firstEndCacheLength.set(0);
                            return Flux.just((Object)thinkChunk);
                        }
                        cacheEndFlag.set(false);
                        QaResponseChunk thinkChunk = new QaResponseChunk();
                        thinkChunk.setReasoning_content(cacheEndStr);
                        cacheEnd.setLength(0);
                        return Flux.just((Object)thinkChunk);
                    }
                    return Flux.empty();
                }
                if (chunk.getContent().contains("</")) {
                    cacheEnd.append(chunk.getContent());
                    int pos = chunk.getContent().indexOf("</");
                    firstEndCacheLength.set(pos);
                    cacheEndFlag.set(true);
                    return Flux.empty();
                }
                chunk.setReasoning_content(chunk.getContent());
                chunk.setContent("");
                return Flux.just((Object)chunk);
            }
            cacheStart.append(chunk.getContent());
            if (cacheStart.length() > 7) {
                if (cacheStart.toString().startsWith("<think>")) {
                    startThink.set(true);
                    cacheStart.delete(0, 8);
                    QaResponseChunk start = new QaResponseChunk();
                    start.setReasoning_content(cacheStart.toString());
                    return Flux.just((Object)start);
                }
                isContent.set(true);
                QaResponseChunk content = new QaResponseChunk();
                content.setContent(cacheStart.toString());
                return Flux.just((Object)content);
            }
            return Flux.empty();
        });
    }
}

