/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.network.factory.impl;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.jxdinfo.hussar.common.model.QaResponseChunk;
import com.jxdinfo.hussar.network.dto.NetworkReferenceChunk;
import com.jxdinfo.hussar.network.dto.NetworkRequest;
import com.jxdinfo.hussar.network.dto.ReferenceItem;
import com.jxdinfo.hussar.network.factory.NetworkProvider;
import com.jxdinfo.hussar.network.factory.NetworkProviderService;
import com.jxdinfo.hussar.network.factory.impl.MetaProvider;
import com.jxdinfo.hussar.platform.core.utils.UnicodeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;

@Service
public class MetaProviderServiceImpl
implements NetworkProviderService {
    private static final Logger logger = LoggerFactory.getLogger(MetaProviderServiceImpl.class);
    private static final String url = "https://metaso.cn/api/v1/chat/completions";
    private static final Gson gson = new Gson();
    private final MetaProvider metaProvider;

    public MetaProviderServiceImpl(MetaProvider metaProvider) {
        this.metaProvider = metaProvider;
    }

    @Override
    public NetworkProvider getProvider() {
        return this.metaProvider;
    }

    @Override
    public Flux<QaResponseChunk> sendRequest(NetworkRequest request) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("Accept", "text/event-stream");
        headers.add("Authorization", "Bearer " + request.getApiKey());
        JsonObject body = new JsonObject();
        JsonArray messages = new JsonArray();
        JsonObject msg = new JsonObject();
        msg.addProperty("content", request.getContent());
        msg.addProperty("role", "user");
        messages.add((JsonElement)msg);
        body.add("messages", (JsonElement)messages);
        body.addProperty("model", request.getSearchEngine());
        body.addProperty("conciseSnippet", Boolean.valueOf(true));
        body.addProperty("stream", Boolean.valueOf(true));
        WebClient webClient = WebClient.builder().baseUrl(url).defaultHeaders(h -> h.putAll((Map)headers)).build();
        Flux result = webClient.post().bodyValue((Object)body.toString()).accept(new MediaType[]{MediaType.TEXT_EVENT_STREAM}).retrieve().bodyToFlux(String.class).map(MetaProviderServiceImpl::getQaResponseChunk);
        return this.processQaChunks((Flux<QaResponseChunk>)result);
    }

    private static QaResponseChunk getQaResponseChunk(String line) {
        try {
            if ("[DONE]".equals(line)) {
                return new QaResponseChunk("", true);
            }
            JsonObject jsonObject = (JsonObject)gson.fromJson(line, JsonObject.class);
            if (jsonObject.has("error") || jsonObject.has("code") && jsonObject.has("message")) {
                logger.error("\u79d8\u5854AI\u670d\u52a1\u8c03\u7528\u5f02\u5e38: {}", (Object)line);
                throw new RuntimeException("\u79d8\u5854AI\u670d\u52a1\u8c03\u7528\u5f02\u5e38: " + line);
            }
            if (!jsonObject.has("choices") || !jsonObject.getAsJsonArray("choices").isJsonArray()) {
                return new QaResponseChunk();
            }
            JsonArray choices = jsonObject.getAsJsonArray("choices");
            if (choices.isEmpty()) {
                return new QaResponseChunk();
            }
            JsonObject firstChoice = choices.get(0).getAsJsonObject();
            if (!firstChoice.has("delta")) {
                return new QaResponseChunk();
            }
            JsonObject delta = firstChoice.getAsJsonObject("delta");
            QaResponseChunk chunk = new QaResponseChunk();
            if (delta.has("citations") && delta.get("citations").isJsonArray()) {
                return MetaProviderServiceImpl.parseReferenceItem(delta);
            }
            if (delta.has("reasoning_content") && delta.get("reasoning_content").isJsonPrimitive()) {
                String reasoning_content = delta.get("reasoning_content").getAsString();
                chunk.setReasoning_content(reasoning_content);
            }
            if (delta.has("content") && delta.get("content").isJsonPrimitive()) {
                String content = delta.get("content").getAsString();
                chunk.setContent(UnicodeUtil.toString((String)content));
            }
            if (firstChoice.has("finish_reason")) {
                chunk.setDone(true);
            } else {
                chunk.setDone(false);
            }
            return chunk;
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u79d8\u5854AI\u6d41\u5f0f\u54cd\u5e94\u7ed3\u679c\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException("\u5904\u7406\u79d8\u5854AI\u6d41\u5f0f\u54cd\u5e94\u7ed3\u679c\u5f02\u5e38: " + e.getMessage(), e);
        }
    }

    private static NetworkReferenceChunk parseReferenceItem(JsonObject delta) {
        JsonArray citations = delta.getAsJsonArray("citations");
        ArrayList<ReferenceItem> references = new ArrayList<ReferenceItem>();
        for (JsonElement elem : citations) {
            JsonObject cit = elem.getAsJsonObject();
            ReferenceItem item = new ReferenceItem();
            if (cit.has("title")) {
                item.setTitle(cit.get("title").getAsString());
            }
            if (cit.has("title")) {
                item.setContent(cit.get("title").getAsString());
            }
            if (cit.has("link")) {
                item.setUrl(cit.get("link").getAsString());
            }
            if (cit.has("date")) {
                item.setDate(cit.get("date").getAsString());
            }
            if (cit.has("authors") && cit.get("authors").isJsonArray()) {
                ArrayList<String> authors = new ArrayList<String>();
                for (JsonElement a : cit.getAsJsonArray("authors")) {
                    authors.add(a.getAsString());
                }
                item.setAuthors(authors);
            }
            references.add(item);
        }
        NetworkReferenceChunk referenceChunk = new NetworkReferenceChunk();
        referenceChunk.setReferences(references);
        return referenceChunk;
    }

    private static String getString(JsonObject obj, String fieldName) {
        return obj.has(fieldName) && !obj.get(fieldName).isJsonNull() ? obj.get(fieldName).getAsString() : null;
    }

    private Flux<QaResponseChunk> processQaChunks(Flux<QaResponseChunk> chunkFlux) {
        ArrayList references = new ArrayList();
        AtomicBoolean refSent = new AtomicBoolean(false);
        return chunkFlux.flatMap(chunk -> {
            if (chunk instanceof NetworkReferenceChunk && !refSent.get()) {
                references.add((NetworkReferenceChunk)((Object)chunk));
                return Flux.empty();
            }
            if (!refSent.getAndSet(true)) {
                NetworkReferenceChunk allRef = this.buildReferenceListJson(references);
                return Flux.just((Object[])new QaResponseChunk[]{allRef, chunk});
            }
            return Flux.just((Object)chunk);
        });
    }

    private NetworkReferenceChunk buildReferenceListJson(List<NetworkReferenceChunk> references) {
        NetworkReferenceChunk referenceTotal = new NetworkReferenceChunk();
        ArrayList<ReferenceItem> referencesTotal = new ArrayList<ReferenceItem>();
        for (NetworkReferenceChunk chunk : references) {
            referencesTotal.addAll(chunk.getReferences());
        }
        referenceTotal.setReferences(referencesTotal);
        return referenceTotal;
    }
}

