/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.graph.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.common.config.AiGraphRagLibrary;
import com.jxdinfo.hussar.common.util.IqaHttpClientUtil;
import com.jxdinfo.hussar.graph.dao.AiGraphBaseMapper;
import com.jxdinfo.hussar.graph.dto.DeleteGraphData;
import com.jxdinfo.hussar.graph.dto.GraphEntity;
import com.jxdinfo.hussar.graph.dto.GraphRelationship;
import com.jxdinfo.hussar.graph.dto.KnowledgeGraphRequest;
import com.jxdinfo.hussar.graph.model.AiGraphBaseModel;
import com.jxdinfo.hussar.graph.service.GraphService;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class GraphServiceImpl
implements GraphService {
    @Resource
    private AiGraphRagLibrary graphConfig;
    @Resource
    private AiGraphBaseMapper aiGraphBaseMapper;

    @Override
    public Map<String, Object> addGraphData(KnowledgeGraphRequest request) {
        ArrayList<GraphEntity> successGraphEntity = new ArrayList<GraphEntity>();
        ArrayList<GraphEntity> errorGraphEntity = new ArrayList<GraphEntity>();
        ArrayList<GraphRelationship> successRelationships = new ArrayList<GraphRelationship>();
        ArrayList<GraphRelationship> errorRelationships = new ArrayList<GraphRelationship>();
        List<GraphEntity> entities = request.getEntities();
        List<GraphRelationship> relationships = request.getRelationships();
        Date now = new Date();
        List<String> ruleList = request.getTypes();
        HussarException.throwByNull(ruleList, (String)"\u4f20\u5165\u7684\u56fe\u8c31\u62bd\u53d6\u89c4\u5219\u4fe1\u606f\u4e3a\u7a7a!");
        for (GraphEntity entity : entities) {
            String type = entity.getType();
            if (!ruleList.contains(type)) continue;
            List<String> description = entity.getDescription();
            ArrayList propList = new ArrayList();
            HashMap<String, Object> propMap = new HashMap<String, Object>();
            propMap.put("propKey", "descriptions");
            propMap.put("propValue", description);
            propMap.put("propType", "STRING");
            propMap.put("ifMulti", "1");
            propList.add(propMap);
            try {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("name", entity.getName());
                map.put("nodeType", entity.getType());
                map.put("propList", propList);
                String delResult = IqaHttpClientUtil.httpPost((String)(this.graphConfig.getNeo4jServer() + "/instanceManage/addNode"), (String)JSONObject.toJSONString(map), new HashMap());
                JSONObject jsonObject = JSON.parseObject((String)delResult);
                if (jsonObject.getInteger("code") != 10000) {
                    errorGraphEntity.add(entity);
                    continue;
                }
                JSONArray dataArray = jsonObject.getJSONArray("data");
                if (dataArray != null && !dataArray.isEmpty()) {
                    JSONObject firstItem = dataArray.getJSONObject(0);
                    Long graphId = firstItem.getLong("id");
                    AiGraphBaseModel aiGraphBaseModel = new AiGraphBaseModel();
                    aiGraphBaseModel.setNodeId(entity.getId());
                    aiGraphBaseModel.setGraphId(graphId);
                    aiGraphBaseModel.setType("0");
                    aiGraphBaseModel.setCreateTime(now);
                    this.aiGraphBaseMapper.insert(aiGraphBaseModel);
                    successGraphEntity.add(entity);
                    continue;
                }
                errorGraphEntity.add(entity);
            }
            catch (Exception e) {
                errorGraphEntity.add(entity);
            }
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"TYPE", (Object)"0");
        List linkList = this.aiGraphBaseMapper.selectList((Wrapper)queryWrapper);
        if (linkList != null && !linkList.isEmpty()) {
            HashMap<Long, Long> linkMap = new HashMap<Long, Long>();
            for (AiGraphBaseModel model : linkList) {
                linkMap.put(model.getNodeId(), model.getGraphId());
            }
            for (GraphRelationship relationship : relationships) {
                Long source_id = relationship.getSource_id();
                Long target_id = relationship.getTarget_id();
                if (linkMap.containsKey(source_id) && linkMap.containsKey(target_id)) {
                    HashMap sourceNode = new HashMap();
                    sourceNode.put("id", linkMap.get(source_id));
                    HashMap targetNode = new HashMap();
                    targetNode.put("id", linkMap.get(target_id));
                    try {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        ArrayList propList = new ArrayList();
                        HashMap propMap = new HashMap();
                        propList.add(propMap);
                        map.put("name", relationship.getType());
                        map.put("sourceNode", sourceNode);
                        map.put("targetNode", targetNode);
                        map.put("propList", propList);
                        String delResult = IqaHttpClientUtil.httpPost((String)(this.graphConfig.getNeo4jServer() + "/instanceManage/addRelation"), (String)JSONObject.toJSONString(map), new HashMap());
                        JSONObject jsonObject = JSON.parseObject((String)delResult);
                        if (jsonObject.getInteger("code") != 10000) {
                            errorRelationships.add(relationship);
                            continue;
                        }
                        JSONArray dataArray = jsonObject.getJSONArray("data");
                        if (dataArray != null && !dataArray.isEmpty()) {
                            JSONObject firstItem = dataArray.getJSONObject(0);
                            Long edgeId = firstItem.getLong("id_edge");
                            AiGraphBaseModel aiGraphBaseModel = new AiGraphBaseModel();
                            aiGraphBaseModel.setRelationId(relationship.getId());
                            aiGraphBaseModel.setGraphRelId(edgeId);
                            aiGraphBaseModel.setType("1");
                            aiGraphBaseModel.setCreateTime(now);
                            this.aiGraphBaseMapper.insert(aiGraphBaseModel);
                            successRelationships.add(relationship);
                            continue;
                        }
                        errorRelationships.add(relationship);
                    }
                    catch (Exception e) {
                        errorRelationships.add(relationship);
                    }
                    continue;
                }
                errorRelationships.add(relationship);
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("successEntities", successGraphEntity);
        result.put("errorEntities", errorGraphEntity);
        result.put("successRelations", successRelationships);
        result.put("errorRelations", errorRelationships);
        return result;
    }

    @Override
    public void deleteGraphData(DeleteGraphData data) {
        List<Integer> entity_ids;
        List<Integer> relationship_ids = data.getRelationship_ids();
        if (relationship_ids != null && !relationship_ids.isEmpty()) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"TYPE", (Object)"1");
            List linkList = this.aiGraphBaseMapper.selectList((Wrapper)queryWrapper);
            if (linkList != null && !linkList.isEmpty()) {
                HashMap<Long, Long> linkMap = new HashMap<Long, Long>();
                for (AiGraphBaseModel model : linkList) {
                    linkMap.put(model.getRelationId(), model.getGraphRelId());
                }
                List entityIds = relationship_ids.stream().map(String::valueOf).collect(Collectors.toList());
                ArrayList ableDelete = new ArrayList();
                for (String entds : entityIds) {
                    Long stId = Long.valueOf(entds);
                    if (!linkMap.containsKey(stId)) continue;
                    ableDelete.add(String.valueOf(linkMap.get(stId)));
                }
                if (!ableDelete.isEmpty()) {
                    String ids = StringUtil.join((Collection)ableDelete, (String)",");
                    String delResult = IqaHttpClientUtil.httpGet((String)(this.graphConfig.getNeo4jServer() + "/instanceManage/deleteRelations?ids=" + ids), new HashMap());
                    JSONObject jsonObject = JSON.parseObject((String)delResult);
                    if (jsonObject.getInteger("code") != 10000) {
                        throw new HussarException("\u8c03\u7528\u5220\u9664\u56fe\u8c31\u5173\u7cfb\u6570\u636e\u63a5\u53e3\u5931\u8d25!");
                    }
                    boolean success = jsonObject.getBoolean("success");
                    if (!success) {
                        throw new HussarException("\u5220\u9664\u56fe\u8c31\u5173\u7cfb\u6570\u636e\u5931\u8d25!");
                    }
                }
            }
        }
        if ((entity_ids = data.getEntity_ids()) != null && !entity_ids.isEmpty()) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"TYPE", (Object)"0");
            List linkList = this.aiGraphBaseMapper.selectList((Wrapper)queryWrapper);
            if (linkList != null && !linkList.isEmpty()) {
                HashMap<Long, Long> linkMap = new HashMap<Long, Long>();
                for (AiGraphBaseModel model : linkList) {
                    linkMap.put(model.getNodeId(), model.getGraphId());
                }
                List entityIds = entity_ids.stream().map(String::valueOf).collect(Collectors.toList());
                ArrayList<String> ableNodeDelete = new ArrayList<String>();
                for (String entds : entityIds) {
                    Long stId = Long.valueOf(entds);
                    if (!linkMap.containsKey(stId)) continue;
                    ableNodeDelete.add(String.valueOf(linkMap.get(stId)));
                }
                if (!ableNodeDelete.isEmpty()) {
                    String ids = StringUtil.join(ableNodeDelete, (String)",");
                    String delResult = IqaHttpClientUtil.httpGet((String)(this.graphConfig.getNeo4jServer() + "/instanceManage/deleteNodes?ids=" + ids), new HashMap());
                    JSONObject jsonObject = JSON.parseObject((String)delResult);
                    if (jsonObject.getInteger("code") != 10000) {
                        throw new HussarException("\u8c03\u7528\u5220\u9664\u56fe\u8c31\u5b9e\u4f8b\u6570\u636e\u63a5\u53e3\u5931\u8d25!");
                    }
                    boolean success = jsonObject.getBoolean("success");
                    if (!success) {
                        throw new HussarException("\u5220\u9664\u56fe\u8c31\u5b9e\u4f8b\u6570\u636e\u5931\u8d25!");
                    }
                }
            }
        }
    }
}

