/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.doclibrary.util;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExtractImageUtil {
    public static List<String> getBase64(String content, LinkedHashMap<String, String> imageMap) {
        ArrayList<String> base64Images = new ArrayList<String>();
        if (HussarUtils.isNotEmpty((Object)content)) {
            String regex = "<image>(.*?)</image>";
            Pattern pattern = Pattern.compile(regex, 32);
            Matcher matcher = pattern.matcher(content);
            while (matcher.find()) {
                String matchedContent = matcher.group(1);
                if (!imageMap.containsKey(matchedContent)) continue;
                base64Images.add(imageMap.get(matchedContent));
            }
        }
        return base64Images;
    }

    public static HashMap<String, String> getBase64Map(String content, LinkedHashMap<String, String> imageMap) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (HussarUtils.isNotEmpty((Object)content)) {
            String regex = "<image>(.*?)</image>";
            Pattern pattern = Pattern.compile(regex, 32);
            Matcher matcher = pattern.matcher(content);
            while (matcher.find()) {
                String matchedContent = matcher.group(1);
                if (!imageMap.containsKey(matchedContent)) continue;
                map.put(matchedContent, imageMap.get(matchedContent));
            }
        }
        return map;
    }

    public static void main(String[] args) {
        String content = "<p>This is some text with an image: <image>image_1</image> and another image: <image>image_2</image></p>";
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("image_1", "111111");
        map.put("image_2", "2222222");
        map.put("image_3", "333333");
        List<String> base64 = ExtractImageUtil.getBase64(content, map);
        System.out.println(base64);
    }
}

