/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.doclibrary.service.impl;

import cn.hutool.core.lang.Snowflake;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.common.config.AiDocumentLibrary;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.util.IqaHttpClientUtil;
import com.jxdinfo.hussar.doclibrary.dao.KnowledgeBaseMapper;
import com.jxdinfo.hussar.doclibrary.dto.DeleteParam;
import com.jxdinfo.hussar.doclibrary.dto.KnowledgeBasePageObj;
import com.jxdinfo.hussar.doclibrary.model.AIKnowledgeBase;
import com.jxdinfo.hussar.doclibrary.model.QAFileBase;
import com.jxdinfo.hussar.doclibrary.service.DocService;
import com.jxdinfo.hussar.doclibrary.service.KnowledgeBaseService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class KnowledgeBaseServiceImpl
implements KnowledgeBaseService {
    private static final Logger logger = LoggerFactory.getLogger(KnowledgeBaseServiceImpl.class);
    @Resource
    private KnowledgeBaseMapper modelDao;
    @Resource
    private DocService docService;
    @Resource
    private AiDocumentLibrary docLibraryConfig;

    @Override
    public String createKnowledBase(String knowledgeBaseName, String knowledgeBaseType, String description, String splittingStrategyId, String processingMode, List<String> entityExtractionRule) {
        Snowflake snowflake = new Snowflake(10L, 10L);
        Long modelId = snowflake.nextId();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("knowledge_name", modelId.toString());
        String msg = "";
        String delResult = IqaHttpClientUtil.httpPost((String)this.docLibraryConfig.getCreateKnowledgeBaseUrl(), (String)JSONObject.toJSONString(param), new HashMap());
        JSONObject jsonObject = JSON.parseObject((String)delResult);
        Integer code = jsonObject.getInteger("code");
        if (code != 2000) {
            logger.error(delResult);
            throw new HussarException("\u5411\u91cf\u5316\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
        }
        AIKnowledgeBase model = new AIKnowledgeBase();
        model.setId(modelId);
        if ("knowledge".equals(knowledgeBaseType)) {
            model.setBaseType("0");
            model.setDescription(description);
            model.setSplittingStrategyId(Long.parseLong(splittingStrategyId));
            model.setProcessingMode(processingMode);
            model.setEntityExtractionRule(entityExtractionRule);
        } else if ("question".equals(knowledgeBaseType)) {
            model.setBaseType("1");
        }
        model.setKbName(knowledgeBaseName);
        model.setFileCount(0);
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user != null) {
            model.setCreateUserId(user.getId());
            model.setCreateUserName(user.getName());
        }
        model.setCreateTime(new Date());
        model.setDelFlag("0");
        QueryWrapper qw = new QueryWrapper();
        ((QueryWrapper)qw.orderByDesc((Object)"SEQ")).last("LIMIT 1");
        List knowledgeBaseModelList = this.modelDao.selectList((Wrapper)qw);
        if (knowledgeBaseModelList != null && !knowledgeBaseModelList.isEmpty()) {
            AIKnowledgeBase knowledgeBaseModel = (AIKnowledgeBase)((Object)knowledgeBaseModelList.get(0));
            int maxOrderNum = knowledgeBaseModel.getSeq();
            model.setSeq(maxOrderNum + 1);
        } else {
            model.setSeq(1);
        }
        this.modelDao.insert((Object)model);
        return msg;
    }

    @Override
    public List<KnowledgeBasePageObj> getknowledgeBasesList(String query, String type) {
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user == null) {
            return null;
        }
        QueryWrapper qw = new QueryWrapper();
        qw.eq((Object)"DEL_FLAG", (Object)"0");
        if ("knowledge".equals(type)) {
            qw.eq((Object)"BASE_TYPE", (Object)"0");
        } else if ("question".equals(type)) {
            qw.eq((Object)"BASE_TYPE", (Object)"1");
        }
        qw.eq((Object)"CREATE_USER_ID", (Object)user.getId());
        if (HussarUtils.isNotEmpty((Object)query)) {
            qw.like((Object)"KB_NAME", (Object)query);
        }
        qw.orderByAsc((Object)"SEQ");
        List modelList = this.modelDao.selectList((Wrapper)qw);
        ArrayList<KnowledgeBasePageObj> reslist = new ArrayList<KnowledgeBasePageObj>();
        for (AIKnowledgeBase model : modelList) {
            KnowledgeBasePageObj kb = new KnowledgeBasePageObj();
            kb.setKbId(model.getId());
            kb.setKbName(model.getKbName());
            kb.setDescription(model.getDescription());
            kb.setSplittingStrategyId(model.getSplittingStrategyId());
            kb.setProcessingMode(model.getProcessingMode());
            if (model.getEntityExtractionRule() != null) {
                kb.setEntityExtractionRule(model.getEntityExtractionRule());
            } else {
                ArrayList<String> newList = new ArrayList<String>();
                kb.setEntityExtractionRule(newList);
            }
            reslist.add(kb);
        }
        return reslist;
    }

    @Override
    @HussarTransactional
    public String delKnowledBase(String kbName, String kbType) {
        String delResult;
        JSONObject jsonObject;
        Integer code;
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("knowledge_name", kbName);
        String msg = "";
        Long baseId = Long.parseLong(kbName);
        List<QAFileBase> fileBases = this.docService.selectDocByKbId(baseId);
        if (HussarUtils.isNotEmpty(fileBases)) {
            List<Long> docIds = fileBases.stream().map(QAFileBase::getDocId).collect(Collectors.toList());
            DeleteParam deleteParam = new DeleteParam();
            deleteParam.setDocBaseId(baseId);
            deleteParam.setDocIds(docIds);
            this.docService.delete(deleteParam);
        }
        if ((code = (jsonObject = JSON.parseObject((String)(delResult = IqaHttpClientUtil.httpPost((String)this.docLibraryConfig.getDeleteKnowledgeBaseUrl(), (String)JSONObject.toJSONString(param), new HashMap())))).getInteger("code")) != 2000) {
            logger.error(delResult);
            throw new HussarException("\u5411\u91cf\u5316\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
        }
        QueryWrapper ew = new QueryWrapper();
        ew.eq((Object)"BASE_ID", (Object)kbName);
        if ("knowledge".equals(kbType)) {
            ew.eq((Object)"BASE_TYPE", (Object)"0");
        } else if ("question".equals(kbType)) {
            ew.eq((Object)"BASE_TYPE", (Object)"1");
        }
        AIKnowledgeBase model = (AIKnowledgeBase)((Object)this.modelDao.selectOne((Wrapper)ew));
        if (model != null) {
            model.setDelFlag("1");
            this.modelDao.updateById((Object)model);
        }
        return msg;
    }

    @Override
    public Boolean editKnowledBase(String knowledgeBaseName, String description, String splittingStrategyId, String baseId, List<String> entityExtractionRule) {
        HussarException.throwByNull((Object)baseId, (String)"\u77e5\u8bc6\u5e93id\u4e3a\u7a7a");
        AIKnowledgeBase base = new AIKnowledgeBase();
        base.setId(Long.parseLong(baseId));
        base.setKbName(knowledgeBaseName);
        base.setDescription(description);
        if (HussarUtils.isNotEmpty((Object)splittingStrategyId)) {
            base.setSplittingStrategyId(Long.parseLong(splittingStrategyId));
        }
        base.setEntityExtractionRule(entityExtractionRule);
        this.modelDao.updateById((Object)base);
        return true;
    }

    @Override
    public AIKnowledgeBase qryKnoeledgeBase(Long baseId) {
        HussarException.throwByNull((Object)baseId, (String)"\u77e5\u8bc6\u5e93id\u4e3a\u7a7a");
        return (AIKnowledgeBase)((Object)this.modelDao.selectById(baseId));
    }

    @Override
    public Boolean checkName(String baseName, Long baseId) {
        List ids;
        Boolean flag = false;
        HussarException.throwByNull((Object)baseName, (String)"\u77e5\u8bc6\u5e93\u540d\u79f0\u4e3a\u7a7a");
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.eq(AIKnowledgeBase::getKbName, (Object)baseName);
        qw.eq(AIKnowledgeBase::getDelFlag, (Object)"0");
        qw.eq(AIKnowledgeBase::getBaseType, (Object)"0");
        List aiKnowledgeBases = this.modelDao.selectList((Wrapper)qw);
        if (HussarUtils.isEmpty((Object)baseId)) {
            if (HussarUtils.isNotEmpty((Object)aiKnowledgeBases)) {
                flag = true;
            }
        } else if (HussarUtils.isNotEmpty((Object)aiKnowledgeBases) && !(ids = aiKnowledgeBases.stream().map(AIKnowledgeBase::getId).collect(Collectors.toList())).contains(baseId)) {
            flag = true;
        }
        return flag;
    }
}

