/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.doclibrary.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.common.config.AiDocumentLibrary;
import com.jxdinfo.hussar.common.util.IqaHttpClientUtil;
import com.jxdinfo.hussar.doclibrary.dao.FileBaseMapper;
import com.jxdinfo.hussar.doclibrary.dao.IQADocFragmentMapper;
import com.jxdinfo.hussar.doclibrary.dto.EnableDto;
import com.jxdinfo.hussar.doclibrary.dto.MergeDto;
import com.jxdinfo.hussar.doclibrary.dto.QADocFragmentListDto;
import com.jxdinfo.hussar.doclibrary.dto.UpdateEmbeddingDto;
import com.jxdinfo.hussar.doclibrary.dto.UpdateEmbeddingResultDto;
import com.jxdinfo.hussar.doclibrary.model.QADocFragment;
import com.jxdinfo.hussar.doclibrary.model.QAFileBase;
import com.jxdinfo.hussar.doclibrary.model.QAFileDoc;
import com.jxdinfo.hussar.doclibrary.service.DocService;
import com.jxdinfo.hussar.doclibrary.service.IQADocFragmentService;
import com.jxdinfo.hussar.doclibrary.service.QADocAttachmentService;
import com.jxdinfo.hussar.doclibrary.vo.DocFragmentListVo;
import com.jxdinfo.hussar.doclibrary.vo.PageDocFragmentListVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.vector.dto.EmbedDTO;
import com.jxdinfo.hussar.vector.dto.EmbedParam;
import com.jxdinfo.hussar.vector.util.VectorUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.tomcat.util.threads.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class QADocFragmentServiceImpl
extends ServiceImpl<IQADocFragmentMapper, QADocFragment>
implements IQADocFragmentService {
    @Autowired
    private IQADocFragmentMapper qaDocFragmentMapper;
    @Resource
    private AiDocumentLibrary docLibraryConfig;
    @Resource
    @Lazy
    private DocService docService;
    @Resource
    private QADocAttachmentService qaDocAttachmentService;
    @Resource
    private FileBaseMapper fileBaseMapper;
    private static final ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(5, 100, 10000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue());
    private static final Logger logger = LoggerFactory.getLogger(QADocFragmentServiceImpl.class);

    @Override
    public PageDocFragmentListVo listQaDocFragment(Page<QADocFragment> page, QADocFragmentListDto queryModel) {
        try {
            Long fragmentId = null;
            Long docSourceId = null;
            Long fileBaseId = null;
            if (queryModel.getDocFragmentId() != null) {
                fragmentId = Long.valueOf(queryModel.getDocFragmentId());
            }
            if (queryModel.getDocSourceId() != null) {
                docSourceId = Long.valueOf(queryModel.getDocSourceId());
            }
            if (queryModel.getFileBaseId() != null) {
                fileBaseId = Long.valueOf(queryModel.getFileBaseId());
            }
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(HussarUtils.isNotEmpty((Object)queryModel.getDocFragmentId()), QADocFragment::getDocFragmentId, (Object)fragmentId)).eq(HussarUtils.isNotEmpty((Object)queryModel.getDocSourceId()), QADocFragment::getDocSourceId, (Object)docSourceId)).eq(HussarUtils.isNotEmpty((Object)queryModel.getFileBaseId()), QADocFragment::getFileBaseId, (Object)fileBaseId)).and(HussarUtils.isNotEmpty((Object)queryModel.getQueryContent()), wrapper1 -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.like(QADocFragment::getContent, (Object)queryModel.getQueryContent())).or()).apply(HussarUtils.isNotEmpty((Object)queryModel.getQueryContent()), "SUBSTRING(        SUBSTRING(TITLE, CHAR_LENGTH(SUBSTRING_INDEX(TITLE, '\u8be5\u90e8\u5206\u5185\u5bb9\u5173\u4e8e', 1)) + 8),        1,        LOCATE('\u3002', SUBSTRING(TITLE, CHAR_LENGTH(SUBSTRING_INDEX(TITLE, '\u8be5\u90e8\u5206\u5185\u5bb9\u5173\u4e8e', 1)) + 8)) - 1    ) LIKE CONCAT('%', {0}, '%')", new Object[]{queryModel.getQueryContent()});
            })).eq(HussarUtils.isNotEmpty((Object)queryModel.getEnable()), QADocFragment::getEnable, (Object)queryModel.getEnable())).orderByAsc(QADocFragment::getSeq);
            page = (Page)this.qaDocFragmentMapper.selectPage((IPage)page, (Wrapper)wrapper);
            List<DocFragmentListVo> docFragmentListVoList = QADocFragmentServiceImpl.getDocFragmentListVos((Page<QADocFragment>)page);
            PageDocFragmentListVo pageDocFragmentListVo = new PageDocFragmentListVo();
            pageDocFragmentListVo.setList(docFragmentListVoList);
            pageDocFragmentListVo.setTotal(page.getTotal());
            pageDocFragmentListVo.setPages(page.getPages());
            return pageDocFragmentListVo;
        }
        catch (Exception e) {
            throw new HussarException("\u5217\u8868\u5c55\u793a\u5931\u8d25", (Throwable)e);
        }
    }

    private static List<DocFragmentListVo> getDocFragmentListVos(Page<QADocFragment> page) {
        ArrayList<DocFragmentListVo> docFragmentListVoList = new ArrayList<DocFragmentListVo>();
        List qaDocFragmentList = page.getRecords();
        for (int i = 0; i < qaDocFragmentList.size(); ++i) {
            QADocFragment qaDocFragment = (QADocFragment)((Object)qaDocFragmentList.get(i));
            DocFragmentListVo docFragmentListVo = new DocFragmentListVo();
            docFragmentListVo.setTitle(qaDocFragment.getTitle());
            docFragmentListVo.setContent(qaDocFragment.getContent());
            docFragmentListVo.setSeq(String.valueOf(qaDocFragment.getSeq()));
            docFragmentListVo.setDocFragmentId(String.valueOf(qaDocFragment.getDocFragmentId()));
            docFragmentListVo.setEnable(qaDocFragment.getEnable());
            byte[] byteBase64 = qaDocFragment.getImagesBase64();
            if (byteBase64 != null) {
                List<String> base64 = QADocFragmentServiceImpl.deserializeByteArrayToList(byteBase64);
                docFragmentListVo.setImagesBase64(base64);
            }
            docFragmentListVoList.add(docFragmentListVo);
        }
        return docFragmentListVoList;
    }

    /*
     * Exception decompiling
     */
    public static List<String> deserializeByteArrayToList(byte[] byteArray) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static String deserializeByteArrayToString(byte[] byteArray) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    @HussarTransactional
    public ApiResponse<Boolean> del(EnableDto enableDto) {
        try {
            List<String> ids = enableDto.getIds();
            List idsLong = ids.stream().map(Long::valueOf).collect(Collectors.toList());
            Boolean isSuccess = this.removeByIds(ids);
            if (enableDto.getIsUpdate().booleanValue() && "1".equals(this.docService.getFileBase(enableDto.getFileBaseId(), enableDto.getDocSourceId()).getEnable()) && !this.updateEmbeddingByLLM(enableDto.getDocSourceId(), enableDto.getFileBaseId()).booleanValue()) {
                throw new HussarException("\u6a21\u578b\u5411\u91cf\u5316\u5931\u8d25");
            }
            this.updateFragmentsNumber(enableDto.getDocSourceId(), enableDto.getFileBaseId());
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.in((Object)"DOC_FRAGMENT_ID", idsLong);
            this.qaDocAttachmentService.remove((Wrapper)wrapper);
            return ApiResponse.success((Object)isSuccess);
        }
        catch (Exception e) {
            throw new HussarException("\u5220\u9664\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    @HussarTransactional
    public void merge(MergeDto mergeDto) {
        try {
            ArrayList<Long> idList = new ArrayList<Long>();
            for (int i = 0; i < mergeDto.getIds().size(); ++i) {
                idList.add(Long.valueOf(mergeDto.getIds().get(i)));
            }
            List QADocFragments = this.qaDocFragmentMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(QADocFragment::getDocFragmentId, idList)).orderByAsc(QADocFragment::getSeq));
            ArrayList<String> delIds = new ArrayList<String>();
            ArrayList<String> mergedImagesBase64 = new ArrayList<String>();
            for (int i = 0; i < QADocFragments.size(); ++i) {
                QADocFragment qaDocFragment = (QADocFragment)((Object)QADocFragments.get(i));
                List<String> base64 = QADocFragmentServiceImpl.deserializeByteArrayToList(qaDocFragment.getImagesBase64());
                if (base64 != null) {
                    mergedImagesBase64.addAll(base64);
                }
                if (i == 0) continue;
                delIds.add(String.valueOf(qaDocFragment.getDocFragmentId()));
            }
            QADocFragment newQADocFragment = (QADocFragment)((Object)QADocFragments.get(0));
            newQADocFragment.setTitle(mergeDto.getTitle());
            newQADocFragment.setContent(mergeDto.getContent());
            newQADocFragment.setEnable("1");
            newQADocFragment.setStringBase64(mergedImagesBase64);
            this.qaDocFragmentMapper.updateById((Object)newQADocFragment);
            List delIdsLong = delIds.stream().map(Long::valueOf).collect(Collectors.toList());
            UpdateWrapper wrapper = new UpdateWrapper();
            wrapper.set((Object)"DOC_FRAGMENT_ID", (Object)newQADocFragment.getDocFragmentId());
            wrapper.in((Object)"DOC_FRAGMENT_ID", delIdsLong);
            this.qaDocAttachmentService.update((Wrapper)wrapper);
            this.removeByIds(delIds);
            if ("1".equals(this.docService.getFileBase(mergeDto.getFileBaseId(), mergeDto.getDocSourceId()).getEnable()) && !this.updateEmbeddingByLLM(mergeDto.getDocSourceId(), mergeDto.getFileBaseId()).booleanValue()) {
                throw new HussarException("\u6a21\u578b\u5411\u91cf\u5316\u5931\u8d25");
            }
            this.updateFragmentsNumber(mergeDto.getDocSourceId(), mergeDto.getFileBaseId());
        }
        catch (Exception e) {
            throw new HussarException("\u5408\u5e76\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public void enableOrDisable(List<String> ids, String enable) {
        this.qaDocFragmentMapper.updateBatch(ids, enable);
    }

    @Override
    public QADocFragment isSave(QADocFragment qaDocFragment) {
        if (HussarUtils.isEmpty((Object)qaDocFragment.getDocFragmentId())) {
            Integer seq = this.qaDocFragmentMapper.selectMaxSeq(qaDocFragment);
            if (seq != null) {
                qaDocFragment.setSeq(seq + 1);
            } else {
                qaDocFragment.setSeq(1);
            }
        } else {
            QADocFragment qaDocFragment1 = (QADocFragment)((Object)this.qaDocFragmentMapper.selectById(qaDocFragment.getDocFragmentId()));
            qaDocFragment.setSeq(qaDocFragment1.getSeq());
        }
        return qaDocFragment;
    }

    @Override
    @HussarTransactional
    public void delByFileAndBase(List<Long> docSourceIds, Long fileBaseId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(HussarUtils.isNotEmpty((Object)fileBaseId), QADocFragment::getFileBaseId, (Object)fileBaseId)).in(HussarUtils.isNotEmpty(docSourceIds), QADocFragment::getDocSourceId, docSourceIds);
        LambdaQueryWrapper wrapper1 = (LambdaQueryWrapper)wrapper.clone();
        wrapper1.select(new SFunction[]{QADocFragment::getDocFragmentId});
        List fragmentsToDelete = this.qaDocFragmentMapper.selectObjs((Wrapper)wrapper1);
        List idsToDelete = fragmentsToDelete.stream().map(obj -> (Long)obj).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(idsToDelete)) {
            QueryWrapper picWrapper = new QueryWrapper();
            picWrapper.in((Object)"DOC_FRAGMENT_ID", idsToDelete);
            this.qaDocAttachmentService.remove((Wrapper)picWrapper);
        }
        this.qaDocFragmentMapper.delete((Wrapper)wrapper);
    }

    @Override
    public Boolean updateEmbeddingByLLM(Long docSourceId, Long fileBaseId) {
        threadPoolExecutor.execute(() -> {
            UpdateWrapper wrapper;
            List<QADocFragment> enabledFragments = this.selectEnabledFragments(docSourceId, fileBaseId);
            UpdateEmbeddingDto embeddingDto = this.convertDto(enabledFragments, docSourceId, fileBaseId);
            List<String> splitedTexts = embeddingDto.getSplitedTexts();
            String fileName = embeddingDto.getFileName();
            QAFileBase fileBase = new QAFileBase();
            fileBase.setState("1");
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.eq((Object)"DOCBASE_ID", (Object)fileBaseId);
            updateWrapper.eq((Object)"DOC_ID", (Object)docSourceId);
            this.fileBaseMapper.update(fileBase, (Wrapper)updateWrapper);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("document_name", fileName);
            map.put("knowledge_name", String.valueOf(fileBaseId));
            String delResult = IqaHttpClientUtil.httpPost((String)this.docLibraryConfig.getDeleteByDocumentNameUrl(), (String)JSONObject.toJSONString(map), new HashMap());
            JSONObject jsonObject = JSON.parseObject((String)delResult);
            Integer code = jsonObject.getInteger("code");
            if (code != 2000) {
                QAFileBase failFileBase = new QAFileBase();
                failFileBase.setState("4");
                failFileBase.setReason(delResult);
                UpdateWrapper wrapper2 = new UpdateWrapper();
                wrapper2.eq((Object)"DOCBASE_ID", (Object)fileBaseId);
                wrapper2.eq((Object)"DOC_ID", (Object)docSourceId);
                this.fileBaseMapper.update(failFileBase, (Wrapper)wrapper2);
            }
            QueryWrapper fileBasWrapper = new QueryWrapper();
            fileBasWrapper.eq((Object)"DOCBASE_ID", (Object)fileBaseId);
            fileBasWrapper.eq((Object)"DOC_ID", (Object)docSourceId);
            QAFileBase qaFileDoc = (QAFileBase)this.fileBaseMapper.selectOne((Wrapper)fileBasWrapper);
            EmbedDTO embedDTO = VectorUtil.getVectorMap(splitedTexts, (String)this.docLibraryConfig.getEmbedUrl());
            if (HussarUtils.isEmpty((Object)embedDTO)) {
                QAFileBase failFileBase = new QAFileBase();
                failFileBase.setState("4");
                failFileBase.setReason("\u5411\u91cf\u5316\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
                UpdateWrapper wrapper3 = new UpdateWrapper();
                wrapper3.eq((Object)"DOCBASE_ID", (Object)fileBaseId);
                wrapper3.eq((Object)"DOC_ID", (Object)qaFileDoc.getDocId());
                this.fileBaseMapper.update(failFileBase, (Wrapper)wrapper3);
            }
            List dense = embedDTO.getDense();
            List contents = embedDTO.getContents();
            ArrayList<EmbedParam> embedParams = new ArrayList<EmbedParam>();
            for (int i = 0; i < contents.size(); ++i) {
                EmbedParam embedParam = new EmbedParam(String.valueOf(fileBaseId), (String)contents.get(i), (List)dense.get(i), fileName);
                embedParams.add(embedParam);
            }
            HashMap<String, ArrayList<EmbedParam>> inmap = new HashMap<String, ArrayList<EmbedParam>>();
            inmap.put("items", embedParams);
            String inParam = JSONObject.toJSONString(inmap);
            String result = IqaHttpClientUtil.httpPost((String)this.docLibraryConfig.getBatchAddDataUrl(), (String)inParam, new HashMap());
            JSONObject addObject = JSON.parseObject((String)result);
            Integer addCode = addObject.getInteger("code");
            if (addCode != 2000) {
                QAFileBase failFileBase = new QAFileBase();
                failFileBase.setState("4");
                failFileBase.setReason("\u5411\u91cf\u5e93\u6dfb\u52a0\u5931\u8d25");
                wrapper = new UpdateWrapper();
                wrapper.eq((Object)"DOCBASE_ID", (Object)fileBaseId);
                wrapper.eq((Object)"DOC_ID", (Object)qaFileDoc.getDocId());
                this.fileBaseMapper.update(failFileBase, (Wrapper)wrapper);
            }
            QAFileBase successFileBase = new QAFileBase();
            successFileBase.setState("2");
            wrapper = new UpdateWrapper();
            wrapper.eq((Object)"DOCBASE_ID", (Object)fileBaseId);
            wrapper.eq((Object)"DOC_ID", (Object)docSourceId);
            this.fileBaseMapper.update(successFileBase, (Wrapper)wrapper);
        });
        return true;
    }

    @Override
    public List<UpdateEmbeddingDto> getWordContent(Long[] docSourceIds, Long fileBaseId) {
        ArrayList<UpdateEmbeddingDto> embeddingDtos = new ArrayList<UpdateEmbeddingDto>();
        for (Long l : docSourceIds) {
            List<QADocFragment> enabledFragments = this.selectEnabledFragments(l, fileBaseId);
            embeddingDtos.add(this.convertDto(enabledFragments, l, fileBaseId));
        }
        return embeddingDtos;
    }

    @Override
    public void saveOrResave(List<QADocFragment> qaDocFragments) {
        Long docSourceId = qaDocFragments.get(0).getDocSourceId();
        Long fileBaseId = qaDocFragments.get(0).getFileBaseId();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(HussarUtils.isNotEmpty((Object)fileBaseId), QADocFragment::getFileBaseId, (Object)fileBaseId)).eq(HussarUtils.isNotEmpty((Object)docSourceId), QADocFragment::getDocSourceId, (Object)docSourceId);
        List qaDocFragment = this.qaDocFragmentMapper.selectList((Wrapper)wrapper);
        if (!qaDocFragment.isEmpty()) {
            ArrayList<Long> docSourceIds = new ArrayList<Long>();
            docSourceIds.add(docSourceId);
            this.delByFileAndBase(docSourceIds, fileBaseId);
        }
        this.saveBatch(qaDocFragments);
    }

    @Override
    public List<QADocFragment> selectEnabledFragments(Long docSourceId, Long fileBaseId) {
        String enabled = "1";
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(HussarUtils.isNotEmpty((Object)docSourceId), QADocFragment::getDocSourceId, (Object)docSourceId)).eq(HussarUtils.isNotEmpty((Object)fileBaseId), QADocFragment::getFileBaseId, (Object)fileBaseId)).eq(QADocFragment::getEnable, (Object)enabled)).orderByAsc(QADocFragment::getSeq);
        return this.qaDocFragmentMapper.selectList((Wrapper)wrapper);
    }

    @Override
    public UpdateEmbeddingDto convertDto(List<QADocFragment> enabledDocFragment, Long docSourceId, Long fileBaseId) {
        UpdateEmbeddingDto embeddingDto = new UpdateEmbeddingDto();
        ArrayList<String> splitedTexts = new ArrayList<String>();
        LinkedHashMap<String, String> docFragmentIdAndContentMap = new LinkedHashMap<String, String>();
        for (int i = 0; i < enabledDocFragment.size(); ++i) {
            QADocFragment qaDocFragment = enabledDocFragment.get(i);
            String title = qaDocFragment.getTitle();
            String text = qaDocFragment.getContent();
            if (HussarUtils.isNotEmpty((Object)title)) {
                int lastIndex = title.lastIndexOf(12290);
                if (lastIndex != -1) {
                    title = title.substring(0, lastIndex + 1);
                }
                text = title + "----" + qaDocFragment.getContent();
            }
            splitedTexts.add(text);
            docFragmentIdAndContentMap.put(qaDocFragment.getDocFragmentId().toString(), text);
        }
        embeddingDto.setSplitedTexts(splitedTexts);
        QAFileDoc qaFileDoc = this.docService.getDoc(fileBaseId, docSourceId);
        embeddingDto.setFileName(qaFileDoc.getName() + "." + qaFileDoc.getSuffix());
        embeddingDto.setKnowledgeBaseName(String.valueOf(fileBaseId));
        embeddingDto.setDocFragmentIdAndContentMap(docFragmentIdAndContentMap);
        return embeddingDto;
    }

    @Override
    public void updateDocStatus(UpdateEmbeddingResultDto resultDto, Long docId, Long docBaseId) {
        String status = "";
        status = resultDto.getSuccess() != false ? "2" : "4";
        this.docService.updateStatus(status, docId, docBaseId, resultDto.getMsg());
    }

    @Override
    @HussarTransactional
    public void updateFragmentsNumber(Long docId, Long docBaseId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(HussarUtils.isNotEmpty((Object)docId), QADocFragment::getDocSourceId, (Object)docId)).eq(HussarUtils.isNotEmpty((Object)docBaseId), QADocFragment::getFileBaseId, (Object)docBaseId);
        Integer fragmentsNumber = this.qaDocFragmentMapper.selectCount((Wrapper)wrapper).intValue();
        this.docService.updateSplittingCount(docBaseId, docId, fragmentsNumber);
    }
}

