/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.dialogue.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.common.config.AiDocumentLibrary;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.dialogue.dao.DialogueMapper;
import com.jxdinfo.hussar.dialogue.dao.DialogueQaMapper;
import com.jxdinfo.hussar.dialogue.dao.QaDocUploadParseMapper;
import com.jxdinfo.hussar.dialogue.dto.FileAttachmentInfo;
import com.jxdinfo.hussar.dialogue.model.Dialogue;
import com.jxdinfo.hussar.dialogue.model.DialogueQa;
import com.jxdinfo.hussar.dialogue.service.IDialogueService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DialogueServiceImpl
extends ServiceImpl<DialogueMapper, Dialogue>
implements IDialogueService {
    @Autowired
    private DialogueQaMapper qaDao;
    @Resource
    private QaDocUploadParseMapper qaDocUploadParseMapper;
    @Resource
    private AiDocumentLibrary docLibraryConfig;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResponse<Map<String, Object>> addOrUpdateDialogue(Dialogue dialogue) {
        Long dialogueId = dialogue.getId();
        Timestamp date = new Timestamp(System.currentTimeMillis());
        HashMap<String, Long> map = new HashMap<String, Long>();
        if (dialogueId == null) {
            dialogue.setCreateTime(date);
            dialogue.setUpdateTime(date);
            SecurityUser user = BaseSecurityUtil.getUser();
            if (user != null) {
                dialogue.setCreateUserId(user.getId().toString());
                dialogue.setCreateUserName(user.getUserName());
                dialogue.setUpdateUserId(user.getId().toString());
                dialogue.setUpdateUserName(user.getUserName());
            }
            dialogue.setStatus("0");
            this.save((Object)dialogue);
            map.put("dialogueId", dialogue.getId());
        } else {
            dialogue.setUpdateTime(date);
            SecurityUser user = BaseSecurityUtil.getUser();
            if (user != null) {
                dialogue.setUpdateUserId(user.getId().toString());
                dialogue.setUpdateUserName(user.getUserName());
            }
            this.updateById((Object)dialogue);
            map.put("dialogueId", dialogue.getId());
        }
        return ApiResponse.success(map);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResponse<Map<String, Object>> delDialogue(Long dialogueId) {
        Dialogue dialogue = (Dialogue)((Object)this.getById(dialogueId));
        dialogue.setStatus("1");
        this.updateById((Object)dialogue);
        HashMap map = new HashMap();
        return ApiResponse.success(map);
    }

    @Override
    public ApiResponse<List<Dialogue>> getDialogueList(Map<String, String> params) {
        String systemId = params.get("systemId");
        String scenarioId = params.get("scenarioId");
        QueryWrapper qw = new QueryWrapper();
        if (StringUtil.isNotEmpty((Object)systemId)) {
            qw.eq((Object)"SYSTEM_ID", (Object)systemId);
        }
        if (StringUtil.isNotEmpty((Object)scenarioId)) {
            qw.eq((Object)"SCENARIO_ID", (Object)scenarioId);
        }
        qw.eq((Object)"status", (Object)"0");
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user != null) {
            qw.eq((Object)"CREATE_USER_ID", (Object)user.getId());
        }
        qw.orderByDesc((Object)"create_time");
        qw.last(" limit 0, 10");
        List list = this.list((Wrapper)qw);
        return ApiResponse.success((Object)list);
    }

    @Override
    public ApiResponse<Map<String, Object>> addDialogueQa(DialogueQa dialogueQa) {
        Timestamp date = new Timestamp(System.currentTimeMillis());
        HashMap<String, Long> map = new HashMap<String, Long>();
        Long pid = dialogueQa.getDialogueId();
        if (pid == null) {
            Dialogue dialogue = new Dialogue();
            dialogue.setCreateTime(date);
            dialogue.setDialogueName(dialogueQa.getQuestions());
            SecurityUser user = BaseSecurityUtil.getUser();
            if (user != null) {
                dialogue.setCreateUserId(user.getId().toString());
                dialogue.setCreateUserName(user.getUserName());
            }
            dialogue.setStatus("0");
            this.save((Object)dialogue);
            map.put("dialogueId", dialogue.getId());
            dialogueQa.setDialogueId(dialogue.getId());
            dialogueQa.setDialogueName(dialogue.getDialogueName());
        }
        dialogueQa.setCreateTime(date);
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user != null) {
            dialogueQa.setCreateUserId(user.getId().toString());
            dialogueQa.setCreateUserName(user.getUserName());
        }
        this.qaDao.insert((Object)dialogueQa);
        map.put("dialogueQaId", dialogueQa.getId());
        return ApiResponse.success(map);
    }

    @Override
    public ApiResponse<Map<String, Object>> getDialogueInfo(Long dialogueId) {
        QueryWrapper qa = new QueryWrapper();
        qa.eq((Object)"dialogue_id", (Object)dialogueId);
        List qaList = this.qaDao.selectList((Wrapper)qa);
        Dialogue dialogue = (Dialogue)((Object)this.getById(dialogueId));
        if (qaList != null && !qaList.isEmpty()) {
            for (DialogueQa qaRecord : qaList) {
                List<FileAttachmentInfo> parses;
                List<Long> docIds = qaRecord.getDocIds();
                if (docIds == null || docIds.isEmpty() || (parses = this.qaDocUploadParseMapper.getFileInfoList(docIds)) == null || parses.isEmpty()) continue;
                qaRecord.setFileList(parses);
            }
        }
        dialogue.setChildList(qaList);
        HashMap<String, Dialogue> map = new HashMap<String, Dialogue>();
        map.put("data", dialogue);
        return ApiResponse.success(map);
    }

    @Override
    public ApiResponse<Map<String, Object>> feedback(Map param) {
        String dialogueQaId = (String)param.get("dialogueQaId");
        String isUseFul = (String)param.get("isUseful");
        DialogueQa dialogueQa = (DialogueQa)((Object)this.qaDao.selectById((Serializable)((Object)dialogueQaId)));
        if (dialogueQa != null) {
            dialogueQa.setIsUseful(isUseFul);
            this.qaDao.updateById((Object)dialogueQa);
        }
        HashMap map = new HashMap();
        return ApiResponse.success(map);
    }

    @Override
    public ApiResponse<Page<DialogueQa>> getallData(Map<String, String> params) {
        Integer page = Integer.parseInt(params.get("page"));
        Integer size = Integer.parseInt(params.get("size"));
        String qaName = params.get("qaName");
        String responseState = params.get("responseState");
        String isUseful = params.get("isUseful");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)qaName)) {
            queryWrapper.like(DialogueQa::getQuestions, (Object)qaName);
        }
        if (HussarUtils.isNotEmpty((Object)responseState)) {
            if ("2".equals(responseState)) {
                queryWrapper.isNull(DialogueQa::getResponseState);
            } else {
                queryWrapper.eq(DialogueQa::getResponseState, (Object)responseState);
            }
        }
        if (HussarUtils.isNotEmpty((Object)isUseful)) {
            if ("2".equals(isUseful)) {
                queryWrapper.isNull(DialogueQa::getIsUseful);
            } else {
                queryWrapper.eq(DialogueQa::getIsUseful, (Object)isUseful);
            }
        }
        queryWrapper.orderByDesc(DialogueQa::getCreateTime);
        Page dataPage = new Page((long)page.intValue(), (long)size.intValue());
        return ApiResponse.success((Object)this.qaDao.selectPage((IPage)dataPage, (Wrapper)queryWrapper));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResponse<Map<String, Object>> delDialogueQa(String qaId) {
        String[] ids = qaId.split(",");
        this.qaDao.deleteBatchIds(Arrays.asList(ids));
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @Override
    @HussarTransactional
    public void deleteByScenarioId(Long scenarioId) {
        LambdaQueryWrapper dialogueWrapper = new LambdaQueryWrapper();
        dialogueWrapper.eq(Dialogue::getScenarioId, (Object)scenarioId);
        List dialogues = this.list((Wrapper)dialogueWrapper);
        if (!dialogues.isEmpty()) {
            List dialogueIds = dialogues.stream().map(Dialogue::getId).collect(Collectors.toList());
            LambdaQueryWrapper qaWrapper = new LambdaQueryWrapper();
            qaWrapper.in(DialogueQa::getDialogueId, dialogueIds);
            List qaList = this.qaDao.selectList((Wrapper)qaWrapper);
            if (!qaList.isEmpty()) {
                String qaIds = qaList.stream().map(qa -> qa.getId().toString()).collect(Collectors.joining(","));
                this.delDialogueQa(qaIds);
            }
            for (Dialogue dialogue : dialogues) {
                this.delDialogue(dialogue.getId());
            }
        }
    }

    @Override
    public void addQa(DialogueQa qa) {
        this.qaDao.insert((Object)qa);
    }
}

